/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.constants.SpecialUUIDs;
import com.hybridlab.hyve3d.core.DrawingArea;
import com.hybridlab.hyve3d.core.DrawingAreaTransformation;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.His2DCanvas;
import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class Jme3Canvas2D
extends Jme3SceneObject
implements His2DCanvas {
    private Vector3f originPosition = new Vector3f();
    private Quaternion orientation = new Quaternion();
    private List<Stroke2D> strokes = new ArrayList<Stroke2D>();
    private FrameRect frameRect = new FrameRect();
    private Node nativePlaneNode = new Node("nativeplane");
    Quaternion rotationBetweenFrameRectAndDrawingArea = new Quaternion(new float[]{0.0f, 0.0f, 1.5707964f});
    private Quaternion camRigRotation = new Quaternion();
    private Quaternion compassHeadingRotation = new Quaternion();
    private Geometry nativePlaneGeometry;

    public Jme3Canvas2D(AssetManager assetManager, Jme3HisClientRenderer jmeApp, Thread renderThread) {
        super(assetManager, jmeApp, renderThread);
        this.rootNode.setName(Jme3Canvas2D.class.getSimpleName() + " rootnode");
    }

    @Override
    public void setOriginPosition(Vector3f pos) {
        this.originPosition = pos;
    }

    @Override
    public void setOrientation(Quaternion rot) {
        this.orientation = rot;
    }

    @Override
    public Vector3f getOriginPosition() {
        return this.originPosition;
    }

    @Override
    public Quaternion getOrientation() {
        return this.orientation;
    }

    @Override
    public Vector3f getNormal() {
        Vector3f[] axis = new Vector3f[3];
        this.orientation.toAxes(axis);
        Vector3f normal = axis[3];
        normal.normalize();
        return normal;
    }

    @Override
    public Vector3f getInCanvasUpDirection() {
        Vector3f[] axis = new Vector3f[3];
        this.orientation.toAxes(axis);
        Vector3f up = axis[2];
        up.normalize();
        return up;
    }

    @Override
    public void addStroke(Stroke2D stroke) {
        this.strokes.add(stroke);
    }

    @Override
    public List<Stroke2D> getAllStrokes() {
        return this.strokes;
    }

    @Override
    public List<Stroke2D> calculateProjectedStrokes(His3DCanvas canvas) {
        ArrayList<Stroke2D> projectedStrokes = new ArrayList<Stroke2D>();
        Matrix4f transformationMatrix = new Matrix4f();
        Quaternion rotationOfProjectionPlane = this.camRigRotation.mult(this.compassHeadingRotation).mult(this.orientation);
        rotationOfProjectionPlane.toRotationMatrix(transformationMatrix);
        transformationMatrix.setTranslation(this.originPosition);
        Matrix4f projectionMatrix = transformationMatrix.invert();
        Set<Stroke3D> strokes3D = canvas.getAllVisibleStrokes();
        for (Stroke3D s3d : strokes3D) {
            Stroke2D projectedStroke2D = new Stroke2D();
            projectedStroke2D.observeStatusOf(s3d);
            boolean useOriginalInk = false;
            if (useOriginalInk || s3d.keepInkInProjection()) {
                StrokeInk ink = StrokeInk.createCopyOf(s3d.getInk());
                projectedStroke2D.setInk(ink);
            } else {
                projectedStroke2D.setInk(StrokeInk.createDefaultProjectionInk());
            }
            projectedStroke2D.setStrokeId(StrokeId.random());
            List<Stroke3DPoint> points3d = s3d.getPointsInSceneCoordinates();
            ArrayList<Vector2f> points2d = new ArrayList<Vector2f>();
            for (Stroke3DPoint p3 : points3d) {
                Vector3f p3Projected = projectionMatrix.mult(p3.position);
                Vector3f p3ProjectedInFrameRect = this.rotationBetweenFrameRectAndDrawingArea.mult(p3Projected);
                points2d.add(new Vector2f(-p3ProjectedInFrameRect.x, -p3ProjectedInFrameRect.y));
            }
            if (s3d.getStrokeId() == null || s3d.getStrokeId().getUUID().equals(SpecialUUIDs.xAxisStroke) || s3d.getStrokeId().getUUID().equals(SpecialUUIDs.yAxisStroke) || s3d.getStrokeId().getUUID().equals(SpecialUUIDs.zAxisStroke)) {
                // empty if block
            }
            projectedStroke2D.addPoints(points2d);
            projectedStrokes.add(projectedStroke2D);
        }
        return projectedStrokes;
    }

    @Override
    public void alignTo(final DrawingArea da) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3Canvas2D.this.alignTo(da);
                    return this;
                }
            });
            return;
        }
        DrawingAreaTransformation t = da.getTransformation();
        this.orientation = t.getRotation().clone();
        this.originPosition = t.getTranslation().clone();
        this.frameRect = t.getFrameRect();
        this.createPlane(this.frameRect);
        this.camRigRotation = t.getCamRigRotation().clone();
        this.compassHeadingRotation = t.getCompassHeadingRotation().clone();
        this.update();
    }

    @Override
    public void update() {
        this.nativePlaneNode.setLocalRotation(this.orientation);
        this.rootNode.setLocalTranslation(this.originPosition);
        this.rootNode.setLocalRotation(this.camRigRotation.mult(this.compassHeadingRotation));
    }

    @Override
    public void processStroke2DTransmissionPart(Stroke2DTransmissionPartMessage message) {
    }

    @Override
    public void processStroke2DTransmissionPart(DrawingArea drawingArea, Stroke2DTransmissionPartMessage message) {
        drawingArea.processStroke2DTransmissionPart(message);
    }

    public void build() {
        boolean show = false;
        Material matTransparentDrawAreaUnShaded = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        float whitevalue = 0.4f;
        float greenValue = 1.0f;
        float alphavalue = 0.2f;
        matTransparentDrawAreaUnShaded.setColor("Color", new ColorRGBA(whitevalue, greenValue, whitevalue, alphavalue));
        matTransparentDrawAreaUnShaded.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        matTransparentDrawAreaUnShaded.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        this.createPlane(this.frameRect);
        this.nativePlaneGeometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.nativePlaneGeometry.setMaterial(matTransparentDrawAreaUnShaded);
        this.nativePlaneNode.attachChild((Spatial)this.nativePlaneGeometry);
        if (show) {
            this.rootNode.attachChild((Spatial)this.nativePlaneNode);
        }
        float ArrowLength = 2.0f;
        if (show) {
            this.rootNode.attachChild((Spatial)this.createCoordinateAxes(new Vector3f(), new Vector3f(ArrowLength, ArrowLength, ArrowLength)));
        }
        ArrowLength = 1.0f;
        this.nativePlaneNode.attachChild((Spatial)this.createCoordinateAxes(new Vector3f(), new Vector3f(ArrowLength, ArrowLength, ArrowLength)));
    }

    private void createPlane(FrameRect r) {
        float scale = 1.0f;
        float planeHeight = r.getWidth() * scale;
        float planeWidth = r.getHeight() * scale;
        Quad plane = new Quad(planeWidth, planeHeight);
        if (this.nativePlaneGeometry == null) {
            this.nativePlaneGeometry = new Geometry("planequad", (Mesh)plane);
        } else {
            this.nativePlaneGeometry.setMesh((Mesh)plane);
        }
        this.nativePlaneGeometry.setLocalTranslation(planeWidth * -0.5f, planeHeight * -0.5f, 0.0f);
    }
}

