/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.core.AbstractBaseScene;
import com.hybridlab.hyve3d.core.CamRigPositionAndRotationListener;
import com.hybridlab.hyve3d.core.DrawingArea;
import com.hybridlab.hyve3d.core.DrawingAreaVisualization;
import com.hybridlab.hyve3d.core.His2DCanvas;
import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.His3DScene;
import com.hybridlab.hyve3d.core.HisClientRenderer;
import com.hybridlab.hyve3d.core.HisDrawingAreaListener;
import com.hybridlab.hyve3d.core.IdeationSpaceVisualization;
import com.hybridlab.hyve3d.core.StrokeInputBuffer;
import com.hybridlab.hyve3d.core.StrokeInputCommand;
import com.hybridlab.hyve3d.core.animation.SimpleAnimation;
import com.hybridlab.hyve3d.core.jme3.Jme3Canvas2D;
import com.hybridlab.hyve3d.core.jme3.Jme3Canvas3D;
import com.hybridlab.hyve3d.core.jme3.Jme3IdeationSpaceVisualization;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.hybridlab.hyve3d.core.jme3.Jme3TabletDevice;
import com.hybridlab.hyve3d.core.jme3.Jme3VolumeVisualization;
import com.hybridlab.hyve3d.core.locations.Compass;
import com.hybridlab.hyve3d.core.locations.HisClient;
import com.hybridlab.hyve3d.core.locations.HydraOrientation;
import com.hybridlab.hyve3d.network.interconnection.HisDrawingArea;
import com.hybridlab.hyve3d.rendering.Jme3ThreadingHelper;
import com.hybridlab.hyve3d.rendering.projection.SixCameraRig;
import com.hybridlab.hyve3d.scenemanipulation.BrailedVolume;
import com.hybridlab.hyve3d.scenemanipulation.Volume;
import com.hybridlab.hyve3d.scenes.HisSceneManager;
import com.hybridlab.hyve3d.scenes.StaticSceneElementState;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.BufferUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Jme3HisClientRenderer
implements HisClientRenderer {
    protected List<Jme3IdeationSpaceVisualization> ideationSpaceVisualizations = new ArrayList<Jme3IdeationSpaceVisualization>();
    protected List<Jme3TabletDevice> drawFrames = new ArrayList<Jme3TabletDevice>();
    protected List<Jme3Canvas2D> canvas2Ds = new ArrayList<Jme3Canvas2D>();
    private StrokeInputBuffer strokeInputBuffer = new StrokeInputBuffer();
    private AssetManager assetManager;
    private RenderManager renderManager;
    private SimpleApplication jmeApp;
    private HisSceneManager sceneManager;
    private SixCameraRig camRig;
    private int textureSize;
    private Jme3Canvas3D canvas3d;
    private TextureCubeMap cubeMapTexture;
    private Logger logger = Logger.getLogger(Jme3HisClientRenderer.class.getName());
    private Node drawingAreaGroupNode = new Node("drawingAreaGroupNode");
    private Node drawingAreaTrfVisGroupNode = new Node("drawingAreaTrfVisGroupNode");
    private Node canvas2DGroupNode = new Node("canvas2DGroupNode");
    private List<SimpleAnimation> ongoingAnimations = new ArrayList<SimpleAnimation>();
    private Set<SimpleAnimation> finishedAnimations = new HashSet<SimpleAnimation>();
    private Map<StaticSceneElementState.Element, StaticSceneElementState> staticElements = AbstractBaseScene.getDefaultStaticElementStateMap();
    private HisClient hisClient;
    private Thread renderThread;
    private Set<CamRigPositionAndRotationListener> camRigPositionAndRotationListeners = new HashSet<CamRigPositionAndRotationListener>();
    private Vector3f camerRigMoveMent = new Vector3f();
    private boolean sky = false;
    FrameBuffer offBuffer;
    private static final int width = 1024;
    private static final int height = 768;
    private static final String targetFile = "/Users/Michah/temp/img.jpg";
    private final int numBytesPerPixel = 4;
    private final ByteBuffer cpuBuf = BufferUtils.createByteBuffer((int)0x300000);
    private final byte[] cpuArray = new byte[0x300000];
    private final BufferedImage image = new BufferedImage(1024, 768, 6);
    private float frustumSize = 1.0f;
    private Camera cam2;
    private boolean visualizeBrailedVolumes = false;

    public HisSceneManager getSceneManager() {
        return this.sceneManager;
    }

    public Jme3HisClientRenderer(SimpleApplication jmeApp, int texturesize) {
        this.jmeApp = jmeApp;
        this.textureSize = texturesize;
    }

    public void setHisClient(HisClient client) {
        this.hisClient = client;
    }

    public HisClient getHisClient() {
        return this.hisClient;
    }

    public void simpleInit(AssetManager assetManager, RenderManager renderManager) {
        this.renderThread = Thread.currentThread();
        this.jmeApp.getCamera().setName("MainCam");
        this.assetManager = assetManager;
        this.renderManager = renderManager;
        boolean mirrored = true;
        HashMap<TextureCubeMap.Face, Boolean> enabled = new HashMap<TextureCubeMap.Face, Boolean>(6);
        enabled.put(TextureCubeMap.Face.NegativeX, true);
        enabled.put(TextureCubeMap.Face.NegativeY, true);
        enabled.put(TextureCubeMap.Face.NegativeZ, false);
        enabled.put(TextureCubeMap.Face.PositiveX, true);
        enabled.put(TextureCubeMap.Face.PositiveY, false);
        enabled.put(TextureCubeMap.Face.PositiveZ, false);
        this.camRig = new SixCameraRig(this.textureSize, mirrored, new Jme3ThreadingHelper(){

            @Override
            public boolean isThreadEqualToRenderThread(Thread currentThread) {
                return Jme3HisClientRenderer.this.isThreadEqualToRenderThread(currentThread);
            }

            @Override
            public <V> Future<V> enqueue(Callable<V> callable) {
                return Jme3HisClientRenderer.this.enqueue(callable);
            }
        }, enabled);
        Quaternion r = new Quaternion();
        r = r.fromAngles(0.0f, 0.0f, 0.0f);
        this.camRig.setLocalRotation(r);
        this.camRig.move(0.0f, 2.5f, 0.0f);
        this.sceneManager = new HisSceneManager(assetManager, this);
        this.sceneManager.getCamerRigGroupNode().attachChild((Spatial)this.camRig);
        this.canvas3d = this.createNewCanvas3D();
        this.getSceneRootNode().attachChild((Spatial)this.drawingAreaTrfVisGroupNode);
        this.drawingAreaTrfVisGroupNode.setLocalTranslation(0.0f, 1.0f, 1.0f);
        this.getSceneRootNode().attachChild((Spatial)this.drawingAreaGroupNode);
        for (Jme3TabletDevice f : this.drawFrames) {
            this.drawingAreaGroupNode.attachChild((Spatial)f.getRootNode());
        }
        this.getSceneRootNode().attachChild((Spatial)this.canvas2DGroupNode);
        for (Jme3Canvas2D c : this.canvas2Ds) {
            this.canvas2DGroupNode.attachChild((Spatial)c.getRootNode());
        }
        this.setupCameraRigToBuildOffscreenViewCubeMap(this.sceneManager.getSceneNode(), this.camRig);
        this.initOrthoOffscreen();
    }

    public Jme3Canvas3D createNewCanvas3D() {
        if (!Thread.currentThread().equals(this.renderThread)) {
            try {
                return (Jme3Canvas3D)this.jmeApp.enqueue((Callable)new Callable<Jme3Canvas3D>(){

                    @Override
                    public Jme3Canvas3D call() throws Exception {
                        return Jme3HisClientRenderer.this.createNewCanvas3D();
                    }
                }).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return null;
        }
        Jme3Canvas3D c3d = new Jme3Canvas3D(this.assetManager, this, this.renderThread);
        this.sceneManager.getSceneNode().attachChild((Spatial)c3d.getRootNode());
        return c3d;
    }

    private void setupCameraRigToBuildOffscreenViewCubeMap(Node sceneRootNode, SixCameraRig camRig) {
        ViewPort[] offViews = new ViewPort[6];
        TextureCubeMap offTex = new TextureCubeMap(this.textureSize, this.textureSize, Image.Format.RGBA8);
        int i = 0;
        for (TextureCubeMap.Face face : TextureCubeMap.Face.values()) {
            if (!camRig.isFaceEnabled(face)) {
                ++i;
                continue;
            }
            Camera offCamera = camRig.getCam(face);
            offViews[i] = this.renderManager.createPreView("Offscreen View " + i, offCamera);
            offViews[i].setClearFlags(true, true, true);
            offViews[i].setBackgroundColor(ColorRGBA.Black);
            FrameBuffer offBuffer = new FrameBuffer(this.textureSize, this.textureSize, 1);
            offBuffer.setDepthBuffer(Image.Format.Depth);
            offBuffer.setMultiTarget(true);
            offBuffer.addColorTexture(offTex, face);
            offViews[i].setOutputFrameBuffer(offBuffer);
            offViews[i].attachScene((Spatial)sceneRootNode);
            ++i;
        }
        this.cubeMapTexture = offTex;
    }

    public Node getSceneRootNode() {
        return this.sceneManager.getSceneNode();
    }

    @Override
    public boolean isThreadEqualToRenderThread(Thread t) {
        return this.renderThread.equals(t);
    }

    public Jme3TabletDevice createDrawFrame() {
        try {
            if (!Thread.currentThread().equals(this.renderThread)) {
                this.logger.warning("called createDrawFrame() from a different than the render thread [" + Thread.currentThread().toString() + "] ! Enqueueing...");
                return (Jme3TabletDevice)this.jmeApp.enqueue((Callable)new Callable<Jme3TabletDevice>(){

                    @Override
                    public Jme3TabletDevice call() throws Exception {
                        return Jme3HisClientRenderer.this.createDrawFrame();
                    }
                }).get();
            }
            this.logger.info(Thread.currentThread().toString());
            this.logger.info("actual creation of the Jme3TabletDevice instance");
            Jme3TabletDevice f = new Jme3TabletDevice(this.assetManager, this, this.renderThread);
            f.build();
            f.camRigRotationHasChanged(this.getCameraRigRotation());
            f.compassHeadingHasChanged(this.getHisClient().getCompass().getNorthHeadingRotation());
            this.drawingAreaGroupNode.attachChild((Spatial)f.getRootNode());
            this.drawFrames.add(f);
            return f;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void showDATrfVisualizer(final DrawingArea da) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DaTrfVisualizer dav = new DaTrfVisualizer(Jme3HisClientRenderer.this.assetManager, Jme3HisClientRenderer.this, Jme3HisClientRenderer.this.renderThread, da);
                da.registerListener(dav);
                Jme3HisClientRenderer.this.drawingAreaTrfVisGroupNode.attachChild((Spatial)dav.getRootNode());
                return this;
            }
        };
        if (this.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.enqueue(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyDrawFrame(final Jme3TabletDevice f) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.logger.warning("called destroyDrawFrame() from a different than the render thread [" + Thread.currentThread().toString() + "] ! Enqueueing...");
            try {
                this.jmeApp.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Jme3HisClientRenderer.this.destroyDrawFrame(f);
                        return null;
                    }
                }).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        f.wipe();
        this.drawFrames.remove(f);
        Set<CamRigPositionAndRotationListener> set = this.camRigPositionAndRotationListeners;
        synchronized (set) {
            this.camRigPositionAndRotationListeners.remove(f);
        }
    }

    public void changeCameraRigRotationY(final float f) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.logger.warning("called changeCameraRigRotationY() from a different than the render thread [" + Thread.currentThread().toString() + "] ! Enqueueing...");
            try {
                this.jmeApp.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Jme3HisClientRenderer.this.changeCameraRigRotationY(f);
                        return null;
                    }
                }).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        this.camRig.rotateY(f);
    }

    public void changeCameraRigPosition(final Vector3f move) {
        this.jmeApp.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                Jme3HisClientRenderer.this.camerRigMoveMent.addLocal(move);
                return this;
            }
        });
    }

    public boolean performCameraRigPositionChange() {
        if (this.camerRigMoveMent.x != 0.0f || this.camerRigMoveMent.y != 0.0f || this.camerRigMoveMent.z != 0.0f) {
            Vector3f move = this.camerRigMoveMent.clone();
            this.camerRigMoveMent.x = 0.0f;
            this.camerRigMoveMent.y = 0.0f;
            this.camerRigMoveMent.z = 0.0f;
            this.camRig.move(move);
            if (move.lengthSquared() != 0.0f) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Vector3f getCameraRigPosition() {
        return this.camRig.getLocalTranslation().clone();
    }

    @Override
    public void setCameraRigPosition(final Vector3f position) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            try {
                this.jmeApp.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Jme3HisClientRenderer.this.setCameraRigPosition(position);
                        return null;
                    }
                }).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        Vector3f oldPosition = this.camRig.getLocalTranslation();
        if (!position.equals((Object)oldPosition)) {
            this.camRig.setLocalTranslation(position);
            this.notifyCamRigPositionListeners();
        }
    }

    @Override
    public void setCameraRigRotation(final Quaternion rotation) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            try {
                this.jmeApp.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Jme3HisClientRenderer.this.setCameraRigRotation(rotation);
                        return null;
                    }
                }).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        Quaternion oldRotation = this.camRig.getLocalRotation();
        if (!rotation.equals((Object)oldRotation)) {
            this.camRig.setLocalRotation(rotation);
            this.notifyCamRigRotationListeners();
        }
    }

    @Override
    public Quaternion getCameraRigRotation() {
        return this.camRig.getLocalRotation();
    }

    @Override
    public DrawingAreaVisualization createDrawingAreaVisualization() {
        Jme3TabletDevice vis = this.createDrawFrame();
        return vis;
    }

    @Override
    public void destroyDrawingAreaVisualization(DrawingAreaVisualization visualization) {
        this.destroyDrawFrame((Jme3TabletDevice)visualization);
    }

    public StrokeInputBuffer getStrokeInputBuffer() {
        return this.strokeInputBuffer;
    }

    @Override
    public void enqueueStrokeInputCommand(StrokeInputCommand cmd) {
        this.strokeInputBuffer.add(cmd);
    }

    @Override
    public <V> Future<V> enqueue(Callable<V> callable) {
        return this.jmeApp.enqueue(callable);
    }

    @Override
    public His3DCanvas getHis3dCanvasForScene(His3DScene his3dScene) {
        return this.canvas3d;
    }

    @Override
    public His3DCanvas getNewEmptyHis3dCanvas() {
        return this.createNewCanvas3D();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleUpdate(float tpf) {
        if (this.renderThread != Thread.currentThread()) {
            this.logger.severe("simpleUpdate called outside renderThread !!!");
        }
        List<SimpleAnimation> list = this.ongoingAnimations;
        synchronized (list) {
            for (SimpleAnimation simpleAnimation : this.ongoingAnimations) {
                simpleAnimation.update(tpf);
                if (!simpleAnimation.isFinished()) continue;
                this.finishedAnimations.add(simpleAnimation);
            }
            for (SimpleAnimation simpleAnimation : this.finishedAnimations) {
                this.ongoingAnimations.remove(simpleAnimation);
            }
            this.finishedAnimations.clear();
        }
        boolean camRigPositionHasChanged = this.performCameraRigPositionChange();
        if (camRigPositionHasChanged) {
            camRigPositionHasChanged = false;
            this.notifyCamRigPositionListeners();
        }
        for (Jme3TabletDevice jme3TabletDevice : this.drawFrames) {
            jme3TabletDevice.update(tpf);
        }
        for (His2DCanvas his2DCanvas : this.canvas2Ds) {
            his2DCanvas.update();
        }
        for (Jme3IdeationSpaceVisualization jme3IdeationSpaceVisualization : this.ideationSpaceVisualizations) {
            jme3IdeationSpaceVisualization.update(tpf);
        }
        this.processStrokeBuffer();
        this.sceneManager.update(tpf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCamRigRotationListeners() {
        Set<CamRigPositionAndRotationListener> set = this.camRigPositionAndRotationListeners;
        synchronized (set) {
            for (CamRigPositionAndRotationListener l : this.camRigPositionAndRotationListeners) {
                l.camRigRotationHasChanged(this.camRig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCamRigPositionListeners() {
        Set<CamRigPositionAndRotationListener> set = this.camRigPositionAndRotationListeners;
        synchronized (set) {
            for (CamRigPositionAndRotationListener l : this.camRigPositionAndRotationListeners) {
                l.camRigPositionHasChanged(this.camRig);
            }
        }
    }

    private void processStrokeBuffer() {
        if (this.strokeInputBuffer.hasInput()) {
            List<StrokeInputCommand> buf = this.strokeInputBuffer.getBufferContentAndClear();
            for (StrokeInputCommand sicmd : buf) {
                sicmd.canvas2d.processStroke2DTransmissionPart(sicmd.drawingArea, sicmd.message);
            }
        }
    }

    public TextureCubeMap getCubeMapTexture() {
        return this.cubeMapTexture;
    }

    @Override
    public void setWireFrameMode(final boolean useWireFrame) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.logger.warning("called setWireFrameMode() from a different than the render thread [" + Thread.currentThread().toString() + "] ! Enqueueing...");
            this.jmeApp.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3HisClientRenderer.this.setWireFrameMode(useWireFrame);
                    return null;
                }
            });
            return;
        }
        ArrayList<Material> matlist = new ArrayList<Material>(8);
        this.getMaterials((Spatial)this.sceneManager.getSceneNode(), matlist);
        for (Material m : matlist) {
            m.getAdditionalRenderState().setWireframe(useWireFrame);
        }
    }

    public void getMaterials(Spatial spatial, List<Material> matlist) {
        try {
            Geometry geo;
            Material m;
            if (spatial instanceof Node) {
                Node node = (Node)spatial;
                for (int i = 0; i < node.getQuantity(); ++i) {
                    Spatial child = node.getChild(i);
                    this.getMaterials(child, matlist);
                }
            } else if (spatial instanceof Geometry && !matlist.contains(m = (geo = (Geometry)spatial).getMaterial())) {
                matlist.add(m);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void setSkyVisibility(final boolean show) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.logger.warning("called toggleSky() from a different than the render thread [" + Thread.currentThread().toString() + "] ! Enqueueing...");
            this.jmeApp.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3HisClientRenderer.this.setSkyVisibility(show);
                    return null;
                }
            });
            return;
        }
        if (this.sky) {
            this.sceneManager.hideSky();
        } else {
            this.sceneManager.showSky();
        }
        this.sky = show;
    }

    @Override
    public void moveCamera(Vector3f translation) {
        this.changeCameraRigPosition(translation);
    }

    @Override
    public His2DCanvas createHis2DCanvasVisualization() {
        try {
            if (!Thread.currentThread().equals(this.renderThread)) {
                return (His2DCanvas)this.jmeApp.enqueue((Callable)new Callable<His2DCanvas>(){

                    @Override
                    public His2DCanvas call() throws Exception {
                        return Jme3HisClientRenderer.this.createHis2DCanvasVisualization();
                    }
                }).get();
            }
            Jme3Canvas2D c = new Jme3Canvas2D(this.assetManager, this, this.renderThread);
            c.build();
            this.canvas2DGroupNode.attachChild((Spatial)c.getRootNode());
            this.canvas2Ds.add(c);
            return c;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setCityVisibility(final boolean show) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeApp.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3HisClientRenderer.this.setCityVisibility(show);
                    return this;
                }
            });
            return;
        }
        this.logger.info("CityScene: " + (show ? "show" : "hide"));
        if (show) {
            this.sceneManager.showCityScene();
        } else {
            this.sceneManager.hideCityScene();
        }
    }

    private void setCubes1000Visibility(final boolean visibility) {
        Callable<Object> v = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (visibility) {
                    Jme3HisClientRenderer.this.sceneManager.showCubes1000();
                } else {
                    Jme3HisClientRenderer.this.sceneManager.hideCubes1000();
                }
                return this;
            }
        };
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeApp.enqueue((Callable)v);
        } else {
            try {
                v.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setCarVisibility(final boolean visibility) {
        Callable<Object> v = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (visibility) {
                    Jme3HisClientRenderer.this.sceneManager.showCar();
                } else {
                    Jme3HisClientRenderer.this.sceneManager.hideCar();
                }
                return this;
            }
        };
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeApp.enqueue((Callable)v);
        } else {
            try {
                v.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setTestSceneVisibility(final boolean show) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeApp.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3HisClientRenderer.this.setTestSceneVisibility(show);
                    return this;
                }
            });
            return;
        }
        this.logger.info("GokceTestScene: " + (show ? "show" : "hide"));
        if (show) {
            this.sceneManager.showGokceTestScene();
        } else {
            this.sceneManager.hideGokceTestScene();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueSimpleAnimation(SimpleAnimation animation) {
        List<SimpleAnimation> list = this.ongoingAnimations;
        synchronized (list) {
            if (!this.ongoingAnimations.contains(animation)) {
                this.ongoingAnimations.add(animation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterCamRigPositionAndRotationListener(CamRigPositionAndRotationListener listener) {
        Set<CamRigPositionAndRotationListener> set = this.camRigPositionAndRotationListeners;
        synchronized (set) {
            this.camRigPositionAndRotationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCamRigPositionAndRotationListener(CamRigPositionAndRotationListener listener) {
        Set<CamRigPositionAndRotationListener> set = this.camRigPositionAndRotationListeners;
        synchronized (set) {
            this.camRigPositionAndRotationListeners.add(listener);
        }
        listener.camRigPositionHasChanged(this.camRig);
        listener.camRigRotationHasChanged(this.camRig);
    }

    @Override
    public Compass createCompass() {
        Compass compass = new Compass(this.assetManager, this, this.renderThread);
        BitmapFont font = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        Node compassGroupNode = compass.getRootNode();
        float compassradius = 250.0f;
        String addition = "\n(in real world)";
        ArrayList<CompassDirection> directions = new ArrayList<CompassDirection>();
        class CompassDirection {
            float labelPosY = 50.0f;
            public String label;
            public Vector3f position = new Vector3f(0.0f, this.labelPosY, 0.0f);
            public Vector3f lookAt = Vector3f.ZERO;
            public Vector3f lookUp = Vector3f.UNIT_Y;
            public ColorRGBA color = ColorRGBA.Gray;

            CompassDirection() {
            }
        }
        CompassDirection east = new CompassDirection();
        east.label = "EAST" + addition;
        east.position.x = compassradius;
        east.position.z = -20.5f;
        east.color = ColorRGBA.LightGray;
        directions.add(east);
        CompassDirection south = new CompassDirection();
        south.label = "SOUTH" + addition;
        south.position.z = compassradius;
        south.position.x = 28.5f;
        directions.add(south);
        CompassDirection west = new CompassDirection();
        west.label = "WEST" + addition;
        west.position.x = -compassradius;
        west.position.z = 23.5f;
        directions.add(west);
        CompassDirection north = new CompassDirection();
        north.label = "NORTH" + addition;
        north.position.z = -compassradius;
        north.position.x = -28.5f;
        directions.add(north);
        for (CompassDirection d : directions) {
            BitmapText compassLabelText = new BitmapText(font, false);
            compassLabelText.setSize((float)font.getCharSet().getRenderedSize());
            compassLabelText.setText(d.label);
            compassLabelText.setColor(d.color);
            compassLabelText.setLocalTranslation(d.position);
            compassLabelText.lookAt(d.lookAt, d.lookUp);
            compassLabelText.updateLogicalState(1.0f);
            compassGroupNode.attachChild((Spatial)compassLabelText);
        }
        this.sceneManager.getSceneNode().attachChild((Spatial)compassGroupNode);
        this.registerCamRigPositionAndRotationListener(compass);
        return compass;
    }

    @Override
    public HydraOrientation createHydraOrientationVisualization() {
        HydraOrientation ho = new HydraOrientation(this.assetManager, this, this.renderThread);
        BitmapFont font = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        Node groupNode = ho.getRootNode();
        float radius = 250.0f;
        ArrayList<LabelInformation> labelInfos = new ArrayList<LabelInformation>();
        class LabelInformation {
            float labelPosY = 50.0f;
            public String label;
            public Vector3f position = new Vector3f(0.0f, this.labelPosY, 0.0f);
            public Vector3f lookAt = Vector3f.ZERO;
            public Vector3f lookUp = Vector3f.UNIT_Y;
            public ColorRGBA color = ColorRGBA.Gray;

            LabelInformation() {
            }
        }
        LabelInformation north = new LabelInformation();
        north.label = "HYDRA BASE\nCABLE OUTLET";
        north.position.z = -radius;
        north.position.x = -35.0f;
        north.position.y = 3.0f;
        north.color = ColorRGBA.Green;
        labelInfos.add(north);
        for (LabelInformation d : labelInfos) {
            BitmapText label = new BitmapText(font, false);
            label.setSize((float)font.getCharSet().getRenderedSize());
            label.setText(d.label);
            label.setColor(d.color);
            label.setLocalTranslation(d.position);
            label.lookAt(d.lookAt, d.lookUp);
            label.updateLogicalState(1.0f);
            groupNode.attachChild((Spatial)label);
        }
        this.sceneManager.getSceneNode().attachChild((Spatial)groupNode);
        this.registerCamRigPositionAndRotationListener(ho);
        return ho;
    }

    @Override
    public SixCameraRig getCameraRig() {
        return this.camRig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdeationSpaceVisualization createRemoteIdeationSpaceVisualization() {
        if (!Thread.currentThread().equals(this.renderThread)) {
            try {
                return (IdeationSpaceVisualization)this.jmeApp.enqueue((Callable)new Callable<IdeationSpaceVisualization>(){

                    @Override
                    public IdeationSpaceVisualization call() throws Exception {
                        return Jme3HisClientRenderer.this.createRemoteIdeationSpaceVisualization();
                    }
                }).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return null;
        }
        Jme3IdeationSpaceVisualization vis = new Jme3IdeationSpaceVisualization(this.assetManager, this, this.renderThread);
        vis.build();
        Set<CamRigPositionAndRotationListener> set = this.camRigPositionAndRotationListeners;
        synchronized (set) {
            this.camRigPositionAndRotationListeners.add(vis);
        }
        vis.camRigPositionHasChanged(this.getCameraRig());
        this.ideationSpaceVisualizations.add(vis);
        this.sceneManager.getSceneNode().attachChild((Spatial)vis.getRootNode());
        return vis;
    }

    @Override
    public void setStaticSceneElementState(StaticSceneElementState state) {
        this.staticElements.put(state.element, state);
        switch (state.element) {
            case CITY: {
                this.setCityVisibility(state.visibility);
                break;
            }
            case SKY: {
                this.setSkyVisibility(state.visibility);
                break;
            }
            case TESTSCENE: {
                this.setTestSceneVisibility(state.visibility);
                break;
            }
            case CAR: {
                this.setCarVisibility(state.visibility);
                break;
            }
            case CUBES1000: {
                this.setCubes1000Visibility(state.visibility);
                break;
            }
        }
    }

    @Override
    public StaticSceneElementState getStaticSceneElementState(StaticSceneElementState.Element e) {
        return this.staticElements.get((Object)e).clone();
    }

    @Override
    public Jme3VolumeVisualization createFor(Volume volume) {
        if (volume instanceof BrailedVolume) {
            if (!this.visualizeBrailedVolumes) {
                return new InvisibleVolumeVisualization(this.assetManager, this, this.renderThread);
            }
            final Jme3VolumeVisualization newVis = new Jme3VolumeVisualization(this.assetManager, this, this.renderThread);
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3HisClientRenderer.this.sceneManager.getSceneNode().attachChild((Spatial)newVis.getRootNode());
                    return this;
                }
            };
            if (!Thread.currentThread().equals(this.renderThread)) {
                this.jmeApp.enqueue((Callable)c);
            } else {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return newVis;
        }
        throw new RuntimeException("No VisualizationSupport for " + volume.getClass().getName());
    }

    @Override
    public void destroy(final Jme3VolumeVisualization visualization) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                visualization.destroy();
                Jme3HisClientRenderer.this.sceneManager.getSceneNode().detachChild((Spatial)visualization.getRootNode());
                return this;
            }
        };
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeApp.enqueue((Callable)c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initOrthoOffscreen() {
        Camera cam = this.jmeApp.getCamera();
        this.cam2 = cam.clone();
        this.cam2.setViewPort(0.0f, 1.0f, 0.0f, 1.0f);
        this.cam2.setLocation(new Vector3f(0.0f, 0.0f, 1.0f));
        this.cam2.setRotation(new Quaternion().fromAngleAxis(0.0f, new Vector3f(1.0f, 0.0f, 0.0f)));
        this.cam2.setParallelProjection(true);
        float aspect = (float)cam.getWidth() / (float)cam.getHeight();
        this.cam2.setFrustum(-1000.0f, 1000.0f, -aspect * this.frustumSize, aspect * this.frustumSize, this.frustumSize, -this.frustumSize);
        this.setupOffscreenViewPort();
    }

    private void setupOffscreenViewPort() {
        ViewPort vp = this.renderManager.createPreView("ortho viewport", this.cam2);
        vp.setClearFlags(true, true, true);
        vp.setBackgroundColor(ColorRGBA.Yellow);
        this.offBuffer = new FrameBuffer(1024, 768, 1);
        this.offBuffer.setDepthBuffer(Image.Format.Depth);
        this.offBuffer.setColorBuffer(Image.Format.ABGR8);
        vp.setOutputFrameBuffer(this.offBuffer);
        vp.attachScene((Spatial)this.sceneManager.getSceneNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImageContents() {
        this.cpuBuf.clear();
        this.jmeApp.getRenderer().readFrameBuffer(this.offBuffer, this.cpuBuf);
        this.cpuBuf.clear();
        this.cpuBuf.get(this.cpuArray);
        this.cpuBuf.clear();
        BufferedImage bufferedImage = this.image;
        synchronized (bufferedImage) {
            WritableRaster wr = this.image.getRaster();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            System.arraycopy(this.cpuArray, 0, db.getData(), 0, this.cpuArray.length);
            try {
                ImageIO.write((RenderedImage)this.image, "jpg", new FileOutputStream(targetFile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void shootOrthoImage() {
        this.logger.info("shooting !");
        this.updateImageContents();
    }

    @Override
    public void setVisualizeVolumes(boolean b) {
        this.visualizeBrailedVolumes = b;
    }

    @Override
    public void loadOgreZip(String path, String file) {
        this.sceneManager.loadOgreZip(path, file);
    }

    @Override
    public void clearAllImportedModels() {
        this.sceneManager.clearAllImportedModels();
    }

    private class InvisibleVolumeVisualization
    extends Jme3VolumeVisualization {
        public InvisibleVolumeVisualization(AssetManager assetManager, Jme3HisClientRenderer jmeApp, Thread renderThread) {
            super(assetManager, jmeApp, renderThread);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void onVolumeExtended(BrailedVolume brailedVolume, int newNumberOfVolumeParts) {
        }

        @Override
        public void onVolumeReduced(BrailedVolume brailedVolume) {
        }
    }

    private class DaTrfVisualizer
    extends Jme3SceneObject
    implements HisDrawingAreaListener {
        private Node normal;
        private Node world;
        private Jme3HisClientRenderer jmeApp;

        public DaTrfVisualizer(AssetManager assetManager, Jme3HisClientRenderer jmeApp, Thread renderThread, DrawingArea da) {
            super(assetManager, jmeApp, renderThread);
            this.jmeApp = jmeApp;
            this.normal = this.createCoordinateAxes(Vector3f.ZERO, new Vector3f(2.0f, 2.0f, 3.0f), ColorRGBA.Yellow);
            this.world = this.createCoordinateAxes(Vector3f.ZERO, new Vector3f(2.0f, 2.0f, 3.0f), ColorRGBA.Cyan);
            this.world.setLocalTranslation(0.25f, 0.0f, 0.0f);
            this.rootNode.attachChild((Spatial)this.normal);
            this.rootNode.attachChild((Spatial)this.world);
        }

        private Geometry putShape(Mesh shape, ColorRGBA color, boolean wireframe) {
            Geometry g = new Geometry("coordinate axis", shape);
            Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.getAdditionalRenderState().setWireframe(wireframe);
            mat.setColor("Color", color);
            g.setMaterial(mat);
            return g;
        }

        private Node createCoordinateAxes(Vector3f pos, Vector3f sizeEachDimension, ColorRGBA dotcolor) {
            Node node = new Node("axes");
            Arrow arrow = new Arrow(new Vector3f(sizeEachDimension.x, 0.0f, 0.0f));
            arrow.setLineWidth(2.0f);
            Geometry g = this.putShape((Mesh)arrow, ColorRGBA.Red);
            g.setLocalTranslation(pos);
            node.attachChild((Spatial)g);
            arrow = new Arrow(new Vector3f(0.0f, sizeEachDimension.y, 0.0f));
            arrow.setLineWidth(2.0f);
            g = this.putShape((Mesh)arrow, ColorRGBA.Green);
            g.setLocalTranslation(pos);
            node.attachChild((Spatial)g);
            arrow = new Arrow(new Vector3f(0.0f, 0.0f, sizeEachDimension.z));
            arrow.setLineWidth(2.0f);
            g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
            g.setLocalTranslation(pos);
            node.attachChild((Spatial)g);
            Sphere dot = new Sphere(16, 16, 0.05f);
            g = this.putShape((Mesh)dot, dotcolor, false);
            node.attachChild((Spatial)g);
            return node;
        }

        @Override
        public void onTransformationHasChanged(final HisDrawingArea drawingArea) {
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DaTrfVisualizer.this.normal.setLocalRotation(drawingArea.getTransformation().getRotation());
                    DaTrfVisualizer.this.world.setLocalRotation(drawingArea.getTransformation().getWorldRotation());
                    return null;
                }
            };
            if (this.renderThread.equals(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.jmeApp.enqueue(c);
            }
        }

        @Override
        public void onLabelHasChanged(HisDrawingArea drawingArea) {
        }

        @Override
        public void onVisibilityChanged(HisDrawingArea drawingArea, boolean isVisibleNow) {
        }

        @Override
        public void onStyleHasChanged(HisDrawingArea drawingArea, DrawingArea.DrawingAreaStyle currentStyle) {
        }

        @Override
        public void onFrameColorHasChanged(HisDrawingArea drawingArea) {
        }
    }
}

