/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.core.CamRigPositionAndRotationListener;
import com.hybridlab.hyve3d.core.IdeationSpaceVisualization;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.hybridlab.hyve3d.network.interconnection.IdeationSpace;
import com.hybridlab.hyve3d.rendering.projection.SixCameraRig;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Cylinder;
import java.util.concurrent.Callable;

public class Jme3IdeationSpaceVisualization
extends Jme3SceneObject
implements IdeationSpaceVisualization,
CamRigPositionAndRotationListener,
IdeationSpace.IdeationSpacePropertyListener {
    private BitmapText label;
    private Vector3f absolutePosition = new Vector3f();
    private Quaternion absoluteRotation = new Quaternion();
    private Node visualizationRoot = new Node();
    private Vector3f lastLookAtForLabel = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean rotationUpdate = false;
    private boolean positionUpdate = false;
    boolean labelNeedsUpdating = false;

    public Jme3IdeationSpaceVisualization(AssetManager assetManager, Jme3HisClientRenderer jmeRenderer, Thread renderThread) {
        super(assetManager, jmeRenderer, renderThread);
    }

    public void build() {
        Material matMagenta = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matMagenta.setColor("Color", ColorRGBA.Magenta);
        float r1 = 0.25f;
        float r2 = 0.25f;
        float h = 0.1f;
        Cylinder shape = new Cylinder(4, 16, r1, r2, h, true, false);
        Geometry g = new Geometry("center", (Mesh)shape);
        g.setMaterial(matMagenta);
        g.rotate(1.5707964f, 0.0f, 0.0f);
        this.visualizationRoot.attachChild((Spatial)g);
        float l = 1.0f;
        this.visualizationRoot.attachChild((Spatial)this.createArrow(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, l), ColorRGBA.Magenta, 10.0f));
        this.getRootNode().attachChild((Spatial)this.visualizationRoot);
        BitmapFont font = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        float textSize = 0.35f;
        this.label = new BitmapText(font, false);
        this.label.setSize(textSize);
        this.label.setText("Ideationspace");
        float w = this.label.getLineWidth();
        this.label.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f));
        Vector3f pos = new Vector3f(0.0f, 0.65f, 0.0f);
        this.label.setLocalTranslation(pos);
        Vector3f lookat = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f up = Vector3f.UNIT_Y;
        this.label.lookAt(lookat, up);
        this.label.updateLogicalState(1.0f);
        this.getRootNode().attachChild((Spatial)this.label);
        this.orientLabelToWorldPosition(lookat);
    }

    private void orientLabelToWorldPosition(Vector3f w) {
        this.lastLookAtForLabel = w;
        this.label.lookAt(w, Vector3f.UNIT_Y);
    }

    private void reOrientLabelToLastKnownWorldPosition() {
        this.orientLabelToWorldPosition(this.lastLookAtForLabel);
    }

    public void update(float tpf) {
        if (this.positionUpdate) {
            this.getRootNode().setLocalTranslation(this.absolutePosition);
            this.labelNeedsUpdating = true;
            this.positionUpdate = false;
        }
        if (this.rotationUpdate) {
            this.visualizationRoot.setLocalRotation(this.absoluteRotation);
            this.labelNeedsUpdating = true;
            this.rotationUpdate = false;
        }
        if (this.labelNeedsUpdating) {
            this.reOrientLabelToLastKnownWorldPosition();
            this.labelNeedsUpdating = false;
        }
    }

    @Override
    public void setPosition(final Vector3f position) {
        if (position == null) {
            throw new IllegalArgumentException("position must not be null");
        }
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3IdeationSpaceVisualization.this.setPosition(position);
                    return null;
                }
            });
            return;
        }
        this.positionUpdate = true;
        this.absolutePosition = position;
    }

    @Override
    public void setRotation(final Quaternion rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("rotation must not be null");
        }
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3IdeationSpaceVisualization.this.setRotation(rotation);
                    return null;
                }
            });
            return;
        }
        this.rotationUpdate = true;
        this.absoluteRotation = rotation;
    }

    @Override
    public void setName(final String name) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3IdeationSpaceVisualization.this.label.setText(name);
                return this;
            }
        });
    }

    @Override
    public void camRigPositionHasChanged(SixCameraRig camRig) {
        this.lastLookAtForLabel = camRig.getPosition();
        this.labelNeedsUpdating = true;
    }

    @Override
    public void camRigRotationHasChanged(SixCameraRig camRig) {
    }

    @Override
    public void onTransformationHasChanged(IdeationSpace space) {
        this.setRotation(space.getRotation());
        this.setPosition(space.getPosition());
    }

    @Override
    public void onNameHasChanged(IdeationSpace space) {
        this.setName(space.getName());
    }
}

