/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.core.VisibilityChanger;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.util.concurrent.Callable;
import org.joda.time.Duration;

public abstract class Jme3SceneObject
implements VisibilityChanger {
    protected AssetManager assetManager;
    protected Jme3HisClientRenderer jmeRenderer;
    protected Thread renderThread;
    protected Node rootNode;
    private Node parent;

    public Jme3SceneObject(AssetManager assetManager, Jme3HisClientRenderer jmeApp, Thread renderThread) {
        this.assetManager = assetManager;
        this.jmeRenderer = jmeApp;
        this.renderThread = renderThread;
        this.rootNode = new Node(this.getClass().getSimpleName() + " (" + String.valueOf(this.hashCode()) + ") Root");
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    protected Geometry putShape(Mesh shape, ColorRGBA color) {
        Geometry g = new Geometry("coordinate axis", shape);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        return g;
    }

    protected Node createCoordinateAxes(Vector3f pos) {
        return this.createCoordinateAxes(pos, new Vector3f(2.0f, 2.0f, 2.0f));
    }

    protected Node createArrow(Vector3f pos, Vector3f dir, ColorRGBA color, float thickness) {
        Node node = new Node("axes");
        Arrow arrow = new Arrow(dir);
        arrow.setLineWidth(thickness);
        Geometry g = this.putShape((Mesh)arrow, color);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    protected Node createCoordinateAxes(Vector3f pos, Vector3f sizeEachDimension) {
        Node node = new Node("axes");
        Arrow arrow = new Arrow(new Vector3f(sizeEachDimension.x, 0.0f, 0.0f));
        arrow.setLineWidth(2.0f);
        Geometry g = this.putShape((Mesh)arrow, ColorRGBA.Red);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, sizeEachDimension.y, 0.0f));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Green);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, 0.0f, sizeEachDimension.z));
        arrow.setLineWidth(2.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    @Override
    public void show() {
        this.show(null);
    }

    @Override
    public void hide() {
        this.hide(null);
    }

    @Override
    public void show(final Duration transitionDuration) {
        if (!this.jmeRenderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3SceneObject.this.show(transitionDuration);
                    return null;
                }
            });
            return;
        }
        if (!this.isHidden()) {
            return;
        }
        if (transitionDuration == null) {
            // empty if block
        }
        if (null != this.parent) {
            this.parent.attachChild((Spatial)this.rootNode);
        }
    }

    protected boolean isHidden() {
        return this.rootNode.getParent() == null;
    }

    @Override
    public void hide(final Duration transitionDuration) {
        if (!this.jmeRenderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3SceneObject.this.hide(transitionDuration);
                    return null;
                }
            });
            return;
        }
        if (this.isHidden()) {
            return;
        }
        if (transitionDuration == null) {
            // empty if block
        }
        this.parent = this.rootNode.getParent();
        this.parent.detachChild((Spatial)this.rootNode);
    }
}

