/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.core.DrawingArea;
import com.hybridlab.hyve3d.core.DrawingAreaTransformation;
import com.hybridlab.hyve3d.core.DrawingAreaVisualization;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.hybridlab.hyve3d.geometry.Jme3TabletVisualization;
import com.hybridlab.hyve3d.network.interconnection.HisDrawingArea;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

public class Jme3TabletDevice
extends Jme3SceneObject
implements DrawingAreaVisualization {
    private FrameRect frameRect = new FrameRect();
    private Node daRootNode;
    private Node subNode;
    private Geometry touchDot;
    private Logger logger = Logger.getLogger(Jme3TabletDevice.class.getName());
    boolean framerectWasUpdated = false;
    boolean rotationUpdate = false;
    Transform rootWorldTransform = new Transform();
    Transform subNodeLocalTransform = new Transform();
    Vector3f newTouchDotPosition = new Vector3f();
    Vector3f receivedMoveVector = new Vector3f();
    Vector2f receivedMove2dVector = new Vector2f();
    float receivedMove1DScalar = 0.0f;
    private Vector3f absolutePosition = new Vector3f();
    private Quaternion receivedRotation = new Quaternion();
    private Vector2f receivedPivotPoint1 = null;
    private Vector2f receivedPivotPoint2 = null;
    Jme3TabletVisualization iPod;
    float topDummyScale = 1.0f;
    tabletPlanes planes = tabletPlanes.XY;
    private Vector3f lastLookAtForLabel = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean compassUpdate = false;
    private Quaternion northDirectionRotation = new Quaternion();
    private Quaternion camRigRotation = new Quaternion();
    Material matBottom;
    Material matTop;
    Material matLeft;
    Material matRight;
    Geometry frameTopMagenta;
    Geometry frameBottomCyanNextToControls;
    Geometry frameRightGreyNextToButton;
    Geometry frameLeftYellowNextToCamera;
    Geometry planeGeoFront;
    BitmapText label;
    float thickness = 0.006f;
    float zShiftForTransparentQuad = -0.8f * this.thickness;
    private boolean ignoreCamRigUpdates = false;
    private ColorRGBA colorOfDrawingArea;
    private ColorRGBA frameColor = ColorRGBA.Blue;
    private float touchdotRadius = 0.02f;
    Quaternion referenceQuaternionForAxisRotation;
    private boolean camRigUpdate = false;
    private boolean isRemotevisualization = false;
    private Material matTransparentDrawAreaUnShaded;
    private float borderSizeFactor = 0.2f;
    private float cursorSizeFactor = 0.35f;
    private DrawingArea.DrawingAreaStyle style = DrawingArea.DrawingAreaStyle.REGULAR;

    public Jme3TabletDevice(AssetManager assetManager, Jme3HisClientRenderer jmeRenderer, Thread renderThread) {
        super(assetManager, jmeRenderer, renderThread);
    }

    @Override
    public void setIgnoreCamRigUpdates(boolean b) {
        this.ignoreCamRigUpdates = b;
        if (b) {
            this.camRigRotation = new Quaternion();
        }
        this.logger.info(String.format("ignoreCamRigUpdates = %b\ncamRigRotation = %s\n", this.ignoreCamRigUpdates, MathUtils.quaternionToAxisAngleInDegreesString(this.camRigRotation)));
    }

    public void build() {
        this.rootNode.setName(this.getClass().getSimpleName() + " rootNode");
        this.daRootNode = new Node("daRootNodeX");
        this.rootNode.attachChild((Spatial)this.daRootNode);
        this.subNode = new Node("subNodeX");
        this.daRootNode.attachChild((Spatial)this.subNode);
        this.matBottom = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matTop = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matLeft = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matRight = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.setMaterialColors();
        this.createOrUpdateFrameBorders();
        this.createOrUpdateTouchDot();
        Material matdot = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matdot.setColor("Color", ColorRGBA.Magenta);
        this.touchDot.setMaterial(matdot);
        this.subNode.attachChild((Spatial)this.touchDot);
        this.frameTopMagenta.setMaterial(this.matTop);
        this.frameBottomCyanNextToControls.setMaterial(this.matBottom);
        this.frameRightGreyNextToButton.setMaterial(this.matRight);
        this.frameLeftYellowNextToCamera.setMaterial(this.matLeft);
        this.subNode.attachChild((Spatial)this.frameTopMagenta);
        this.subNode.attachChild((Spatial)this.frameRightGreyNextToButton);
        this.subNode.attachChild((Spatial)this.frameLeftYellowNextToCamera);
        this.subNode.attachChild((Spatial)this.frameBottomCyanNextToControls);
        this.subNode.attachChild((Spatial)this.createCoordinateAxes(new Vector3f(0.0f, 0.0f, 0.0f)));
        float tabletScale = 0.05f * this.topDummyScale;
        this.iPod = new Jme3TabletVisualization(this.assetManager, 11.0f, 6.0f, 5.1f, 7.6f, 0.5f, tabletScale);
        Node tabletVisualization = this.iPod.getRootNode();
        tabletVisualization.setLocalRotation(new Quaternion(new float[]{1.5707964f, 0.0f, 0.0f}));
        this.subNode.attachChild((Spatial)tabletVisualization);
        this.matTransparentDrawAreaUnShaded = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        float whitevalue = 0.4f;
        this.colorOfDrawingArea = new ColorRGBA(whitevalue, whitevalue, whitevalue, 0.7f);
        this.matTransparentDrawAreaUnShaded.setColor("Color", this.colorOfDrawingArea);
        this.matTransparentDrawAreaUnShaded.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.matTransparentDrawAreaUnShaded.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        this.planeGeoFront.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.planeGeoFront.setMaterial(this.matTransparentDrawAreaUnShaded);
        BitmapFont font = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        float textSize = 0.35f;
        this.label = new BitmapText(font, false);
        this.label.setSize(textSize);
        this.label.setText("DrawingArea");
        float w = this.label.getLineWidth();
        this.label.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f));
        Vector3f pos = new Vector3f(-0.5f * w, this.frameRectToScene(0.5f * this.frameRect.getDiagonalLength()), 0.0f);
        this.label.setLocalTranslation(pos);
        Vector3f lookat = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f up = Vector3f.UNIT_Y;
        this.label.lookAt(lookat, up);
        this.label.updateLogicalState(1.0f);
        this.rootNode.attachChild((Spatial)this.label);
        this.orientLabelToWorldPosition(lookat);
    }

    private void setMaterialColors() {
        switch (this.style) {
            default: {
                boolean useDebugFrameColors = false;
                if (useDebugFrameColors) {
                    this.matBottom.setColor("Color", ColorRGBA.Cyan);
                    this.matTop.setColor("Color", ColorRGBA.Magenta);
                    this.matLeft.setColor("Color", ColorRGBA.Yellow);
                    this.matRight.setColor("Color", ColorRGBA.Gray);
                    break;
                }
                ColorRGBA frameColor = this.frameColor;
                this.matBottom.setColor("Color", frameColor);
                this.matTop.setColor("Color", frameColor);
                this.matLeft.setColor("Color", frameColor);
                this.matRight.setColor("Color", frameColor);
                break;
            }
            case ACTIVE_SELECTION_PROCESS: 
            case MODIFY_SELECTION: {
                ColorRGBA frameColor = ColorRGBA.Magenta;
                this.matBottom.setColor("Color", frameColor);
                this.matTop.setColor("Color", frameColor);
                this.matLeft.setColor("Color", frameColor);
                this.matRight.setColor("Color", frameColor);
            }
        }
    }

    private void createOrUpdateTouchDot() {
        float r = this.touchdotRadius * this.frameRect.getDiagonalLength() * this.cursorSizeFactor;
        Sphere dotMesh = new Sphere(12, 12, r);
        if (this.touchDot == null) {
            this.touchDot = new Geometry("Touchdot", (Mesh)dotMesh);
        } else {
            this.touchDot.setMesh((Mesh)dotMesh);
        }
    }

    public void setLabelText(final String txt) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3TabletDevice.this.label.setText(txt);
                return this;
            }
        });
    }

    @Override
    public void setTabletVisibility(final boolean visibility) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    if (visibility) {
                        Jme3TabletDevice.this.subNode.attachChild((Spatial)Jme3TabletDevice.this.iPod.getRootNode());
                    } else {
                        Jme3TabletDevice.this.iPod.getRootNode().removeFromParent();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private void applyRotationAroundSinglePivot(Quaternion rotation, Vector2f pivotPoint) {
        if (!this.renderThread.equals(Thread.currentThread())) {
            this.logger.info(Thread.currentThread().toString());
        }
        Vector2f pivotInFrameSpace = this.frameRectToScene(pivotPoint);
        Vector3f newpos = new Vector3f(-pivotInFrameSpace.x, -pivotInFrameSpace.y, 0.0f);
        this.subNode.localToWorld(newpos, newpos);
        Vector3f moveVector = this.daRootNode.getLocalTranslation().clone().subtract(newpos);
        this.daRootNode.move(moveVector);
        this.subNode.setLocalRotation(rotation);
        newpos = new Vector3f(pivotInFrameSpace.x, pivotInFrameSpace.y, 0.0f);
        this.subNode.localToWorld(newpos, newpos);
        moveVector = this.daRootNode.getLocalTranslation().clone().subtract(newpos);
        this.daRootNode.move(moveVector);
    }

    public void update(float tpf) {
        Vector3f moveVector;
        Vector3f newpos;
        boolean labelNeedsUpdating = false;
        boolean doCamRigUpdate = this.camRigUpdate;
        this.touchDot.setLocalTranslation(this.newTouchDotPosition);
        if (this.ignoreCamRigUpdates && this.camRigUpdate && !this.rotationUpdate) {
            doCamRigUpdate = false;
        }
        if (doCamRigUpdate && this.compassUpdate) {
            this.camRigUpdate = false;
            this.compassUpdate = false;
            this.daRootNode.setLocalRotation(this.camRigRotation.mult(this.northDirectionRotation));
        } else {
            if (doCamRigUpdate) {
                this.camRigUpdate = false;
                this.daRootNode.setLocalRotation(this.camRigRotation.mult(this.northDirectionRotation));
            }
            if (this.compassUpdate) {
                this.compassUpdate = false;
                this.daRootNode.setLocalRotation(this.camRigRotation.mult(this.northDirectionRotation));
            }
        }
        if (this.rotationUpdate) {
            this.rotationUpdate = false;
            if (null == this.receivedPivotPoint1) {
                this.subNode.setLocalRotation(this.receivedRotation);
                labelNeedsUpdating = true;
            } else if (null == this.receivedPivotPoint2) {
                this.applyRotationAroundSinglePivot(this.receivedRotation, this.receivedPivotPoint1);
                labelNeedsUpdating = true;
            } else {
                Vector2f pivotInFrameSpace = this.frameRectToScene(this.receivedPivotPoint1);
                Vector3f worldPosPivot1 = new Vector3f(pivotInFrameSpace.x, pivotInFrameSpace.y, 0.0f);
                pivotInFrameSpace = this.frameRectToScene(this.receivedPivotPoint2);
                Vector3f worldPosPivot2 = new Vector3f(pivotInFrameSpace.x, pivotInFrameSpace.y, 0.0f);
                Vector3f rotationAxisInWorld = worldPosPivot2.subtract(worldPosPivot1);
                rotationAxisInWorld.normalizeLocal();
                Vector3f zAxis = new Vector3f(0.0f, 0.0f, 1.0f);
                zAxis.normalizeLocal();
                Vector3f vOrthogonalToRotationAxisAndZAxis = zAxis.cross(rotationAxisInWorld);
                Quaternion opposite = this.receivedRotation.opposite();
                Quaternion diffRotation = this.referenceQuaternionForAxisRotation.mult(opposite);
                Vector3f rotatedZAxis = new Vector3f();
                diffRotation.multLocal(zAxis);
                Vector3f a = zAxis.project(rotatedZAxis);
                Vector3f b = zAxis.project(vOrthogonalToRotationAxisAndZAxis);
                Vector3f projected = new Vector3f();
                projected = a.add(b);
                float alpha = projected.angleBetween(zAxis);
                Quaternion qAlpha = Quaternion.IDENTITY.fromAngleAxis(alpha, rotationAxisInWorld);
                Quaternion qToApply = this.referenceQuaternionForAxisRotation.mult(qAlpha);
                this.applyRotationAroundSinglePivot(qToApply.clone(), this.receivedPivotPoint1.clone());
                labelNeedsUpdating = true;
            }
        }
        if (this.receivedMoveVector.x != 0.0f || this.receivedMoveVector.y != 0.0f || this.receivedMoveVector.z != 0.0f) {
            this.absolutePosition = this.absolutePosition.add(this.receivedMoveVector);
            this.receivedMoveVector.x = 0.0f;
            this.receivedMoveVector.y = 0.0f;
            this.receivedMoveVector.z = 0.0f;
        }
        if (this.receivedMove2dVector.x != 0.0f || this.receivedMove2dVector.y != 0.0f) {
            Vector2f relmoveFramerect = this.frameRectToScene(this.receivedMove2dVector);
            newpos = new Vector3f(relmoveFramerect.x, relmoveFramerect.y, 0.0f);
            this.subNode.localToWorld(newpos, newpos);
            moveVector = this.rootNode.getLocalTranslation().clone().subtract(newpos);
            this.absolutePosition = this.absolutePosition.add(moveVector);
            this.receivedMove2dVector.x = 0.0f;
            this.receivedMove2dVector.y = 0.0f;
        }
        if (this.receivedMove1DScalar != 0.0f) {
            float relmoveFramerect = this.frameRectToScene(this.receivedMove1DScalar);
            newpos = new Vector3f(0.0f, 0.0f, relmoveFramerect);
            this.subNode.localToWorld(newpos, newpos);
            moveVector = this.rootNode.getLocalTranslation().clone().subtract(newpos);
            this.absolutePosition = this.absolutePosition.add(moveVector);
            this.receivedMove1DScalar = 0.0f;
        }
        this.rootNode.setLocalTranslation(this.absolutePosition);
        if (this.framerectWasUpdated) {
            try {
                this.createOrUpdateFrameBorders();
                this.createOrUpdateTouchDot();
                this.framerectWasUpdated = false;
                labelNeedsUpdating = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (labelNeedsUpdating) {
            float w = this.label.getLineWidth();
            Vector3f pos = new Vector3f(0.5f * w, this.frameRectToScene(0.5f * this.frameRect.getDiagonalLength()), 0.0f);
            this.label.setLocalTranslation(pos);
            this.reOrientLabelToLastKnownWorldPosition();
        }
        this.rootNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
    }

    private void createOrUpdateFrameBorders() {
        Box meshRight;
        Box meshBottom;
        Box meshTop;
        float borderthickness = this.borderSizeFactor * this.thickness * this.frameRect.getDiagonalLength();
        float tabletFrameWidth = this.topDummyScale * this.frameRect.getWidth() * 0.5f;
        float tabletFrameHeight = this.topDummyScale * this.frameRect.getHeight() * 0.5f;
        Box meshLeft = switch (this.planes) {
            case tabletPlanes.XY -> {
                meshTop = new Box(borderthickness, tabletFrameWidth, borderthickness);
                meshBottom = new Box(borderthickness, tabletFrameWidth, borderthickness);
                meshRight = new Box(tabletFrameHeight, borderthickness, borderthickness);
                yield new Box(tabletFrameHeight, borderthickness, borderthickness);
            }
            default -> {
                meshTop = new Box(borderthickness, borderthickness, tabletFrameWidth);
                meshBottom = new Box(borderthickness, borderthickness, tabletFrameWidth);
                meshRight = new Box(tabletFrameHeight, borderthickness, borderthickness);
                yield new Box(tabletFrameHeight, borderthickness, borderthickness);
            }
        };
        if (this.frameTopMagenta == null) {
            this.frameTopMagenta = new Geometry("frameTop", (Mesh)meshTop);
        } else {
            this.frameTopMagenta.setMesh((Mesh)meshTop);
        }
        if (this.frameBottomCyanNextToControls == null) {
            this.frameBottomCyanNextToControls = new Geometry("frameBottomCyanNextToControls", (Mesh)meshBottom);
        } else {
            this.frameBottomCyanNextToControls.setMesh((Mesh)meshBottom);
        }
        if (this.frameRightGreyNextToButton == null) {
            this.frameRightGreyNextToButton = new Geometry("frameRightNextToButton", (Mesh)meshRight);
        } else {
            this.frameRightGreyNextToButton.setMesh((Mesh)meshRight);
        }
        if (this.frameLeftYellowNextToCamera == null) {
            this.frameLeftYellowNextToCamera = new Geometry("frameLeftNextToCamera", (Mesh)meshLeft);
        } else {
            this.frameLeftYellowNextToCamera.setMesh((Mesh)meshLeft);
        }
        float positionFactor = 1.0f;
        switch (this.planes) {
            case XY: {
                this.frameTopMagenta.setLocalTranslation(positionFactor * tabletFrameHeight, 0.0f, 0.0f);
                this.frameBottomCyanNextToControls.setLocalTranslation(-positionFactor * tabletFrameHeight, 0.0f, 0.0f);
                this.frameRightGreyNextToButton.setLocalTranslation(0.0f, -positionFactor * tabletFrameWidth, 0.0f);
                this.frameLeftYellowNextToCamera.setLocalTranslation(0.0f, positionFactor * tabletFrameWidth, 0.0f);
                break;
            }
            default: {
                this.frameTopMagenta.setLocalTranslation(positionFactor * tabletFrameHeight, 0.0f, 0.0f);
                this.frameBottomCyanNextToControls.setLocalTranslation(-positionFactor * tabletFrameHeight, 0.0f, 0.0f);
                this.frameRightGreyNextToButton.setLocalTranslation(0.0f, 0.0f, positionFactor * tabletFrameWidth);
                this.frameLeftYellowNextToCamera.setLocalTranslation(0.0f, 0.0f, -positionFactor * tabletFrameWidth);
            }
        }
        float planeXDimension = this.topDummyScale * this.frameRect.getHeight();
        float planeYDimension = this.topDummyScale * this.frameRect.getWidth();
        if (this.planeGeoFront == null) {
            this.planeGeoFront = new Geometry("planequad", (Mesh)new Quad(planeXDimension, planeYDimension));
            Node planeNode = new Node("plane");
            planeNode.attachChild((Spatial)this.planeGeoFront);
            this.subNode.attachChild((Spatial)planeNode);
            switch (this.planes) {
                case XY: {
                    break;
                }
                default: {
                    planeNode.setLocalRotation(new Quaternion(new float[]{-1.5707964f, 0.0f, 0.0f}));
                    break;
                }
            }
        } else {
            this.planeGeoFront.setMesh((Mesh)new Quad(planeXDimension, planeYDimension));
        }
        float zShift = this.zShiftForTransparentQuad * this.borderSizeFactor * this.frameRect.getDiagonalLength();
        this.planeGeoFront.setLocalTranslation(planeXDimension * -0.5f, planeYDimension * -0.5f, zShift);
    }

    @Override
    public void setCursorPointPosition(final Vector2f p) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Vector2f scenepoint = Jme3TabletDevice.this.frameRectToScene(p);
                switch (Jme3TabletDevice.this.planes) {
                    case XY: {
                        Jme3TabletDevice.this.newTouchDotPosition.x = scenepoint.x;
                        Jme3TabletDevice.this.newTouchDotPosition.y = scenepoint.y;
                        Jme3TabletDevice.this.newTouchDotPosition.z = 0.0f;
                        break;
                    }
                    case XZ: {
                        Jme3TabletDevice.this.newTouchDotPosition.x = scenepoint.x;
                        Jme3TabletDevice.this.newTouchDotPosition.y = 0.0f;
                        Jme3TabletDevice.this.newTouchDotPosition.z = scenepoint.y;
                    }
                }
                return this;
            }
        });
    }

    @Override
    public void setRotation(final Quaternion quaternion) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Jme3TabletDevice.this.setRotation(quaternion);
                    return this;
                }
            });
            return;
        }
        this.receivedRotation = quaternion;
        this.rotationUpdate = true;
        this.receivedPivotPoint1 = null;
        this.receivedPivotPoint2 = null;
    }

    @Override
    public void setRotation(final Quaternion rotation, final Vector2f pivot) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3TabletDevice.this.receivedRotation = rotation;
                Jme3TabletDevice.this.rotationUpdate = true;
                Jme3TabletDevice.this.receivedPivotPoint1 = pivot;
                Jme3TabletDevice.this.receivedPivotPoint2 = null;
                Jme3TabletDevice.this.setCursorPointPosition(pivot);
                return this;
            }
        });
    }

    @Override
    public void setRotation(final Quaternion rotation, final Vector2f pivot1, final Vector2f pivot2) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3TabletDevice.this.receivedRotation = rotation;
                Jme3TabletDevice.this.rotationUpdate = true;
                boolean newValues = false;
                if (Jme3TabletDevice.this.receivedPivotPoint1 == null || Jme3TabletDevice.this.receivedPivotPoint2 == null) {
                    newValues = true;
                }
                if (!pivot1.equals((Object)Jme3TabletDevice.this.receivedPivotPoint1) || !pivot2.equals((Object)Jme3TabletDevice.this.receivedPivotPoint2)) {
                    newValues = true;
                }
                if (newValues) {
                    Jme3TabletDevice.this.referenceQuaternionForAxisRotation = rotation.clone();
                    Jme3TabletDevice.this.receivedPivotPoint1 = pivot1;
                    Jme3TabletDevice.this.receivedPivotPoint2 = pivot2;
                }
                return this;
            }
        });
    }

    private Vector2f frameRectToScene(Vector2f v) {
        switch (this.planes) {
            case XY: {
                return new Vector2f(v.y * this.topDummyScale, -v.x * this.topDummyScale);
            }
        }
        return new Vector2f(v.y * this.topDummyScale, v.x * this.topDummyScale);
    }

    private float frameRectToScene(float v) {
        return v * this.topDummyScale;
    }

    @Override
    public void setFrameRect(final FrameRect r) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3TabletDevice.this.frameRect = r;
                Jme3TabletDevice.this.framerectWasUpdated = true;
                return this;
            }
        });
    }

    @Override
    public Vector3f getScenePositionOfPointOnDrawArea(final Vector2f point2d) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            try {
                this.jmeRenderer.enqueue(new Callable<Vector3f>(){

                    @Override
                    public Vector3f call() {
                        return Jme3TabletDevice.this.getScenePositionOfPointOnDrawArea(point2d);
                    }
                }).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        Vector2f sceneVector = this.frameRectToScene(point2d);
        Vector3f worldpos = switch (this.planes) {
            case tabletPlanes.XY -> new Vector3f(sceneVector.x, sceneVector.y, 0.0f);
            default -> new Vector3f(sceneVector.x, 0.0f, sceneVector.y);
        };
        this.subNode.localToWorld(worldpos, worldpos);
        return worldpos;
    }

    public void wipe() {
        this.rootNode.removeFromParent();
    }

    @Override
    public void move(final Vector3f moveVector) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() {
                Jme3TabletDevice.this.receivedMoveVector.addLocal(moveVector);
                return this;
            }
        });
    }

    @Override
    public void move(final Vector2f moveVector) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() {
                Vector2f sceneVector = new Vector2f(-moveVector.x, moveVector.y);
                Jme3TabletDevice.this.receivedMove2dVector.addLocal(sceneVector);
                return this;
            }
        });
    }

    @Override
    public void move(final float moveAmount) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() {
                Jme3TabletDevice.this.receivedMove1DScalar += moveAmount;
                return this;
            }
        });
    }

    @Override
    public Vector3f getTranslation() {
        return this.rootNode.getLocalTranslation();
    }

    @Override
    public void setTranslation(final Vector3f vector3f) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3TabletDevice.this.setTranslation(vector3f);
                    return this;
                }
            });
            return;
        }
        this.absolutePosition = vector3f;
    }

    @Override
    public void camRigPositionHasChanged(final Vector3f camRigPosition) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3TabletDevice.this.camRigPositionHasChanged(camRigPosition);
                    return this;
                }
            });
            return;
        }
        this.orientLabelToWorldPosition(camRigPosition);
    }

    private void orientLabelToWorldPosition(Vector3f w) {
        this.lastLookAtForLabel = w;
        this.label.lookAt(w, Vector3f.UNIT_Y);
    }

    private void reOrientLabelToLastKnownWorldPosition() {
        this.orientLabelToWorldPosition(this.lastLookAtForLabel);
    }

    @Override
    public void setDrawAreaLabelText(String txt) {
        this.setLabelText(txt);
    }

    @Override
    public void camRigRotationHasChanged(final Quaternion camRigRotation) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3TabletDevice.this.camRigRotationHasChanged(camRigRotation);
                    return this;
                }
            });
            return;
        }
        if (!this.ignoreCamRigUpdates) {
            this.camRigRotation = camRigRotation;
            this.camRigUpdate = true;
        }
    }

    @Override
    public void compassHeadingHasChanged(final Quaternion compassHeadingRotation) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3TabletDevice.this.compassHeadingHasChanged(compassHeadingRotation);
                    return this;
                }
            });
            return;
        }
        this.northDirectionRotation = compassHeadingRotation;
        this.compassUpdate = true;
    }

    @Override
    public void onTransformationHasChanged(HisDrawingArea da) {
        DrawingAreaTransformation trf = da.getTransformation();
        Quaternion cr = trf.getCompassHeadingRotation();
        this.compassHeadingHasChanged(cr);
        this.camRigRotationHasChanged(trf.getCamRigRotation());
        this.setFrameRect(trf.getFrameRect());
        this.setTranslation(trf.getTranslation());
        this.setRotation(trf.getRotation());
    }

    @Override
    public void setIsRemoteVisualization(boolean b) {
        this.isRemotevisualization = b;
        this.setTransparency(0.1f);
    }

    @Override
    public void onLabelHasChanged(HisDrawingArea drawingArea) {
        this.setLabelText(drawingArea.getLabelText());
    }

    @Override
    public void onVisibilityChanged(HisDrawingArea drawingArea, boolean isVisibleNow) {
        if (isVisibleNow) {
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void setDefaultValue(DrawingAreaVisualization.VisualizationDefaultValueType valueType, Object value) {
        float f = ((Float)value).floatValue();
        switch (valueType) {
            case BorderSizeFactor: {
                this.setBorderSizeFactor(f);
                break;
            }
            case CursorSizeFactor: {
                this.setCursorSizeFactor(f);
                break;
            }
            case Transparency: {
                this.setTransparency(f);
                break;
            }
        }
    }

    private void setBorderSizeFactor(final float f) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3TabletDevice.this.setBorderSizeFactor(f);
                    return this;
                }
            });
            return;
        }
        this.borderSizeFactor = f;
        this.createOrUpdateFrameBorders();
    }

    private void setCursorSizeFactor(final float f) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3TabletDevice.this.setCursorSizeFactor(f);
                    return this;
                }
            });
            return;
        }
        this.cursorSizeFactor = f;
        this.createOrUpdateTouchDot();
    }

    private void setTransparency(final float f) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3TabletDevice.this.setTransparency(f);
                    return this;
                }
            });
            return;
        }
        this.colorOfDrawingArea.a = f;
        this.matTransparentDrawAreaUnShaded.setColor("Color", this.colorOfDrawingArea);
    }

    @Override
    public void onStyleHasChanged(HisDrawingArea drawingArea, DrawingArea.DrawingAreaStyle currentStyle) {
        if (!this.style.equals((Object)currentStyle)) {
            this.style = currentStyle;
            this.setMaterialColors();
        }
    }

    @Override
    public void onFrameColorHasChanged(HisDrawingArea drawingArea) {
        this.setFrameColor(drawingArea.getFrameColor());
    }

    @Override
    public void setFrameColor(ColorRGBA color) {
        this.frameColor = color;
        this.setMaterialColors();
    }

    static enum tabletPlanes {
        XZ,
        XY;

    }
}

