/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.locations;

import com.hybridlab.hyve3d.core.CamRigPositionAndRotationListener;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.hybridlab.hyve3d.rendering.projection.SixCameraRig;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.joda.time.Duration;

public class Compass
extends Jme3SceneObject
implements CamRigPositionAndRotationListener {
    Quaternion camRigRotation = new Quaternion();
    float northHeadingInDegrees = 0.0f;
    private Set<CompassListener> listeners = new HashSet<CompassListener>();

    public Compass(AssetManager am, Jme3HisClientRenderer r, Thread rt) {
        super(am, r, rt);
        this.updateRootNodeRotation();
    }

    @Override
    public void camRigPositionHasChanged(SixCameraRig camRig) {
        this.rootNode.setLocalTranslation(camRig.getLocalTranslation());
    }

    public void addListener(CompassListener listener) {
        this.listeners.add(listener);
        listener.compassHeadingHasChanged(this);
    }

    public Quaternion getNorthHeadingRotation() {
        Quaternion north = new Quaternion();
        north.fromAngleAxis(this.northHeadingInDegrees * ((float)Math.PI / 180), Vector3f.UNIT_Y);
        return north;
    }

    @Override
    public void camRigRotationHasChanged(SixCameraRig camRig) {
        this.camRigRotation = camRig.getLocalRotation();
        this.updateRootNodeRotation();
    }

    private void updateRootNodeRotation() {
        if (!this.jmeRenderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Compass.this.updateRootNodeRotation();
                    return null;
                }
            });
            return;
        }
        Quaternion north = this.getNorthHeadingRotation();
        Quaternion myRot = this.camRigRotation.mult(north);
        this.rootNode.setLocalRotation(myRot);
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public void changeNorthHeadingByDegrees(float angleDeg) {
        this.northHeadingInDegrees += angleDeg;
        this.hasChanged();
    }

    public void setNorthHeadingInDegrees(final float angleDeg) {
        if (!this.jmeRenderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Compass.this.setNorthHeadingInDegrees(angleDeg);
                    return null;
                }
            });
            return;
        }
        this.northHeadingInDegrees = angleDeg;
        this.hasChanged();
    }

    private void hasChanged() {
        for (CompassListener l : this.listeners) {
            l.compassHeadingHasChanged(this);
        }
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Compass.this.updateRootNodeRotation();
                return null;
            }
        });
    }

    public float getHeadingAngleInDegrees() {
        return this.northHeadingInDegrees;
    }

    public boolean isVisible() {
        return !this.isHidden();
    }

    @Override
    public void show(Duration transitionDuration) {
        boolean wasAlreadyShown = !this.isHidden();
        super.show(transitionDuration);
        if (!wasAlreadyShown) {
            this.visibilityHasChanged();
        }
    }

    private void visibilityHasChanged() {
        for (CompassListener l : this.listeners) {
            l.visibilityHasChanged(this);
        }
    }

    @Override
    public void hide(Duration transitionDuration) {
        boolean wasAlreadyHidden = this.isHidden();
        super.hide(transitionDuration);
        if (!wasAlreadyHidden) {
            this.visibilityHasChanged();
        }
    }

    public static interface CompassListener {
        public void compassHeadingHasChanged(Compass var1);

        public void visibilityHasChanged(Compass var1);
    }
}

