/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data;

import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.commands.CommandChangeMode;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.CopyAble;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.hyve.undoredo.AbstractCommandExecutor;
import com.hybridlab.hyve3d.hyve.undoredo.CommandExecutor;
import com.hybridlab.hyve3d.hyve.undoredo.CopyCommand;
import com.hybridlab.hyve3d.hyve.undoredo.DrawingAreaTransformationCommand;
import com.hybridlab.hyve3d.hyve.undoredo.DrawingAreaTransformerState;
import com.hybridlab.hyve3d.hyve.undoredo.EraseCommand;
import com.hybridlab.hyve3d.hyve.undoredo.Executable;
import com.hybridlab.hyve3d.hyve.undoredo.ReleaseSelectionCommand;
import com.hybridlab.hyve3d.hyve.undoredo.SelectionCommand;
import com.hybridlab.hyve3d.hyve.undoredo.SelectionTransformationCommand;
import com.hybridlab.hyve3d.hyve.undoredo.StrokeCreationCommand;
import com.hybridlab.hyve3d.hyve.undoredo.TransformerState;
import com.hybridlab.hyve3d.scenemanipulation.SceneElementSelector;
import com.jme3.math.Transform;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class CommandExecutorHelper {
    public static void attachExecutor(Executable e, Session session) {
        if (e instanceof EraseCommand) {
            cmd = (EraseCommand)e;
            CommandExecutor cex = CommandExecutorHelper.createExecutor((EraseCommand)cmd, session);
            cmd.setExecutor(cex);
        } else if (e instanceof CopyCommand) {
            cmd = (CopyCommand)e;
            CommandExecutor cex = CommandExecutorHelper.createExecutor((CopyCommand)cmd, session);
            cmd.setExecutor(cex);
        } else if (e instanceof StrokeCreationCommand) {
            cmd = (StrokeCreationCommand)e;
            CommandExecutor cex = CommandExecutorHelper.createExecutor((StrokeCreationCommand)cmd, session);
            cmd.setExecutor(cex);
        } else if (e instanceof SelectionTransformationCommand) {
            cmd = (SelectionTransformationCommand)e;
            CommandExecutor cex = CommandExecutorHelper.createSelectionTransformationExecutor((SelectionTransformationCommand)cmd, session);
            cmd.setExecutor(cex);
        } else if (e instanceof SelectionCommand) {
            cmd = (SelectionCommand)e;
            CommandExecutor cex = CommandExecutorHelper.createSelectionExecutor((SelectionCommand)cmd, session);
            cmd.setExecutor(cex);
        }
        String cmdToString = e == null ? "null" : e.toString();
        Logger.getAnonymousLogger().info(cmdToString);
    }

    private static CommandExecutor createSelectionExecutor(SelectionCommand cmd, Session session) {
        return new CommandExecutor(){

            @Override
            public void undo() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionExecutor");
            }

            @Override
            public void setIsExecuted(boolean executed) {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionExecutor");
            }

            @Override
            public void redo() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionExecutor");
            }

            @Override
            public boolean isExecuted() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionExecutor");
                return false;
            }

            @Override
            public void execute() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionExecutor");
            }
        };
    }

    private static CommandExecutor createExecutor(EraseCommand cmd, Session session) {
        Set<UUID> ids = cmd.getEraseItems();
        Set<HyveData> all = session.getWithIDs(ids);
        if (all != null) {
            return CommandExecutorHelper.createEraseExecutor(session, all);
        }
        throw new RuntimeException("cannot create EraseAllExecutor");
    }

    private static CommandExecutor createExecutor(EraseCommand cmd, Session session, SceneElementSelector selector, Satellite satellite) {
        Set<UUID> ids = cmd.getEraseItems();
        Set<HyveData> all = session.getWithIDs(ids);
        if (all != null) {
            return CommandExecutorHelper.createEraseExecutor(session, all, selector, satellite);
        }
        throw new RuntimeException("cannot create EraseAllExecutor");
    }

    private static CommandExecutor createExecutor(StrokeCreationCommand cmd, Session session) {
        UUID strokeid = cmd.getStrokeId();
        Stroke stroke = session.getWithID(strokeid.toString(), Stroke.class);
        if (stroke != null) {
            return CommandExecutorHelper.createStrokeCreationExecutor(session, stroke);
        }
        throw new RuntimeException("cannot create StrokeCreationExecutor");
    }

    private static CommandExecutor createExecutor(CopyCommand cmd, Session session) {
        Map<UUID, UUID> ids = cmd.getItemsToCopyMap();
        Set<HyveData> toCopy = session.getWithIDs(ids.keySet());
        if (toCopy != null) {
            return CommandExecutorHelper.createCopyExecutor(session, toCopy, ids);
        }
        throw new RuntimeException("cannot create CopyExecutor");
    }

    public static CommandExecutor createStrokeCreationExecutor(Session session, Stroke stroke) {
        return new StrokeCreationExecutor(session, stroke);
    }

    public static CommandExecutor createEraseExecutor(Session erasingSession, Set<HyveData> all) {
        return new EraseExecutor(erasingSession, all);
    }

    public static CommandExecutor createEraseExecutor(Session erasingSession, Set<HyveData> all, SceneElementSelector selector, Satellite satellite) {
        return new EraseExecutor(erasingSession, all, selector, satellite);
    }

    public static CommandExecutor createReleaseAllExecutor(SceneElementSelector selector, Satellite satellite, ReleaseSelectionCommand releaseSelectionCommand) {
        return new ReleaseAllExecutor(selector, satellite, releaseSelectionCommand);
    }

    public static CommandExecutor createCopyExecutor(Session session, Set<HyveData> copyItems, Map<UUID, UUID> ids) {
        return new CopyExecutor(session, copyItems, ids);
    }

    public static CommandExecutor createSelectionTransformationExecutor(Set<Selectable> selected, SelectionTransformationCommand selectionTrfCommand) {
        return new SelectionTransformationExecutor(selected, selectionTrfCommand);
    }

    private static CommandExecutor createSelectionTransformationExecutor(SelectionTransformationCommand cmd, Session session) {
        return new CommandExecutor(){

            @Override
            public void undo() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionTransformationExecutor");
            }

            @Override
            public void setIsExecuted(boolean executed) {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionTransformationExecutor");
            }

            @Override
            public void redo() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionTransformationExecutor");
            }

            @Override
            public boolean isExecuted() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionTransformationExecutor");
                return false;
            }

            @Override
            public void execute() {
                Logger.getAnonymousLogger().severe("Unimplemented SelectionTransformationExecutor");
            }
        };
    }

    public static CommandExecutor createSelectionTransformationExecutor(DrawingArea drawingArea, Set<Selectable> selected, SelectionTransformationCommand selectionTrfCommand) {
        return new SelectionTransformationExecutor(selected, selectionTrfCommand, drawingArea);
    }

    public static CommandExecutor createDrawingAreaTransformationCommandExecutor(DrawingArea drawingArea, DrawingAreaTransformationCommand daCmd) {
        return new DrawingAreaTransformationCommandExecutor(daCmd, drawingArea);
    }

    private static class StrokeCreationExecutor
    extends AbstractCommandExecutor {
        private Session session;
        private Stroke stroke;

        public StrokeCreationExecutor(Session session, Stroke stroke) {
            this.stroke = stroke;
            this.session = session;
        }

        @Override
        public void undo() {
            if (!this.isExecuted()) {
                return;
            }
            this.setIsExecuted(false);
            this.session.remove(this.stroke);
        }

        @Override
        public void execute() {
            if (this.isExecuted()) {
                return;
            }
            this.setIsExecuted(true);
            try {
                this.session.add(this.stroke);
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
        }
    }

    private static class EraseExecutor
    extends AbstractCommandExecutor {
        private Session erasingSession;
        private Set<HyveData> dataToErase;
        private SceneElementSelector selector;
        private Satellite satellite;

        public EraseExecutor(Session erasingSession, Set<HyveData> dataToErase, SceneElementSelector selector, Satellite satellite) {
            this.erasingSession = erasingSession;
            this.dataToErase = dataToErase;
            this.selector = selector;
            this.satellite = satellite;
        }

        public EraseExecutor(Session erasingSession, Set<HyveData> dataToErase) {
            this.erasingSession = erasingSession;
            this.dataToErase = dataToErase;
        }

        @Override
        public void undo() {
            if (!this.isExecuted()) {
                return;
            }
            this.setIsExecuted(false);
            HashSet<UUID> ids = new HashSet<UUID>();
            for (HyveData data : this.dataToErase) {
                try {
                    this.erasingSession.add(data);
                    ids.add(data.getId());
                }
                catch (ConcurrentAddException e) {
                    e.printStackTrace();
                }
            }
            if (this.selector != null) {
                this.selector.regainSelection(ids);
            }
            if (this.satellite != null) {
                this.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Editing);
            }
        }

        @Override
        public void execute() {
            if (this.isExecuted()) {
                return;
            }
            this.setIsExecuted(true);
            if (this.selector != null) {
                this.selector.dismissSelection();
            }
            if (this.selector != null) {
                this.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Drawing);
            }
            for (HyveData data : this.dataToErase) {
                this.erasingSession.remove(data);
            }
        }
    }

    private static class ReleaseAllExecutor
    extends AbstractCommandExecutor {
        private ReleaseSelectionCommand releaseSelectionCommand;
        private SceneElementSelector selector;
        private Satellite satellite;

        public ReleaseAllExecutor(SceneElementSelector selector, Satellite satellite, ReleaseSelectionCommand releaseSelectionCommand) {
            this.selector = selector;
            this.satellite = satellite;
            this.releaseSelectionCommand = releaseSelectionCommand;
        }

        @Override
        public void undo() {
            if (!this.isExecuted()) {
                return;
            }
            this.setIsExecuted(false);
            this.selector.regainSelection(this.releaseSelectionCommand.getIds());
            this.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Editing);
        }

        @Override
        public void execute() {
            if (this.isExecuted()) {
                return;
            }
            this.setIsExecuted(true);
            this.selector.dismissSelection();
            this.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Drawing);
        }
    }

    private static class CopyExecutor
    extends AbstractCommandExecutor {
        private Session session;
        private Set<HyveData> dataToCopy;
        private Set<HyveData> copies;
        private Map<UUID, UUID> idMap;

        public CopyExecutor(Session session, Set<HyveData> copyItems, Map<UUID, UUID> ids) {
            this.session = session;
            this.dataToCopy = copyItems;
            this.idMap = ids;
        }

        @Override
        public void execute() {
            if (this.isExecuted()) {
                return;
            }
            this.setIsExecuted(true);
            if (this.copies == null) {
                this.copies = new HashSet<HyveData>(this.dataToCopy.size());
                for (HyveData data : this.dataToCopy) {
                    if (!(data instanceof CopyAble)) continue;
                    CopyAble cd = (CopyAble)((Object)data);
                    UUID idForCopy = this.idMap.get(data.getId());
                    HyveData copy = cd.createCopy(idForCopy);
                    this.copies.add(copy);
                }
            }
            for (HyveData copy : this.copies) {
                try {
                    this.session.add(copy);
                }
                catch (ConcurrentAddException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void undo() {
            if (!this.isExecuted()) {
                return;
            }
            this.setIsExecuted(false);
            if (this.copies == null) {
                this.copies = this.session.getWithIDs(new HashSet<UUID>(this.idMap.values()));
            }
            for (HyveData copy : this.copies) {
                this.session.remove(copy);
            }
        }
    }

    private static class SelectionTransformationExecutor
    extends AbstractCommandExecutor {
        private Set<Selectable> selectables;
        private SelectionTransformationCommand cmd;
        private DrawingArea transformer;

        public SelectionTransformationExecutor(Set<Selectable> selected, SelectionTransformationCommand selectionTrfCommand) {
            this.selectables = selected;
            this.cmd = selectionTrfCommand;
        }

        public SelectionTransformationExecutor(Set<Selectable> selected, SelectionTransformationCommand selectionTrfCommand, DrawingArea drawingArea) {
            this(selected, selectionTrfCommand);
            this.transformer = drawingArea;
        }

        @Override
        public void execute() {
            TransformerState trfState;
            if (this.isExecuted()) {
                return;
            }
            this.setIsExecuted(true);
            for (Selectable s : this.selectables) {
                Transform trf = this.cmd.getAfterTransformation(s.getId());
                if (trf == null) continue;
                s.setTransformation(trf);
            }
            if (this.transformer != null && (trfState = this.cmd.getTrfStateAfter()) instanceof DrawingAreaTransformerState) {
                DrawingAreaTransformerState dastate = (DrawingAreaTransformerState)trfState;
                this.transformer.setTransformation(dastate.getTransformation());
                this.transformer.setFrame(dastate.getFrame());
            }
        }

        @Override
        public void undo() {
            TransformerState trfState;
            if (!this.isExecuted()) {
                return;
            }
            this.setIsExecuted(false);
            for (Selectable s : this.selectables) {
                Transform trf = this.cmd.getBeforeTransformation(s.getId());
                if (trf == null) continue;
                s.setTransformation(trf);
            }
            if (this.transformer != null && (trfState = this.cmd.getTrfStateBefore()) instanceof DrawingAreaTransformerState) {
                DrawingAreaTransformerState dastate = (DrawingAreaTransformerState)trfState;
                this.transformer.setTransformation(dastate.getTransformation());
                this.transformer.setFrame(dastate.getFrame());
            }
        }
    }

    private static class DrawingAreaTransformationCommandExecutor
    extends AbstractCommandExecutor {
        private DrawingAreaTransformationCommand cmd;
        private DrawingArea drawingarea;

        public DrawingAreaTransformationCommandExecutor(DrawingAreaTransformationCommand cmd, DrawingArea drawingArea) {
            this.cmd = cmd;
            this.drawingarea = drawingArea;
        }

        @Override
        public void execute() {
            TransformerState trfState;
            if (this.isExecuted()) {
                return;
            }
            this.setIsExecuted(true);
            if (this.drawingarea != null && (trfState = this.cmd.getTrfStateAfter()) instanceof DrawingAreaTransformerState) {
                DrawingAreaTransformerState dastate = (DrawingAreaTransformerState)trfState;
                this.drawingarea.setTransformation(dastate.getTransformation());
                this.drawingarea.setFrame(dastate.getFrame());
            }
        }

        @Override
        public void undo() {
            TransformerState trfState;
            if (!this.isExecuted()) {
                return;
            }
            this.setIsExecuted(false);
            if (this.drawingarea != null && (trfState = this.cmd.getTrfStateBefore()) instanceof DrawingAreaTransformerState) {
                DrawingAreaTransformerState dastate = (DrawingAreaTransformerState)trfState;
                this.drawingarea.setTransformation(dastate.getTransformation());
                this.drawingarea.setFrame(dastate.getFrame());
            }
        }
    }
}

