/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.DataModelObserver;
import com.hybridlab.hyve3d.data.DataPoolAccess;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.synch.SynchronizableDataModel;
import com.hybridlab.hyve3d.data.synch.Synchronizer;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DataPool
implements SynchronizableDataModel,
DataPoolAccess,
PropertyChangeListener {
    private Map<String, Object> propertyMap = new HashMap<String, Object>();
    private Map<String, HyveData> dataIdMap = new HashMap<String, HyveData>();
    private Map<DataModelKey, HyveData> dataModelMap = new HashMap<DataModelKey, HyveData>();
    private Map<String, PropertyDescriptor> dataPropertyMap = new HashMap<String, PropertyDescriptor>();
    private Set<DataModelObserver> observer = new HashSet<DataModelObserver>();
    private ChangedPropertyInfo currentChangedProperty = new ChangedPropertyInfo();
    private Synchronizer synchronizer;
    private boolean isLeading = true;

    @Override
    public void setSynchronizer(Synchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void addObserver(DataModelObserver observer) {
        this.observer.add(observer);
    }

    public void removeObserver(DataModelObserver observer) {
        this.observer.remove(observer);
    }

    protected <T extends HyveData> Set<T> getAll(Class<T> clazz) {
        HashSet<HyveData> result = new HashSet<HyveData>();
        for (HyveData d : this.dataModelMap.values()) {
            if (!clazz.isInstance(d)) continue;
            HyveData r = d;
            result.add(r);
        }
        return result;
    }

    public Set<HyveData> getWithIDs(Set<UUID> ids) {
        HashSet<HyveData> result = new HashSet<HyveData>();
        for (UUID id : ids) {
            HyveData d;
            if (id == null || (d = this.getWithID(id.toString(), HyveData.class)) == null) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public <T extends HyveData> T getWithID(String id, Class<T> clazz) {
        HyveData d = this.findById(id);
        if (!clazz.isInstance(d)) {
            return null;
        }
        try {
            HyveData r = d;
            return (T)r;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private HyveData findById(String id) {
        return this.dataIdMap.get(id);
    }

    private void add(DataModelKey key, HyveData data) throws ConcurrentAddException {
        PropertyDescriptor[] pds;
        if (this.dataModelMap.containsKey(key)) {
            ConcurrentAddException cae = new ConcurrentAddException("The data with key " + key + " is already in the Datapool.");
            throw cae;
        }
        this.dataModelMap.put(key, data);
        UUID id = data.getId();
        if (id != null) {
            this.dataIdMap.put(id.toString(), data);
        }
        for (DataModelObserver o : this.observer) {
            o.onDataAdded(key, data);
        }
        for (PropertyDescriptor pd : pds = HyveData.getPropertyDescriptors(data.getClass())) {
            String propertykey = key.getFullPropertyKeyAsString(pd.getName());
            this.propertyMap.put(propertykey, data);
            this.dataPropertyMap.put(propertykey, pd);
        }
        data.addPropertyChangeListener(this);
    }

    @Override
    public void add(HyveData data) throws ConcurrentAddException {
        this.add(data.getKey(), data);
        if (this.synchronizer != null) {
            this.synchronizer.onDataAdded(data.getKey(), data);
        }
    }

    @Override
    public void dataAddFromSynchronizer(HyveData data) throws ConcurrentAddException {
        this.add(data.getKey(), data);
    }

    @Override
    public void dataRemoveFromSynchronizer(DataModelKey key) {
        this.remove(key);
    }

    @Override
    public void indexedPropertyChangeFromSynchronizer(String propertyName, Object newValue, int index) {
        Object o = this.propertyMap.get(propertyName);
        if (o != null) {
            IndexedPropertyDescriptor pd = (IndexedPropertyDescriptor)this.dataPropertyMap.get(propertyName);
            this.currentChangedProperty.set(propertyName, newValue, index);
            try {
                Method wm = pd.getIndexedWriteMethod();
                if (wm != null) {
                    wm.invoke(o, index, newValue);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.currentChangedProperty.setChangedFinished();
        }
    }

    @Override
    public void propertyChangeFromSynchronizer(String propertyName, Object newValue) {
        Object o = this.propertyMap.get(propertyName);
        if (o != null) {
            PropertyDescriptor pd = this.dataPropertyMap.get(propertyName);
            this.currentChangedProperty.set(propertyName, newValue);
            try {
                Method wm = pd.getWriteMethod();
                if (wm != null) {
                    wm.invoke(o, newValue);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.currentChangedProperty.setChangedFinished();
        }
    }

    public void remove(DataModelKey key) {
        HyveData data = this.dataModelMap.remove(key);
        if (data == null) {
            return;
        }
        UUID id = data.getId();
        if (id != null) {
            this.dataIdMap.remove(id.toString());
        }
        if (data != null) {
            for (DataModelObserver o : this.observer) {
                o.onDataRemoved(key, data);
            }
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(data.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (pd.getName().equals("class")) continue;
                String propertykey = key.getFullPropertyKeyAsString(pd.getName());
                this.propertyMap.remove(propertykey);
                this.dataPropertyMap.remove(propertykey);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        data.removePropertyChangeListener(this);
    }

    @Override
    public void remove(HyveData data) {
        this.remove(data.getKey());
        if (this.synchronizer != null) {
            this.synchronizer.onDataRemoved(data.getKey(), data);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.synchronizer == null) {
            return;
        }
        String propertyname = pce.getPropertyName();
        Object n = pce.getNewValue();
        if (pce instanceof IndexedPropertyChangeEvent) {
            IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)pce;
            int index = ipce.getIndex();
            if (!this.currentChangedProperty.isEqualTo(propertyname, n, index)) {
                this.synchronizer.onIndexedPropertyChange(propertyname, n, index);
            }
        } else if (!this.currentChangedProperty.isEqualTo(propertyname, n)) {
            this.synchronizer.onPropertyChange(propertyname, n);
        }
    }

    @Override
    public void setFollowing() {
        this.isLeading = false;
    }

    @Override
    public boolean isLeading() {
        return this.isLeading;
    }

    @Override
    public Collection<HyveData> getEntities() {
        return Collections.unmodifiableCollection(new HashSet<HyveData>(this.dataModelMap.values()));
    }

    private class ChangedPropertyInfo {
        private String propertyName;
        private Object propertyValue;
        private int index;

        private ChangedPropertyInfo() {
        }

        public void set(String propertyName, Object newValue) {
            this.propertyName = propertyName;
            this.propertyValue = newValue;
        }

        public boolean isEqualTo(String propertyName, Object value) {
            if (this.propertyName == null) {
                return false;
            }
            if (this.propertyValue == null && value == null) {
                return true;
            }
            if (this.propertyValue == null) {
                return false;
            }
            return this.propertyName.equals(propertyName) && this.propertyValue.equals(value);
        }

        public boolean isEqualTo(String propertyname, Object value, int index) {
            if (this.index != index) {
                return false;
            }
            return this.isEqualTo(propertyname, value);
        }

        public void set(String propertyName, Object newValue, int index) {
            this.index = index;
            this.set(propertyName, newValue);
        }

        public void setChangedFinished() {
            this.propertyName = null;
            this.propertyValue = null;
            this.index = -2;
        }
    }
}

