/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data;

import com.hybridlab.hyve3d.data.CommandExecutorHelper;
import com.hybridlab.hyve3d.data.DataPool;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.domainobjects.AmbientLight;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.BackGround;
import com.hybridlab.hyve3d.data.domainobjects.DirectionalLight;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Sky;
import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.hyve.undoredo.CommandExecutor;
import com.hybridlab.hyve3d.hyve.undoredo.EraseCommand;
import com.hybridlab.hyve3d.hyve.undoredo.Executable;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class Session
extends DataPool {
    private UUID id;
    private String sessionname;
    public static final UUID defaultAmbientLightUUID = UUID.fromString("3b18ca9c-7fda-11e4-b116-123b93f75cba");
    public static final UUID defaultDirectionalLight_1_UUID = UUID.fromString("e4e3ca65-6a72-44b6-b161-62f4b7e2582d");
    public static final UUID defaultDirectionalLight_2_UUID = UUID.fromString("4a7bd532-7fdb-11e4-b116-123b93f75cba");

    public Session(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public void indexedPropertyChangeFromSynchronizer(String propertyName, Object newValue, int index) {
        super.indexedPropertyChangeFromSynchronizer(propertyName, newValue, index);
        if (newValue instanceof Executable) {
            this.ensureExistingExecutor((Executable)newValue);
        }
    }

    private void ensureExistingExecutor(Executable ex) {
        if (ex.hasExecutor()) {
            return;
        }
        CommandExecutorHelper.attachExecutor(ex, this);
    }

    public String getName() {
        return this.sessionname == null ? this.getId().toString() : this.sessionname;
    }

    public void setName(String sessionname) {
        this.sessionname = sessionname;
    }

    public Set<Space> getParticipatingSpaces() {
        Set<Space> spaces = this.getAll(Space.class);
        return Collections.unmodifiableSet(spaces);
    }

    public BackGround getBackGround() {
        Set<BackGround> bgs = this.getAll(BackGround.class);
        if (bgs.isEmpty()) {
            try {
                BackGround bg = new BackGround(UUID.randomUUID());
                this.add(bg);
                return bg;
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
                bgs = this.getAll(BackGround.class);
                if (!bgs.isEmpty()) {
                    return bgs.iterator().next();
                }
            }
        } else {
            return bgs.iterator().next();
        }
        return null;
    }

    public Set<DrawingArea> getParticipatingDrawingAreas() {
        Set<DrawingArea> drawingareas = this.getAll(DrawingArea.class);
        return Collections.unmodifiableSet(drawingareas);
    }

    public Set<Stroke> getAllStrokes() {
        Set<Stroke> strokes = this.getAll(Stroke.class);
        return Collections.unmodifiableSet(strokes);
    }

    public Set<Sky> getAllSkys() {
        Set<Sky> skys = this.getAll(Sky.class);
        return Collections.unmodifiableSet(skys);
    }

    public Set<Asset> getAllAssets() {
        Set<Asset> assets = this.getAll(Asset.class);
        return Collections.unmodifiableSet(assets);
    }

    public void eraseAll() {
        HashSet<HyveData> all = new HashSet<HyveData>();
        all.addAll(this.getAllStrokes());
        all.addAll(this.getAllAssets());
        HashSet<UUID> uidset = new HashSet<UUID>();
        for (HyveData d : all) {
            uidset.add(d.getId());
        }
        CommandExecutor commandExecutor = CommandExecutorHelper.createEraseExecutor(this, all);
        EraseCommand eraseAllCommand = new EraseCommand(uidset, commandExecutor, "Erase all");
        eraseAllCommand.execute();
    }

    public void addDefaultLights() {
        AmbientLight ambientLightl = new AmbientLight(defaultAmbientLightUUID);
        ambientLightl.setColor(ColorRGBA.LightGray);
        DirectionalLight directionalLight_1 = new DirectionalLight(defaultDirectionalLight_1_UUID);
        directionalLight_1.setColor(ColorRGBA.White);
        directionalLight_1.setDirection(new Vector3f(1.0f, -3.0f, -5.0f).normalizeLocal());
        DirectionalLight directionalLight_2 = new DirectionalLight(defaultDirectionalLight_2_UUID);
        directionalLight_2.setColor(ColorRGBA.White);
        directionalLight_2.setDirection(new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal());
        directionalLight_2.setEnabled(false);
        try {
            if (this.getWithID(defaultAmbientLightUUID.toString(), AmbientLight.class) == null) {
                this.add(ambientLightl);
            }
            if (this.getWithID(defaultDirectionalLight_1_UUID.toString(), DirectionalLight.class) == null) {
                this.add(directionalLight_1);
            }
            if (this.getWithID(defaultDirectionalLight_2_UUID.toString(), DirectionalLight.class) == null) {
                this.add(directionalLight_2);
            }
        }
        catch (ConcurrentAddException concurrentAddException) {
            // empty catch block
        }
    }

    public SessionInfo getInfo() {
        return new SessionInfo(this.id, this.sessionname);
    }
}

