/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.decorators;

import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;

public abstract class SelectableDecorator
implements PropertyChangeListener,
Selectable {
    private HyveData data;
    private Set<Selectable.SelectableBoundsObserver> boundsObserver = new HashSet<Selectable.SelectableBoundsObserver>();

    public SelectableDecorator(HyveData data) {
        this.data = data;
        this.data.addPropertyChangeListener(this);
    }

    @Override
    public HyveData getData() {
        return this.data;
    }

    public void destroy() {
        this.data.removePropertyChangeListener(this);
        this.boundsObserver.clear();
    }

    @Override
    public void addSelectableBoundsObserver(Selectable.SelectableBoundsObserver listener) {
        this.boundsObserver.add(listener);
    }

    @Override
    public void removeSelectableBoundsObserver(Selectable.SelectableBoundsObserver listener) {
        this.boundsObserver.remove(listener);
    }

    protected void fireBoundsChange() {
        for (Selectable.SelectableBoundsObserver o : this.boundsObserver) {
            o.onBoundsHaveChanged(this);
        }
    }
}

