/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.decorators;

import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.data.decorators.SelectableDecorator;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class StrokeSelectable
extends SelectableDecorator {
    private Stroke stroke;
    private static final AABBox nullaabbox = new AABBox(Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    private AABBox aabbox = nullaabbox;

    public StrokeSelectable(Stroke stroke) {
        super(stroke);
        this.stroke = stroke;
        this.calculateAABBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAABBox() {
        AABBox aABBox = this.aabbox;
        synchronized (aABBox) {
            boolean first = true;
            boolean changed = false;
            for (Vector3f p : this.getPointsInSceneCoordinates()) {
                if (first) {
                    this.aabbox = new AABBox(p.x, p.y, p.z, p.x, p.y, p.z);
                    first = false;
                    changed = true;
                    continue;
                }
                if (this.aabbox.contains(p.x, p.y, p.z)) continue;
                this.aabbox.resize(p.x, p.y, p.z);
                changed = true;
            }
            if (changed) {
                this.fireBoundsChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeAABBox(Vector3f p) {
        AABBox aABBox = this.aabbox;
        synchronized (aABBox) {
            if (this.aabbox == nullaabbox) {
                this.aabbox = new AABBox(p.x, p.y, p.z, p.x, p.y, p.z);
                this.fireBoundsChange();
            } else if (!this.aabbox.contains(p.x, p.y, p.z)) {
                this.aabbox.resize(p.x, p.y, p.z);
                this.fireBoundsChange();
            }
        }
    }

    @Override
    public UUID getId() {
        return this.stroke.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AABBox getAABBox() {
        AABBox aABBox = this.aabbox;
        synchronized (aABBox) {
            return this.aabbox;
        }
    }

    @Override
    public List<Vector3f> getPointsInSceneCoordinates() {
        List<Stroke3DPoint> s3dlist = this.stroke.getPointsInSceneCoordinates();
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        for (Stroke3DPoint s3d : s3dlist) {
            points.add(s3d.position);
        }
        return points;
    }

    @Override
    public void setSelected(boolean b) {
        this.stroke.setSelected(b);
    }

    @Override
    public Boolean isCurrentlySelectable() {
        return this.stroke.getIsSelectable();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.stroke) {
            String prop = evt.getPropertyName();
            if (evt instanceof IndexedPropertyChangeEvent) {
                StrokePoint sp;
                IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)evt;
                if (prop.endsWith("point") && (sp = (StrokePoint)ipce.getNewValue()) != null) {
                    this.resizeAABBox(this.stroke.calculateSceneCoordinates(sp));
                }
            } else if (prop.endsWith("transformation")) {
                this.calculateAABBox();
            } else if (prop.endsWith("selected")) {
                // empty if block
            }
        }
    }

    @Override
    public Transform getTransformation() {
        return this.stroke.getTransformation().toTransform();
    }

    @Override
    public void setTransformation(Transform trf) {
        Transformation transformation = new Transformation(trf);
        this.stroke.setTransformation(transformation);
    }

    @Override
    public Selectable.ButterFlyNetCriteria getButterFlyNetSelectionCriteria() {
        return Selectable.ButterFlyNetCriteria.AnyPointOfSelectableContainedInButterFlyVolume;
    }
}

