/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.decorators;

import com.hybridlab.hyve3d.data.decorators.Transformer;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransformableSelection
implements Transformer.TransformerListener {
    private Set<Selectable> selection = new HashSet<Selectable>();
    private Map<Selectable, Transform> selectableReferenceTransformations = new HashMap<Selectable, Transform>();
    private boolean centerWasCalculatedBefore = false;
    private Vector3f center;
    private Transformer transformer;
    private Transform referenceTransformerValue;

    public TransformableSelection(Transformer t) {
        this.transformer = t;
    }

    public Vector3f getCenter() {
        this.recalculateCenter();
        return this.center;
    }

    public void recalculateCenter() {
        this.centerWasCalculatedBefore = false;
        this.calculateCenter();
    }

    public boolean calculateCenter() {
        if (!this.centerWasCalculatedBefore) {
            this.centerWasCalculatedBefore = true;
            AABBox all = new AABBox();
            boolean first = true;
            for (Selectable selected : this.selection) {
                if (first) {
                    all = selected.getAABBox();
                    first = false;
                    continue;
                }
                all.resize(selected.getAABBox());
            }
            float[] center = all.getCenter();
            Vector3f vCenter = new Vector3f(center[0], center[1], center[2]);
            System.out.println(String.format("the center of selection is %s, while aabbox min=%s,max=%s", vCenter, new Vector3f(all.getMinX(), all.getMinY(), all.getMinZ()), new Vector3f(all.getMaxX(), all.getMaxY(), all.getMaxZ())));
            this.center = vCenter;
            return true;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        return this.selection.isEmpty();
    }

    public synchronized boolean add(Selectable s) {
        return this.selection.add(s);
    }

    public synchronized boolean remove(Selectable s) {
        this.selectableReferenceTransformations.remove(s);
        return this.selection.remove(s);
    }

    public Set<Selectable> getAll() {
        return this.selection;
    }

    public synchronized void clear() {
        this.selection.clear();
        this.selectableReferenceTransformations.clear();
    }

    public void disconnectTransformer() {
        this.transformer.disconnectChangeListener(this);
        this.referenceTransformerValue = null;
    }

    public void connectTransformer() {
        this.referenceTransformerValue = this.transformer.getCurrentValue().clone();
        this.storeSelectableReferenceTransformations();
        this.transformer.connectChangeListener(this);
    }

    private synchronized void storeSelectableReferenceTransformations() {
        for (Selectable s : this.selection) {
            this.selectableReferenceTransformations.put(s, s.getTransformation().clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hasChanged(Transform oldValue, Transform newValue) {
        if (this.referenceTransformerValue != null) {
            Quaternion rotDiff = newValue.getRotation().mult(this.referenceTransformerValue.getRotation().inverse());
            Vector3f scaleDiff = newValue.getScale().divide(this.referenceTransformerValue.getScale());
            Map<Selectable, Transform> map = this.selectableReferenceTransformations;
            synchronized (map) {
                for (Map.Entry<Selectable, Transform> entry : this.selectableReferenceTransformations.entrySet()) {
                    Selectable selectable = entry.getKey();
                    Transform refTrf = entry.getValue();
                    Vector3f refTransflation_transformerToSelectable = refTrf.getTranslation().subtract(this.referenceTransformerValue.getTranslation());
                    Vector3f rotated_transformerToSelectable = rotDiff.mult(refTransflation_transformerToSelectable);
                    Vector3f rotatedAndScaled_transformerToSelectable = rotated_transformerToSelectable.mult(scaleDiff);
                    Vector3f newPosition = newValue.getTranslation().add(rotatedAndScaled_transformerToSelectable);
                    Transform trf = refTrf.clone();
                    trf.setTranslation(newPosition);
                    trf.setScale(scaleDiff.mult(refTrf.getScale()));
                    trf.setRotation(rotDiff.mult(refTrf.getRotation()));
                    selectable.setTransformation(trf);
                }
            }
        }
    }
}

