/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.domainobjects;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.domainobjects.CopyAble;
import com.hybridlab.hyve3d.data.domainobjects.Node;
import com.hybridlab.hyve3d.data.valueobjects.BoundingBoxInformation;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.utils.network.NetworkUtil;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.network.serializing.Serializable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

@Serializable
public class Asset
extends Node
implements CopyAble {
    private static final long serialVersionUID = 4226958956194286591L;
    protected UUID id;
    protected Type type;
    protected String path;
    protected String file;
    protected String importoptions;
    protected byte[] fileContent;
    protected byte[][] multipleFileContent;
    protected String[] multiplefile;
    protected UUID originHyveID = NetworkUtil.NULL_UUID;
    private boolean isSelected = false;
    private BoundingBoxInformation originalBoundingBox;
    private boolean isSelectable = false;
    protected transient ImportOptions importOptionsInstance;

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " [id=" + this.id + " file=" + this.file + "]";
    }

    public Asset(DataModelKey key) {
        super(key);
    }

    public Asset() {
        super(DataModelKey.createWithKeyParts("Asset"));
    }

    public Asset(UUID assetId, UUID originhyveId, Type type, String path, String file, String importOptions) {
        super(DataModelKey.createWithKeyParts("Asset", assetId.toString()));
        this.originHyveID = originhyveId;
        this.id = assetId;
        this.type = type;
        this.path = path;
        this.file = file;
        this.importoptions = importOptions == null ? "" : importOptions;
        this.setIsSelectable(this.getImportOptionsInstance().getIsSelectable());
        this.setTransformation(new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion()));
        try {
            File f = new File(path, file);
            FileInputStream is = new FileInputStream(f);
            this.fileContent = IOUtils.toByteArray(is);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Asset(UUID idForCopy, Asset original) {
        super(DataModelKey.createWithKeyParts("Asset", idForCopy.toString()));
        this.id = idForCopy;
        this.type = Type.valueOf(original.type.toString());
        this.transformation = original.transformation.copy();
        this.path = original.path;
        this.file = original.file;
        this.importoptions = original.importoptions;
        this.fileContent = (byte[])original.fileContent.clone();
        this.originHyveID = original.originHyveID;
        this.originalBoundingBox = original.originalBoundingBox.copy();
        this.isSelectable = original.isSelectable;
        this.importOptionsInstance = original.importOptionsInstance.getCopy();
        if (original.multiplefile != null) {
            this.multiplefile = (String[])original.multiplefile.clone();
        }
        if (original.multipleFileContent != null) {
            this.multipleFileContent = (byte[][])original.multipleFileContent.clone();
        }
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getImportOptions() {
        return this.importoptions;
    }

    public void setImportOptions(String importoptions) {
        this.importoptions = importoptions;
    }

    public UUID getOriginHyveID() {
        return this.originHyveID;
    }

    public void setOriginHyveID(UUID hyveID) {
        this.originHyveID = hyveID;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public void setFile(String f) {
        this.file = f;
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public HyveData createCopy() {
        UUID id = UUID.randomUUID();
        return this.createCopy(id);
    }

    public void setSelected(boolean b) {
        boolean old = this.isSelected;
        if (old != b) {
            this.isSelected = b;
            this.fireChange("selected", old, this.isSelected);
        }
    }

    public boolean getSelected() {
        return this.isSelected;
    }

    @Override
    public HyveData createCopy(UUID idForCopy) {
        Asset copy = new Asset(idForCopy, this);
        return copy;
    }

    public void setOriginalBoundingBoxInformation(BoundingBoxInformation bbox) {
        BoundingBoxInformation old = this.originalBoundingBox;
        this.originalBoundingBox = bbox;
        this.fireChange("originalAABBInformation", old, this.originalBoundingBox);
    }

    public BoundingBoxInformation getOriginalBoundingBoxInformation() {
        return this.originalBoundingBox;
    }

    public void setIsSelectable(boolean isSelectable) {
        boolean old = this.isSelectable;
        this.isSelectable = isSelectable;
        this.fireChange("isSelectable", old, this.isSelectable);
    }

    public boolean getIsSelectable() {
        return this.isSelectable;
    }

    public ImportOptions getImportOptionsInstance() {
        if (this.importOptionsInstance == null) {
            ImportOptions importOptions;
            try {
                JSONObject o = new JSONObject(this.getImportOptions());
                importOptions = ImportOptions.fromJson(o);
            }
            catch (JSONException e) {
                e.printStackTrace();
                importOptions = ImportOptions.createDefaultOptions();
            }
            this.importOptionsInstance = importOptions;
        }
        return this.importOptionsInstance;
    }

    public void setDependentFiles(List<String> dfl) {
        int l = dfl.size();
        this.multiplefile = new String[l];
        this.multipleFileContent = new byte[l][];
        for (int i = 0; i < l; ++i) {
            String df = dfl.get(i);
            File f = new File(this.getPath(), df);
            this.multiplefile[i] = df;
            try {
                FileInputStream is = new FileInputStream(f);
                this.multipleFileContent[i] = IOUtils.toByteArray(is);
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isMultipleFileAsset() {
        if (this.multiplefile == null) {
            return false;
        }
        return this.multiplefile.length > 0;
    }

    public String[] getMultipleFileList() {
        return this.multiplefile;
    }

    public byte[] getMultipleFileContent(int i) {
        return this.multipleFileContent[i];
    }

    public static enum Type {
        OgreZip,
        OBJ,
        OBJ_ZIPPED,
        Sky,
        PointCloud,
        FBX;

    }
}

