/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.domainobjects;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.Rotations;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.util.UUID;

public class DrawingArea
extends HyveData {
    private static final long serialVersionUID = 7025735838778196313L;
    private UUID id;
    private UUID spaceId;
    private String satelliteId;
    private Transformation transformation;
    private String name;
    private FrameRect frame;
    private ColorRGBA regularFrameColor;
    private Boolean isTransLucent = false;
    private Boolean isPaused = false;
    private Boolean isCursorVisible = false;
    private Vector2f cursorposition = Vector2f.ZERO;
    private Quaternion satelliteOrientation = Quaternion.IDENTITY;
    private Quaternion satelliteOrientationCorrected = Quaternion.IDENTITY;
    public static final transient FrameRect DefaultFrame = new FrameRect(1.3333334f);

    public String toString() {
        return DrawingArea.class.getSimpleName() + " [id=" + this.id + ", hashCode()=" + this.hashCode() + "]";
    }

    public DrawingArea() {
        super(DataModelKey.createWithKeyParts("DrawingArea"));
    }

    public DrawingArea(UUID id, UUID spaceId) {
        super(DataModelKey.createWithKeyParts("DrawingArea", id.toString()));
        this.id = id;
        this.spaceId = spaceId;
        this.frame = new FrameRect(1.3333334f);
        this.setTransformation(new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(new float[]{0.0f, 0.0f, 1.5707964f})));
        this.setKey(DataModelKey.createWithKeyParts("DrawingArea", this.id.toString()));
        this.name = "unnamed DrawingArea";
        this.regularFrameColor = ColorRGBA.randomColor();
        this.regularFrameColor.a = 1.0f;
        this.regularFrameColor = MathUtils.ensureNotDarkerThan(0.6f, this.regularFrameColor);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation newTransformation) {
        Transformation old = this.transformation;
        this.transformation = newTransformation;
        Rotations.setValue(Rotations.RotationIdentifier.DrawingArea, this.transformation.getRotation());
        this.fireChange("transformation", old, this.transformation);
    }

    public Quaternion getSatelliteOrientation() {
        return this.satelliteOrientation;
    }

    public void setSatelliteOrientation(Quaternion satelliteOrientation) {
        Quaternion old = this.satelliteOrientation;
        this.satelliteOrientation = satelliteOrientation;
        this.fireChange("satelliteorientation", old, this.satelliteOrientation);
    }

    public Quaternion getSatelliteOrientationCorrected() {
        return this.satelliteOrientationCorrected;
    }

    public void setSatelliteOrientationCorrected(Quaternion satelliteOrientationCorrected) {
        Quaternion old = this.satelliteOrientationCorrected;
        this.satelliteOrientationCorrected = satelliteOrientationCorrected;
        this.fireChange("satelliteorientationcorrected", old, this.satelliteOrientationCorrected);
    }

    public void setSpaceId(UUID spaceId) {
        UUID old = this.spaceId;
        this.spaceId = spaceId;
        this.fireChange("spaceId", old, this.spaceId);
    }

    public UUID getSpaceId() {
        return this.spaceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String old = this.name;
        this.name = newName;
        this.fireChange("name", old, this.name);
    }

    public void setFrame(FrameRect newFrame) {
        FrameRect old = this.frame;
        this.frame = newFrame;
        this.fireChange("frame", old, this.frame);
    }

    public FrameRect getFrame() {
        return this.frame;
    }

    public Boolean getIsTransLucent() {
        return this.isTransLucent;
    }

    public void setIsTransLucent(Boolean b) {
        Boolean old = this.isTransLucent;
        this.isTransLucent = b;
        this.fireChange("isTransLucent", old, this.isTransLucent);
    }

    public ColorRGBA getRegularFrameColor() {
        return this.regularFrameColor;
    }

    public void setRegularFrameColor(ColorRGBA regularFrameColor) {
        ColorRGBA old = this.regularFrameColor;
        this.regularFrameColor = regularFrameColor;
        this.fireChange("regularFrameColor", old, this.regularFrameColor);
    }

    public String getConnectedSatelliteId() {
        return this.satelliteId;
    }

    public void setConnectedSatelliteId(String satid) {
        String old = this.satelliteId;
        this.satelliteId = satid;
        this.fireChange("connectedSatelliteId", old, this.satelliteId);
    }

    public void setIsPaused(Boolean b) {
        Boolean old = this.isPaused;
        this.isPaused = b;
        this.fireChange("isPaused", old, this.isPaused);
    }

    public Boolean getIsPaused() {
        return this.isPaused;
    }

    public Vector2f getCursorPosition() {
        return this.cursorposition;
    }

    public void setCursorPosition(Vector2f cursorposition) {
        Vector2f old = this.cursorposition;
        this.cursorposition = cursorposition;
        this.fireChange("cursorPosition", old, this.cursorposition);
    }

    public Boolean getCursorVisibility() {
        return this.isCursorVisible;
    }

    public void setCursorVisibility(Boolean isCursorVisible) {
        Boolean old = this.isCursorVisible;
        this.isCursorVisible = isCursorVisible;
        this.fireChange("cursorVisibility", old, this.isCursorVisible);
    }

    public Vector3f getCursorWorldPosition() {
        Vector3f worldpos = this.transformation.getRotation().mult(new Vector3f(this.cursorposition.x, this.cursorposition.y, 0.0f)).add(this.transformation.getPosition());
        return worldpos;
    }
}

