/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.domainobjects;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.jme3.network.serializing.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

@Serializable
public class HubNodeInfo
extends HyveData {
    private static final long serialVersionUID = -8177600300643077685L;
    private UUID hubnodeid;
    private HubNodeAddress address;
    private Map<Integer, SessionInfo> sessions = new HashMap<Integer, SessionInfo>();
    private Map<SessionInfo, Integer> indices = new HashMap<SessionInfo, Integer>();
    private Set<Integer> freeIndices = new HashSet<Integer>();
    private String descriptiveName = "";
    private Logger logger = Logger.getAnonymousLogger();

    public HubNodeInfo() {
        super(DataModelKey.createWithKeyParts("HubNodeInfo"));
    }

    public HubNodeInfo(UUID id) {
        super(DataModelKey.createWithKeyParts("HubNodeInfo", id.toString()));
        this.hubnodeid = id;
    }

    @Override
    public UUID getId() {
        return this.hubnodeid;
    }

    public boolean hasSession(SessionInfo sessionInfo) {
        return this.sessions.containsValue(sessionInfo);
    }

    public SessionInfo[] getSession() {
        SessionInfo[] result = new SessionInfo[this.sessions.size()];
        for (Map.Entry<Integer, SessionInfo> entry : this.sessions.entrySet()) {
            result[entry.getKey().intValue()] = entry.getValue();
        }
        return result;
    }

    public SessionInfo getSession(int propertyIndex) {
        return this.sessions.get(propertyIndex);
    }

    public void setSession(int index, SessionInfo sessionInfo) {
        SessionInfo old = this.sessions.get(index);
        this.sessions.put(index, sessionInfo);
        if (sessionInfo == null) {
            this.freeIndices.add(index);
        } else {
            this.freeIndices.remove(index);
            this.indices.put(sessionInfo, index);
        }
        this.fireIndexedChange("session", index, old, sessionInfo);
    }

    public void removeSession(SessionInfo sessionInfo) {
        int index = this.indices.get(sessionInfo);
        this.setSession(index, null);
    }

    public void addSession(SessionInfo sessionInfo) {
        if (this.sessions.containsValue(sessionInfo)) {
            this.logger.severe("Session " + sessionInfo.toString() + " already in HubnodeInfo " + this);
        } else {
            int nextIndex = this.getNextFreeIndex();
            this.setSession(nextIndex, sessionInfo);
        }
    }

    private int getNextFreeIndex() {
        if (this.freeIndices.isEmpty()) {
            return this.sessions.values().size();
        }
        return this.freeIndices.iterator().next();
    }

    public int getNumberOfSessions() {
        return this.sessions.values().size();
    }

    public HubNodeAddress getAddress() {
        return this.address;
    }

    public void setAddress(HubNodeAddress address) {
        HubNodeAddress oldValue = this.address;
        this.address = address;
        this.fireChange("address", oldValue, this.address);
    }

    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    public void setDescriptiveName(String descriptiveName) {
        String old = this.descriptiveName;
        this.descriptiveName = descriptiveName;
        this.fireChange("descriptiveName", old, this.descriptiveName);
    }

    public String getInfos() {
        return "HubNodeInfo( \n   hubnodeid=" + this.hubnodeid + " \n   sessions=" + this.sessions + " \n    indices=" + this.indices + " \n    freeIndices=" + this.freeIndices + " \n    descriptiveName=" + this.descriptiveName + " \n    address=" + this.address + "\n) HubNodeInfo END";
    }
}

