/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.domainobjects;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

@com.jme3.network.serializing.Serializable
public class Selection
extends HyveData
implements Serializable {
    private static final long serialVersionUID = -7773612421364259774L;
    private Set<UUID> selectedItemIds = new HashSet<UUID>();
    private UUID selectionId;
    private UUID creator;

    public Selection() {
        super(DataModelKey.createWithKeyParts("Selection"));
    }

    public Selection(UUID id, UUID creatorid) {
        super(DataModelKey.createWithKeyParts("Selection", id.toString()));
        this.selectionId = id;
        this.creator = creatorid;
    }

    public UUID getCreatorId() {
        return this.creator;
    }

    @Override
    public UUID getId() {
        return this.selectionId;
    }

    public Set<UUID> getIdsOfSelectedItems() {
        return new HashSet<UUID>(this.selectedItemIds);
    }

    public void setIdsOfSelectedItems(Set<UUID> selectedIds) {
        boolean willChange;
        Set<UUID> old = this.selectedItemIds;
        if (selectedIds == null) {
            selectedIds = new HashSet<UUID>();
        }
        boolean bl = willChange = !this.selectedItemIds.containsAll(selectedIds) || !selectedIds.containsAll(this.selectedItemIds);
        if (willChange) {
            this.selectedItemIds = selectedIds;
            this.fireChange("idsOfSelectedItems", old, this.selectedItemIds);
        }
    }

    public void removeItemId(UUID id) {
        HashSet<UUID> selectedIds = new HashSet<UUID>(this.selectedItemIds);
        selectedIds.remove(id);
        this.setIdsOfSelectedItems(selectedIds);
    }

    public void addItemId(UUID id) {
        HashSet<UUID> selectedIds = new HashSet<UUID>(this.selectedItemIds);
        selectedIds.add(id);
        this.setIdsOfSelectedItems(selectedIds);
    }

    public void clear() {
        HashSet<UUID> selectedIds = new HashSet<UUID>();
        this.setIdsOfSelectedItems(selectedIds);
    }
}

