/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.domainobjects;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.network.serializing.Serializable;
import java.util.UUID;

@Serializable
public class Space
extends HyveData {
    private static final long serialVersionUID = 6011236906321914405L;
    private UUID id;
    private String name;
    private Transformation transformation = new Transformation(new Vector3f(0.0f, 1.5f, 0.0f), new Quaternion());
    private static final Transformation defaulttransformation = new Transformation(new Vector3f(0.0f, 1.5f, 0.0f), new Quaternion());

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " [id=" + this.id + "]";
    }

    public Space() {
        super(null);
    }

    public Space(UUID id) {
        super(DataModelKey.createWithKeyParts("Space", id.toString()));
        this.id = id;
        this.name = "unnamed IdeationSpace";
    }

    public Space(UUID id, String name) {
        this(id);
        this.name = name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newname) {
        String oldValue = this.name;
        this.name = newname;
        this.fireChange("name", oldValue, this.name);
    }

    public void setTransformation(Transformation newTransformation) {
        Transformation old = this.transformation;
        this.transformation = newTransformation;
        this.fireChange("transformation", old, this.transformation);
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void resetTransformationToDefault() {
        this.setTransformation(defaulttransformation.copy());
    }
}

