/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.domainobjects;

import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.domainobjects.CopyAble;
import com.hybridlab.hyve3d.data.domainobjects.Node;
import com.hybridlab.hyve3d.data.valueobjects.Ink;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.network.serializing.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;

@Serializable
public class Stroke
extends Node
implements CopyAble {
    private static final long serialVersionUID = 1710361484008405595L;
    private UUID id;
    private ColorRGBA color;
    private Ink.Style style;
    private TreeMap<Integer, StrokePoint> points;
    private float thickness;
    private boolean isSelected = false;
    private boolean isSelectable = true;

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " [id=" + this.id + "]";
    }

    public Stroke() {
        super(DataModelKey.createWithKeyParts("Stroke"));
    }

    public Stroke(UUID id, Ink ink, Transformation trf) {
        super(DataModelKey.createWithKeyParts("Stroke", id.toString()));
        this.id = id;
        this.color = ink.getColor();
        this.style = ink.getStyle();
        this.transformation = trf;
        this.points = new TreeMap();
        this.thickness = ink.getBaseThickness();
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setColor(ColorRGBA color) {
        ColorRGBA oldValue = this.color;
        this.color = color;
        this.fireChange("color", oldValue, this.color);
    }

    public Ink.Style getStyle() {
        return this.style;
    }

    public void setStyle(Ink.Style style) {
        Ink.Style oldValue = this.style;
        this.style = style;
        this.fireChange("style", (Object)oldValue, (Object)this.style);
    }

    public void setSelected(boolean b) {
        boolean old = this.isSelected;
        if (old != b) {
            this.isSelected = b;
            this.fireChange("selected", old, this.isSelected);
        }
    }

    public boolean getSelected() {
        return this.isSelected;
    }

    public void setIsSelectable(boolean isSelectable) {
        boolean old = this.isSelectable;
        this.isSelectable = isSelectable;
        this.fireChange("isSelectable", old, this.isSelectable);
    }

    public boolean getIsSelectable() {
        return this.isSelectable;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public StrokePoint getPoint(int propertyIndex) {
        return this.points.get(propertyIndex);
    }

    public void setPoint(int index, StrokePoint point) {
        StrokePoint old = this.points.get(index);
        this.points.put(index, point);
        this.fireIndexedChange("point", index, old, point);
    }

    public void addStrokePoint(StrokePoint p) {
        int nextIndex = this.points.values().size();
        if (nextIndex > 0) {
            Vector3f tangent = p.getPoint3d().subtract(this.points.get(nextIndex - 1).getPoint3d()).normalizeLocal();
            p.setTangent(tangent);
            if (nextIndex == 1) {
                this.points.get(0).setTangent(tangent);
            }
        }
        this.setPoint(nextIndex, p);
    }

    public int getNumberOfPoints() {
        return this.points.values().size();
    }

    public ArrayList<StrokePoint> getAllPoints() {
        return new ArrayList<StrokePoint>(this.points.values());
    }

    public float getBaseThickness() {
        return this.thickness;
    }

    public List<Stroke3DPoint> getPointsInSceneCoordinates() {
        ArrayList<Stroke3DPoint> result = new ArrayList<Stroke3DPoint>(this.getNumberOfPoints());
        Transformation st = this.getTransformation();
        int i = 0;
        for (StrokePoint p : this.getAllPoints()) {
            Stroke3DPoint p3d = new Stroke3DPoint();
            p3d.orientation = st.getRotation();
            p3d.pressure = p.getPressure();
            Vector3f pos2d3d = p.getPoint3d().clone();
            pos2d3d.multLocal(st.getScale());
            p3d.position = pos2d3d = st.getRotation().mult(pos2d3d).add(st.getPosition());
            p3d.indexInStroke = i++;
            result.add(p3d);
        }
        return result;
    }

    public Vector3f calculateSceneCoordinates(StrokePoint p) {
        Vector3f pos2d3d = Vector3f.NAN;
        Transformation st = this.getTransformation();
        pos2d3d = p.getPoint3d();
        pos2d3d.multLocal(st.getScale());
        pos2d3d = st.getRotation().mult(pos2d3d).add(st.getPosition());
        return pos2d3d;
    }

    @Override
    public HyveData createCopy() {
        UUID id = UUID.randomUUID();
        return this.createCopy(id);
    }

    @Override
    public HyveData createCopy(UUID idForCopy) {
        Ink ink = new Ink(this.getColor(), this.getStyle(), Float.valueOf(this.getBaseThickness()));
        Transformation trf = this.getTransformation().copy();
        Stroke copy = new Stroke(idForCopy, ink, trf);
        copy.points = new TreeMap<Integer, StrokePoint>((SortedMap<Integer, StrokePoint>)this.points);
        return copy;
    }
}

