/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.synch;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.synch.SynchConnection;
import com.hybridlab.hyve3d.data.synch.SynchronizableDataModel;
import com.hybridlab.hyve3d.data.synch.Synchronizer;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.data.synch.messages.DataAddMessage;
import com.hybridlab.hyve3d.data.synch.messages.DataRemoveMessage;
import com.hybridlab.hyve3d.data.synch.messages.IndexedPropertyChangeMessage;
import com.hybridlab.hyve3d.data.synch.messages.PropertyChangeMessage;
import com.hybridlab.hyve3d.data.synch.messages.RequestSynchCompleteMessage;
import com.hybridlab.hyve3d.data.synch.messages.SynchCompleteMessage;
import com.hybridlab.hyve3d.data.synch.messages.SynchMessage;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import java.util.Collection;

public class ImmediateSynchDataModelSynchronizer
implements Synchronizer {
    private SynchronizableDataModel observingModel;
    private SynchConnection connection;

    public ImmediateSynchDataModelSynchronizer(SynchronizableDataModel model, SynchConnection c) {
        this.observingModel = model;
        this.observingModel.setSynchronizer(this);
        this.connection = c;
        this.connection.setLocalSynchronizer(this);
    }

    @Override
    public void onDataAdded(DataModelKey key, HyveData data) {
        this.connection.send(new DataAddMessage(key, data));
    }

    @Override
    public void onDataRemoved(DataModelKey key, HyveData data) {
        this.connection.send(new DataRemoveMessage(key));
    }

    @Override
    public void receiveSynchMessage(SynchConnection connection, SynchMessage m) {
        if (m instanceof PropertyChangeMessage) {
            PropertyChangeMessage pcm = (PropertyChangeMessage)m;
            String propertyName = pcm.getPropertyName();
            Object newValue = pcm.getNewValue();
            if (pcm instanceof IndexedPropertyChangeMessage) {
                int index = ((IndexedPropertyChangeMessage)pcm).getIndex();
                this.observingModel.indexedPropertyChangeFromSynchronizer(propertyName, newValue, index);
            } else {
                this.observingModel.propertyChangeFromSynchronizer(propertyName, newValue);
            }
        } else if (m instanceof DataAddMessage) {
            DataAddMessage dam = (DataAddMessage)m;
            try {
                this.observingModel.dataAddFromSynchronizer(dam.getData());
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
        } else if (m instanceof DataRemoveMessage) {
            DataRemoveMessage drm = (DataRemoveMessage)m;
            this.observingModel.dataRemoveFromSynchronizer(drm.getKey());
        } else if (m instanceof SynchCompleteMessage) {
            SynchCompleteMessage scm = (SynchCompleteMessage)m;
            for (HyveData d : this.observingModel.getEntities()) {
                this.observingModel.dataRemoveFromSynchronizer(d.getKey());
            }
            for (HyveData d : scm.getAllEntities()) {
                try {
                    this.observingModel.dataAddFromSynchronizer(d);
                }
                catch (ConcurrentAddException e) {
                    e.printStackTrace();
                }
            }
        } else if (m instanceof RequestSynchCompleteMessage && this.observingModel.isLeading()) {
            this.sendSynchCompleteMessage(((RequestSynchCompleteMessage)m).getSourceNode());
        }
    }

    private void sendSynchCompleteMessage(String targetNode) {
        Collection<HyveData> alldata = this.observingModel.getEntities();
        this.connection.send(new SynchCompleteMessage(targetNode, alldata));
    }

    @Override
    public void onPropertyChange(String propertyname, Object newValue) {
        PropertyChangeMessage pcm = new PropertyChangeMessage(propertyname, newValue);
        if (newValue != null && newValue instanceof Transformation) {
            pcm.setFast();
        }
        this.connection.send(pcm);
    }

    @Override
    public void onIndexedPropertyChange(String propertyname, Object newValue, int index) {
        IndexedPropertyChangeMessage msg = new IndexedPropertyChangeMessage(propertyname, newValue, index);
        this.connection.send(msg);
    }

    @Override
    public boolean isDataModelFollowing() {
        return !this.observingModel.isLeading();
    }
}

