/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.synch.messages;

import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.synch.messages.SynchMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@com.jme3.network.serializing.Serializable
public class SynchCompleteMessage
extends SynchMessage
implements Serializable {
    private static final long serialVersionUID = 8971813571064123402L;
    private Set<byte[]> data = new HashSet<byte[]>();

    @Override
    public int getSize() {
        int s = 0;
        for (byte[] d : this.data) {
            s += d.length;
        }
        return s;
    }

    public SynchCompleteMessage() {
    }

    public String toString() {
        return "SynchCompleteMessage [data=" + this.data + ", getSize()=" + this.getSize() + ", isReliable()=" + this.isReliable() + ", getTargetNodes()=" + this.getTargetNodes() + "]";
    }

    public SynchCompleteMessage(String targetNode, Collection<HyveData> alldata) {
        this.addTargetNode(targetNode);
        for (HyveData d : alldata) {
            this.data.add(this.serializeToBytes(d));
        }
    }

    private byte[] serializeToBytes(HyveData d) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            output.writeObject(d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toByteArray();
    }

    public Collection<HyveData> getAllEntities() {
        HashSet<HyveData> r = new HashSet<HyveData>();
        for (byte[] ser : this.data) {
            r.add(this.deserialize(ser));
        }
        return r;
    }

    private HyveData deserialize(byte[] ser) {
        try {
            ByteArrayInputStream buffer = new ByteArrayInputStream(ser);
            ObjectInputStream input = new ObjectInputStream(buffer);
            HyveData data = (HyveData)input.readObject();
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

