/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.valueobjects;

import com.hybridlab.hyve3d.core.StylusPressure;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.io.Serializable;

public class StrokePoint
implements Serializable {
    private static final long serialVersionUID = -8736737131551806564L;
    private StylusPressure pressure;
    private Vector3f point3d;
    private Vector3f normal = Vector3f.UNIT_Z;
    private Vector3f tangent = Vector3f.ZERO;

    private StrokePoint() {
    }

    public StrokePoint(Vector2f point) {
        this(point, StylusPressure.NoPressure);
    }

    public StrokePoint(Vector2f point, StylusPressure pressure) {
        this.point3d = new Vector3f(point.x, point.y, 0.0f);
        this.pressure = pressure;
    }

    public StrokePoint(Vector3f position, StylusPressure pressure) {
        this.point3d = position;
        this.pressure = pressure;
    }

    public StrokePoint(StrokePoint blueprint, Vector3f offset) {
        this.pressure = blueprint.pressure;
        this.normal = blueprint.normal;
        this.tangent = blueprint.tangent;
        this.point3d = offset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " [point=" + this.point3d + ", pressure=" + this.pressure + "]";
    }

    public Vector3f getPoint3d() {
        return this.point3d;
    }

    @Deprecated
    public Vector2f getPoint() {
        return new Vector2f(this.point3d.x, this.point3d.y);
    }

    public StylusPressure getPressure() {
        return this.pressure;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public Vector3f getTangent() {
        return this.tangent;
    }

    public void setTangent(Vector3f tangent) {
        this.tangent = tangent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.normal == null ? 0 : this.normal.hashCode());
        result = 31 * result + (this.point3d == null ? 0 : this.point3d.hashCode());
        result = 31 * result + (this.pressure == null ? 0 : this.pressure.hashCode());
        result = 31 * result + (this.tangent == null ? 0 : this.tangent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StrokePoint other = (StrokePoint)obj;
        if (this.normal == null ? other.normal != null : !this.normal.equals((Object)other.normal)) {
            return false;
        }
        if (this.point3d == null ? other.point3d != null : !this.point3d.equals((Object)other.point3d)) {
            return false;
        }
        if (this.pressure == null ? other.pressure != null : !this.pressure.equals(other.pressure)) {
            return false;
        }
        return !(this.tangent == null ? other.tangent != null : !this.tangent.equals((Object)other.tangent));
    }
}

