/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.files;

import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.His3DScene;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.files.StrokeConverter;
import com.jme3.math.Vector3f;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class DXFExportDocument {
    private StringBuilder elements;
    private StringBuilder header;
    private StringBuilder footer;
    private CoordinateSystem exportSystem = CoordinateSystem.RightHandedYUp;
    StrokeExportMode exportmode = StrokeExportMode.POLYLINE;

    public void save(File f) throws IOException {
        FileUtils.writeStringToFile(f, this.header.toString() + this.elements.toString() + this.footer.toString());
    }

    public void transferSessionContentIntoDocument(Session session) {
        Set<Stroke3D> allStrokes = StrokeConverter.convertStrokes(session.getAllStrokes());
        this.header = new StringBuilder();
        this.footer = new StringBuilder();
        this.elements = new StringBuilder();
        this.writeOpenDXF(this.header);
        this.writeCloseDXF(this.footer);
        block3: for (Stroke3D stroke : allStrokes) {
            int ip;
            List<Stroke3DPoint> points = stroke.getPointsInSceneCoordinates();
            if (points.size() <= 0) continue;
            switch (this.exportmode) {
                case POLYLINE: {
                    Vector3f[] linepoints = new Vector3f[points.size()];
                    for (ip = 0; ip < points.size(); ++ip) {
                        linepoints[ip] = points.get((int)ip).position;
                    }
                    this.writePolyLine(this.elements, linepoints);
                    continue block3;
                }
            }
            Stroke3DPoint a = points.get(0);
            for (ip = 1; ip < points.size(); ++ip) {
                Stroke3DPoint b = points.get(ip);
                this.writeLine(this.elements, a.position, b.position);
                a = b;
            }
        }
    }

    public void transferSceneIntoDocument(His3DScene scene) {
        HashSet<Stroke3D> allStrokes = new HashSet<Stroke3D>();
        Set<His3DCanvas> canvases = scene.getAllCanvases();
        for (His3DCanvas c3d : canvases) {
            Set<Stroke3D> strokes = c3d.getAllSaveableStrokes();
            allStrokes.addAll(strokes);
        }
        this.header = new StringBuilder();
        this.footer = new StringBuilder();
        this.elements = new StringBuilder();
        this.writeOpenDXF(this.header);
        this.writeCloseDXF(this.footer);
        block4: for (Stroke3D stroke : allStrokes) {
            int ip;
            List<Stroke3DPoint> points = stroke.getPointsInSceneCoordinates();
            if (points.size() <= 0) continue;
            switch (this.exportmode) {
                case POLYLINE: {
                    Vector3f[] linepoints = new Vector3f[points.size()];
                    for (ip = 0; ip < points.size(); ++ip) {
                        linepoints[ip] = points.get((int)ip).position;
                    }
                    this.writePolyLine(this.elements, linepoints);
                    continue block4;
                }
            }
            Stroke3DPoint a = points.get(0);
            for (ip = 1; ip < points.size(); ++ip) {
                Stroke3DPoint b = points.get(ip);
                this.writeLine(this.elements, a.position, b.position);
                a = b;
            }
        }
    }

    private void write(StringBuilder target, String s) {
        target.append(s);
    }

    private String formatFloat(float f) {
        return String.format(Locale.ENGLISH, "%.4f", Float.valueOf(f));
    }

    private void writePolyLine(StringBuilder target, Vector3f[] linepoints) {
        this.write(target, "  0\n");
        this.write(target, "POLYLINE\n");
        this.write(target, "  66\n");
        this.write(target, "1\n");
        this.write(target, " 10\n");
        this.write(target, "0\n");
        this.write(target, " 20\n");
        this.write(target, "0\n");
        this.write(target, " 30\n");
        this.write(target, "0\n");
        this.write(target, " 70\n");
        this.write(target, "8\n");
        this.write(target, " 40\n");
        this.write(target, "1\n");
        this.write(target, " 41\n");
        this.write(target, "1\n");
        for (Vector3f v : linepoints) {
            float y;
            float x;
            float z = switch (this.exportSystem) {
                default -> {
                    x = v.x;
                    y = v.y;
                    yield v.z;
                }
                case CoordinateSystem.RightHandedZUp -> {
                    x = v.x;
                    y = -v.z;
                    yield v.y;
                }
            };
            this.write(target, "  0\n");
            this.write(target, "VERTEX\n");
            this.write(target, " 10\n");
            this.write(target, this.formatFloat(x) + "\n");
            this.write(target, " 20\n");
            this.write(target, this.formatFloat(y) + "\n");
            this.write(target, " 30\n");
            this.write(target, this.formatFloat(z) + "\n");
            this.write(target, " 40\n");
            this.write(target, "3\n");
            this.write(target, " 41\n");
            this.write(target, "3\n");
            this.write(target, " 70\n");
            this.write(target, "32\n");
        }
        this.write(target, "  0\n");
        this.write(target, "SEQEND\n");
    }

    private void writeLine(StringBuilder target, Vector3f a, Vector3f b) {
        this.write(target, "  0\n");
        this.write(target, "LINE\n");
        this.write(target, "  8\n");
        this.write(target, "0\n");
        switch (this.exportSystem) {
            default: {
                this.write(target, " 10\n");
                this.write(target, this.formatFloat(a.x) + "\n");
                this.write(target, " 20\n");
                this.write(target, this.formatFloat(a.y) + "\n");
                this.write(target, " 30\n");
                this.write(target, this.formatFloat(a.z) + "\n");
                this.write(target, " 11\n");
                this.write(target, this.formatFloat(b.x) + "\n");
                this.write(target, " 21\n");
                this.write(target, this.formatFloat(b.y) + "\n");
                this.write(target, " 31\n");
                this.write(target, this.formatFloat(b.z) + "\n");
                break;
            }
            case RightHandedZUp: {
                this.write(target, " 10\n");
                this.write(target, this.formatFloat(a.x) + "\n");
                this.write(target, " 20\n");
                this.write(target, this.formatFloat(-a.z) + "\n");
                this.write(target, " 30\n");
                this.write(target, this.formatFloat(a.y) + "\n");
                this.write(target, " 11\n");
                this.write(target, this.formatFloat(b.x) + "\n");
                this.write(target, " 21\n");
                this.write(target, this.formatFloat(-b.z) + "\n");
                this.write(target, " 31\n");
                this.write(target, this.formatFloat(b.y) + "\n");
            }
        }
    }

    private void writeOpenDXF(StringBuilder target) {
        this.write(target, "  0\n");
        this.write(target, "SECTION\n");
        this.write(target, "  2\n");
        this.write(target, "HEADER\n");
        this.write(target, "999\n");
        this.write(target, "DXF Created by Hyve-3D\n");
        this.write(target, "999\n");
        this.write(target, "by Hybridlab\n");
        this.write(target, "  0\n");
        this.write(target, "ENDSEC\n");
        this.write(target, "  0\n");
        this.write(target, "SECTION\n");
        this.write(target, "  2\n");
        this.write(target, "TABLES\n");
        this.write(target, "  0\n");
        this.write(target, "ENDSEC\n");
        this.write(target, "  0\n");
        this.write(target, "SECTION\n");
        this.write(target, "  2\n");
        this.write(target, "BLOCKS\n");
        this.write(target, "  0\n");
        this.write(target, "ENDSEC\n");
        this.write(target, "  0\n");
        this.write(target, "SECTION\n");
        this.write(target, "  2\n");
        this.write(target, "ENTITIES\n");
    }

    private void writeCloseDXF(StringBuilder target) {
        this.write(target, "  0\n");
        this.write(target, "ENDSEC\n");
        this.write(target, "  0\n");
        this.write(target, "EOF\n");
    }

    public static enum CoordinateSystem {
        RightHandedYUp,
        RightHandedZUp;

    }

    private static enum StrokeExportMode {
        SEVERAL_LINES,
        POLYLINE;

    }
}

