/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.files;

import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.StylusPressure;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.BackGround;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.files.AssetData;
import com.hybridlab.hyve3d.files.StrokeConverter;
import com.hybridlab.hyve3d.network.interconnection.HisScene;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.xmltools.AbstractXMLFile;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class His3dSceneXMLDocument
extends AbstractXMLFile {
    private static final String TAGNAME_ROOTNODE = "His3dScene";
    private static final String TAGNAME_SCENE = "Scene";
    private static final String TAGNAME_DEPENDENT_FILES = "DependendFiles";
    private static final String TAGNAME_FILE = "File";
    private static final String TAGNAME_CANVAS3D = "Canvas3D";
    private static final String TAGNAME_STROKE3D = "Stroke3D";
    private static final String TAGNAME_ASSET = "Asset";
    private static final String TAGNAME_ASSET_DATA = "AssetData";
    private static final String TAGNAME_INK = "Ink";
    private static final String TAGNAME_POINTS = "Points";
    private static final String ATTRIBUTENAME_CREATION_TIME = "creationTimeMS";
    private static final String ATTRIBUTENAME_SELECTABLE = "selectable";
    private static final String ATTRIBUTENAME_UID = "uid";
    private static final String ATTRIBUTENAME_ASSET_TYPE = "assetType";
    private Map<AssetData, Element> dependentAssets = new HashMap<AssetData, Element>();
    private Set<String> assetFolders = new HashSet<String>();

    public His3dSceneXMLDocument(File f) throws ParserConfigurationException, SAXException, IOException {
        super(f, TAGNAME_ROOTNODE);
    }

    public His3dSceneXMLDocument() throws ParserConfigurationException, SAXException, IOException {
        super(new File(""), TAGNAME_ROOTNODE);
    }

    public His3dSceneXMLDocument(byte[] xmlBytes) throws ParserConfigurationException, SAXException, IOException {
        super(xmlBytes, TAGNAME_ROOTNODE);
    }

    @Deprecated
    public void saveSceneIntoDocument(HisScene scene) {
        this.removeAllNodesUnderParentNode();
        this.addScene(scene);
    }

    public void saveSessionContentsIntoDocument(Session session) {
        this.removeAllNodesUnderParentNode();
        this.addSessionContents(session);
    }

    @Override
    public void save() throws TransformerException, IOException {
        if (!this.dependentAssets.isEmpty()) {
            this.copyAndLinkDependentAssetFiles();
        }
        if (this.hasChanges) {
            this.saveNoMatterIfUnchanged();
        }
        if (!this.dependentAssets.isEmpty()) {
            this.createBundle();
        }
    }

    private void createBundle() throws IOException {
        String theFileName = this.getFile().getName();
        File targetFolder = this.getFile().getParentFile();
        File contentsFolder = new File(this.getFile().getAbsolutePath(), "Contents");
        String tmpFileName = UUID.randomUUID().toString();
        File tempFile = new File(targetFolder.getAbsolutePath(), tmpFileName);
        FileUtils.copyFile(this.getFile(), tempFile);
        FileUtils.deleteQuietly(this.getFile());
        File finalFile = new File(contentsFolder, theFileName);
        FileUtils.forceMkdir(contentsFolder);
        FileUtils.copyFile(tempFile, finalFile);
        FileUtils.deleteQuietly(tempFile);
        for (String af : this.assetFolders) {
            File src = new File(targetFolder.getAbsolutePath(), af);
            FileUtils.moveDirectory(src, new File(contentsFolder, af));
        }
        FileUtils.write(new File(contentsFolder, "PkgInfo"), (CharSequence)"BNDL????", "UTF8");
        FileUtils.write(new File(contentsFolder, "Info.plist"), (CharSequence)this.getPlistXMLText(), "UTF8");
    }

    private String getPlistXMLText() throws FileNotFoundException, IOException {
        String plist = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n    <key>CFBundleDevelopmentRegion</key>\n    <string>English</string>\n    <key>CFBundleGetInfoString</key>\n    <string>1.0, Copyright \u00a9 2024 Syst\u00e8mes Hybridlab</string>\n    <key>CFBundleIdentifier</key>\n    <string>com.hyve3d.sketches</string>\n    <key>CFBundleInfoDictionaryVersion</key>\n    <string>6.0</string>\n    <key>CFBundleName</key>\n    <string>Hyve3D File</string>\n    <key>CFBundlePackageType</key>\n    <string>BNDL</string>\n    <key>CFBundleShortVersionString</key>\n    <string>1.0</string>\n    <key>CFBundleSignature</key>\n    <string>????</string>\n    <key>CFBundleDisplayName</key>\n    <string>Hyve3D File</string>\n    <key>NSHumanReadableCopyright</key>\n    <string>Copyright \u00a9 2024 Syst\u00e8mes Hybridlab</string>\n    <key>CFBundleVersion</key>\n    <string>1.0</string>\n</dict>\n</plist>";
        return plist;
    }

    private void copyAndLinkDependentAssetFiles() {
        File hyveFile = this.getFile();
        this.assetFolders = new HashSet<String>();
        for (Map.Entry<AssetData, Element> entry : this.dependentAssets.entrySet()) {
            AssetData ad = entry.getKey();
            try {
                this.assetFolders.add(ad.copyDependendFilesAndReLink(hyveFile.getParentFile()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Element xmlDataNode = entry.getValue();
            xmlDataNode.setTextContent(ad.toAssetJsonString());
        }
    }

    @Deprecated
    public void loadDocumentIntoScene(HisScene scene) {
        Node rootNode = this.getRootNode();
        if (null != rootNode) {
            NodeList rootNodeChildren = rootNode.getChildNodes();
            for (int loopIndexLevel1 = 0; loopIndexLevel1 < rootNodeChildren.getLength(); ++loopIndexLevel1) {
                Node nodeScene;
                NodeList nodeSceneChildren;
                String childname;
                short nodetype;
                Node child = rootNodeChildren.item(loopIndexLevel1);
                if (null == child || (nodetype = child.getNodeType()) != 1 || !TAGNAME_SCENE.equals(childname = child.getNodeName()) || null == (nodeSceneChildren = (nodeScene = child).getChildNodes())) continue;
                for (int loopIndexLevel2 = 0; loopIndexLevel2 < nodeSceneChildren.getLength(); ++loopIndexLevel2) {
                    Node possibleCanvasNode = nodeSceneChildren.item(loopIndexLevel2);
                    if (null == possibleCanvasNode || possibleCanvasNode.getNodeType() != 1 || !possibleCanvasNode.getNodeName().equals(TAGNAME_CANVAS3D)) continue;
                    Node canvas3dXMLNode = possibleCanvasNode;
                    His3DCanvas c3d = scene.createNewEmpty3dCanvas();
                    System.out.println(String.format("--> created canvas in iteration %d / %d", loopIndexLevel2, nodeSceneChildren.getLength()));
                    NamedNodeMap canvasAttribs = canvas3dXMLNode.getAttributes();
                    Node ct = canvasAttribs.getNamedItem(ATTRIBUTENAME_CREATION_TIME);
                    try {
                        long creationTimeMillis = Long.valueOf(ct.getNodeValue());
                        c3d.setCreationTimeMilliseconds(creationTimeMillis);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    NodeList nodeCanvasChildren = canvas3dXMLNode.getChildNodes();
                    for (int loopIndexLevel3 = 0; loopIndexLevel3 < nodeCanvasChildren.getLength(); ++loopIndexLevel3) {
                        Node nodeCanvasChild = nodeCanvasChildren.item(loopIndexLevel3);
                        if (nodeCanvasChild.getNodeType() != 1 || !nodeCanvasChild.getNodeName().equals(TAGNAME_STROKE3D)) continue;
                        Node stroke3dXMLNode = nodeCanvasChild;
                        System.out.println(String.format("--> created stroke in iteration %d / %d", loopIndexLevel3, nodeCanvasChildren.getLength()));
                        NamedNodeMap strokeAttribs = stroke3dXMLNode.getAttributes();
                        Node strokeCreationTime = strokeAttribs.getNamedItem(ATTRIBUTENAME_CREATION_TIME);
                        Node strokeUid = strokeAttribs.getNamedItem(ATTRIBUTENAME_UID);
                        Boolean isSelectable = true;
                        try {
                            Node strokeIsSelectable = strokeAttribs.getNamedItem(ATTRIBUTENAME_SELECTABLE);
                            isSelectable = strokeIsSelectable == null ? true : Boolean.valueOf(strokeIsSelectable.getNodeValue());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            long e = Long.valueOf(strokeCreationTime.getNodeValue());
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        UUID strokeid = null;
                        try {
                            String uid = strokeUid.getNodeValue();
                            strokeid = UUID.fromString(uid);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ColorRGBA color = null;
                        Float thickness = null;
                        ArrayList<Stroke3DPoint> points = new ArrayList<Stroke3DPoint>();
                        NodeList nodeStrokeChildren = stroke3dXMLNode.getChildNodes();
                        for (int loopIndexLevel4 = 0; loopIndexLevel4 < nodeStrokeChildren.getLength(); ++loopIndexLevel4) {
                            Node nodeStrokeChild = nodeStrokeChildren.item(loopIndexLevel4);
                            if (nodeStrokeChild.getNodeType() != 1) continue;
                            if (nodeStrokeChild.getNodeName().equals(TAGNAME_INK)) {
                                StrokeInkMessage msg = StrokeInkMessage.fromJSONString(nodeStrokeChild.getTextContent());
                                color = new ColorRGBA(msg.red, msg.green, msg.blue, msg.alpha);
                                thickness = Float.valueOf(msg.thickness);
                                continue;
                            }
                            if (!nodeStrokeChild.getNodeName().equals(TAGNAME_POINTS)) continue;
                            String jsonPointArrayString = nodeStrokeChild.getTextContent();
                            if (jsonPointArrayString.isEmpty()) {
                                jsonPointArrayString = "[]";
                            }
                            try {
                                JSONArray jsonPoints = new JSONArray(jsonPointArrayString);
                                for (int p = 0; p < jsonPoints.length(); ++p) {
                                    JSONObject jsonPoint = jsonPoints.getJSONObject(p);
                                    float x = Float.parseFloat(jsonPoint.getString("x"));
                                    float y = Float.parseFloat(jsonPoint.getString("y"));
                                    float z = Float.parseFloat(jsonPoint.getString("z"));
                                    Vector3f pnt = new Vector3f(x, y, z);
                                    try {
                                        float pp = Float.parseFloat(jsonPoint.getString("p"));
                                        points.add(Stroke3DPoint.create(pnt, pp));
                                        continue;
                                    }
                                    catch (JSONException jse) {
                                        points.add(Stroke3DPoint.create(pnt, StylusPressure.NoPressure));
                                    }
                                }
                                continue;
                            }
                            catch (DOMException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                        if (points.isEmpty() || color == null || thickness == null || strokeid == null) continue;
                        Stroke3D s3d = new Stroke3D(thickness.floatValue(), color);
                        s3d.setStrokeId(new StrokeId(strokeid));
                        s3d.setIsSelectable(isSelectable);
                        for (int ppi = 0; ppi < points.size(); ++ppi) {
                            Stroke3DPoint p = (Stroke3DPoint)points.get(ppi);
                            s3d.addPoint(p);
                        }
                        c3d.addStroke(s3d);
                        System.out.println(String.format("--> adding Stroke to Canvas stroke in iteration %d / %d with numpoints: %d", loopIndexLevel3, nodeCanvasChildren.getLength(), s3d.getNumberOfPoints()));
                    }
                    System.out.println(String.format(">>>  Canvas holds %d visible and %d saveable strokes!", c3d.getAllVisibleStrokes().size(), c3d.getAllSaveableStrokes().size()));
                }
            }
        }
    }

    private void addSessionContents(Session session) {
        this.dependentAssets = new HashMap<AssetData, Element>();
        Node nodeScene = this.createNodeUnderRootNode(TAGNAME_SCENE);
        Node nodeCanvas3D = this.createNodeUnderNode(nodeScene, TAGNAME_CANVAS3D);
        ((Element)nodeCanvas3D).setAttribute(ATTRIBUTENAME_CREATION_TIME, String.valueOf(System.currentTimeMillis()));
        BackGround backGround = session.getBackGround();
        Set<Asset> allSessionAssets = session.getAllAssets();
        for (Asset a : allSessionAssets) {
            Asset.Type assettype;
            Element assetNode = (Element)this.createNodeUnderNode(nodeCanvas3D, TAGNAME_ASSET);
            UUID id = a.getId();
            if (id != null) {
                assetNode.setAttribute(ATTRIBUTENAME_UID, id.toString());
            }
            if ((assettype = a.getType()) != null) {
                assetNode.setAttribute(ATTRIBUTENAME_ASSET_TYPE, assettype.toString());
            }
            Element dataNode = (Element)this.createNodeUnderNode(assetNode, TAGNAME_ASSET_DATA);
            AssetData ad = AssetData.AssetToData(a);
            dataNode.setTextContent(ad.toAssetJsonString());
            if (!ad.hasDependentFiles()) continue;
            this.dependentAssets.put(ad, dataNode);
        }
        Set<Stroke> allSessionStrokes = session.getAllStrokes();
        Set<Stroke3D> strokes = this.convertStrokes(allSessionStrokes);
        for (Stroke3D stroke : strokes) {
            Element strokeNode = (Element)this.createNodeUnderNode(nodeCanvas3D, TAGNAME_STROKE3D);
            StrokeId sid = stroke.getStrokeId();
            if (sid != null) {
                String uid = sid.getUuidString();
                strokeNode.setAttribute(ATTRIBUTENAME_UID, uid);
            }
            strokeNode.setAttribute(ATTRIBUTENAME_CREATION_TIME, String.valueOf(stroke.getCreationMilliseconds()));
            strokeNode.setAttribute(ATTRIBUTENAME_SELECTABLE, String.valueOf(stroke.isSelectable()));
            Element inkNode = (Element)this.createNodeUnderNode(strokeNode, TAGNAME_INK);
            StrokeInkMessage msg = new StrokeInkMessage();
            ColorRGBA color = stroke.getInk().getColor();
            msg.alpha = color.a;
            msg.red = color.r;
            msg.green = color.g;
            msg.blue = color.b;
            msg.thickness = stroke.getInk().getThickness();
            msg.style = stroke.getInk().getStyle();
            inkNode.setTextContent(StrokeInkMessage.toJSONString(msg));
            Element pointsNode = (Element)this.createNodeUnderNode(strokeNode, TAGNAME_POINTS);
            List<Stroke3DPoint> points = stroke.getPointsInSceneCoordinates();
            if (points.size() <= 0) continue;
            JSONArray jsonPointArray = new JSONArray();
            String floatFormat = "%.4f";
            Locale locale = Locale.ENGLISH;
            try {
                for (int ip = 0; ip < points.size(); ++ip) {
                    Stroke3DPoint p = points.get(ip);
                    JSONObject pointObject = new JSONObject();
                    pointObject.put("x", (Object)String.format(locale, floatFormat, Float.valueOf(p.position.x)));
                    pointObject.put("y", (Object)String.format(locale, floatFormat, Float.valueOf(p.position.y)));
                    pointObject.put("z", (Object)String.format(locale, floatFormat, Float.valueOf(p.position.z)));
                    pointObject.put("p", (Object)String.format(locale, floatFormat, Float.valueOf(p.pressure.getNormalizedValue())));
                    jsonPointArray.put((Object)pointObject);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            pointsNode.setTextContent(jsonPointArray.toString());
        }
    }

    private Set<Stroke3D> convertStrokes(Set<Stroke> allSessionStrokes) {
        HashSet<Stroke3D> s3ds = new HashSet<Stroke3D>();
        for (Stroke s : allSessionStrokes) {
            s3ds.add(StrokeConverter.convert(s));
        }
        return s3ds;
    }

    @Deprecated
    private void addScene(HisScene scene) {
        Node nodeScene = this.createNodeUnderRootNode(TAGNAME_SCENE);
        Set<His3DCanvas> canvases = scene.getAllCanvases();
        for (His3DCanvas c3d : canvases) {
            Node nodeCanvas3D = this.createNodeUnderNode(nodeScene, TAGNAME_CANVAS3D);
            ((Element)nodeCanvas3D).setAttribute(ATTRIBUTENAME_CREATION_TIME, String.valueOf(c3d.getCreationTimeMilliseconds()));
            Set<Stroke3D> strokes = c3d.getAllSaveableStrokes();
            for (Stroke3D stroke : strokes) {
                Element strokeNode = (Element)this.createNodeUnderNode(nodeCanvas3D, TAGNAME_STROKE3D);
                StrokeId sid = stroke.getStrokeId();
                if (sid != null) {
                    String uid = sid.getUuidString();
                    strokeNode.setAttribute(ATTRIBUTENAME_UID, uid);
                }
                strokeNode.setAttribute(ATTRIBUTENAME_CREATION_TIME, String.valueOf(stroke.getCreationMilliseconds()));
                strokeNode.setAttribute(ATTRIBUTENAME_SELECTABLE, String.valueOf(stroke.isSelectable()));
                Element inkNode = (Element)this.createNodeUnderNode(strokeNode, TAGNAME_INK);
                StrokeInkMessage msg = new StrokeInkMessage();
                ColorRGBA color = stroke.getInk().getColor();
                msg.alpha = color.a;
                msg.red = color.r;
                msg.green = color.g;
                msg.blue = color.b;
                msg.thickness = stroke.getInk().getThickness();
                inkNode.setTextContent(StrokeInkMessage.toJSONString(msg));
                Element pointsNode = (Element)this.createNodeUnderNode(strokeNode, TAGNAME_POINTS);
                List<Stroke3DPoint> points = stroke.getPointsInSceneCoordinates();
                if (points.size() <= 0) continue;
                JSONArray jsonPointArray = new JSONArray();
                String floatFormat = "%.4f";
                Locale locale = Locale.ENGLISH;
                try {
                    for (int ip = 0; ip < points.size(); ++ip) {
                        Stroke3DPoint p = points.get(ip);
                        JSONObject pointObject = new JSONObject();
                        pointObject.put("x", (Object)String.format(locale, floatFormat, Float.valueOf(p.position.x)));
                        pointObject.put("y", (Object)String.format(locale, floatFormat, Float.valueOf(p.position.y)));
                        pointObject.put("z", (Object)String.format(locale, floatFormat, Float.valueOf(p.position.z)));
                        pointObject.put("p", (Object)String.format(locale, floatFormat, Float.valueOf(p.pressure.getNormalizedValue())));
                        jsonPointArray.put((Object)pointObject);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                pointsNode.setTextContent(jsonPointArray.toString());
            }
        }
    }

    public void loadDocumentIntoSession(Session session) {
        ArrayList<Node> badNodes = new ArrayList<Node>();
        int numGoodNodes = 0;
        Node rootNode = this.getRootNode();
        if (null != rootNode) {
            NodeList rootNodeChildren = rootNode.getChildNodes();
            for (int loopIndexLevel1 = 0; loopIndexLevel1 < rootNodeChildren.getLength(); ++loopIndexLevel1) {
                Node nodeScene;
                NodeList nodeSceneChildren;
                String childname;
                short nodetype;
                Node child = rootNodeChildren.item(loopIndexLevel1);
                if (null == child || (nodetype = child.getNodeType()) != 1 || !TAGNAME_SCENE.equals(childname = child.getNodeName()) || null == (nodeSceneChildren = (nodeScene = child).getChildNodes())) continue;
                for (int loopIndexLevel2 = 0; loopIndexLevel2 < nodeSceneChildren.getLength(); ++loopIndexLevel2) {
                    Node possibleCanvasNode = nodeSceneChildren.item(loopIndexLevel2);
                    if (null == possibleCanvasNode || possibleCanvasNode.getNodeType() != 1 || !possibleCanvasNode.getNodeName().equals(TAGNAME_CANVAS3D)) continue;
                    Node canvas3dXMLNode = possibleCanvasNode;
                    NodeList nodeCanvasChildren = canvas3dXMLNode.getChildNodes();
                    for (int loopIndexLevel3 = 0; loopIndexLevel3 < nodeCanvasChildren.getLength(); ++loopIndexLevel3) {
                        String uid;
                        Node nodeCanvasChild = nodeCanvasChildren.item(loopIndexLevel3);
                        if (nodeCanvasChild.getNodeType() != 1) continue;
                        boolean isBad = false;
                        if (nodeCanvasChild.getNodeName().equals(TAGNAME_STROKE3D)) {
                            Node stroke3dXMLNode = nodeCanvasChild;
                            NamedNodeMap strokeAttribs = stroke3dXMLNode.getAttributes();
                            Node strokeCreationTime = strokeAttribs.getNamedItem(ATTRIBUTENAME_CREATION_TIME);
                            Node strokeUid = strokeAttribs.getNamedItem(ATTRIBUTENAME_UID);
                            try {
                                long l = Long.valueOf(strokeCreationTime.getNodeValue());
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                            Boolean isSelectable = true;
                            try {
                                Node strokeIsSelectable = strokeAttribs.getNamedItem(ATTRIBUTENAME_SELECTABLE);
                                isSelectable = strokeIsSelectable == null ? true : Boolean.valueOf(strokeIsSelectable.getNodeValue());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            UUID strokeid = null;
                            try {
                                uid = strokeUid.getNodeValue();
                                strokeid = UUID.fromString(uid);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ColorRGBA color = null;
                            Float thickness = null;
                            StrokeInk.StrokeStyle style = null;
                            ArrayList<Stroke3DPoint> points = new ArrayList<Stroke3DPoint>();
                            NodeList nodeStrokeChildren = stroke3dXMLNode.getChildNodes();
                            for (int loopIndexLevel4 = 0; loopIndexLevel4 < nodeStrokeChildren.getLength(); ++loopIndexLevel4) {
                                Node nodeStrokeChild = nodeStrokeChildren.item(loopIndexLevel4);
                                if (nodeStrokeChild.getNodeType() != 1) continue;
                                if (nodeStrokeChild.getNodeName().equals(TAGNAME_INK)) {
                                    StrokeInkMessage msg = StrokeInkMessage.fromJSONString(nodeStrokeChild.getTextContent());
                                    color = new ColorRGBA(msg.red, msg.green, msg.blue, msg.alpha);
                                    thickness = Float.valueOf(msg.thickness);
                                    style = msg.style;
                                    continue;
                                }
                                if (!nodeStrokeChild.getNodeName().equals(TAGNAME_POINTS)) continue;
                                String jsonPointArrayString = nodeStrokeChild.getTextContent();
                                if (jsonPointArrayString.contains("NaN") || jsonPointArrayString.contains("000000000.0000")) {
                                    badNodes.add(stroke3dXMLNode);
                                    isBad = true;
                                } else {
                                    ++numGoodNodes;
                                }
                                if (jsonPointArrayString.isEmpty()) {
                                    jsonPointArrayString = "[]";
                                }
                                try {
                                    JSONArray jsonPoints = new JSONArray(jsonPointArrayString);
                                    for (int p = 0; p < jsonPoints.length(); ++p) {
                                        JSONObject jsonPoint = jsonPoints.getJSONObject(p);
                                        float x = Float.parseFloat(jsonPoint.getString("x"));
                                        float y = Float.parseFloat(jsonPoint.getString("y"));
                                        float z = Float.parseFloat(jsonPoint.getString("z"));
                                        Vector3f pnt = new Vector3f(x, y, z);
                                        try {
                                            float pp = Float.parseFloat(jsonPoint.getString("p"));
                                            points.add(Stroke3DPoint.create(pnt, pp));
                                            continue;
                                        }
                                        catch (JSONException jse) {
                                            points.add(Stroke3DPoint.create(pnt, StylusPressure.NoPressure));
                                        }
                                    }
                                    continue;
                                }
                                catch (DOMException e) {
                                    e.printStackTrace();
                                    continue;
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (points.isEmpty() || color == null || thickness == null || strokeid == null || style == null) continue;
                            Stroke3D s3d = new Stroke3D(thickness, color, style);
                            s3d.setStrokeId(new StrokeId(strokeid));
                            s3d.setIsSelectable(isSelectable);
                            for (int ppi = 0; ppi < points.size(); ++ppi) {
                                Stroke3DPoint p = (Stroke3DPoint)points.get(ppi);
                                s3d.addPoint(p);
                            }
                            if (isBad) {
                                System.out.println("BAD: " + strokeid);
                                continue;
                            }
                            Stroke newDataModelStroke = StrokeConverter.convert(s3d);
                            try {
                                session.add(newDataModelStroke);
                            }
                            catch (ConcurrentAddException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (!nodeCanvasChild.getNodeName().equals(TAGNAME_ASSET)) continue;
                        Node assetXMLNode = nodeCanvasChild;
                        Asset asset = null;
                        NamedNodeMap sassetAttribs = assetXMLNode.getAttributes();
                        Node assetUid = sassetAttribs.getNamedItem(ATTRIBUTENAME_UID);
                        Node assetType = sassetAttribs.getNamedItem(ATTRIBUTENAME_ASSET_TYPE);
                        UUID assetid = null;
                        try {
                            uid = assetUid.getNodeValue();
                            assetid = UUID.fromString(uid);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Asset.Type type = null;
                        try {
                            String typestring = assetType.getNodeValue();
                            type = Asset.Type.valueOf(typestring);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        NodeList nodeAssetChildren = assetXMLNode.getChildNodes();
                        for (int loopIndexLevel4 = 0; loopIndexLevel4 < nodeAssetChildren.getLength(); ++loopIndexLevel4) {
                            Node nodeAssetChild = nodeAssetChildren.item(loopIndexLevel4);
                            if (nodeAssetChild.getNodeType() != 1 || !nodeAssetChild.getNodeName().equals(TAGNAME_ASSET_DATA)) continue;
                            AssetData ad = AssetData.fromAssetJsonString(nodeAssetChild.getTextContent(), this.getFile().getParentFile());
                            if (ad.hasDependentFiles()) {
                                Set<File> df = ad.getDependentFiles();
                                asset = AssetData.DataToAsset(ad);
                                continue;
                            }
                            asset = AssetData.DataToAsset(ad);
                        }
                        if (asset == null) continue;
                        try {
                            session.add(asset);
                            continue;
                        }
                        catch (ConcurrentAddException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            System.out.println("skipped " + badNodes.size() + " bad strokes, but there were " + numGoodNodes + " good ones.");
        }
    }
}

