/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.files;

import com.hybridlab.hyve3d.QuaternionJSONRepresentation;
import com.jme3.math.Quaternion;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportOptions {
    private static final String noOptionsString = "{}";
    private Float scale;
    private Quaternion rotation;
    private static final String KEY_SCALEFACTOR = "scaleFactor";
    private static final String KEY_ROTATION = "rotation";
    private static final String KEY_ROTATION_ANGLES = "rotationAngles";
    private static final String KEY_SELECTABLE = "selectable";
    private static final String KEY_BACKFACECULLING = "backfaceculling";
    private static final String KEY_PLACEMENT = "placement";
    private Boolean isSelectable = false;
    private Boolean backFaceCulling = false;
    private Placement placement = Placement.VIEW_FRONT;

    private ImportOptions() {
    }

    public String toImportOptionsString() {
        JSONObject o = new JSONObject();
        if (this.scale != null) {
            try {
                o.put(KEY_SCALEFACTOR, (Object)this.scale);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (this.rotation != null) {
            try {
                o.put(KEY_ROTATION, (Object)QuaternionJSONRepresentation.QuaternionToJsonString(this.rotation));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (this.isSelectable != null) {
            try {
                o.put(KEY_SELECTABLE, (Object)this.isSelectable);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (this.backFaceCulling != null) {
            try {
                o.put(KEY_BACKFACECULLING, (Object)this.backFaceCulling);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (this.placement != null) {
            try {
                o.put(KEY_PLACEMENT, (Object)this.placement.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (o.length() > 0) {
            return o.toString();
        }
        return noOptionsString;
    }

    public void setScaleFactor(Float scale) {
        this.scale = scale;
    }

    public static ImportOptions fromJson(JSONObject j) {
        Object v3;
        ImportOptions o = new ImportOptions();
        try {
            double v2 = j.getDouble(KEY_SCALEFACTOR);
            o.scale = Float.valueOf((float)v2);
        }
        catch (JSONException v2) {
            // empty catch block
        }
        try {
            Quaternion t;
            v3 = j.getString(KEY_ROTATION);
            o.rotation = t = QuaternionJSONRepresentation.jsonStringToQuaternion((String)v3);
        }
        catch (JSONException v3) {
            // empty catch block
        }
        try {
            Quaternion rot;
            v3 = j.getString(KEY_ROTATION_ANGLES);
            String[] angleStrings = ((String)v3).split(" ");
            float fx = Float.parseFloat(angleStrings[0]);
            float fy = Float.parseFloat(angleStrings[1]);
            float fz = Float.parseFloat(angleStrings[2]);
            float[] angles = new float[]{(float)Math.PI / 180 * fx, (float)Math.PI / 180 * fy, (float)Math.PI / 180 * fz};
            o.rotation = rot = new Quaternion(angles);
        }
        catch (JSONException v4) {
            // empty catch block
        }
        try {
            o.isSelectable = v3 = Boolean.valueOf(j.getBoolean(KEY_SELECTABLE));
        }
        catch (JSONException v5) {
            // empty catch block
        }
        try {
            o.backFaceCulling = v3 = Boolean.valueOf(j.getBoolean(KEY_BACKFACECULLING));
        }
        catch (JSONException v6) {
            // empty catch block
        }
        try {
            v3 = j.getString(KEY_PLACEMENT);
            o.placement = Placement.valueOf((String)v3);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return o;
    }

    public float getScaleFactor() {
        return this.scale == null ? 1.0f : this.scale.floatValue();
    }

    public boolean getIsSelectable() {
        return this.isSelectable == null ? false : this.isSelectable;
    }

    public void setIsSelectable(boolean selectable) {
        this.isSelectable = selectable;
    }

    public boolean getBackfaceCulling() {
        return this.backFaceCulling == null ? false : this.backFaceCulling;
    }

    public void setBackfaceCulling(boolean bfc) {
        this.backFaceCulling = bfc;
    }

    public void setRotation(Quaternion r) {
        this.rotation = r;
    }

    public Quaternion getRotation() {
        return this.rotation == null ? Quaternion.IDENTITY : this.rotation;
    }

    public static ImportOptions createDefaultOptions() {
        ImportOptions defaultOptions = new ImportOptions();
        return defaultOptions;
    }

    public ImportOptions getCopy() {
        try {
            ImportOptions copy = ImportOptions.fromJson(new JSONObject(this.toImportOptionsString()));
            return copy;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement p) {
        this.placement = p;
    }

    public static enum Placement {
        ZERO_POSITION,
        VIEW_FRONT;

    }
}

