/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.geometry;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;

public class Arc
extends Mesh {
    public Arc(int samples, float radius, float start, float end) {
        FloatBuffer vertexBuf = this.createBuffer(samples, radius, start, end);
        this.setBuffer(VertexBuffer.Type.Position, 3, vertexBuf);
        this.setMode(Mesh.Mode.LineStrip);
        this.updateBound();
        this.updateCounts();
    }

    private FloatBuffer createBuffer(int sample, float radius, float start, float end) {
        FloatBuffer buf = BufferUtils.createVector3Buffer((int)sample);
        buf.rewind();
        float arc = end - start;
        for (int i = 0; i < sample; ++i) {
            float theta = start + arc / (float)(sample - 1) * (float)i;
            float x = (float)(Math.cos(theta) * (double)radius);
            float y = (float)(Math.sin(theta) * (double)radius);
            buf.put(x).put(y).put(0.0f);
        }
        return buf;
    }
}

