/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.geometry;

import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.utils.Interpolation;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.Arrow;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class StrokeFaceMesh
extends Node {
    private AssetManager assetManager;
    private Material mat;
    private int numPointsRendered = 0;
    private Vector3f[] vertices;
    private int[] indices = new int[]{0, 1, 2};
    private Geometry strokeGeometry;
    private List<StrokePoint> strokePoints = new ArrayList<StrokePoint>();
    private static final int roundNessAlongAxis = 4;
    private float baseExtend;
    private float maximumPressureExtend;
    private static final float StrokeThicknessToBaseExtendFactor = 0.005f;
    private boolean normalsFixedOrNotNecessaryToFix = false;

    public StrokeFaceMesh(AssetManager assetManager, ColorRGBA color, float baseThickness) {
        this.assetManager = assetManager;
        this.baseExtend = baseThickness * 0.005f;
        this.maximumPressureExtend = this.baseExtend * 2.0f;
        this.vertices = new Vector3f[0];
        this.indices = new int[0];
        this.mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat.setColor("Color", color);
        this.mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
    }

    public void setColor(ColorRGBA c) {
        this.mat.setColor("Color", c);
    }

    private void drawArrow(Vector3f dir, Vector3f pos, ColorRGBA color) {
        Arrow arrow = new Arrow(dir);
        arrow.setLineWidth(1.0f);
        Geometry g = new Geometry("coordinate axis", (Mesh)arrow);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", color);
        g.setMaterial(mat);
        g.setLocalTranslation(pos);
        this.attachChild((Spatial)g);
    }

    private void createGeometry() {
        this.buildArrays();
        this.strokeGeometry = new Geometry("StrokeFaceMesh", this.createMesh());
        this.strokeGeometry.setMaterial(this.mat);
        this.attachChild((Spatial)this.strokeGeometry);
    }

    private void updateMesh() {
        this.buildArrays();
        this.strokeGeometry.setMesh(this.createMesh());
    }

    private void buildArrays() {
        this.fixNormalsIfNecessary();
        int pointsToAdd = this.strokePoints.size() - this.numPointsRendered;
        int numTrianglesPerStrokePoint = 8;
        int numIndicesPerStrokePoint = numTrianglesPerStrokePoint * 3;
        int numVerticesPerStrokePoint = 4;
        int indicesToAdd = numIndicesPerStrokePoint * (this.numPointsRendered == 0 ? pointsToAdd - 1 : pointsToAdd);
        int verticesToAdd = numVerticesPerStrokePoint * pointsToAdd;
        int[] newIndices = new int[this.indices.length + indicesToAdd];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        this.indices = newIndices;
        Vector3f[] newVertices = new Vector3f[this.vertices.length + verticesToAdd];
        System.arraycopy(this.vertices, 0, newVertices, 0, this.vertices.length);
        this.vertices = newVertices;
        for (int s = this.numPointsRendered - 1; s < this.strokePoints.size(); ++s) {
            NullPointerException e;
            StrokePoint sp_sm1;
            List<Vector3f> verticesInPlane;
            Vector3f tangent;
            Vector3f normal;
            StrokePoint sp_s;
            if (s < 0) continue;
            if (s == 0) {
                NullPointerException e2;
                sp_s = this.strokePoints.get(s);
                StrokePoint sp_sp1 = this.strokePoints.get(s + 1);
                normal = sp_sp1.getNormal();
                tangent = sp_sp1.getTangent();
                if (normal == null) {
                    normal = Vector3f.UNIT_Z;
                    e2 = new NullPointerException("normal was null!");
                    e2.printStackTrace();
                }
                if (tangent == null) {
                    tangent = Vector3f.UNIT_X;
                    e2 = new NullPointerException("tangent was null!");
                    e2.printStackTrace();
                }
                verticesInPlane = this.calculateVertices(normal, tangent, 4, null, sp_s.getPoint3d(), sp_sp1.getPoint3d(), sp_s.getPressure().getNormalizedValue());
                for (int v = 0; v < verticesInPlane.size(); ++v) {
                    this.vertices[s * numVerticesPerStrokePoint + v] = verticesInPlane.get(v);
                }
                continue;
            }
            if (s == this.strokePoints.size() - 1) {
                sp_s = this.strokePoints.get(s);
                sp_sm1 = this.strokePoints.get(s - 1);
                normal = sp_s.getNormal();
                tangent = sp_s.getTangent();
                if (normal == null) {
                    normal = Vector3f.UNIT_Z;
                    NullPointerException e3 = new NullPointerException("normal was null!");
                    e3.printStackTrace();
                }
                if (tangent == null) {
                    tangent = Vector3f.UNIT_X;
                    NullPointerException e4 = new NullPointerException("tangent was null!");
                    e4.printStackTrace();
                }
                verticesInPlane = this.calculateVertices(normal, tangent, 4, sp_sm1.getPoint3d(), sp_s.getPoint3d(), null, sp_s.getPressure().getNormalizedValue());
                for (int v = 0; v < verticesInPlane.size(); ++v) {
                    this.vertices[s * numVerticesPerStrokePoint + v] = verticesInPlane.get(v);
                }
                this.assignIndices(numIndicesPerStrokePoint, s);
                continue;
            }
            sp_s = this.strokePoints.get(s);
            sp_sm1 = this.strokePoints.get(s - 1);
            StrokePoint sp_sp1 = this.strokePoints.get(s + 1);
            normal = sp_sp1.getNormal();
            tangent = sp_sp1.getTangent();
            if (normal == null) {
                normal = Vector3f.UNIT_Z;
                e = new NullPointerException("normal was null!");
                e.printStackTrace();
            }
            if (tangent == null) {
                tangent = Vector3f.UNIT_X;
                e = new NullPointerException("tangent was null!");
                e.printStackTrace();
            }
            verticesInPlane = this.calculateVertices(normal, tangent, 4, sp_sm1.getPoint3d(), sp_s.getPoint3d(), sp_sp1.getPoint3d(), sp_s.getPressure().getNormalizedValue());
            for (int v = 0; v < verticesInPlane.size(); ++v) {
                this.vertices[s * numVerticesPerStrokePoint + v] = verticesInPlane.get(v);
            }
            this.assignIndices(numIndicesPerStrokePoint, s);
        }
        this.numPointsRendered = this.strokePoints.size();
    }

    private void fixNormalsIfNecessary() {
        if (this.strokePoints.size() <= 2) {
            return;
        }
        if (this.normalsFixedOrNotNecessaryToFix) {
            return;
        }
        StrokePoint sp1 = this.strokePoints.get(1);
        if (!sp1.getNormal().equals((Object)Vector3f.UNIT_Z)) {
            this.normalsFixedOrNotNecessaryToFix = true;
            return;
        }
        Random rand = new Random();
        int randomIndexInBetween = rand.nextInt(this.strokePoints.size() - 2) + 1;
        int[] indices = new int[]{0, randomIndexInBetween, this.strokePoints.size() - 1};
        StrokePoint a = this.strokePoints.get(indices[0]);
        StrokePoint b = this.strokePoints.get(indices[1]);
        StrokePoint c = this.strokePoints.get(indices[2]);
        Vector3f pa = a.getPoint3d();
        Vector3f pb = b.getPoint3d();
        Vector3f pc = c.getPoint3d();
        Vector3f v1 = pb.subtract(pa);
        Vector3f v2 = pc.subtract(pb);
        Vector3f n = v1.cross(v2);
        n.normalizeLocal();
        this.setNormalForAllStrokePoints(n);
        this.normalsFixedOrNotNecessaryToFix = true;
    }

    private void setNormalForAllStrokePoints(Vector3f normal) {
        for (StrokePoint sp : this.strokePoints) {
            sp.setNormal(normal);
        }
    }

    private void assignIndices(int numIndicesPerStrokePoint, int s) {
        for (int quadsection = 0; quadsection < 4; ++quadsection) {
            int a = s * 4 + quadsection;
            int b = a + 1;
            if (quadsection == 3) {
                b = a - quadsection;
            }
            int x = a - 4;
            int y = b - 4;
            int firstIndexOfQuad = numIndicesPerStrokePoint * (s - 1) + quadsection * 3 * 2;
            this.indices[firstIndexOfQuad++] = a;
            this.indices[firstIndexOfQuad++] = x;
            this.indices[firstIndexOfQuad++] = b;
            this.indices[firstIndexOfQuad++] = b;
            this.indices[firstIndexOfQuad++] = x;
            this.indices[firstIndexOfQuad++] = y;
        }
    }

    private List<Vector3f> calculateVertices(Vector3f normal, Vector3f tangent, int numVerticesInOnePlane, Vector3f a, Vector3f b, Vector3f c, float normalizedStrokePressure) {
        ArrayList<Vector3f> returnvalue = new ArrayList<Vector3f>(numVerticesInOnePlane);
        Vector3f planeNormal = normal;
        Vector3f planeCenter = b;
        Vector3f pole = normal.cross(tangent);
        if (normalizedStrokePressure < 0.0f) {
            normalizedStrokePressure = 0.0f;
        }
        float extend = Interpolation.linearTransform(this.baseExtend, this.maximumPressureExtend, normalizedStrokePressure);
        Vector3f normalizedPlaneVector = tangent.negate();
        float depth = 0.01f * extend;
        Vector3f u = normalizedPlaneVector;
        Vector3f v = normalizedPlaneVector.cross(planeNormal).normalize();
        Vector3f v0 = u.mult(depth).add(v.mult(extend));
        Vector3f v1 = u.mult(depth * -1.0f).add(v.mult(extend));
        Vector3f v2 = u.mult(depth * -1.0f).add(v.mult(extend * -1.0f));
        Vector3f v3 = u.mult(depth).add(v.mult(extend * -1.0f));
        returnvalue.add(planeCenter.add(v0));
        returnvalue.add(planeCenter.add(v1));
        returnvalue.add(planeCenter.add(v2));
        returnvalue.add(planeCenter.add(v3));
        return returnvalue;
    }

    private Mesh createMesh() {
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Triangles);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])this.vertices));
        mesh.setBuffer(VertexBuffer.Type.Index, 1, BufferUtils.createIntBuffer((int[])this.indices));
        mesh.updateBound();
        return mesh;
    }

    public void addStrokePoint(StrokePoint sp) {
        this.strokePoints.add(sp);
        if (this.strokePoints.size() > 2) {
            this.updateMesh();
        } else if (this.strokePoints.size() == 2) {
            this.createGeometry();
        }
    }

    private void debug_drawSideVectors() {
        int lastaddedIndex = this.strokePoints.size() - 1;
        if (lastaddedIndex <= 4) {
            return;
        }
        StrokePoint c = this.strokePoints.get(lastaddedIndex);
        StrokePoint b = this.strokePoints.get(lastaddedIndex - 1);
        StrokePoint a = this.strokePoints.get(lastaddedIndex - 2);
        Vector3f bc = c.getPoint3d().subtract(b.getPoint3d());
        Vector3f ba = a.getPoint3d().subtract(b.getPoint3d());
        this.drawArrow(bc, c.getPoint3d(), ColorRGBA.Yellow);
        Vector3f dir = bc.cross(ba).mult(100.0f);
        Vector3f pos = b.getPoint3d();
        ColorRGBA color = ColorRGBA.Magenta;
        this.drawArrow(dir, pos, color);
    }

    public void initialize(ArrayList<StrokePoint> initialStrokePoints) {
        this.strokePoints.addAll(initialStrokePoints);
        if (this.strokePoints.size() > 2) {
            this.createGeometry();
            this.updateMesh();
        } else if (this.strokePoints.size() == 2) {
            this.createGeometry();
        }
    }
}

