/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.geometry;

import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.utils.Interpolation;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.Arrow;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;

public class StrokePipeMesh
extends Node {
    private AssetManager assetManager;
    private Material mat;
    private int numPointsRendered = 0;
    private Vector3f[] vertices;
    private int[] indices = new int[]{0, 1, 2};
    private Geometry strokeGeometry;
    private List<Vector3f> strokePoints = new ArrayList<Vector3f>();
    private List<Float> strokePressureValues = new ArrayList<Float>();
    private static final int roundNessAlongAxis = 4;
    private float baseExtend;
    private static final float StrokeThicknessToBaseExtendFactor = 0.001f;
    private static final float minCross = 0.01f;
    private static final float maximumPressureFactor = 6.0f;

    public StrokePipeMesh(AssetManager assetManager, StrokeInk strokeInk) {
        this.assetManager = assetManager;
        this.baseExtend = strokeInk.getThickness() * 0.001f;
        this.vertices = new Vector3f[0];
        this.indices = new int[0];
        this.mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat.setColor("Color", strokeInk.getColor());
        this.mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
    }

    private void drawArrow(Vector3f dir, Vector3f pos, ColorRGBA color) {
        Arrow arrow = new Arrow(dir);
        arrow.setLineWidth(1.0f);
        Geometry g = new Geometry("coordinate axis", (Mesh)arrow);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        g.setLocalTranslation(pos);
        this.attachChild((Spatial)g);
    }

    private void createGeometry() {
        this.buildArrays();
        this.strokeGeometry = new Geometry("StrokeMesh", this.createMesh());
        this.strokeGeometry.setMaterial(this.mat);
        this.attachChild((Spatial)this.strokeGeometry);
    }

    private void updateMesh() {
        this.buildArrays();
        this.strokeGeometry.setMesh(this.createMesh());
    }

    private void buildArrays() {
        int pointsToAdd = this.strokePoints.size() - this.numPointsRendered;
        int numTrianglesPerStrokePoint = 8;
        int numIndicesPerStrokePoint = numTrianglesPerStrokePoint * 3;
        int numVerticesPerStrokePoint = 4;
        int indicesToAdd = numIndicesPerStrokePoint * (this.numPointsRendered == 0 ? pointsToAdd - 1 : pointsToAdd);
        int verticesToAdd = numVerticesPerStrokePoint * pointsToAdd;
        int[] newIndices = new int[this.indices.length + indicesToAdd];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        this.indices = newIndices;
        Vector3f[] newVertices = new Vector3f[this.vertices.length + verticesToAdd];
        System.arraycopy(this.vertices, 0, newVertices, 0, this.vertices.length);
        this.vertices = newVertices;
        Vector3f poleVector1 = Vector3f.UNIT_X.clone();
        Vector3f poleVector2 = Vector3f.UNIT_Y.clone();
        for (int s = this.numPointsRendered - 1; s < this.strokePoints.size(); ++s) {
            int v;
            List<Vector3f> verticesInPlane;
            if (s < 0) continue;
            if (s == 0) {
                verticesInPlane = this.calculateVertices(poleVector1, poleVector2, 4, null, this.strokePoints.get(s), this.strokePoints.get(s + 1), this.strokePressureValues.get(s).floatValue());
                for (v = 0; v < verticesInPlane.size(); ++v) {
                    this.vertices[s * numVerticesPerStrokePoint + v] = verticesInPlane.get(v);
                }
                continue;
            }
            if (s == this.strokePoints.size() - 1) {
                verticesInPlane = this.calculateVertices(poleVector1, poleVector2, 4, this.strokePoints.get(s - 1), this.strokePoints.get(s), null, this.strokePressureValues.get(s).floatValue());
                for (v = 0; v < verticesInPlane.size(); ++v) {
                    this.vertices[s * numVerticesPerStrokePoint + v] = verticesInPlane.get(v);
                }
                this.assignIndices(numIndicesPerStrokePoint, s);
                continue;
            }
            verticesInPlane = this.calculateVertices(poleVector1, poleVector2, 4, this.strokePoints.get(s - 1), this.strokePoints.get(s), this.strokePoints.get(s + 1), this.strokePressureValues.get(s).floatValue());
            for (v = 0; v < verticesInPlane.size(); ++v) {
                this.vertices[s * numVerticesPerStrokePoint + v] = verticesInPlane.get(v);
            }
            this.assignIndices(numIndicesPerStrokePoint, s);
        }
        this.numPointsRendered = this.strokePoints.size();
    }

    private void assignIndices(int numIndicesPerStrokePoint, int s) {
        for (int quadsection = 0; quadsection < 4; ++quadsection) {
            int a = s * 4 + quadsection;
            int b = a + 1;
            if (quadsection == 3) {
                b = a - quadsection;
            }
            int x = a - 4;
            int y = b - 4;
            int firstIndexOfQuad = numIndicesPerStrokePoint * (s - 1) + quadsection * 3 * 2;
            this.indices[firstIndexOfQuad++] = a;
            this.indices[firstIndexOfQuad++] = x;
            this.indices[firstIndexOfQuad++] = b;
            this.indices[firstIndexOfQuad++] = b;
            this.indices[firstIndexOfQuad++] = x;
            this.indices[firstIndexOfQuad++] = y;
        }
    }

    private List<Vector3f> calculateVertices(Vector3f poleVector1, Vector3f poleVector2, int numVerticesInOnePlane, Vector3f a, Vector3f b, Vector3f c, float normalizedStrokePressure) {
        ArrayList<Vector3f> returnvalue = new ArrayList<Vector3f>(numVerticesInOnePlane);
        Vector3f planeNormal = Vector3f.UNIT_XYZ.clone();
        Vector3f planeCenter = b;
        if (a == null && b != null && c != null) {
            planeNormal = c.subtract(b).normalize();
        } else if (a != null && b != null && c == null) {
            planeNormal = b.subtract(a).normalize();
        } else if (a != null && b != null && c != null) {
            planeNormal = c.subtract(a).normalize();
        }
        Vector3f pole = FastMath.abs((float)planeNormal.dot(poleVector1)) < 0.01f ? poleVector2 : poleVector1;
        if (normalizedStrokePressure < 0.0f) {
            normalizedStrokePressure = 0.0f;
        }
        float extend = Interpolation.linearTransform(this.baseExtend, 6.0f * this.baseExtend, normalizedStrokePressure);
        Vector3f normalizedPlaneVector = pole.subtract(pole.project(planeNormal)).normalize();
        Quaternion rotation = new Quaternion();
        float sectionAngle = (float)Math.PI * 2 / (float)numVerticesInOnePlane;
        for (int i = 0; i < numVerticesInOnePlane; ++i) {
            float angle = (float)i * sectionAngle;
            Vector3f v = rotation.fromAngleAxis(angle, planeNormal).mult(normalizedPlaneVector).mult(extend);
            returnvalue.add(planeCenter.add(v));
        }
        return returnvalue;
    }

    private Mesh createMesh() {
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Triangles);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])this.vertices));
        mesh.setBuffer(VertexBuffer.Type.Index, 1, BufferUtils.createIntBuffer((int[])this.indices));
        mesh.updateBound();
        return mesh;
    }

    public void addStrokePoint(Vector3f pos, float pressure) {
        this.strokePoints.add(pos);
        this.strokePressureValues.add(Float.valueOf(pressure));
        if (this.strokePoints.size() > 2) {
            this.updateMesh();
        } else if (this.strokePoints.size() == 2) {
            this.createGeometry();
        }
    }

    public void setColor(ColorRGBA c) {
        this.mat.setColor("Color", c);
    }
}

