/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.DataModelObserver;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.hyve.HyveSessionLogger;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileSessionLogger
implements HyveSessionLogger,
DataModelObserver,
PropertyChangeListener {
    private File file;
    private File folderToPlaceLogsInto;
    private Charset encoding = Charset.forName("UTF-8");
    private Session session;
    private static final String itemseparator = " ";
    private static final String strokeType = "Stroke";
    private static final String actionAdd = "ADD";
    private static final String actionRemove = "REMOVE";
    private static final String actionStrokePoint = "STROKEPOINT";
    private static final String lineSeparator = System.getProperty("line.separator");

    public FileSessionLogger(File folderToPlaceLogsInto) {
        this.folderToPlaceLogsInto = folderToPlaceLogsInto;
    }

    @Override
    public void stopLogging(Session sessionToStopLogging) {
        if (sessionToStopLogging == null) {
            return;
        }
        if (sessionToStopLogging != this.session) {
            return;
        }
        this.session.removeObserver(this);
        this.session = null;
        this.file = null;
    }

    @Override
    public void startLogging(Session sessionToLog) {
        if (sessionToLog == null) {
            return;
        }
        this.session = sessionToLog;
        this.file = new File(this.folderToPlaceLogsInto, "Hyve3DSession-" + this.session.getId().toString() + ".log");
        try {
            FileUtils.touch(this.file);
            this.session.addObserver(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.stopLogging(sessionToLog);
        }
    }

    @Override
    public void onDataAdded(DataModelKey key, HyveData data) {
        if (data instanceof Stroke) {
            Stroke s = (Stroke)data;
            this.l(actionAdd, strokeType, data.getId().toString(), "STYLE=" + s.getStyle().toString(), "COLOR=" + this.ColorToPrettyString(s.getColor()));
            data.addPropertyChangeListener(this);
        }
    }

    private String ColorToPrettyString(ColorRGBA color) {
        if (color == null) {
            return "none";
        }
        return "R" + FileSessionLogger.FloatToPrettyString(color.r) + "G" + FileSessionLogger.FloatToPrettyString(color.g) + "B" + FileSessionLogger.FloatToPrettyString(color.b) + "A" + FileSessionLogger.FloatToPrettyString(color.a);
    }

    @Override
    public void onDataRemoved(DataModelKey key, HyveData data) {
        if (data instanceof Stroke) {
            this.l(actionRemove, strokeType, data.getId().toString());
            data.removePropertyChangeListener(this);
        }
    }

    private void l(String ... args) {
        this.logLine(StringUtils.join((Object[])args, itemseparator));
    }

    private void logLine(String txt) {
        try {
            FileUtils.write(this.file, (CharSequence)(txt + lineSeparator), this.encoding, true);
        }
        catch (IOException e) {
            this.stopLogging(this.session);
            e.printStackTrace();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() instanceof Stroke && pce.getPropertyName().endsWith("#point")) {
            int index = -1;
            if (pce instanceof IndexedPropertyChangeEvent) {
                IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)pce;
                index = ipce.getIndex();
            }
            Stroke s = (Stroke)pce.getSource();
            StrokePoint p = (StrokePoint)pce.getNewValue();
            Vector3f point3d = s.calculateSceneCoordinates(p);
            this.l(actionStrokePoint, s.getId().toString(), index > -1 ? String.valueOf(index) : "", FileSessionLogger.FloatToPrettyString(point3d.x), FileSessionLogger.FloatToPrettyString(point3d.y), FileSessionLogger.FloatToPrettyString(point3d.z));
        }
    }

    private static String FloatToPrettyString(float d) {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(340);
        return df.format(d);
    }

    @Override
    public void quit() {
        this.stopLogging(this.session);
    }

    @Override
    public boolean isEnabled() {
        return this.session != null;
    }
}

