/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.config.ConfigurationAdapter;
import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.core.animation.AnimationTrigger;
import com.hybridlab.hyve3d.data.CommandExecutorHelper;
import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.DataModelObserver;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.decorators.AssetSelectable;
import com.hybridlab.hyve3d.data.decorators.SelectableDecorator;
import com.hybridlab.hyve3d.data.decorators.StrokeSelectable;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.CommandHistory;
import com.hybridlab.hyve3d.data.domainobjects.CopyAble;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Node;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.data.domainobjects.Selection;
import com.hybridlab.hyve3d.data.domainobjects.Sky;
import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.data.valueobjects.Ink;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.DrawingAreaDirectionAdapter;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.hyve.HyveSessionLogger;
import com.hybridlab.hyve3d.hyve.OrthoShooter;
import com.hybridlab.hyve3d.hyve.ParallaxEffect;
import com.hybridlab.hyve3d.hyve.ParallaxEffectParameters;
import com.hybridlab.hyve3d.hyve.SatelliteCenter;
import com.hybridlab.hyve3d.hyve.SatelliteDrawingAreaAdapter;
import com.hybridlab.hyve3d.hyve.SelectableProvider;
import com.hybridlab.hyve3d.hyve.StrokeCreationAdapter;
import com.hybridlab.hyve3d.hyve.undoredo.CommandExecutor;
import com.hybridlab.hyve3d.hyve.undoredo.CopyCommand;
import com.hybridlab.hyve3d.hyve.undoredo.EraseCommand;
import com.hybridlab.hyve3d.hyve.undoredo.HistoryController;
import com.hybridlab.hyve3d.hyve.undoredo.StrokeCreationCommand;
import com.hybridlab.hyve3d.network.messages.OrbitMessage;
import com.hybridlab.hyve3d.scenemanipulation.SceneElementSelector;
import com.hybridlab.utils.ThreePerpendicularAxes;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class Hyve
implements SatelliteCenter.SatelliteListeners {
    private Space space;
    private Session session;
    private Set<SatelliteDrawingAreaAdapter> satDaAdapter = new HashSet<SatelliteDrawingAreaAdapter>();
    private CameraAdapter cam;
    private Logger logger = Logger.getAnonymousLogger();
    private Compass northHeading;
    private SpaceTransformationAdapter spaceTransformationAdapter;
    private UUID hyveId;
    private OrthoShooter orthoShooter;
    private ConfigurationAdapter configurationAdapter;
    private DrawingAreaDirectionAdapter.DirectionObserver daDirectionObserver;
    private LocalDrawingAreaObserver localDrawingAreaObserver = new LocalDrawingAreaObserver();
    private Map<UUID, CommandHistory> histories = new HashMap<UUID, CommandHistory>();
    private Map<DrawingArea, SessionSelectablesProvider> providers = new HashMap<DrawingArea, SessionSelectablesProvider>();
    private IOrbitingController currentOrbitingController;
    private boolean orbitTargetIsDrawingArea = false;
    private boolean synchHyvePositions = false;
    private AnimationTrigger animationtrigger;
    private Map<UUID, ParallaxEffect> parallaxEffects = new HashMap<UUID, ParallaxEffect>();
    private boolean parallaxEffectEnabled = true;
    private HistoryController historyController;
    private NamedAngle tiltAngle = new NamedAngle("Tilt", 0.0f);
    private NamedAngle snapAngle = new NamedAngle("Snaptreshold", 5.0f);
    private HyveSessionLogger doNothingSessionlogger;
    private HyveSessionLogger sessionlogger = this.doNothingSessionlogger = new DoNothingSessionLogger();

    public UUID getHyveId() {
        return this.hyveId;
    }

    public Hyve(UUID hyveId, ConfigurationAdapter ca) {
        String hyveName = ca.getHyveName();
        NamedAngle north = ca.getNorthHeading();
        this.configurationAdapter = ca;
        this.hyveId = hyveId;
        this.space = new Space(hyveId, hyveName);
        this.spaceTransformationAdapter = new SpaceTransformationAdapter(this.space);
        this.northHeading = new Compass(north);
    }

    public CommandHistory getCommandHistoryForId(UUID id) {
        CommandHistory h = this.histories.get(id);
        if (h == null) {
            h = new CommandHistory(UUID.randomUUID());
            this.histories.put(id, h);
        }
        return h;
    }

    public void removeCommandHistoryForId(UUID id) {
        this.histories.remove(id);
    }

    public Space getLocalSpace() {
        return this.space;
    }

    public boolean isSpaceIdEqualToLocalSpace(Space s) {
        return this.space.getId().equals(s.getId());
    }

    public void leaveSession() {
        if (this.session != null) {
            this.sessionlogger.stopLogging(this.session);
            if (this.cam != null) {
                this.cam.disConnectFromSpace(this.space);
            }
            if (this.space != null) {
                for (SatelliteDrawingAreaAdapter a : this.satDaAdapter) {
                    if (a.getDrawingArea().getSpaceId().equals(this.space.getId())) {
                        this.session.remove(a.getDrawingArea());
                    }
                    a.getStrokeCreationAdapter().setSession(null);
                    a.getStrokeProjector().setSession(null);
                    a.getSceneElementSelector().setSelectableProvider(null);
                    a.disconnectDrawingArea();
                }
                this.session.remove(this.space);
            } else {
                throw new RuntimeException("space must nut be null here");
            }
        }
        this.localDrawingAreaObserver.useSession(null);
        if (this.historyController != null) {
            this.historyController.connect(null);
        }
    }

    public void joinSession(Session session) {
        this.leaveSession();
        this.session = session;
        this.sessionlogger.startLogging(this.session);
        this.localDrawingAreaObserver.useSession(this.session);
        Space formerInstance = this.findFormerSpaceInSession();
        if (formerInstance != null) {
            this.useSpace(formerInstance);
        } else {
            try {
                this.session.add(this.space);
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
        }
        for (SatelliteDrawingAreaAdapter sdAdapter : this.satDaAdapter) {
            sdAdapter.getStrokeProjector().setSession(this.session);
            DrawingArea recentlyUsed = null;
            recentlyUsed = this.findFormerUsedDrawingAreaInSession(sdAdapter.getSatelliteId());
            if (recentlyUsed != null) {
                sdAdapter.connectDrawingArea(recentlyUsed, SatelliteDrawingAreaAdapter.PairingDirection.DrawingAreaIsLeading);
            } else {
                DrawingArea adapterDa = sdAdapter.getDrawingArea();
                if (adapterDa == null) {
                    adapterDa = this.createNewDrawingAreaAndAddToSession();
                    sdAdapter.connectDrawingArea(adapterDa, SatelliteDrawingAreaAdapter.PairingDirection.SatelliteIsLeading);
                } else if (adapterDa.getSpaceId().equals(this.space.getId())) {
                    try {
                        this.session.add(sdAdapter.getDrawingArea());
                    }
                    catch (ConcurrentAddException e) {
                        e.printStackTrace();
                    }
                }
            }
            sdAdapter.getStrokeCreationAdapter().setSession(this.session);
            sdAdapter.getSceneElementSelector().setSelectableProvider(this.getSelectableProviderFor(sdAdapter.getDrawingArea()));
            CommandHistory cmdHistory = this.getCommandHistoryForId(sdAdapter.getDrawingArea().getId());
            sdAdapter.useHistory(cmdHistory);
        }
        if (this.cam != null) {
            this.cam.connectToSpace(this.space);
        }
    }

    private SelectableProvider getSelectableProviderFor(DrawingArea da) {
        SessionSelectablesProvider provider = this.providers.get(da);
        if (provider == null) {
            provider = new SessionSelectablesProvider(this.session, da);
            this.providers.put(da, provider);
        } else {
            provider.setSession(this.session);
        }
        return provider;
    }

    private void useSpace(Space formerInstance) {
        this.space = formerInstance;
        this.spaceTransformationAdapter.reNewWith(this.space);
    }

    private Space findFormerSpaceInSession() {
        for (Space s : this.session.getParticipatingSpaces()) {
            if (!this.hyveId.equals(s.getId())) continue;
            return s;
        }
        return null;
    }

    public boolean isParticipatingInSession() {
        return this.session != null;
    }

    private DrawingArea createNewDrawingArea() {
        if (!this.isParticipatingInSession()) {
            throw new RuntimeException("Hyve without Session cannot create DrawingAreas");
        }
        DrawingArea da = new DrawingArea(UUID.randomUUID(), this.space.getId());
        Vector3f spacePos = this.space.getTransformation().getPosition();
        ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(this.space.getTransformation().getRotation());
        float distance = -1.0f * da.getFrame().getDiagonalLength();
        Vector3f newPos = spacePos.add(axes.Z.mult(distance));
        da.setTransformation(new Transformation(newPos, da.getTransformation().getRotation()));
        return da;
    }

    public DrawingArea createNewDrawingAreaAndAddToSession() {
        if (!this.isParticipatingInSession()) {
            throw new RuntimeException("Hyve without Session cannot create DrawingAreas");
        }
        DrawingArea da = this.createNewDrawingArea();
        try {
            this.session.add(da);
        }
        catch (ConcurrentAddException e) {
            e.printStackTrace();
        }
        return da;
    }

    public CameraAdapter connectCamera(Transformable cameraRig) {
        this.cam = new CameraAdapter(cameraRig);
        return this.cam;
    }

    public Session currentSession() {
        return this.session;
    }

    @Override
    public void satelliteCreated(Satellite sat) {
        DrawingArea da = this.findFormerUsedDrawingAreaInSession(sat.getSatelliteId());
        SatelliteDrawingAreaAdapter.PairingDirection pairingDir = SatelliteDrawingAreaAdapter.PairingDirection.DrawingAreaIsLeading;
        sat.getSatelliteId();
        if (da == null) {
            pairingDir = SatelliteDrawingAreaAdapter.PairingDirection.SatelliteIsLeading;
            da = this.createNewDrawingArea();
            try {
                this.session.add(da);
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
        }
        DrawingAreaStrokeCreationAdapter sketcher = new DrawingAreaStrokeCreationAdapter(da, this.session);
        SatelliteDrawingAreaAdapter adapter = new SatelliteDrawingAreaAdapter(sat, da, pairingDir, this, this.northHeading, this.spaceTransformationAdapter, this.orthoShooter, this.animationtrigger);
        adapter.setStrokeCreationAdapter(sketcher);
        adapter.getStrokeProjector().setSession(this.session);
        adapter.getSceneElementSelector().setSelectableProvider(this.getSelectableProviderFor(da));
        adapter.useHistory(sketcher.getHistory());
        this.satDaAdapter.add(adapter);
    }

    private DrawingArea findFormerUsedDrawingAreaInSession(String satelliteId) {
        if (satelliteId == null) {
            return null;
        }
        for (DrawingArea da : this.session.getParticipatingDrawingAreas()) {
            if (!satelliteId.equals(da.getConnectedSatelliteId())) continue;
            return da;
        }
        return null;
    }

    public void onNavigationRequest(Object source, Vector3f direction) {
        this.destroyParallaxEffects();
        Vector3f correctedDirection = this.northHeading.getRotation().mult(direction);
        correctedDirection = this.space.getTransformation().getRotation().mult(correctedDirection);
        Transformation t = this.space.getTransformation();
        Transformation tMoved = t.add(correctedDirection);
        this.space.setTransformation(tMoved);
        if (this.synchHyvePositions) {
            this.synchHyvePositions();
        }
    }

    public void onSetRotationRequest(Object tilter, Quaternion hyveRot) {
        this.destroyParallaxEffects();
        Transformation t = this.space.getTransformation();
        Transformation tnew = new Transformation(t.getPosition(), hyveRot, t.getScale());
        this.space.setTransformation(tnew);
    }

    public void onOrbitingRequest(SatelliteDrawingAreaAdapter satelliteDrawingAreaAdapter, OrbitMessage orbitMsg) {
        block19: {
            block18: {
                if (this.currentOrbitingController != null && this.currentOrbitingController.getInputSource() != satelliteDrawingAreaAdapter) {
                    return;
                }
                if (!GlobalSettings.panoramaMode.booleanValue()) break block18;
                switch (orbitMsg.getPhase()) {
                    case INTERACTION_BEGIN: {
                        this.currentOrbitingController = new PanoramicModeOrbitingController(satelliteDrawingAreaAdapter, this.spaceTransformationAdapter);
                        break;
                    }
                    case INTERACTION_END: {
                        this.currentOrbitingController = null;
                        break;
                    }
                    case INTERACTION_ONGOING: {
                        if (this.currentOrbitingController != null) {
                            this.currentOrbitingController.feed(orbitMsg);
                            if (this.synchHyvePositions) {
                                this.synchHyvePositions();
                                break;
                            }
                        }
                        break block19;
                    }
                    case INTERACTION_RESTART: {
                        break;
                    }
                }
                break block19;
            }
            if (this.parallaxEffectIsActive()) {
                return;
            }
            switch (orbitMsg.getPhase()) {
                case INTERACTION_BEGIN: {
                    Vector3f target;
                    if (this.orbitTargetIsDrawingArea) {
                        Vector3f daPosition;
                        target = daPosition = satelliteDrawingAreaAdapter.getDrawingArea().getTransformation().getPosition();
                    } else {
                        Vector3f spacePos = this.space.getTransformation().getPosition();
                        ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(this.space.getTransformation().getRotation());
                        float distance = -1.0f * DrawingArea.DefaultFrame.getDiagonalLength();
                        target = spacePos.add(axes.Z.mult(distance));
                    }
                    Vector3f orbitPlaneNormal = Vector3f.UNIT_Y;
                    this.currentOrbitingController = new OrbitingController(satelliteDrawingAreaAdapter, target, this.spaceTransformationAdapter, orbitPlaneNormal);
                    break;
                }
                case INTERACTION_END: {
                    this.currentOrbitingController = null;
                    break;
                }
                case INTERACTION_ONGOING: {
                    if (this.currentOrbitingController == null) break;
                    this.currentOrbitingController.feed(orbitMsg);
                    if (!this.synchHyvePositions) break;
                    this.synchHyvePositions();
                    break;
                }
                case INTERACTION_RESTART: {
                    break;
                }
            }
        }
    }

    public void setSynchronizeHyvePositions(boolean b) {
        this.synchHyvePositions = b;
        if (b) {
            this.synchHyvePositions();
        }
    }

    private void synchHyvePositions() {
        Transformation myTrf = this.space.getTransformation();
        Set<Space> allspaces = this.session.getParticipatingSpaces();
        for (Space s : allspaces) {
            if (s == this.space) continue;
            s.setTransformation(myTrf);
        }
    }

    public CopyCommand onCopyRequest(UUID creatorid, Set<Selectable> selected) {
        HashSet<UUID> copyItems = new HashSet<UUID>();
        for (Selectable s : selected) {
            HyveData data = s.getData();
            if (!(data instanceof CopyAble)) continue;
            copyItems.add(data.getId());
        }
        CopyCommand e = new CopyCommand(copyItems, null, "Copy");
        CommandExecutorHelper.attachExecutor(e, this.session);
        return e;
    }

    public EraseCommand onDeleteRequest(UUID deletorid, Set<Selectable> selected, SceneElementSelector selector, Satellite satellite) {
        HashSet<UUID> eraseItems = new HashSet<UUID>();
        HashSet<HyveData> erasedata = new HashSet<HyveData>();
        for (Selectable s : selected) {
            HyveData data = s.getData();
            erasedata.add(data);
            eraseItems.add(data.getId());
        }
        EraseCommand cmd = new EraseCommand(eraseItems, null, "Delete");
        CommandExecutor cex = CommandExecutorHelper.createEraseExecutor(this.session, erasedata, selector, satellite);
        cmd.setExecutor(cex);
        return cmd;
    }

    public void setOrthoShooter(OrthoShooter orthoShooter) {
        this.orthoShooter = orthoShooter;
    }

    public void setAnimationTrigger(AnimationTrigger trigger) {
        this.animationtrigger = trigger;
    }

    public void setOrthogonalRenderingEnabled(boolean b) {
        for (SatelliteDrawingAreaAdapter a : this.satDaAdapter) {
            a.setOrthogonalRenderingEnabled(b);
        }
    }

    public void setLocalSpaceName(String hyveName) {
        this.space.setName(hyveName);
        this.configurationAdapter.setHyveName(hyveName);
    }

    public String getLocalSpaceName() {
        return this.space.getName();
    }

    public HyveSessionLogger getSessionlogger() {
        return this.sessionlogger;
    }

    public void setParallaxEffectEnabled(boolean enabled) {
        this.parallaxEffectEnabled = enabled;
    }

    public boolean isParallaxEffectEnabled() {
        return this.parallaxEffectEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID requestParallaxEffect(Object requestor, ParallaxEffectParameters p) {
        if (this.currentOrbitingController != null) {
            return null;
        }
        if (!this.isParallaxEffectEnabled()) {
            return null;
        }
        Map<UUID, ParallaxEffect> map = this.parallaxEffects;
        synchronized (map) {
            if (!this.parallaxEffects.isEmpty()) {
                return null;
            }
            UUID id = UUID.randomUUID();
            ParallaxEffect pe = new ParallaxEffect(id, p, requestor);
            this.parallaxEffects.put(id, pe);
            this.cam.applyEffect(pe);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelParallaxEffect(UUID parallaxEffectId) {
        Map<UUID, ParallaxEffect> map = this.parallaxEffects;
        synchronized (map) {
            ParallaxEffect p = this.parallaxEffects.remove(parallaxEffectId);
            if (p != null) {
                this.cam.cancelEffect(p);
            }
        }
    }

    public void eraseAllInSession() {
        if (this.session != null) {
            this.session.eraseAll();
            for (CommandHistory h : this.histories.values()) {
                h.clear();
            }
            this.clearAllSatellites();
        }
    }

    public void clearAllSatellites() {
        for (SatelliteDrawingAreaAdapter a : this.satDaAdapter) {
            a.clearSatelliteScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyParallaxEffects() {
        Map<UUID, ParallaxEffect> map = this.parallaxEffects;
        synchronized (map) {
            while (!this.parallaxEffects.isEmpty()) {
                ParallaxEffect p = this.parallaxEffects.remove(this.parallaxEffects.keySet().iterator().next());
                this.cam.destroyEffect(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parallaxEffectIsActive() {
        Map<UUID, ParallaxEffect> map = this.parallaxEffects;
        synchronized (map) {
            return !this.parallaxEffects.isEmpty();
        }
    }

    public void registerDrawingAreaDirectionObserver(DrawingAreaDirectionAdapter.DirectionObserver o) {
        if (this.daDirectionObserver != null) {
            this.daDirectionObserver.cancel();
        }
        this.daDirectionObserver = o;
    }

    public void setHistoryController(HistoryController ctrl) {
        this.historyController = ctrl;
    }

    public Transformation calculateViewFrontAssetPlacement() {
        Transformation spacetrf = this.getLocalSpace().getTransformation().copy();
        Vector3f spacePos = spacetrf.getPosition();
        ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(this.space.getTransformation().getRotation());
        float distance = -1.0f * DrawingArea.DefaultFrame.getDiagonalLength();
        Vector3f target = spacePos.add(axes.Z.mult(distance));
        Transformation viewFront = new Transformation(target, spacetrf.getRotation());
        return viewFront;
    }

    public NamedAngle getSnapAngle() {
        return this.snapAngle;
    }

    public NamedAngle getTiltAngle() {
        return this.tiltAngle;
    }

    public void setTiltAngle(float tiltAngleDeg) {
        this.tiltAngle.setAngleInDegrees(tiltAngleDeg);
    }

    public void setTiltAngleAnimated(float f, int durationInMilliseconds) {
        this.setTiltAngle(f);
    }

    public void clearSkyInCurrentSession() {
        Session s = this.currentSession();
        for (Sky sky : s.getAllSkys()) {
            s.remove(sky);
        }
    }

    public void connectSessionLogger(HyveSessionLogger sessionlog) {
        if (sessionlog == null) {
            if (this.sessionlogger != null) {
                this.sessionlogger.quit();
            }
            this.sessionlogger = this.doNothingSessionlogger;
        } else {
            this.sessionlogger = sessionlog;
            this.sessionlogger.startLogging(this.currentSession());
        }
    }

    private class LocalDrawingAreaObserver
    implements DataModelObserver,
    PropertyChangeListener {
        private Session session;
        private Set<DrawingArea> observedDrawingAreas = new HashSet<DrawingArea>();

        private LocalDrawingAreaObserver() {
        }

        public void useSession(Session session) {
            if (session == null) {
                if (this.session != null) {
                    this.session.removeObserver(this);
                }
                this.forgetAll();
            } else {
                this.session = session;
                this.session.addObserver(this);
            }
        }

        @Override
        public void onDataAdded(DataModelKey key, HyveData data) {
            DrawingArea da;
            if (data instanceof DrawingArea && (da = (DrawingArea)data).getSpaceId().equals(Hyve.this.getLocalSpace().getId())) {
                this.observe(da);
            }
        }

        private void observe(DrawingArea da) {
            da.addPropertyChangeListener("transformation", this);
            this.observedDrawingAreas.add(da);
        }

        private void forget(DrawingArea da) {
            da.removePropertyChangeListener("transformation", this);
            this.observedDrawingAreas.remove(da);
        }

        private void forgetAll() {
            for (DrawingArea da : this.observedDrawingAreas) {
                da.removePropertyChangeListener("transformation", this);
            }
            this.observedDrawingAreas.clear();
        }

        @Override
        public void onDataRemoved(DataModelKey key, HyveData data) {
            DrawingArea da;
            if (data instanceof DrawingArea && (da = (DrawingArea)data).getSpaceId().equals(Hyve.this.getLocalSpace().getId())) {
                this.forget(da);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop;
            if (this.observedDrawingAreas.contains(evt.getSource()) && (prop = evt.getPropertyName()).endsWith("transformation") && Hyve.this.daDirectionObserver != null) {
                DrawingArea da = (DrawingArea)evt.getSource();
                Hyve.this.daDirectionObserver.connect(new DADirectionObserver(da));
                Hyve.this.daDirectionObserver = null;
            }
        }
    }

    private class DoNothingSessionLogger
    implements HyveSessionLogger {
        private DoNothingSessionLogger() {
        }

        @Override
        public void stopLogging(Session session) {
        }

        @Override
        public void startLogging(Session session) {
        }

        @Override
        public void quit() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    private class SpaceTransformationAdapter
    implements Transformable,
    PropertyChangeListener {
        private Space space;
        private Set<Transformable.TransformationChangedListener> listener = new HashSet<Transformable.TransformationChangedListener>();

        public SpaceTransformationAdapter(Space sp) {
            this.space = sp;
            this.space.addPropertyChangeListener("transformation", this);
        }

        public void reNewWith(Space newSpace) {
            if (this.space == newSpace) {
                return;
            }
            this.space.removePropertyChangeListener("transformation", this);
            this.space = newSpace;
            this.space.addPropertyChangeListener("transformation", this);
            for (Transformable.TransformationChangedListener l : this.listener) {
                l.hasChanged(this);
            }
        }

        @Override
        public Transformation getTransformation() {
            return this.space.getTransformation();
        }

        @Override
        public void setTransformation(Transformation t) {
            this.space.setTransformation(t);
        }

        @Override
        public void addChangeListener(Transformable.TransformationChangedListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeChangeListener(Transformable.TransformationChangedListener l) {
            this.listener.remove(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop;
            if (evt.getSource() == this.space && (prop = evt.getPropertyName()).endsWith("transformation")) {
                for (Transformable.TransformationChangedListener l : this.listener) {
                    l.hasChanged(this);
                }
            }
        }

        @Override
        public void setTiltAngle(float angleRad) {
        }

        @Override
        public float getTiltAngle() {
            return 0.0f;
        }
    }

    public class Compass {
        private Quaternion rotation = new Quaternion();
        private Set<CompassListener> listener = new HashSet<CompassListener>();
        private NamedAngle north;

        public Compass(NamedAngle north) {
            this.setNorthHeading(north.getAngleInDegrees());
            this.north = north;
            north.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    Compass.this.setNorthHeading(((Float)e.getNewValue()).floatValue());
                }
            });
        }

        public NamedAngle getAngle() {
            return this.north;
        }

        private void setNorthHeading(float angleDeg) {
            this.rotation.fromAngleAxis((float)Math.PI / 180 * angleDeg, Vector3f.UNIT_Y);
            for (CompassListener l : this.listener) {
                l.rotationHasChanged(this, this.rotation);
            }
        }

        public void addListener(CompassListener l) {
            this.listener.add(l);
        }

        public Quaternion getRotation() {
            return this.rotation;
        }
    }

    public class CameraAdapter
    implements PropertyChangeListener {
        private Space followedspace;
        private Transformable cameraRig;
        private ParallaxEffect currentEffect;

        public CameraAdapter(Transformable cameraRig) {
            this.cameraRig = cameraRig;
            Hyve.this.tiltAngle.addPropertyChangeListener(this);
        }

        public void disConnectFromSpace(Space space) {
            if (space == this.followedspace) {
                this.followedspace.removePropertyChangeListener(this);
                this.followedspace = null;
            }
        }

        public void connectToSpace(Space space) {
            if (this.followedspace != null) {
                if (this.followedspace == space) {
                    return;
                }
                this.disConnectFromSpace(space);
            }
            this.followedspace = space;
            this.followedspace.addPropertyChangeListener(this);
            this.cameraRig.setTransformation(space.getTransformation());
        }

        public void setConnectedSpaceTransformation(Transformation t) {
            if (this.followedspace != null) {
                this.followedspace.setTransformation(t);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == Hyve.this.space) {
                String prop = evt.getPropertyName();
                if (prop.endsWith("transformation")) {
                    Transformation t = (Transformation)evt.getNewValue();
                    this.cameraRig.setTransformation(t);
                }
            } else if (evt.getSource() == Hyve.this.tiltAngle) {
                this.cameraRig.setTiltAngle(Hyve.this.tiltAngle.getAngleInDegrees() * ((float)Math.PI / 180));
            }
        }

        public void applyEffect(ParallaxEffect pe) {
            if (this.currentEffect != null) {
                this.currentEffect.destroy();
            }
            this.currentEffect = pe;
            pe.startWithTriggerAndTransformable(Hyve.this.animationtrigger, this.cameraRig);
            System.out.println("applyEffect(" + pe + ")");
        }

        public void cancelEffect(ParallaxEffect pe) {
            if (pe == this.currentEffect && pe != null && this.currentEffect != null) {
                System.out.println("cancelEffect(" + pe + ")");
                this.currentEffect.cancel();
                this.currentEffect = null;
            } else {
                Hyve.this.logger.severe("ParallaxEffect mismatch: " + pe + " / " + this.currentEffect);
            }
        }

        public void destroyEffect(ParallaxEffect pe) {
            if (pe == this.currentEffect && pe != null && this.currentEffect != null) {
                System.out.println("destroyEffect(" + pe + ")");
                this.currentEffect.destroy();
                this.currentEffect = null;
            } else {
                Hyve.this.logger.severe("ParallaxEffect mismatch: " + pe + " / " + this.currentEffect);
            }
        }
    }

    private class SessionSelectablesProvider
    implements SelectableProvider,
    DataModelObserver,
    PropertyChangeListener,
    Selectable.SelectableBoundsObserver {
        private Session session;
        private DrawingArea drawingArea;
        private Map<UUID, Selectable> all = new HashMap<UUID, Selectable>();
        private Map<HyveData, SelectableDecorator> selectableMap = new HashMap<HyveData, SelectableDecorator>();
        private Set<SelectableProvider.SelectableCollectionListener> listeners = new HashSet<SelectableProvider.SelectableCollectionListener>();

        public SessionSelectablesProvider(Session session, DrawingArea da) {
            this.drawingArea = da;
            this.drawingArea.addPropertyChangeListener(this);
            this.setSession(session);
        }

        @Override
        public Selectable get(UUID id) {
            return this.all.get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Selectable> getAll() {
            HashSet<Selectable> copy;
            Map<UUID, Selectable> map = this.all;
            synchronized (map) {
                copy = new HashSet<Selectable>(this.all.values());
            }
            return Collections.unmodifiableSet(copy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Selectable> getAllCurrentlySelectable() {
            HashSet<Selectable> copy = new HashSet<Selectable>();
            Map<UUID, Selectable> map = this.all;
            synchronized (map) {
                for (Selectable x : this.all.values()) {
                    if (!x.isCurrentlySelectable().booleanValue()) continue;
                    copy.add(x);
                }
            }
            return Collections.unmodifiableSet(copy);
        }

        public void setSession(Session session) {
            if (this.session != session) {
                Session old = this.session;
                this.sessionHasChanged(old, session);
            }
        }

        private void sessionHasChanged(Session old, Session newSession) {
            this.session = newSession;
            if (old != null) {
                old.removeObserver(this);
            }
            for (Stroke stroke : this.session.getAllStrokes()) {
                this.onDataAdded(stroke.getKey(), stroke);
            }
            for (Node node : this.session.getAllAssets()) {
                this.onDataAdded(node.getKey(), node);
            }
            this.session.addObserver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSelectableForHyveData(SelectableDecorator s, HyveData data) {
            this.selectableMap.put(data, s);
            s.addSelectableBoundsObserver(this);
            Map<UUID, Selectable> map = this.all;
            synchronized (map) {
                this.all.put(s.getId(), s);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeSelectableOfHyveData(HyveData data) {
            SelectableDecorator s = this.selectableMap.remove(data);
            if (s != null) {
                s.removeSelectableBoundsObserver(this);
                s.destroy();
                Map<UUID, Selectable> map = this.all;
                synchronized (map) {
                    this.all.remove(s.getId());
                }
            }
        }

        @Override
        public void onDataAdded(DataModelKey key, HyveData data) {
            if (data instanceof Stroke) {
                StrokeSelectable ss = new StrokeSelectable((Stroke)data);
                this.addSelectableForHyveData(ss, data);
            } else if (data instanceof Asset) {
                Asset asset = (Asset)data;
                if (asset.getIsSelectable()) {
                    AssetSelectable as = new AssetSelectable(asset);
                    this.addSelectableForHyveData(as, data);
                }
            } else if (data instanceof Selection) {
                // empty if block
            }
        }

        @Override
        public void onDataRemoved(DataModelKey key, HyveData data) {
            this.removeSelectableOfHyveData(data);
            if (data instanceof Selection) {
                // empty if block
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getSource() == this.drawingArea && pce.getPropertyName().endsWith("transformation")) {
                Transformation t = (Transformation)pce.getNewValue();
                for (SelectableProvider.SelectableCollectionListener selectableCollectionListener : this.listeners) {
                }
            }
        }

        @Override
        public void addSelectableCollectionListener(SelectableProvider.SelectableCollectionListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeSelectableCollectionListener(SelectableProvider.SelectableCollectionListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void onBoundsHaveChanged(Selectable s) {
            for (SelectableProvider.SelectableCollectionListener selectableCollectionListener : this.listeners) {
            }
        }

        @Override
        public Selection createNewSelection(UUID creator) {
            Selection s = new Selection(UUID.randomUUID(), creator);
            try {
                this.session.add(s);
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
            return s;
        }

        @Override
        public void removeSelection(Selection s) {
            this.session.remove(s);
        }
    }

    public class DrawingAreaStrokeCreationAdapter
    implements StrokeCreationAdapter {
        private DrawingArea drawingArea;
        private Session session;
        private Map<UUID, Stroke> currentStrokes = new HashMap<UUID, Stroke>();
        private Ink currentInk = new Ink(ColorRGBA.Yellow, Ink.Style.LINE, Float.valueOf(2.0f), Float.valueOf(3.0f));
        private CommandHistory cmdHistory;
        private Map<UUID, DrawingAreaMovementStrokeObserver> movementSketchingObservers = new HashMap<UUID, DrawingAreaMovementStrokeObserver>();

        public DrawingAreaStrokeCreationAdapter(DrawingArea drawingArea, Session session) {
            this.drawingArea = drawingArea;
            this.setSession(session);
        }

        public CommandHistory getHistory() {
            return this.cmdHistory;
        }

        @Override
        public void setInk(Ink newInk) {
            this.currentInk = newInk;
        }

        private void print(String txt) {
            System.out.println(txt);
        }

        @Override
        public void create(UUID id) {
            Transformation dat = this.drawingArea.getTransformation();
            this.print("DrawingArea: " + dat.toString());
            Transformation t = new Transformation(dat.getPosition(), dat.getRotation());
            this.print("Stroke: " + t.toString());
            Stroke current = new Stroke(id, this.currentInk, t);
            this.currentStrokes.put(id, current);
            this.drawingArea.setCursorVisibility(true);
            DrawingAreaMovementStrokeObserver obs = new DrawingAreaMovementStrokeObserver(current, this.drawingArea);
            this.movementSketchingObservers.put(id, obs);
            if (this.session != null) {
                CommandExecutor ce = CommandExecutorHelper.createStrokeCreationExecutor(this.session, current);
                StrokeCreationCommand cmd = new StrokeCreationCommand(current.getId(), ce);
                cmd.execute();
                this.addStrokeCreationToHistory(cmd);
            } else {
                Hyve.this.logger.severe("Cannot create Stroke without Session!");
            }
        }

        private void addStrokeCreationToHistory(StrokeCreationCommand cmd) {
            if (this.cmdHistory == null) {
                return;
            }
            this.cmdHistory.add_AndExecuteIfNotYetExecuted(cmd);
        }

        @Override
        public void feed(UUID strokeid, StrokePoint p) {
            this.drawingArea.setCursorPosition(p.getPoint());
            Vector3f cwp = this.drawingArea.getCursorWorldPosition();
            Stroke current = this.currentStrokes.get(strokeid);
            if (current != null) {
                DrawingAreaMovementStrokeObserver obs = this.movementSketchingObservers.get(strokeid);
                if (obs != null) {
                    obs.addStrokePointOnWorldPosition(p, cwp);
                }
            } else {
                Hyve.this.logger.severe("unable to feed Stroke " + strokeid.toString());
            }
        }

        @Override
        public void feed(UUID strokeid, float x, float y) {
            this.feed(strokeid, new StrokePoint(new Vector2f(x, y)));
        }

        @Override
        public void finish(UUID strokeid) {
            Stroke current = this.currentStrokes.remove(strokeid);
            if (current != null) {
                Hyve.this.logger.info("finished " + current.getId().toString() + " with " + current.getNumberOfPoints() + "Points");
            } else {
                Hyve.this.logger.severe("unable to finish Stroke " + strokeid.toString());
            }
            DrawingAreaMovementStrokeObserver obs = this.movementSketchingObservers.remove(strokeid);
            if (obs != null) {
                this.drawingArea.removePropertyChangeListener("transformation", obs);
            } else {
                Hyve.this.logger.severe("did no remove movementSketchingObserver as a drawingarea - propertylistener for strokeid=" + strokeid.toString());
            }
            this.drawingArea.setCursorVisibility(false);
        }

        @Override
        public void setSession(Session session) {
            this.session = session;
            if (session != null) {
                UUID daid = this.drawingArea.getId();
                this.cmdHistory = Hyve.this.getCommandHistoryForId(daid);
            }
        }

        @Override
        public Ink getInk() {
            return this.currentInk;
        }

        public void setDrawingArea(DrawingArea drawingArea) {
            this.drawingArea = drawingArea;
        }

        @Override
        public void setCursorTo(Vector2f point, boolean showCursor) {
            this.drawingArea.setCursorPosition(point);
            this.drawingArea.setCursorVisibility(showCursor);
        }
    }

    static interface IOrbitingController {
        public Object getInputSource();

        public void feed(OrbitMessage var1);
    }

    private class PanoramicModeOrbitingController
    implements IOrbitingController {
        private OrbitMessage latestMessage;
        private Transformable orbiter;
        private Transformation initialOrbiterTransformation;
        private Vector3f orbitPlaneNormal;
        private Object inputsource;

        public PanoramicModeOrbitingController(Object inputsource, Transformable orbiter) {
            this.inputsource = inputsource;
            this.orbiter = orbiter;
            this.initialOrbiterTransformation = this.orbiter.getTransformation().copy();
            ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(this.initialOrbiterTransformation.getRotation());
            this.orbitPlaneNormal = axes.Y;
        }

        @Override
        public Object getInputSource() {
            return this.inputsource;
        }

        private void performupdate() {
            Quaternion r = new Quaternion();
            r = r.fromAngleAxis(this.latestMessage.getAngleRad(), this.orbitPlaneNormal);
            Quaternion newOrbiterRotation = r.mult(this.initialOrbiterTransformation.getRotation());
            this.orbiter.setTransformation(new Transformation(this.initialOrbiterTransformation.getPosition(), newOrbiterRotation));
        }

        @Override
        public void feed(OrbitMessage orbitMsg) {
            if (orbitMsg.hasDifferentValuesComparedTo(this.latestMessage)) {
                this.latestMessage = orbitMsg;
                this.performupdate();
            }
        }
    }

    private class OrbitingController
    implements IOrbitingController {
        private OrbitMessage latestMessage;
        private Transformable orbiter;
        private Vector3f initialTargetPosition;
        private Transformation initialOrbiterTransformation;
        private Vector3f orbitPlaneNormal;
        private Vector3f initialTargetToOrbiterVector;
        private Vector3f heightVector;
        private Vector3f initialTargetToProjectedOrbiterPositionInPlane;
        private Object inputsource;

        public OrbitingController(Object inputsource, Vector3f target, Transformable orbiter, Vector3f orbitPlaneNormal) {
            this.inputsource = inputsource;
            this.initialTargetPosition = target;
            this.orbiter = orbiter;
            this.initialOrbiterTransformation = this.orbiter.getTransformation().copy();
            this.initialTargetToOrbiterVector = this.initialOrbiterTransformation.getPosition().subtract(this.initialTargetPosition);
            this.orbitPlaneNormal = orbitPlaneNormal.normalize();
            this.heightVector = this.orbitPlaneNormal.project(this.initialTargetToOrbiterVector);
            this.initialTargetToProjectedOrbiterPositionInPlane = this.initialOrbiterTransformation.getPosition().subtract(this.heightVector).subtract(target);
        }

        @Override
        public Object getInputSource() {
            return this.inputsource;
        }

        private void performupdate() {
            Quaternion r = new Quaternion();
            r = r.fromAngleAxis(this.latestMessage.getAngleRad(), this.orbitPlaneNormal);
            Vector3f rotatedInPlane = r.mult(this.initialTargetToProjectedOrbiterPositionInPlane);
            Vector3f orbiterPosition = this.initialTargetPosition.add(rotatedInPlane).add(this.heightVector);
            Quaternion newOrbiterRotation = r.mult(this.initialOrbiterTransformation.getRotation());
            this.orbiter.setTransformation(new Transformation(orbiterPosition, newOrbiterRotation));
        }

        @Override
        public void feed(OrbitMessage orbitMsg) {
            if (orbitMsg.hasDifferentValuesComparedTo(this.latestMessage)) {
                this.latestMessage = orbitMsg;
                this.performupdate();
            }
        }
    }

    public class DrawingAreaMovementStrokeObserver
    implements PropertyChangeListener {
        private StrokePoint latest = new StrokePoint(Vector2f.ZERO);
        private Stroke stroke;
        private Transformation strokeWorldTransformation;
        private Quaternion inverseStrokeWorldRotation;
        private DrawingArea drawingArea;

        public DrawingAreaMovementStrokeObserver(Stroke stroke, DrawingArea drawingArea) {
            this.stroke = stroke;
            this.drawingArea = drawingArea;
            this.drawingArea.addPropertyChangeListener("transformation", this);
            this.strokeWorldTransformation = stroke.getWorldTransformation().copy();
            this.inverseStrokeWorldRotation = this.strokeWorldTransformation.getRotation().inverse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.endsWith("transformation")) {
                Vector3f cwp = this.drawingArea.getCursorWorldPosition();
                StrokePoint strokePoint = this.latest;
                synchronized (strokePoint) {
                    this.addStrokePointOnWorldPosition(this.latest, cwp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStrokePoint(StrokePoint p) {
            StrokePoint strokePoint = this.latest;
            synchronized (strokePoint) {
                this.latest = p;
            }
        }

        public void addStrokePointOnWorldPosition(StrokePoint p, Vector3f cwp) {
            this.setStrokePoint(p);
            Vector3f local = this.calcLocalPosition(cwp);
            StrokePoint sp = new StrokePoint(p, local);
            Vector3f normal = MathUtils.getQuaternionAxes((Quaternion)this.drawingArea.getTransformation().getRotation()).Z;
            normal = this.inverseStrokeWorldRotation.mult(normal).normalizeLocal();
            sp.setNormal(normal);
            this.stroke.addStrokePoint(sp);
        }

        private Vector3f calcLocalPosition(Vector3f worldposition) {
            Vector3f p = worldposition.subtract(this.strokeWorldTransformation.getPosition());
            p = this.inverseStrokeWorldRotation.mult(p);
            return p;
        }
    }

    private class DADirectionObserver
    implements DrawingAreaDirectionAdapter,
    PropertyChangeListener {
        private DrawingArea da;
        private Set<DrawingAreaDirectionAdapter.DirectionObserver> oberver = new HashSet<DrawingAreaDirectionAdapter.DirectionObserver>();

        public DADirectionObserver(DrawingArea da) {
            this.da = da;
        }

        @Override
        public Vector3f getDirection() {
            Vector3f dir = MathUtils.getQuaternionAxes((Quaternion)this.da.getTransformation().getRotation()).Z.negate();
            return dir;
        }

        @Override
        public void addObserver(DrawingAreaDirectionAdapter.DirectionObserver o) {
            if (this.oberver.isEmpty()) {
                this.da.addPropertyChangeListener("transformation", this);
            }
            this.oberver.add(o);
        }

        @Override
        public void removeObserver(DrawingAreaDirectionAdapter.DirectionObserver o) {
            this.oberver.remove(o);
            if (this.oberver.isEmpty()) {
                this.da.removePropertyChangeListener("transformation", this);
            }
        }

        @Override
        public void destroy() {
            this.da.removePropertyChangeListener("transformation", this);
            this.oberver.clear();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop;
            if (this.da == evt.getSource() && (prop = evt.getPropertyName()).endsWith("transformation")) {
                Transformation t = (Transformation)evt.getNewValue();
                Vector3f dir = MathUtils.getQuaternionAxes((Quaternion)t.getRotation()).Z.negate();
                for (DrawingAreaDirectionAdapter.DirectionObserver o : this.oberver) {
                    o.onDirectionChange(dir);
                }
            }
        }
    }

    public static interface CompassListener {
        public void rotationHasChanged(Compass var1, Quaternion var2);
    }
}

