/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.HisSceneStorage;
import com.hybridlab.hyve3d.LocalFileScene;
import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.BackGround;
import com.hybridlab.hyve3d.data.domainobjects.Sky;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.data.valueobjects.Ink;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.DXFExportDocument;
import com.hybridlab.hyve3d.files.His3dSceneXMLDocument;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.files.ObjInformation;
import com.hybridlab.hyve3d.files.STLExportDocument;
import com.hybridlab.hyve3d.files.STLExportParameter;
import com.hybridlab.hyve3d.hyve.FileSessionLogger;
import com.hybridlab.hyve3d.hyve.FileTypes;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.hyve.HyveSessionLogger;
import com.hybridlab.hyve3d.hyve.SatelliteCenter;
import com.hybridlab.hyve3d.hyve.SessionVisualizer;
import com.hybridlab.hyve3d.hyve.StrokeCreationAdapter;
import com.hybridlab.hyve3d.network.interconnection.SessionDescriptor;
import com.hybridlab.hyve3d.network.interconnection.SessionRepository;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.momchil_atanasov.data.front.error.WFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class HyveApplication {
    private SessionRepository sessionRepo;
    private HyveNetworking networking;
    private Hyve localhyve;
    private UUID localSessionId;
    private Set<SessionVisualizer> sessionVisualizer = new HashSet<SessionVisualizer>();
    private Logger logger = Logger.getLogger(HyveApplication.class.getSimpleName());
    private MyRandomColoredStrokeCreationAdapter testStrokeCreator = new MyRandomColoredStrokeCreationAdapter();
    private SatelliteCenter satCenter;
    private File hyveAssetFolder;

    public HyveApplication(UUID localSessionId) {
        this.localSessionId = localSessionId;
    }

    public static void showWarmingMessageInUI(String s) {
        throw new RuntimeException(s);
    }

    public Hyve getLocalHyve() {
        return this.localhyve;
    }

    public void setLocalHyve(Hyve localhyve) {
        this.localhyve = localhyve;
    }

    public boolean isSessionLogEnabled() {
        HyveSessionLogger log = this.localhyve.getSessionlogger();
        return log != null ? log.isEnabled() : false;
    }

    public void enableSessionLogging(File folder) {
        FileSessionLogger sessionlog = new FileSessionLogger(folder);
        this.localhyve.connectSessionLogger(sessionlog);
    }

    public void disableSessionLogging() {
        this.localhyve.connectSessionLogger(null);
    }

    public SatelliteCenter getSatelliteCenter() {
        return this.satCenter;
    }

    public void setSatelliteCenter(SatelliteCenter satCenter) {
        this.satCenter = satCenter;
        this.satCenter.registerListener(this.localhyve);
    }

    public HyveNetworking getNetworking() {
        return this.networking;
    }

    public void setNetworkingController(HyveNetworking net) {
        this.networking = net;
    }

    public void setSessionRepository(SessionRepository sessionRepo) {
        this.sessionRepo = sessionRepo;
    }

    @Deprecated
    public void joinSession(UUID id) {
        this.letHyveJoinSession();
    }

    public void visualizeLocalSession() {
        UUID id = this.localSessionId;
        this.showSession(id);
    }

    public void visualizeSession(UUID id) {
        this.showSession(id);
    }

    public void synchSession(UUID selectedSessionId) {
        try {
            this.getNetworking().synchWithRemoteSession(selectedSessionId);
        }
        catch (Exception e) {
            HyveApplication.showWarmingMessageInUI(e.getMessage());
        }
    }

    public UUID getLocalSessionId() {
        return this.localSessionId;
    }

    public List<UUID> getShowableSessions() {
        ArrayList<UUID> sessionids = new ArrayList<UUID>();
        List<SessionDescriptor> available = this.sessionRepo.getKnownAvailableSessions();
        for (SessionDescriptor sd : available) {
            sessionids.add(sd.sessionId);
        }
        return sessionids;
    }

    public SessionRepository getSessionRepository() {
        return this.sessionRepo;
    }

    public void showSession(UUID sessionId) {
        if (!this.sessionVisualizer.isEmpty()) {
            Session session = this.sessionRepo.getSession(sessionId);
            for (SessionVisualizer sv : this.sessionVisualizer) {
                sv.visualize(session);
            }
            this.testStrokeCreator.setSession(session);
        } else {
            HyveApplication.showWarmingMessageInUI("unable to show Session because no SessionVisualizer in App!");
        }
    }

    public void addSessionVisualizer(SessionVisualizer visualizer) {
        this.sessionVisualizer.add(visualizer);
    }

    public void letHyveJoinSession() {
        UUID id = this.sessionVisualizer.iterator().next().getIdOfCurrentShownSession();
        Session session = this.sessionRepo.getSession(id);
        if (session != null) {
            this.localhyve.joinSession(session);
        }
    }

    public StrokeCreationAdapter getTestStrokeCreationAdapter() {
        return this.testStrokeCreator;
    }

    public Hyve.CameraAdapter setCameraTransformer(Transformable cameraRig) {
        if (this.localhyve != null) {
            return this.localhyve.connectCamera(cameraRig);
        }
        return null;
    }

    public String toggleBackGround(String string) {
        HashMap<String, String> backgrounds = new HashMap<String, String>();
        backgrounds.put("Cube forest", "Cubes");
        backgrounds.put("Training geometries", "Test");
        Session s = this.localhyve.currentSession();
        if (s != null) {
            BackGround bg = s.getBackGround();
            if (bg.getElements().contains(backgrounds.get(string))) {
                bg.removeElement((String)backgrounds.get(string));
                return "show " + string;
            }
            bg.addElement((String)backgrounds.get(string));
            return "hide " + string;
        }
        return "show " + string;
    }

    public void saveFile(LocalFileScene destination) {
        try {
            String documentName;
            File f;
            String dirname = destination.directory;
            File theDir = new File(dirname);
            if (!theDir.exists()) {
                theDir.mkdir();
            }
            if ((f = new File(theDir, documentName = destination.filename)).exists()) {
                f.delete();
            }
            switch (destination.getTypeFromExtension()) {
                case DXF: {
                    DXFExportDocument dxfdoc = new DXFExportDocument();
                    dxfdoc.transferSessionContentIntoDocument(this.localhyve.currentSession());
                    dxfdoc.save(f);
                    break;
                }
                case HYVE: {
                    His3dSceneXMLDocument doc = new His3dSceneXMLDocument(f);
                    doc.saveSessionContentsIntoDocument(this.localhyve.currentSession());
                    doc.save();
                    break;
                }
                case STL: {
                    STLExportParameter parameter = new STLExportParameter();
                    STLExportDocument stlDoc = new STLExportDocument(parameter);
                    stlDoc.exportStrokesIntoDocument(this.localhyve.currentSession());
                    stlDoc.save(f);
                    break;
                }
                default: {
                    HyveApplication.showWarmingMessageInUI("Unsupported file type!");
                    break;
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            HyveApplication.showWarmingMessageInUI(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            HyveApplication.showWarmingMessageInUI(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            HyveApplication.showWarmingMessageInUI(e.getMessage());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            HyveApplication.showWarmingMessageInUI(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            HyveApplication.showWarmingMessageInUI(e.getMessage());
        }
    }

    public void openFile(LocalFileScene storage, FileTypes type) {
        this.localhyve.eraseAllInSession();
        this.importFile(storage, type, ImportOptions.createDefaultOptions().toImportOptionsString());
    }

    public void importFile(HisSceneStorage storage, FileTypes type, String importOptions) {
        if (storage instanceof LocalFileScene) {
            LocalFileScene sceneToLoad = (LocalFileScene)storage;
            Object pathEndingWithDelimiter = sceneToLoad.directory;
            String delimiter = "/";
            if (!((String)pathEndingWithDelimiter).endsWith(delimiter)) {
                pathEndingWithDelimiter = (String)pathEndingWithDelimiter + delimiter;
            }
            switch (type) {
                case HYVE: {
                    this.importHyveFile(sceneToLoad.directory, sceneToLoad.filename);
                    break;
                }
                case FBX: {
                    this.importFBXFromLocalFile((String)pathEndingWithDelimiter, sceneToLoad.filename, type, importOptions);
                    break;
                }
                case OBJ: 
                case OBJ_ZIPPED: {
                    this.importObjFromLocalFile((String)pathEndingWithDelimiter, sceneToLoad.filename, type, importOptions);
                    break;
                }
                case PLY_POINTCLOUD: {
                    this.importPointCloudFromLocalFile((String)pathEndingWithDelimiter, sceneToLoad.filename, type, importOptions);
                    break;
                }
                case OGRE_ZIPPED: {
                    this.importOgreZip((String)pathEndingWithDelimiter, sceneToLoad.filename, importOptions);
                    break;
                }
                case DDS_SKY: {
                    this.importDDSSky((String)pathEndingWithDelimiter, sceneToLoad.filename, type, importOptions);
                    break;
                }
            }
        }
    }

    private void importDDSSky(String path, String filename, FileTypes type, String importOptions) {
        Session session = this.localhyve.currentSession();
        if (session != null) {
            for (Sky sky : session.getAllSkys()) {
                session.remove(sky);
            }
            UUID testskyid = UUID.randomUUID();
            UUID localID = this.getLocalHyve().getLocalSpace().getId();
            Sky testSky = new Sky(testskyid, Sky.SourceType.DDS, localID, Asset.Type.Sky, path, filename, importOptions);
            try {
                session.add(testSky);
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
        }
    }

    private void importPointCloudFromLocalFile(String path, String filename, FileTypes type, String importOptions) {
        Session session = this.localhyve.currentSession();
        if (session != null) {
            Asset.Type t = null;
            switch (type) {
                case PLY_POINTCLOUD: {
                    t = Asset.Type.PointCloud;
                    break;
                }
            }
            if (t != null) {
                Asset a = new Asset(UUID.randomUUID(), this.localhyve.getHyveId(), t, path, filename, importOptions);
                switch (a.getImportOptionsInstance().getPlacement()) {
                    case VIEW_FRONT: {
                        Transformation viewFrontTransformation = this.getLocalHyve().calculateViewFrontAssetPlacement();
                        a.setTransformation(viewFrontTransformation);
                        break;
                    }
                }
                try {
                    session.add(a);
                }
                catch (ConcurrentAddException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void importObjFromLocalFile(String path, String filename, FileTypes type, String importOptions) {
        Session session = this.localhyve.currentSession();
        if (session != null) {
            Asset.Type t = null;
            List<String> dfl = null;
            switch (type) {
                case OBJ: {
                    t = Asset.Type.OBJ;
                    try {
                        dfl = ObjInformation.getDependentFiles(new File(path, filename));
                    }
                    catch (WFException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                case OBJ_ZIPPED: {
                    t = Asset.Type.OBJ_ZIPPED;
                    break;
                }
            }
            if (t != null) {
                Asset a = new Asset(UUID.randomUUID(), this.localhyve.getHyveId(), t, path, filename, importOptions);
                if (dfl != null) {
                    a.setDependentFiles(dfl);
                }
                switch (a.getImportOptionsInstance().getPlacement()) {
                    case VIEW_FRONT: {
                        Transformation viewFrontTransformation = this.getLocalHyve().calculateViewFrontAssetPlacement();
                        a.setTransformation(viewFrontTransformation);
                        break;
                    }
                }
                try {
                    session.add(a);
                }
                catch (ConcurrentAddException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void importFBXFromLocalFile(String path, String filename, FileTypes type, String importOptions) {
        Session session = this.localhyve.currentSession();
        if (session != null) {
            Asset.Type t = null;
            Object dfl = null;
            switch (type) {
                case FBX: {
                    t = Asset.Type.FBX;
                }
            }
            if (t != null) {
                Asset a = new Asset(UUID.randomUUID(), this.localhyve.getHyveId(), t, path, filename, importOptions);
                switch (a.getImportOptionsInstance().getPlacement()) {
                    case VIEW_FRONT: {
                        Transformation viewFrontTransformation = this.getLocalHyve().calculateViewFrontAssetPlacement();
                        a.setTransformation(viewFrontTransformation);
                        break;
                    }
                }
                try {
                    session.add(a);
                }
                catch (ConcurrentAddException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void importOgreZip(String path, String file, String importOptions) {
        Session session = this.localhyve.currentSession();
        if (session != null) {
            Asset a = new Asset(UUID.randomUUID(), this.localhyve.getHyveId(), Asset.Type.OgreZip, path, file, importOptions);
            switch (a.getImportOptionsInstance().getPlacement()) {
                case VIEW_FRONT: {
                    Transformation viewFrontTransformation = this.getLocalHyve().calculateViewFrontAssetPlacement();
                    a.setTransformation(viewFrontTransformation);
                    break;
                }
            }
            try {
                session.add(a);
            }
            catch (ConcurrentAddException e) {
                e.printStackTrace();
            }
        }
    }

    private void importHyveFile(String directory, String fileName) {
        System.out.println("importHyveFile(directory='" + directory + "', filename='" + fileName + "')");
        try {
            Session session = this.localhyve.currentSession();
            if (session == null) {
                return;
            }
            String dirname = directory;
            File theDir = new File(dirname);
            String documentName = fileName;
            File f = new File(theDir, documentName);
            if (f.isDirectory()) {
                System.out.println("... a directory has been chosen: " + f.getAbsolutePath());
                File actualHyveFile = new File(f, new File("Contents", documentName).getPath());
                System.out.println("... ... using the actual file now: " + actualHyveFile.getAbsolutePath());
                His3dSceneXMLDocument doc = new His3dSceneXMLDocument(actualHyveFile);
                doc.loadDocumentIntoSession(session);
            } else if (!this.isHyveFileInBundleFolder(f)) {
                His3dSceneXMLDocument doc = new His3dSceneXMLDocument(f);
                doc.loadDocumentIntoSession(session);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isHyveFileInBundleFolder(File f) {
        return false;
    }

    public void setSynchronizeHyvePositions(boolean b) {
        this.localhyve.setSynchronizeHyvePositions(b);
    }

    public void setOrthogonalRenderingEnabled(boolean b) {
        this.localhyve.setOrthogonalRenderingEnabled(b);
    }

    public void eraseAll() {
        this.localhyve.eraseAllInSession();
        System.gc();
    }

    public File getApplicationFolder() {
        File f = new File(".");
        return f;
    }

    public File getHyveAssetFolder() {
        return this.hyveAssetFolder;
    }

    public void setHyveAssetFolder(File hyveAssetFolder) {
        this.hyveAssetFolder = hyveAssetFolder;
    }

    private class MyRandomColoredStrokeCreationAdapter
    implements StrokeCreationAdapter {
        private Session session;
        private Map<UUID, Stroke> currentStrokes = new HashMap<UUID, Stroke>();
        private Ink ink;

        private MyRandomColoredStrokeCreationAdapter() {
        }

        @Override
        public void create(UUID id) {
            Transformation t = new Transformation();
            Stroke current = new Stroke(id, new Ink(ColorRGBA.randomColor(), Ink.Style.LINE), t);
            this.currentStrokes.put(id, current);
            if (this.session != null) {
                try {
                    this.session.add(current);
                }
                catch (ConcurrentAddException e) {
                    HyveApplication.this.logger.severe(e.getMessage());
                }
            }
        }

        @Override
        public void feed(UUID strokeid, float x, float y) {
            this.feed(strokeid, new StrokePoint(new Vector2f(x, y)));
        }

        @Override
        public void finish(UUID strokeid) {
            Stroke current = this.currentStrokes.remove(strokeid);
            if (current != null) {
                HyveApplication.this.logger.info("finished " + current.getId().toString() + " with " + current.getNumberOfPoints() + "Points");
            } else {
                HyveApplication.this.logger.severe("unable to finish Stroke " + strokeid.toString());
            }
        }

        @Override
        public void setSession(Session session) {
            this.session = session;
        }

        @Override
        public void setInk(Ink ink) {
            this.ink = ink;
        }

        @Override
        public void feed(UUID strokeid, StrokePoint p) {
            Stroke current = this.currentStrokes.get(strokeid);
            if (current != null) {
                current.addStrokePoint(p);
            } else {
                HyveApplication.this.logger.severe("unable to feed Stroke " + strokeid.toString());
            }
        }

        @Override
        public Ink getInk() {
            return this.ink;
        }

        @Override
        public void setCursorTo(Vector2f point, boolean showCursor) {
        }
    }
}

