/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.SatelliteObserver;
import com.hybridlab.hyve3d.core.SatelliteStroke2DManager;
import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.StylusPressure;
import com.hybridlab.hyve3d.core.TransformationOptions;
import com.hybridlab.hyve3d.core.commands.Command;
import com.hybridlab.hyve3d.core.commands.CommandChangeMode;
import com.hybridlab.hyve3d.core.commands.CommandChangeModeRequest;
import com.hybridlab.hyve3d.core.commands.CommandClearSatellite2dCanvas;
import com.hybridlab.hyve3d.core.commands.CommandSetBackgroundImage;
import com.hybridlab.hyve3d.core.commands.CommandSetFrameColor;
import com.hybridlab.hyve3d.core.commands.DrawAreaTransformOptionsCommand;
import com.hybridlab.hyve3d.core.commands.SetSatelliteSelectionModeCommand;
import com.hybridlab.hyve3d.core.commands.SimpleStringCommand;
import com.hybridlab.hyve3d.core.commands.UndoRedoCommand;
import com.hybridlab.hyve3d.core.commands.UndoRedoStepsCommand;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.StrokeConverter;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.hyve.Rotations;
import com.hybridlab.hyve3d.hyve.SatelliteCenter;
import com.hybridlab.hyve3d.hyve.SatelliteDrawingAreaAdapter;
import com.hybridlab.hyve3d.hyve.StrokeCreationAdapter;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import com.hybridlab.hyve3d.network.messages.FrameRectDefinitionMessage;
import com.hybridlab.hyve3d.network.messages.Move2DMessage;
import com.hybridlab.hyve3d.network.messages.Move3DMessage;
import com.hybridlab.hyve3d.network.messages.OrbitMessage;
import com.hybridlab.hyve3d.network.messages.PinchPointsMessage;
import com.hybridlab.hyve3d.network.messages.Pointing2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.hyve3d.network.messages.TransformMessage;
import com.hybridlab.hyve3d.network.messages.ZoomMessage;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConfiguration;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSession;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IpadSatellite
implements Satellite {
    private String version = "unknown";
    private String deviceId;
    private Satellite.SatelliteState state = Satellite.SatelliteState.PAUSED;
    private Set<SatelliteObserver> observer = new HashSet<SatelliteObserver>();
    private String name = "";
    private SatelliteSession session;
    private Logger logger = Logger.getLogger("IpadSatellite");
    private ColorRGBA regularFrameColor = ColorRGBA.Blue;
    private CommandChangeMode.SatelliteMode currentMode = CommandChangeMode.SatelliteMode.Unkown;
    private SatelliteCenter center;
    private FrameRect zoomReferenceFrameRect = null;
    private FrameRect frameRect = new FrameRect(1.3333334f);
    private TransformationOptions transformOptions = new TransformationOptions();
    private TransformMessage.Source rotationSource = TransformMessage.Source.IPAD;
    private SatelliteClientConfiguration satConfig;
    private boolean shouldReceiveProjectedStrokes = false;
    private UUID currentsid;
    private boolean navigationStridesBegan = false;
    private IpadCalibrator calib;
    private Navigator navigator;
    private final float fastE = (float)Math.E;
    private StrokeCreationAdapter sketcher;
    private List<AbstractHisMessage> messageQueue = new ArrayList<AbstractHisMessage>();
    private boolean trackingEnabled;
    private String trackingId;
    private SatelliteStroke2DManager freshlyDrawnStrokesManager = new SatelliteStroke2DManager(this);
    private SatelliteStroke2DManager projectedStrokesManager = new SatelliteStroke2DManager(this);
    private Transformation transformation = new Transformation();
    private CommandChangeMode.SatelliteMode modeBeforeDisconnect;

    public IpadSatellite(String deviceId, SatelliteCenter center, SatelliteClientConfiguration satConfig, String version) {
        this.version = version;
        if (version.contains("pre A l b e r t i 0 . 3 . 13")) {
            this.shouldReceiveProjectedStrokes = true;
        }
        this.deviceId = deviceId;
        this.center = center;
        this.satConfig = satConfig;
    }

    @Override
    public void setRotationSource(TransformMessage.Source rotationSource) {
        this.rotationSource = rotationSource;
    }

    @Override
    public void processMessage(SatelliteSession satelliteSession, AbstractHisMessage message) {
        this.logger.info(message.toString());
    }

    @Override
    public boolean shouldReceiveProjectedStrokes() {
        return this.shouldReceiveProjectedStrokes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionOpened(SatelliteSession session) {
        this.session = session;
        this.session.setSessionHandlingSatelliteInstanceOnServer(this);
        List<AbstractHisMessage> list = this.messageQueue;
        synchronized (list) {
            for (AbstractHisMessage m : this.messageQueue) {
                this.logger.info("sending message delayed from messagequeue: \n" + m.toString());
                this.sendMessage(m);
            }
            this.messageQueue.clear();
        }
        this.setFrame(this.getFrame());
        this.setRegularFrameColor(this.getRegularFrameColor());
        this.setSatelliteState(Satellite.SatelliteState.ACTIVE);
        this.setCurrentMode(CommandChangeMode.SatelliteMode.Drawing);
        if (this.sketcher != null) {
            StrokeInk i = StrokeConverter.InkToStrokeInk(this.sketcher.getInk());
            StrokeInkMessage inkMsg = StrokeInkMessage.fromStrokeInk(i);
            this.sendMessage(inkMsg);
        }
        for (SatelliteObserver o : this.observer) {
            o.onBeginObserving(this);
        }
    }

    @Override
    public void onSessionClosed(SatelliteSession session) {
        if (session == this.session) {
            this.setSatelliteState(Satellite.SatelliteState.PAUSED);
            this.session = null;
        }
    }

    private void setSatelliteState(Satellite.SatelliteState newState) {
        if (!this.state.equals((Object)newState)) {
            this.state = newState;
            this.fireChange(SatelliteObserver.Change.STATE);
        }
    }

    @Override
    public void processMessage(TransformMessage message) {
        if (message.getSource().equals((Object)this.rotationSource)) {
            Rotations.setValue(Rotations.RotationIdentifier.iPadRaw, message.getQuaternion());
            Quaternion q = message.getCorrectedQuaternion();
            Rotations.setValue(Rotations.RotationIdentifier.iPad, q);
            this.setRotation(q);
        }
    }

    private void setRotation(Quaternion rotation) {
        if (!this.transformation.getRotation().equals((Object)rotation)) {
            this.transformation.changeRotationTo(rotation);
            this.fireChange(SatelliteObserver.Change.TRANSFORMATION);
        }
    }

    @Override
    public void processMessage(Stroke2DTransmissionPartMessage message) {
        if (this.sketcher == null) {
            this.logger.severe("no sketcher in " + this + " can handle " + message.toString());
            return;
        }
        UUID sid = message.getStrokeId().getUUID();
        switch (message.getType()) {
            case BEGIN: {
                if (!sid.equals(this.currentsid) && this.currentsid != null) {
                    this.sketcher.finish(this.currentsid);
                    this.currentsid = null;
                }
                this.currentsid = sid;
                if (message.getInk() != null) {
                    this.sketcher.setInk(StrokeConverter.StrokeInkToInk(message.getInk()));
                }
                this.sketcher.create(sid);
                Vector2f[] points = message.getPoints();
                short[] pressures = message.getPressures();
                for (int i = 0; i < points.length; ++i) {
                    StrokePoint p = new StrokePoint(this.convertAxes(points[i]), new StylusPressure(pressures[i]));
                    this.sketcher.feed(sid, p);
                }
                break;
            }
            case ADD: {
                Vector2f[] points = message.getPoints();
                short[] pressures = message.getPressures();
                for (int i = 0; i < points.length; ++i) {
                    StrokePoint p = new StrokePoint(this.convertAxes(points[i]), new StylusPressure(pressures[i]));
                    this.sketcher.feed(sid, p);
                }
                break;
            }
            case END: {
                this.sketcher.finish(sid);
                break;
            }
            case COMPLETE: {
                this.logger.severe("no support for COMPLETE strokes in " + this);
            }
        }
    }

    @Override
    public void processMessage(Pointing2DTransmissionPartMessage message) {
        Vector2f[] points = message.getPoints();
        if (points.length > 0) {
            Vector2f lastpoint = points[points.length - 1];
            this.sketcher.setCursorTo(this.convertAxes(lastpoint), switch (message.getType()) {
                case Pointing2DTransmissionPartMessage.SubType.ADD, Pointing2DTransmissionPartMessage.SubType.BEGIN -> true;
                default -> false;
            });
        }
    }

    private Vector2f convertAxes(Vector2f v) {
        return new Vector2f(v.y, -v.x);
    }

    private void beginNavigationStride() {
        if (!this.navigationStridesBegan) {
            this.navigationStridesBegan = true;
        }
    }

    private void endNavigationStride() {
        if (this.navigationStridesBegan) {
            this.navigationStridesBegan = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(Move2DMessage message) {
        block4 : switch (this.currentMode) {
            case IpadCalibration: {
                switch (message.getState()) {
                    case BEGIN: {
                        this.calib = new IpadCalibrator();
                        break block4;
                    }
                    case END: {
                        break block4;
                    }
                    case MOVE: {
                        if (this.calib == null) break block4;
                        this.calib.move(message.getVector());
                        break block4;
                    }
                }
                break;
            }
            case Navigation: {
                Quaternion currentTabletRotation;
                Transformation transformation = this.transformation;
                synchronized (transformation) {
                    currentTabletRotation = this.transformation.getRotation().clone();
                }
                boolean invert = false;
                Vector3f move = this.calculateWalkVector(message, currentTabletRotation, invert);
                switch (message.getState()) {
                    case BEGIN: {
                        if (this.navigator != null) {
                            this.navigator.stop();
                        }
                        this.navigator = new Navigator(System.currentTimeMillis());
                        break;
                    }
                    case END: {
                        if (this.navigator == null) break;
                        this.navigator.inputEnded();
                        break;
                    }
                    case MOVE: {
                        if (this.navigator == null) break;
                        this.navigator.move(move);
                        break;
                    }
                }
                this.beginNavigationStride();
                break;
            }
            case DrawingAreaTransformation: 
            case DrawingAreaTransformationWhileSelection: 
            case SelectionTransformation: {
                Quaternion currentTabletRotation;
                if (!message.getState().equals((Object)Move2DMessage.State.MOVE)) break;
                Transformation invert = this.transformation;
                synchronized (invert) {
                    currentTabletRotation = this.transformation.getRotation().clone();
                }
                boolean invert2 = false;
                Vector3f move = this.calculateMoveVector(message, currentTabletRotation, invert2);
                this.move(move);
                break;
            }
        }
    }

    private Vector3f calculateMoveVector(Move2DMessage message, Quaternion tabletRotation, boolean invertWalking) {
        Vector3f result = new Vector3f();
        if (null != tabletRotation) {
            float moveMultiplicator = 7.0f;
            float daDiagonal = this.frameRect.getDiagonalLength();
            Vector2f offset = message.getVector().mult(moveMultiplicator).divideLocal(daDiagonal);
            Vector3f offset3D = switch (this.transformOptions.transformFilter) {
                case TransformationOptions.TransformationFilter.RXYZ_TGXYZ -> new Vector3f(-1.0f * offset.y, -1.0f * offset.x, 0.0f);
                case TransformationOptions.TransformationFilter.TXY -> new Vector3f(-1.0f * offset.y, -1.0f * offset.x, 0.0f);
                case TransformationOptions.TransformationFilter.TZ -> new Vector3f(0.0f, 0.0f, offset.y);
                default -> Vector3f.ZERO;
            };
            Quaternion correctedTabletRotation = Quaternion.IDENTITY;
            for (SatelliteObserver o : this.observer) {
                if (!(o instanceof SatelliteDrawingAreaAdapter)) continue;
                SatelliteDrawingAreaAdapter daadapter = (SatelliteDrawingAreaAdapter)o;
                correctedTabletRotation = daadapter.satelliteRotationCorrection(tabletRotation);
            }
            Vector3f rotatedOffset3D = correctedTabletRotation.mult(offset3D);
            Transformation spacetrf = this.center.getLocalSpaceTransformation();
            result = rotatedOffset3D = spacetrf.getRotation().inverse().mult(rotatedOffset3D);
            if (invertWalking) {
                result.multLocal(-1.0f);
            }
        }
        return result;
    }

    private Vector3f calculateWalkVector(Move2DMessage message, Quaternion tabletRotation, boolean invertWalking) {
        Vector3f result = new Vector3f();
        if (null != tabletRotation) {
            Vector3f rotatedOffset3D;
            float moveMultiplicator = 7.0f;
            float daDiagonal = this.frameRect.getDiagonalLength();
            Vector2f offset = message.getVector().mult(moveMultiplicator).divideLocal(daDiagonal);
            Vector3f offset3D = new Vector3f(1.0f * offset.y, 1.0f * offset.x, 0.0f);
            result = rotatedOffset3D = tabletRotation.mult(offset3D);
            if (invertWalking) {
                result.multLocal(-1.0f);
            }
        }
        return result;
    }

    @Override
    public void processMessage(Move3DMessage message) {
        Vector3f messageVector = message.getVector();
        switch (message.getType()) {
            case TYPE_RELATIVE_HYDRA_BASED: {
                float base = (float)Math.E;
                float flattenfactor = 0.004f;
                float value = this.frameRect.getDiagonalLength();
                float moveScale_hydra = flattenfactor * FastMath.log((float)(value + 1.0f), (float)base);
                Vector3f move = messageVector.mult(moveScale_hydra);
                this.move(move);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(Vector3f moveAmount) {
        Transformation transformation = this.transformation;
        synchronized (transformation) {
            this.transformation.addLocal(moveAmount);
        }
        if (!moveAmount.equals((Object)Vector3f.ZERO)) {
            this.fireChange(SatelliteObserver.Change.TRANSFORMATION);
        }
    }

    @Override
    public void processMessage(StrokeInkMessage message) {
        if (this.sketcher == null) {
            this.logger.severe("no sketcher in " + this + " can handle " + message.toString());
            return;
        }
        StrokeInk strokeInk = StrokeInkMessage.toStrokeInk(message);
        this.sketcher.setInk(StrokeConverter.StrokeInkToInk(strokeInk));
    }

    @Override
    public void processMessage(ZoomMessage message) {
        this.logger.info(message.toString());
        switch (message.getSt()) {
            case ZOOM_BEGIN: {
                if (this.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Editing)) {
                    this.beginSelectionScale();
                }
                this.zoomReferenceFrameRect = message.getFrameRect();
                this.scaleReferenceFrameRectWithZoomFactorAndSet(message.getZoomValue());
                for (SatelliteObserver o : this.observer) {
                    o.onSatelliteActionNotification(SatelliteObserver.Action.ZoomBegin);
                }
                break;
            }
            case ZOOM_CHANGE: {
                this.scaleReferenceFrameRectWithZoomFactorAndSet(message.getZoomValue());
                break;
            }
            case ZOOM_END: {
                if (this.scaleReferenceFrameRectWithZoomFactorAndSet(message.getZoomValue())) {
                    this.zoomReferenceFrameRect = null;
                }
                if (this.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Editing)) {
                    this.endSelectionScale();
                }
                for (SatelliteObserver o : this.observer) {
                    o.onSatelliteActionNotification(SatelliteObserver.Action.ZoomEnd);
                }
                break;
            }
        }
    }

    private boolean scaleReferenceFrameRectWithZoomFactorAndSet(float zoomvalue) {
        if (null != this.zoomReferenceFrameRect) {
            FrameRect zoomedFrameRect = this.zoomReferenceFrameRect.mult(zoomvalue);
            this.setFrame(zoomedFrameRect);
            return true;
        }
        return false;
    }

    @Override
    public FrameRect getFrame() {
        return this.frameRect;
    }

    @Override
    public void setFrame(FrameRect r) {
        boolean changed = false;
        if (!this.frameRect.equals(r)) {
            changed = true;
        }
        if (changed) {
            this.frameRect = r;
        }
        this.logger.info(this.frameRect.toString());
        this.sendMessage(new FrameRectDefinitionMessage(this.frameRect));
        if (changed) {
            this.fireChange(SatelliteObserver.Change.FRAME);
        }
    }

    @Override
    public void processMessage(FrameRectDefinitionMessage message) {
        this.logger.info(message.toString());
    }

    @Override
    public void processMessage(PinchPointsMessage message) {
        this.logger.info(message.toString());
        switch (message.getPhase()) {
            case INTERACTION_BEGIN: {
                this.endNavigationStride();
                break;
            }
            case INTERACTION_END: {
                break;
            }
            case INTERACTION_ONGOING: {
                break;
            }
            case INTERACTION_RESTART: {
                break;
            }
        }
        OrbitMessage orbitMsg = new OrbitMessage(message);
        for (SatelliteObserver o : this.observer) {
            o.onOrbitingRequest(this, orbitMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(AbstractHisMessage message) {
        if (this.session != null) {
            this.session.sendMessage(message);
        } else {
            List<AbstractHisMessage> list = this.messageQueue;
            synchronized (list) {
                this.messageQueue.add(message);
            }
        }
    }

    @Override
    public String getSatelliteId() {
        return this.deviceId;
    }

    @Override
    public void setName(String satelliteName) {
        if (!this.name.equals(satelliteName)) {
            this.name = satelliteName;
            this.satConfig.setSatelliteName(satelliteName);
            this.fireChange(SatelliteObserver.Change.NAME);
        }
    }

    private void fireChange(SatelliteObserver.Change what) {
        this.fireChange(what, null);
    }

    private void fireChange(SatelliteObserver.Change what, Object oldValue) {
        for (SatelliteObserver o : this.observer) {
            o.onSomethingHasChanged(this, what, oldValue);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void sendFrameColor(ColorRGBA c) {
        CommandMessage msg = new CommandMessage(new CommandSetFrameColor(c));
        this.sendMessage(msg);
    }

    @Override
    public void setTemporaryFrameColor(ColorRGBA c) {
        if (c == null) {
            this.sendFrameColor(this.getRegularFrameColor());
        } else {
            this.sendFrameColor(c);
        }
    }

    @Override
    public void processMessage(CommandMessage message) {
        this.logger.info(message.toString());
        Command cmd = message.getCommand();
        if (this.getSession() == null) {
            this.logger.log(Level.SEVERE, "Satellite has no Session");
            return;
        }
        if (null == cmd.getCommandName()) {
            this.logger.log(Level.SEVERE, "Command is EMPTY");
            return;
        }
        block0 : switch (cmd.getCommandName()) {
            case drawAreaTransformOptions: {
                DrawAreaTransformOptionsCommand daTrfOptionsCommand = (DrawAreaTransformOptionsCommand)cmd;
                this.logger.info(daTrfOptionsCommand.getOptions().toString());
                this.setTransformOptions(daTrfOptionsCommand.getOptions());
                break;
            }
            case changeModeRequest: {
                CommandChangeModeRequest changeModeRequest = (CommandChangeModeRequest)cmd;
                switch (changeModeRequest.getMode()) {
                    case IpadCalibration: 
                    case Navigation: 
                    case DrawingAreaTransformation: 
                    case SelectionTransformation: 
                    case Editing: {
                        this.setCurrentMode(changeModeRequest.getMode());
                        break;
                    }
                    case Drawing: {
                        for (SatelliteObserver o : this.observer) {
                            o.onDrawingModeRequest(this);
                        }
                        break block0;
                    }
                }
                break;
            }
            case simpleString: {
                SimpleStringCommand stringCmd = (SimpleStringCommand)cmd;
                if (stringCmd.getCommandString().startsWith("tiltAngleInDegrees:")) {
                    float angleDeg = Float.parseFloat(stringCmd.getCommandString().substring("tiltAngleInDegrees:".length()));
                    this.setTiltAngle(Float.valueOf(angleDeg));
                    break;
                }
                if (stringCmd.getCommandString().startsWith("tilt:")) {
                    boolean enabled = Boolean.parseBoolean(stringCmd.getCommandString().substring("tilt:".length()));
                    this.setTiltEnabled(enabled);
                    break;
                }
                if (stringCmd.getCommandString().startsWith("drawingAreaName=")) {
                    String newName = stringCmd.getCommandString().substring("drawingAreaName=".length());
                    this.setName(newName);
                    break;
                }
                if (stringCmd.getCommandString().equals("pullDrawAreas")) {
                    this.pullDrawingAreaOfSatelliteInFrontOfHisCamera();
                    break;
                }
                if (stringCmd.getCommandString().equals("COPYPASTE")) {
                    this.copyAndPasteSelection();
                    break;
                }
                if (stringCmd.getCommandString().equals("UNSELECTALL")) {
                    this.unselectAll();
                    break;
                }
                if (stringCmd.getCommandString().equals("DELETESELECTION")) {
                    this.deleteSelection();
                    break;
                }
                if (stringCmd.getCommandString().equals("begin SelectionTransformation")) {
                    this.beginSelectionTransformation();
                    break;
                }
                if (!stringCmd.getCommandString().equals("end SelectionTransformation")) break;
                this.endSelectionTransformation();
                break;
            }
            case setFrameColor: {
                CommandSetFrameColor csfc = (CommandSetFrameColor)cmd;
                ColorRGBA colorRGBA = csfc.getColor();
                this.setRegularFrameColor(colorRGBA);
                break;
            }
            case disconnect: {
                this.orthoShootClear();
                this.onSessionClosed(this.getSession());
                break;
            }
            case setSatelliteSelectionMode: {
                SetSatelliteSelectionModeCommand selectionCmd = (SetSatelliteSelectionModeCommand)cmd;
                selectionCmd.setSatelliteId(this.getSatelliteId());
                for (SatelliteObserver o : this.observer) {
                    o.onSelectionCommandReceived(this, selectionCmd);
                }
                if (selectionCmd.getIsSelectionModeEnabled()) {
                    if (!this.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Editing)) break;
                    this.setCurrentMode(CommandChangeMode.SatelliteMode.DrawingAreaTransformationWhileSelection);
                    break;
                }
                if (!this.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.DrawingAreaTransformationWhileSelection)) break;
                this.setCurrentMode(CommandChangeMode.SatelliteMode.Editing);
                break;
            }
            case undoredo: {
                UndoRedoCommand undoRedoCmd = (UndoRedoCommand)cmd;
                SatelliteObserver.Action a = undoRedoCmd.getSteps() == -1 ? SatelliteObserver.Action.Undo : SatelliteObserver.Action.Redo;
                for (SatelliteObserver o : this.observer) {
                    o.onSatelliteActionNotification(a);
                }
                break;
            }
            default: {
                this.logger.severe("Unkown Command" + cmd.getCommandName());
            }
        }
    }

    private void setTiltAngle(Float angleDeg) {
        for (SatelliteObserver o : this.observer) {
            o.onSomethingHasChanged(this, SatelliteObserver.Change.TILTANGLE, angleDeg);
        }
    }

    private void setTiltEnabled(boolean enabled) {
        for (SatelliteObserver o : this.observer) {
            o.onSatelliteActionNotification(enabled ? SatelliteObserver.Action.TiltBegin : SatelliteObserver.Action.TiltEnd);
        }
    }

    private void setTrackingEnabled(boolean enabled) {
        this.logger.info("setTrackingEnabled = " + (enabled ? "true" : "false"));
        this.trackingEnabled = enabled;
        if (!this.trackingEnabled) {
            this.setRotationSource(TransformMessage.Source.IPAD);
        }
    }

    private void orthoShootClear() {
        this.sendMessage(new CommandMessage(new CommandSetBackgroundImage()));
    }

    private void copyAndPasteSelection() {
        for (SatelliteObserver o : this.observer) {
            o.onSelectionModification(this, SatelliteObserver.SelectionModification.CopyAndPasteSelection);
        }
    }

    private void deleteSelection() {
        for (SatelliteObserver o : this.observer) {
            o.onSelectionModification(this, SatelliteObserver.SelectionModification.DeleteSelection);
        }
    }

    private void unselectAll() {
        for (SatelliteObserver o : this.observer) {
            o.onSelectionModification(this, SatelliteObserver.SelectionModification.UnselectAll);
        }
    }

    private void beginSelectionTransformation() {
        for (SatelliteObserver o : this.observer) {
            o.onSelectionModification(this, SatelliteObserver.SelectionModification.BeginSelectionTransformation);
        }
    }

    private void endSelectionTransformation() {
        for (SatelliteObserver o : this.observer) {
            o.onSelectionModification(this, SatelliteObserver.SelectionModification.EndSelectionTransformation);
        }
    }

    private void beginSelectionScale() {
        for (SatelliteObserver o : this.observer) {
            o.onSelectionModification(this, SatelliteObserver.SelectionModification.BeginSelectionScale);
        }
    }

    private void endSelectionScale() {
        for (SatelliteObserver o : this.observer) {
            o.onSelectionModification(this, SatelliteObserver.SelectionModification.EndSelectionScale);
        }
    }

    private void beginDrawingAreaTransformation() {
        for (SatelliteObserver o : this.observer) {
            o.onSatelliteActionNotification(SatelliteObserver.Action.DrawingAreaTransformationBegin);
        }
    }

    private void endDrawingAreaTransformation() {
        for (SatelliteObserver o : this.observer) {
            o.onSatelliteActionNotification(SatelliteObserver.Action.DrawingAreaTransformationEnd);
        }
    }

    private void pullDrawingAreaOfSatelliteInFrontOfHisCamera() {
        for (SatelliteObserver o : this.observer) {
            o.onPullRequest(this, "DrawingArea");
        }
    }

    @Override
    public TransformationOptions getTransformOptions() {
        return this.transformOptions;
    }

    private void setTransformOptions(TransformationOptions options) {
        if (!this.transformOptions.equals(options) && options != null) {
            this.transformOptions = options;
            this.fireChange(SatelliteObserver.Change.TRANSFORMATIONOPTIONS);
        }
    }

    @Override
    public SatelliteSession getSession() throws NullPointerException {
        return this.session;
    }

    @Override
    public Satellite.SatelliteState getCurrentState() {
        return this.state;
    }

    @Override
    public CommandChangeMode.SatelliteMode getCurrentMode() {
        return this.currentMode;
    }

    private void PositionTracking(boolean enabled) {
    }

    private void RotationTracking(boolean enabled) {
    }

    @Override
    public void setCurrentMode(CommandChangeMode.SatelliteMode newMode) {
        boolean changed = false;
        if (!this.currentMode.equals((Object)newMode)) {
            changed = true;
        }
        CommandChangeMode.SatelliteMode oldMode = this.currentMode;
        if (changed) {
            if (CommandChangeMode.SatelliteMode.Navigation.equals((Object)oldMode)) {
                this.endNavigationStride();
            }
            if (CommandChangeMode.SatelliteMode.DrawingAreaTransformation.equals((Object)oldMode)) {
                this.endDrawingAreaTransformation();
            }
            this.currentMode = newMode;
        }
        CommandChangeMode answercmd = new CommandChangeMode(newMode);
        CommandMessage message = new CommandMessage(answercmd);
        this.sendMessage(message);
        if (!changed) {
            return;
        }
        this.fireChange(SatelliteObserver.Change.SATELLITEMODE, (Object)oldMode);
        System.out.println("INFO: " + this.getClass().getSimpleName() + "  setCurrentMode( " + newMode + " )");
        switch (newMode) {
            case SelectionTransformation: {
                this.PositionTracking(true);
                this.RotationTracking(true);
                break;
            }
            case Editing: {
                this.PositionTracking(false);
                this.RotationTracking(false);
                break;
            }
            case IpadCalibration: 
            case DrawingAreaTransformation: {
                this.PositionTracking(true);
                this.RotationTracking(true);
                if (!CommandChangeMode.SatelliteMode.DrawingAreaTransformation.equals((Object)newMode)) break;
                this.beginDrawingAreaTransformation();
                break;
            }
            case Drawing: {
                this.PositionTracking(false);
                this.RotationTracking(false);
                break;
            }
            case Default: {
                this.PositionTracking(false);
                this.RotationTracking(false);
                break;
            }
            case Unkown: {
                this.PositionTracking(false);
                this.RotationTracking(false);
                break;
            }
            case Navigation: {
                this.PositionTracking(false);
                this.RotationTracking(true);
                break;
            }
        }
    }

    private void clearCanvas2DOnSatellite() {
        CommandMessage clearMsg = new CommandMessage(new CommandClearSatellite2dCanvas());
        this.sendMessage(clearMsg);
        this.freshlyDrawnStrokesManager.clear();
        this.projectedStrokesManager.clear();
    }

    @Override
    public void clearSatelliteCanvasAndShowStrokes(List<Stroke2D> strokes) {
        this.clearCanvas2DOnSatellite();
        for (Stroke2D stroke : strokes) {
            Stroke2DTransmissionPartMessage m = new Stroke2DTransmissionPartMessage(stroke.getStrokeId(), stroke.getPointsArray(), Stroke2DTransmissionPartMessage.SubType.COMPLETE, stroke.ink);
            this.sendMessage(m);
        }
    }

    @Override
    public void manageFreshStroke(Stroke2D stroke2d) {
        System.out.println(this.getClass().toString() + " manageFreshStroke(Stroke2D stroke2d) - stroke2d.getStrokeId()=" + stroke2d.getStrokeId().getUuidString());
        this.freshlyDrawnStrokesManager.add(stroke2d);
    }

    @Override
    public void registerObserver(SatelliteObserver observer) {
        this.observer.add(observer);
    }

    @Override
    public void setRegularFrameColor(ColorRGBA color) {
        boolean changed = false;
        if (!this.regularFrameColor.equals((Object)color)) {
            changed = true;
        }
        if (changed) {
            this.regularFrameColor = color;
            this.satConfig.setRegularFrameColor(this.regularFrameColor);
        }
        this.sendFrameColor(this.regularFrameColor);
        if (changed) {
            this.fireChange(SatelliteObserver.Change.REGULARFRAMECOLOR);
        }
    }

    @Override
    public ColorRGBA getRegularFrameColor() {
        return this.regularFrameColor;
    }

    @Override
    public void sendUndoRedoStepsCommand(int u, int r) {
        CommandMessage msg = new CommandMessage(new UndoRedoStepsCommand(u, r));
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Quaternion getRotation() {
        Quaternion q;
        Transformation transformation = this.transformation;
        synchronized (transformation) {
            q = this.transformation.getRotation().clone();
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Vector3f getPosition() {
        Vector3f p;
        Transformation transformation = this.transformation;
        synchronized (transformation) {
            p = this.transformation.getPosition().clone();
        }
        return p;
    }

    @Override
    public void setStrokeCreationAdapter(StrokeCreationAdapter sketcher) {
        this.sketcher = sketcher;
    }

    @Override
    public Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public void onDrawingAreaConnect() {
        this.setCurrentMode(this.modeBeforeDisconnect != null ? this.modeBeforeDisconnect : CommandChangeMode.SatelliteMode.Drawing);
    }

    @Override
    public void onDrawingAreaDisconnect() {
        this.modeBeforeDisconnect = this.getCurrentMode();
        this.setCurrentMode(CommandChangeMode.SatelliteMode.NotConnectedToDrawingArea);
    }

    @Override
    public void setTrackingInfos(Boolean isTrackingEnabled, String trackingIdentifier) {
        this.setTrackingEnabled(isTrackingEnabled);
    }

    public class IpadCalibrator {
        Vector2f moveVector = new Vector2f();
        private NamedAngle northHeading;
        private float initialHeading = 0.0f;
        float factor = 50.0f;

        public IpadCalibrator() {
            for (SatelliteObserver o : IpadSatellite.this.observer) {
                o.connectNewIpadCalibrator(this);
            }
        }

        public void move(Vector2f vector) {
            this.moveVector.addLocal(vector);
            float degrees = this.betweenZeroAnd360(this.initialHeading + this.moveVector.x * this.factor);
            this.northHeading.setAngleInDegrees(degrees);
        }

        private float betweenZeroAnd360(float f) {
            if (f > 360.0f) {
                return f - 360.0f;
            }
            if (f < 0.0f) {
                return 360.0f - f;
            }
            return f;
        }

        public void connect(NamedAngle namedAngle) {
            this.northHeading = namedAngle;
            this.initialHeading = namedAngle.getAngleInDegrees();
        }
    }

    private class Navigator {
        List<Vector3f> moves = new ArrayList<Vector3f>();
        InertiaNavigator inertia;
        private long startMilliseconds;

        public Navigator(long starttime) {
            this.startMilliseconds = starttime;
        }

        public void stop() {
            if (this.inertia != null) {
                this.inertia.stop();
            }
            this.moves.clear();
        }

        private Vector3f calcAverageDirection() {
            if (this.moves.isEmpty()) {
                return Vector3f.ZERO;
            }
            Vector3f sum = new Vector3f();
            int numberOfMovesForAverage = 7;
            if (this.moves.size() < numberOfMovesForAverage) {
                for (Vector3f v : this.moves) {
                    sum.addLocal(v);
                }
                return sum.divide((float)this.moves.size());
            }
            for (int i = this.moves.size() - 1; i > this.moves.size() - numberOfMovesForAverage - 1; --i) {
                Vector3f v = this.moves.get(i);
                sum.addLocal(v);
            }
            return sum.divide((float)numberOfMovesForAverage);
        }

        private float calcAverageWayLength() {
            return this.moves.isEmpty() ? 0.0f : this.calcTotalWayLength() / (float)this.moves.size();
        }

        private float calcTotalWayLength() {
            if (this.moves.isEmpty()) {
                return 0.0f;
            }
            float sum = 0.0f;
            for (Vector3f v : this.moves) {
                sum += v.length();
            }
            return sum;
        }

        public void inputEnded() {
            if (GlobalSettings.InertiaNavigationEnabled.booleanValue()) {
                float difftime = System.currentTimeMillis() - this.startMilliseconds;
                this.inertia = new InertiaNavigator(this.calcTotalWayLength(), this.calcAverageDirection(), this.calcAverageWayLength(), difftime);
            }
        }

        public void move(Vector3f move) {
            this.moves.add(move);
            for (SatelliteObserver o : IpadSatellite.this.observer) {
                o.onNavigationRequest(IpadSatellite.this, move);
            }
        }
    }

    private class InertiaNavigator
    implements Runnable {
        private boolean stopWasCalled = false;
        private boolean finished = false;
        private Thread t;
        private float totalWayLength;
        private Vector3f averageDirection;
        private float averageWayLength;
        private float velocity;
        private float inputduration;
        private float initialvelocity;
        private int runloops = 0;

        @Override
        public void run() {
            while (!this.stopWasCalled && !this.finished) {
                for (SatelliteObserver o : IpadSatellite.this.observer) {
                    Vector3f inertiamove = this.calculateInertiaMoveAndReduceVelocity();
                    o.onNavigationRequest(IpadSatellite.this, inertiamove);
                }
                try {
                    Thread.sleep(35L);
                }
                catch (InterruptedException e) {
                    this.stopWasCalled = true;
                }
            }
        }

        private Vector3f calculateInertiaMoveAndReduceVelocity() {
            float s = this.velocity * 35.0f;
            this.velocity -= this.initialvelocity / 30.0f;
            Vector3f inertiaMove = this.averageDirection.normalize().mult(s);
            if ((double)inertiaMove.lengthSquared() < 1.0E-5) {
                this.finished = true;
            }
            return inertiaMove;
        }

        public InertiaNavigator(float totalWayLength, Vector3f averageDirection, float averageWayLength, float seconds) {
            this.totalWayLength = totalWayLength;
            this.averageDirection = averageDirection;
            this.averageWayLength = averageWayLength;
            this.inputduration = seconds;
            this.initialvelocity = this.inputduration > 1.0E-5f ? totalWayLength / this.inputduration : 0.0f;
            System.out.println("initialvelocity: " + this.initialvelocity);
            this.velocity = this.initialvelocity;
            if (this.shouldRun()) {
                this.t = new Thread(this);
                this.t.start();
            }
        }

        private boolean shouldRun() {
            if (this.averageDirection.equals((Object)Vector3f.ZERO)) {
                return false;
            }
            if ((double)this.initialvelocity < 1.0E-5) {
                return false;
            }
            if (this.totalWayLength < 1.0f) {
                return false;
            }
            return this.averageWayLength == 0.0f ? false : this.totalWayLength / this.averageWayLength > 7.0f;
        }

        public void stop() {
            this.stopWasCalled = true;
            if (this.t != null) {
                this.t.interrupt();
            }
        }
    }
}

