/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.jme3.math.Quaternion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Rotations {
    private static Map<RotationIdentifier, Quaternion> values = new HashMap<RotationIdentifier, Quaternion>();
    private static Set<RotationsListener> listener = new HashSet<RotationsListener>();

    public static Quaternion get(RotationIdentifier which) {
        Quaternion v = values.get((Object)which);
        return v == null ? Quaternion.IDENTITY : v;
    }

    public static void addListener(RotationsListener l) {
        listener.add(l);
    }

    public static void removeListener(RotationsListener l) {
        listener.remove(l);
    }

    public static void setValue(RotationIdentifier which, Quaternion q) {
        values.put(which, q.clone());
        for (RotationsListener l : listener) {
            l.onRotationChanged(which, q.clone());
        }
    }

    public static interface RotationsListener {
        public void onRotationChanged(RotationIdentifier var1, Quaternion var2);
    }

    public static enum RotationIdentifier {
        iPad,
        iPadRaw,
        DrawingArea;

    }
}

