/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.SatelliteObserver;
import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.core.TransformationOptions;
import com.hybridlab.hyve3d.core.animation.Animation;
import com.hybridlab.hyve3d.core.animation.AnimationTrigger;
import com.hybridlab.hyve3d.core.animation.Animator;
import com.hybridlab.hyve3d.core.commands.CommandChangeMode;
import com.hybridlab.hyve3d.core.commands.CommandSetBackgroundImage;
import com.hybridlab.hyve3d.core.commands.SetSatelliteSelectionModeCommand;
import com.hybridlab.hyve3d.core.commands.StrokeModificationCommand;
import com.hybridlab.hyve3d.data.CommandExecutorHelper;
import com.hybridlab.hyve3d.data.domainobjects.CommandHistory;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.data.valueobjects.Ink;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.StrokeConverter;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.IpadSatellite;
import com.hybridlab.hyve3d.hyve.OrthoShooter;
import com.hybridlab.hyve3d.hyve.ParallaxEffectParameters;
import com.hybridlab.hyve3d.hyve.StrokeCreationAdapter;
import com.hybridlab.hyve3d.hyve.StrokeProjector;
import com.hybridlab.hyve3d.hyve.undoredo.AbstractCommandExecutor;
import com.hybridlab.hyve3d.hyve.undoredo.CommandExecutor;
import com.hybridlab.hyve3d.hyve.undoredo.CopyCommand;
import com.hybridlab.hyve3d.hyve.undoredo.DrawingAreaTransformationCommand;
import com.hybridlab.hyve3d.hyve.undoredo.DrawingAreaTransformerState;
import com.hybridlab.hyve3d.hyve.undoredo.EraseCommand;
import com.hybridlab.hyve3d.hyve.undoredo.ReleaseSelectionCommand;
import com.hybridlab.hyve3d.hyve.undoredo.SelectionCommand;
import com.hybridlab.hyve3d.hyve.undoredo.SelectionTransformationCommand;
import com.hybridlab.hyve3d.hyve.undoredo.TransformerState;
import com.hybridlab.hyve3d.network.ResourceProvider;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import com.hybridlab.hyve3d.network.messages.OrbitMessage;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.hyve3d.scenemanipulation.SceneElementSelector;
import com.hybridlab.utils.Interpolation;
import com.hybridlab.utils.ThreePerpendicularAxes;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Logger;
import org.json.JSONException;

public class SatelliteDrawingAreaAdapter
implements SatelliteObserver,
Hyve.CompassListener,
Transformable.TransformationChangedListener {
    private Hyve hyve;
    private Satellite satellite;
    private DrawingArea drawingArea;
    private Logger logger = Logger.getLogger(SatelliteDrawingAreaAdapter.class.getSimpleName());
    private Hyve.DrawingAreaStrokeCreationAdapter sketcher;
    private Transformation referenceSatelliteTransformation;
    private Transformation referenceDrawingAreaTransformation;
    private TransformationOptions currentTransformationOptions = new TransformationOptions();
    private Quaternion compassRotation;
    private Quaternion spaceRotation;
    private Transformable spaceTransformAdapter;
    private PairingDirection pairingDirection;
    private StrokeProjector strokeProjector;
    private SceneElementSelector selector;
    private OrthoShooter orthoShooter;
    private AnimationTrigger animationtrigger;
    private AnimationPlayer animationPlayer;
    private Transformation currentSatelliteTransformation;
    private Hyve.Compass northHeading;
    private Quaternion myRotation;
    private Hyve.Compass myHeading;
    private List<String> usedResources = new ArrayList<String>();
    private boolean orthoShootEnabled = true;
    private int numResourcesKept = 20;
    private CommandHistory history;
    private static final float HingeThresholdAngle = 0.2617994f;
    private TransformationOptions.TransformationFilter HingeDirection = null;
    private UUID parallaxEffectId = null;
    private InertiaNavigationProxy navProxy = new InertiaNavigationProxy();
    DrawingAreaRotator drawingAreaRotator;
    private PullAnimator pullanimator;
    private int selectionTransformationStep = 0;
    private DrawingAreaTransformationCommand daTrfcmd;
    private boolean ZoomCmdToHistory = true;
    private boolean TrfCmdToHistory = true;
    private Timer delayedUpdateTimer;
    private Vector3f positionChange = Vector3f.ZERO;

    public void clearSatelliteScreen() {
        this.orthoShootClear();
        this.delayedUpdate();
    }

    public SatelliteDrawingAreaAdapter(Satellite sat, DrawingArea da, PairingDirection pairingDir, Hyve hyve, Hyve.Compass northHeading, Transformable spaceTransformAdapter, OrthoShooter orthoShooter, AnimationTrigger animationtrigger) {
        this.animationtrigger = animationtrigger;
        this.animationPlayer = new AnimationPlayer(this.animationtrigger);
        this.orthoShooter = orthoShooter;
        this.hyve = hyve;
        this.satellite = sat;
        this.drawingArea = da;
        this.pairingDirection = pairingDir;
        this.strokeProjector = new StrokeProjector();
        this.strokeProjector.setDrawingArea(this.drawingArea);
        this.selector = new SceneElementSelector(this.drawingArea);
        this.northHeading = northHeading;
        this.compassRotation = northHeading.getRotation();
        northHeading.addListener(this);
        Hyve hyve2 = hyve;
        Objects.requireNonNull(hyve2);
        this.myHeading = hyve2.new Hyve.Compass(new NamedAngle("local Heading", 0.0f));
        this.myRotation = this.myHeading.getRotation();
        this.myHeading.addListener(this);
        this.spaceTransformAdapter = spaceTransformAdapter;
        this.spaceRotation = spaceTransformAdapter.getTransformation().getRotation().clone();
        spaceTransformAdapter.addChangeListener(this);
        this.satellite.registerObserver(this);
    }

    public DrawingArea getDrawingArea() {
        return this.drawingArea;
    }

    @Override
    public void onBeginObserving(Satellite sat) {
        this.pairDrawingAreaAndSatellite(this.pairingDirection);
    }

    public void disconnectDrawingArea() {
        this.useHistory(null);
        this.unPairDrawingAreaAndSatellite();
        this.drawingArea = null;
    }

    public void connectDrawingArea(DrawingArea drawingArea, PairingDirection pairingdir) {
        this.sketcher.setDrawingArea(drawingArea);
        this.strokeProjector.setDrawingArea(drawingArea);
        this.selector.setDrawingArea(drawingArea);
        this.drawingArea = drawingArea;
        this.pairDrawingAreaAndSatellite(pairingdir);
    }

    private void unPairDrawingAreaAndSatellite() {
        this.satellite.onDrawingAreaDisconnect();
    }

    private void pairDrawingAreaAndSatellite(PairingDirection direction) {
        if (this.drawingArea == null) {
            return;
        }
        this.logger.info("pairDrawingAreaAndSatellite with " + direction);
        this.drawingArea.addPropertyChangeListener("frame", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FrameRect newDAFR = (FrameRect)evt.getNewValue();
                if (!SatelliteDrawingAreaAdapter.this.satellite.getFrame().equals(newDAFR)) {
                    SatelliteDrawingAreaAdapter.this.satellite.setFrame(newDAFR);
                }
            }
        });
        switch (direction) {
            case DrawingAreaIsLeading: {
                this.satellite.setFrame(this.drawingArea.getFrame());
                this.satellite.setRegularFrameColor(this.drawingArea.getRegularFrameColor());
                break;
            }
            default: {
                this.drawingArea.setFrame(this.satellite.getFrame());
                this.drawingArea.setRegularFrameColor(this.satellite.getRegularFrameColor());
            }
        }
        this.drawingArea.setName(this.satellite.getName());
        this.drawingArea.setConnectedSatelliteId(this.satellite.getSatelliteId());
        Ink ink = this.sketcher.getInk();
        StrokeInkMessage inkMsg = StrokeInkMessage.fromStrokeInk(StrokeConverter.InkToStrokeInk(ink));
        this.satellite.sendMessage(inkMsg);
        this.satellite.onDrawingAreaConnect();
    }

    @Override
    public void onSomethingHasChanged(Satellite sat, SatelliteObserver.Change what, Object old) {
        if (this.drawingArea == null) {
            return;
        }
        block1 : switch (what) {
            case TILTANGLE: {
                Float tiltAngleDeg = (Float)old;
                this.hyve.setTiltAngle(tiltAngleDeg.floatValue());
                break;
            }
            case SATELLITEMODE: {
                try {
                    CommandChangeMode.SatelliteMode oldmode = (CommandChangeMode.SatelliteMode)((Object)old);
                    if (oldmode.equals((Object)CommandChangeMode.SatelliteMode.Navigation)) {
                        this.navProxy.stopTilt();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.resetHingeDirection();
                if (this.drawingAreaRotator != null) {
                    this.drawingAreaRotator.restart();
                }
                switch (sat.getCurrentMode()) {
                    case DrawingAreaTransformation: 
                    case DrawingAreaTransformationWhileSelection: 
                    case IpadCalibration: {
                        this.orthoShootClear();
                        this.storeReferenceTransformationValues(sat);
                        this.storeReferenceTransformationValuesForDrawingArea(this.drawingArea);
                        this.drawingArea.setIsTransLucent(true);
                        this.satellite.setTemporaryFrameColor(null);
                        break;
                    }
                    case SelectionTransformation: {
                        this.orthoShootClear();
                        this.storeReferenceTransformationValues(sat);
                        this.storeReferenceTransformationValuesForDrawingArea(this.drawingArea);
                        this.drawingArea.setIsTransLucent(true);
                        this.satellite.setTemporaryFrameColor(ColorRGBA.Magenta);
                        break;
                    }
                    case Editing: {
                        this.orthoShootClear();
                        this.storeReferenceTransformationValues(null);
                        this.storeReferenceTransformationValuesForDrawingArea(null);
                        this.drawingArea.setIsTransLucent(false);
                        this.satellite.setTemporaryFrameColor(ColorRGBA.Magenta);
                        break;
                    }
                    case Navigation: {
                        this.orthoShootClear();
                    }
                    default: {
                        this.satellite.setTemporaryFrameColor(null);
                        this.storeReferenceTransformationValues(null);
                        this.storeReferenceTransformationValuesForDrawingArea(null);
                        this.drawingArea.setIsTransLucent(false);
                    }
                }
                if (!sat.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Drawing) && !sat.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Editing)) break;
                this.projectAndSendStrokes();
                break;
            }
            case TRANSFORMATION: {
                this.currentSatelliteTransformation = sat.getTransformation();
                if (GlobalSettings.showSatelliteOrientationPhantomInDrawingArea.booleanValue()) {
                    this.drawingArea.setSatelliteOrientation(this.currentSatelliteTransformation.getRotation());
                    this.drawingArea.setSatelliteOrientationCorrected(this.satelliteRotationCorrection(this.currentSatelliteTransformation.getRotation()));
                }
                this.updateDrawingAreaTransformationByRecalculation();
                break;
            }
            case NAME: {
                this.drawingArea.setName(sat.getName());
                break;
            }
            case STATE: {
                switch (sat.getCurrentState()) {
                    default: {
                        this.drawingArea.setIsPaused(false);
                        break block1;
                    }
                    case PAUSED: 
                }
                this.drawingArea.setIsPaused(true);
                break;
            }
            case FRAME: {
                FrameRect newFrame = sat.getFrame();
                this.drawingArea.setFrame(newFrame);
                break;
            }
            case TRANSFORMATIONOPTIONS: {
                this.currentTransformationOptions = sat.getTransformOptions();
                this.logger.info("currentTransformationOptions=" + this.currentTransformationOptions);
                this.resetHingeDirection();
                break;
            }
            case REGULARFRAMECOLOR: {
                this.drawingArea.setRegularFrameColor(sat.getRegularFrameColor());
                break;
            }
            default: {
                this.logger.info(what + " has changed in " + sat + " but was not processed in " + this);
            }
        }
    }

    private void updateDrawingAreaTransformationByRecalculation() {
        if (this.referenceSatelliteTransformation != null && this.referenceDrawingAreaTransformation != null) {
            Transformation newDaTrf = this.calculateNewTransformation(this.currentSatelliteTransformation, this.referenceSatelliteTransformation, this.referenceDrawingAreaTransformation, this.currentTransformationOptions);
            this.drawingArea.setTransformation(newDaTrf);
        }
    }

    private void orthoShootClear() {
        CommandSetBackgroundImage cmd = new CommandSetBackgroundImage();
        this.satellite.sendMessage(new CommandMessage(cmd));
    }

    private void orthoShootUpdate() {
        if (this.orthoShooter != null && this.orthoShootEnabled) {
            OrthoShooter.FinishCallback callback = new OrthoShooter.FinishCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFinishedShooting(String shootId, byte[] data) {
                    CommandSetBackgroundImage cmd = new CommandSetBackgroundImage();
                    ResourceProvider.get().setImagePng(shootId, data);
                    String url = ResourceProvider.get().getUrlForResource(shootId);
                    System.out.println(url);
                    cmd.setResourceUrl(url);
                    SatelliteDrawingAreaAdapter.this.satellite.sendMessage(new CommandMessage(cmd));
                    List<String> list = SatelliteDrawingAreaAdapter.this.usedResources;
                    synchronized (list) {
                        SatelliteDrawingAreaAdapter.this.usedResources.add(shootId);
                    }
                    SatelliteDrawingAreaAdapter.this.forgetOlderUsedResources();
                }
            };
            String shootid = this.orthoShooter.shootAt(this.drawingArea.getTransformation().copy(), this.drawingArea.getFrame().getCopy(), callback);
            System.out.println("shootid=" + shootid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetOlderUsedResources() {
        ArrayList<String> toForget = new ArrayList<String>();
        List<String> list = this.usedResources;
        synchronized (list) {
            if (this.usedResources.size() > this.numResourcesKept) {
                while (this.usedResources.size() > this.numResourcesKept) {
                    toForget.add(this.usedResources.get(0));
                    this.usedResources.remove(0);
                }
            }
            ResourceProvider.get().forget(toForget.toArray(new String[toForget.size()]));
        }
    }

    private void projectAndSendStrokes() {
        if (this.strokeProjector == null) {
            return;
        }
        if (this.satellite.shouldReceiveProjectedStrokes()) {
            this.strokeProjector.project();
            List<Stroke2D> strokes = this.strokeProjector.getProjected();
            int maxAmountOfPointsInProjectedStroke = 500;
            List<Stroke2D> strokesWithMaximumAmountOfPoints = StrokeProjector.ensureStrokesConsistOfMaximumAmountOfPoints(strokes, 500);
            this.satellite.clearSatelliteCanvasAndShowStrokes(strokesWithMaximumAmountOfPoints);
        }
        this.orthoShootUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformation calculateNewTransformation(Transformation currentSatelliteTransformation, Transformation referenceSatelliteTransformation, Transformation referenceDrawingAreaTransformation, TransformationOptions currentTransformationOptions) {
        Vector3f moveChange;
        Vector3f vector3f = this.positionChange;
        synchronized (vector3f) {
            moveChange = this.positionChange;
            this.positionChange = Vector3f.ZERO;
        }
        Transformation result = null;
        switch (currentTransformationOptions.transformFilter) {
            case NOTHING: {
                break;
            }
            case RXYZ_TGXYZ: {
                Vector3f move = currentSatelliteTransformation.getPosition().subtract(referenceSatelliteTransformation.getPosition());
                Quaternion rotation = this.satelliteRotationCorrection(currentSatelliteTransformation.getRotation());
                rotation = MathUtils.snapSimple(rotation, 0.13962634f);
                move = this.correctMoveVector(move);
                Vector3f position = referenceDrawingAreaTransformation.getPosition().add(move).add(moveChange);
                result = new Transformation(position, rotation);
                break;
            }
            case TXY: {
                Quaternion rotation = referenceDrawingAreaTransformation.getRotation();
                ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(rotation);
                Vector3f move = currentSatelliteTransformation.getPosition().subtract(referenceSatelliteTransformation.getPosition());
                move = this.correctMoveVector(move);
                Vector3f changeX = move.project(axes.X);
                Vector3f changeY = move.project(axes.Y);
                Vector3f position = referenceDrawingAreaTransformation.getPosition().add(changeX).add(changeY).add(moveChange);
                if (this.drawingAreaRotator != null) {
                    ThreePerpendicularAxes axesOfTheDrawingArea = MathUtils.getQuaternionAxes(referenceDrawingAreaTransformation.getRotation());
                    Quaternion rotationToApply = new Quaternion();
                    rotationToApply.fromAngleAxis(this.drawingAreaRotator.getAngleRad(), axesOfTheDrawingArea.Z);
                    Quaternion newRotationOfDrawingArea = rotationToApply.mult(referenceDrawingAreaTransformation.getRotation());
                    this.drawingArea.setTransformation(new Transformation(referenceDrawingAreaTransformation.getPosition(), newRotationOfDrawingArea));
                    result = new Transformation(position, newRotationOfDrawingArea);
                    break;
                }
                result = new Transformation(position, referenceDrawingAreaTransformation.getRotation());
                break;
            }
            case TZ: {
                Quaternion rotation = referenceDrawingAreaTransformation.getRotation();
                ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(rotation);
                Vector3f move = currentSatelliteTransformation.getPosition().subtract(referenceSatelliteTransformation.getPosition());
                move = this.correctMoveVector(move);
                Vector3f change = move.project(axes.Z);
                Vector3f position = referenceDrawingAreaTransformation.getPosition().add(change).add(moveChange);
                result = new Transformation(position, rotation);
                break;
            }
            case RY: 
            case RX: 
            case RZ: {
                Vector3f position = referenceDrawingAreaTransformation.getPosition().add(moveChange);
                Quaternion rotation = referenceDrawingAreaTransformation.getRotation();
                ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(rotation);
                Vector3f twistAxis = switch (currentTransformationOptions.transformFilter) {
                    case TransformationOptions.TransformationFilter.RY -> axes.Y;
                    case TransformationOptions.TransformationFilter.RX -> axes.X;
                    default -> axes.Z;
                };
                boolean useCorrectionFirst = GlobalSettings.useSatelliteCorrectionInTwistCalculations;
                Quaternion diffTwist = MathUtils.calculateDifferenceTwist(useCorrectionFirst ? this.satelliteRotationCorrection(referenceSatelliteTransformation.getRotation()) : referenceSatelliteTransformation.getRotation(), useCorrectionFirst ? this.satelliteRotationCorrection(currentSatelliteTransformation.getRotation()) : currentSatelliteTransformation.getRotation(), twistAxis);
                Quaternion resultingRotation = diffTwist.mult(referenceDrawingAreaTransformation.getRotation());
                if (currentTransformationOptions.transformFilter.equals((Object)TransformationOptions.TransformationFilter.RY) && GlobalSettings.RotateBy180DegreesOnHingeTurn.booleanValue() && axes.Z.angleBetween(Vector3f.UNIT_Y) > 0.0017453292f) {
                    boolean turn = false;
                    Vector3f normalOfMainRotationPlane = Vector3f.UNIT_Y.cross(axes.Z);
                    Vector3f normalOfTurnPlane = normalOfMainRotationPlane.cross(Vector3f.UNIT_Y);
                    ThreePerpendicularAxes axesNew = MathUtils.getQuaternionAxes(resultingRotation);
                    if (axesNew.Z.dot(normalOfTurnPlane) < 0.0f) {
                        turn = true;
                    }
                    if (turn) {
                        Quaternion turnRotation = new Quaternion();
                        turnRotation.fromAngleAxis((float)Math.PI, axesNew.Z);
                        resultingRotation = turnRotation.mult(resultingRotation);
                    }
                }
                boolean snap = false;
                if (GlobalSettings.SnapDuringHinge.booleanValue()) {
                    if (currentTransformationOptions.transformFilter.equals((Object)TransformationOptions.TransformationFilter.RY)) {
                        snap = true;
                    }
                    if (currentTransformationOptions.transformFilter.equals((Object)TransformationOptions.TransformationFilter.RX)) {
                        snap = true;
                    }
                }
                if (snap) {
                    resultingRotation = MathUtils.snapSimple(resultingRotation, 0.10471976f);
                }
                result = new Transformation(position, resultingRotation);
                break;
            }
            case HINGE_AUTODETECT: {
                boolean useCorrectionFirst = GlobalSettings.useSatelliteCorrectionInTwistCalculations;
                Quaternion rotation = useCorrectionFirst ? this.satelliteRotationCorrection(referenceSatelliteTransformation.getRotation()) : referenceSatelliteTransformation.getRotation();
                ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(rotation);
                Quaternion currentrotation = useCorrectionFirst ? this.satelliteRotationCorrection(currentSatelliteTransformation.getRotation()) : currentSatelliteTransformation.getRotation();
                ThreePerpendicularAxes axescurrent = MathUtils.getQuaternionAxes(currentrotation);
                float diffAngleX = Math.abs(axescurrent.X.angleBetween(axes.X));
                float diffAngleY = Math.abs(axescurrent.Y.angleBetween(axes.Y));
                if (this.HingeDirection == null && (diffAngleX > 0.2617994f || diffAngleY > 0.2617994f)) {
                    this.HingeDirection = diffAngleX > diffAngleY ? TransformationOptions.TransformationFilter.RY : TransformationOptions.TransformationFilter.RX;
                    System.out.println("HingeDirection = " + this.HingeDirection);
                }
                if (this.HingeDirection == null) break;
                TransformationOptions trfOptions = new TransformationOptions();
                trfOptions.transformFilter = this.HingeDirection;
                return this.calculateNewTransformation(currentSatelliteTransformation, referenceSatelliteTransformation, referenceDrawingAreaTransformation, trfOptions);
            }
            default: {
                this.logger.severe("no algorithm to calculate contstrained da placement with option: " + currentTransformationOptions.transformFilter);
            }
        }
        if (result == null) {
            result = referenceDrawingAreaTransformation;
        }
        return result;
    }

    private void resetHingeDirection() {
        this.HingeDirection = null;
        System.out.println("HingeDirection = null");
    }

    private Vector3f correctMoveVector(Vector3f move) {
        return this.spaceRotation.mult(move);
    }

    private void storeReferenceTransformationValuesForDrawingArea(DrawingArea da) {
        this.referenceDrawingAreaTransformation = da == null ? null : da.getTransformation().copy();
    }

    private void storeReferenceTransformationValues(Satellite sat) {
        if (sat == null) {
            this.referenceSatelliteTransformation = null;
            if (this.parallaxEffectId != null) {
                this.hyve.cancelParallaxEffect(this.parallaxEffectId);
                this.parallaxEffectId = null;
            }
        } else {
            this.referenceSatelliteTransformation = sat.getTransformation().copy();
            if (this.parallaxEffectId == null) {
                ParallaxEffectParameters p = new ParallaxEffectParameters(this.drawingArea.getTransformation().copy());
                this.parallaxEffectId = this.hyve.requestParallaxEffect(this, p);
            }
        }
    }

    public StrokeProjector getStrokeProjector() {
        return this.strokeProjector;
    }

    public void setStrokeCreationAdapter(Hyve.DrawingAreaStrokeCreationAdapter sketcher) {
        this.sketcher = sketcher;
        this.satellite.setStrokeCreationAdapter(this.sketcher);
    }

    public StrokeCreationAdapter getStrokeCreationAdapter() {
        return this.sketcher;
    }

    @Override
    public void onNavigationRequest(Satellite sat, Vector3f direction) {
        Vector3f correctedRotation = this.myRotation.mult(direction);
        this.navProxy.onNavigationRequest(correctedRotation);
    }

    @Override
    public void onOrbitingRequest(Satellite sat, OrbitMessage orbitMsg) {
        switch (this.satellite.getCurrentMode()) {
            case Navigation: {
                this.hyve.onOrbitingRequest(this, orbitMsg);
                break;
            }
            case DrawingAreaTransformation: 
            case DrawingAreaTransformationWhileSelection: 
            case SelectionTransformation: 
            case Editing: {
                if (this.drawingAreaRotator == null) {
                    this.drawingAreaRotator = new DrawingAreaRotator();
                }
                this.drawingAreaRotator.feed(orbitMsg);
                break;
            }
        }
    }

    public String getSatelliteId() {
        return this.satellite.getSatelliteId();
    }

    @Override
    public void rotationHasChanged(Hyve.Compass compass, Quaternion rotation) {
        if (compass == this.northHeading) {
            this.compassRotation = rotation;
        } else if (compass == this.myHeading) {
            this.myRotation = rotation;
        }
        this.updateDrawingAreaRotation();
    }

    private void updateDrawingAreaRotation() {
        if (this.drawingArea == null) {
            return;
        }
        Quaternion correctedSatRotation = this.satelliteRotationCorrection(this.satellite.getTransformation().getRotation());
        Transformation newDaTrf = new Transformation(this.drawingArea.getTransformation().getPosition().clone(), correctedSatRotation);
        this.drawingArea.setTransformation(newDaTrf);
    }

    public Quaternion satelliteRotationCorrection(Quaternion satRotation) {
        return this.satelliteRotationCameraSpaceCorrection(this.satelliteRotationNorthCorrection(satRotation));
    }

    private Quaternion satelliteRotationNorthCorrection(Quaternion satRotation) {
        Quaternion corrected = this.myRotation.mult(this.compassRotation).mult(satRotation);
        return corrected;
    }

    private Quaternion satelliteRotationCameraSpaceCorrection(Quaternion satRotation) {
        Quaternion corrected = this.spaceRotation.mult(satRotation);
        return corrected;
    }

    @Override
    public void hasChanged(Transformable transformable) {
        if (this.spaceTransformAdapter == transformable) {
            this.spaceRotation = transformable.getTransformation().getRotation().clone();
        }
    }

    @Override
    public void onPullRequest(Satellite sat, String what) {
        if (sat == this.satellite && "DrawingArea".equals(what)) {
            Animation ani = new Animation(){
                private boolean prepared = false;
                private Vector3f beginPos;
                private Vector3f endPos;
                private Vector3f beginToEnd;
                private Vector3f current = new Vector3f();
                private FrameRect beginFrame;
                private FrameRect endFrame;
                private float frameScale;
                private boolean doFrameScale = false;

                public String toString() {
                    return String.format("beginPos=%s, endPos=%s, current=%s", this.beginPos == null ? "null" : this.beginPos.toString(), this.endPos == null ? "null" : this.endPos.toString(), this.current.toString());
                }

                @Override
                public void step(float t) {
                    if (t < 0.0f) {
                        t = 0.0f;
                    } else if (t > 1.0f) {
                        t = 1.0f;
                    }
                    float used_t = Interpolation.fastInSlowOut_smoothTrigonometrical(t, 2);
                    this.current = this.beginPos.add(this.beginToEnd.mult(used_t));
                    Vector3f newPos = this.current.clone();
                    SatelliteDrawingAreaAdapter.this.drawingArea.setTransformation(new Transformation(newPos, SatelliteDrawingAreaAdapter.this.drawingArea.getTransformation().getRotation().clone()));
                    if (this.doFrameScale) {
                        float zoomValue = Interpolation.inttrf(used_t, 0.0f, 1.0f, 1.0f, this.frameScale);
                        FrameRect newFrame = this.beginFrame.getCopy();
                        newFrame.multLocal(zoomValue);
                        SatelliteDrawingAreaAdapter.this.drawingArea.setFrame(newFrame);
                    }
                }

                @Override
                public void prepare() {
                    this.prepared = true;
                    if (SatelliteDrawingAreaAdapter.this.hasSelection()) {
                        SatelliteDrawingAreaAdapter.this.beginSelectionTransformation(DrawingAreaPlaceMentOption.DoNothing);
                    }
                    this.beginPos = SatelliteDrawingAreaAdapter.this.drawingArea.getTransformation().getPosition().clone();
                    Vector3f spacePos = SatelliteDrawingAreaAdapter.this.spaceTransformAdapter.getTransformation().getPosition();
                    ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(SatelliteDrawingAreaAdapter.this.spaceTransformAdapter.getTransformation().getRotation());
                    float distance = -1.0f * DrawingArea.DefaultFrame.getDiagonalLength();
                    this.endPos = spacePos.add(axes.Z.mult(distance));
                    this.beginToEnd = this.endPos.subtract(this.beginPos);
                    if (!SatelliteDrawingAreaAdapter.this.hasSelection()) {
                        this.doFrameScale = true;
                        this.beginFrame = SatelliteDrawingAreaAdapter.this.drawingArea.getFrame().getCopy();
                        this.endFrame = DrawingArea.DefaultFrame;
                        this.frameScale = this.endFrame.getHeight() / this.beginFrame.getHeight();
                    }
                }

                @Override
                public long getDurationInMilliseconds() {
                    return 500L;
                }

                @Override
                public void cleanup() {
                    if (SatelliteDrawingAreaAdapter.this.hasSelection()) {
                        SatelliteDrawingAreaAdapter.this.endSelectionTransformation();
                    }
                    this.prepared = false;
                    if (SatelliteDrawingAreaAdapter.this.satellite.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Drawing)) {
                        SatelliteDrawingAreaAdapter.this.projectAndSendStrokes();
                    }
                }

                @Override
                public void cancel() {
                    if (this.prepared) {
                        this.cleanup();
                    }
                }

                @Override
                public void update(float tpf) {
                }

                @Override
                public void registerAnimationFinishedCallback(Animation.FinishedCallback cb) {
                }
            };
            if (this.pullanimator != null) {
                this.pullanimator.cancel();
            }
            this.pullanimator = new PullAnimator(ani);
            this.pullanimator.perform();
        }
    }

    protected boolean hasSelection() {
        return this.selector.hasSomethingSelected();
    }

    public SceneElementSelector getSceneElementSelector() {
        return this.selector;
    }

    @Override
    public void onSelectionCommandReceived(Satellite sat, SetSatelliteSelectionModeCommand selectionCmd) {
        this.selector.setSelectionModificationMode(selectionCmd.getModificationMode());
        SelectionCommand cmd = this.selector.beginOrEndSelection(selectionCmd.getIsSelectionModeEnabled());
        if (!selectionCmd.getIsSelectionModeEnabled() && this.selector.hasSomethingSelected()) {
            this.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Editing);
            this.resetSelectionTransformationStep();
        }
        if (cmd != null) {
            cmd.setExecutor(new SelectionExecutor(this, cmd, this.drawingArea));
            cmd.setIsExecuted(true);
            this.getHistory().add_AndExecuteIfNotYetExecuted(cmd);
        }
    }

    private void resetSelectionTransformationStep() {
        this.selectionTransformationStep = 0;
        System.out.println("resetSelectionTransformationStep() " + this.selectionTransformationStep);
    }

    private void beginSelectionTransformation(DrawingAreaPlaceMentOption option) {
        ++this.selectionTransformationStep;
        System.out.println("beginSelectionTransformation(" + option + ") " + this.selectionTransformationStep);
        Satellite sat = this.satellite;
        DrawingAreaPlaceMentOption usedOption = DrawingAreaPlaceMentOption.DoNothing;
        switch (this.currentTransformationOptions.transformFilter) {
            case RXYZ_TGXYZ: {
                usedOption = this.selectionTransformationStep > 1 ? DrawingAreaPlaceMentOption.DoNothing : option;
                break;
            }
        }
        this.selector.prepareSelectionTransformation(usedOption);
        this.storeReferenceTransformationValues(sat);
        this.storeReferenceTransformationValuesForDrawingArea(this.drawingArea);
        SelectionTransformationCommand selectionTrfCommand = new SelectionTransformationCommand("Transformation");
        this.selector.beginSelectionTransformation(selectionTrfCommand);
    }

    private void endSelectionTransformation() {
        SelectionTransformationCommand selectionTrfCommand = this.selector.endSelectionTransformation();
        this.storeReferenceTransformationValues(null);
        this.storeReferenceTransformationValuesForDrawingArea(null);
        if (selectionTrfCommand != null) {
            selectionTrfCommand.setExecutor(CommandExecutorHelper.createSelectionTransformationExecutor(this.drawingArea, this.selector.getSelected(), selectionTrfCommand));
            selectionTrfCommand.setIsExecuted(true);
            this.getHistory().add_AndExecuteIfNotYetExecuted(selectionTrfCommand);
        }
    }

    @Override
    public void onSelectionModification(Satellite sat, SatelliteObserver.SelectionModification mod) {
        this.logger.info("####################\n" + mod.toString() + "\n####################\n");
        switch (mod) {
            case CopyAndPasteSelection: {
                this.copyAndPasteSelection();
                break;
            }
            case DeleteSelection: {
                this.deleteSelection();
                break;
            }
            case UnselectAll: {
                this.releaseSelection();
                break;
            }
            case BeginSelectionScale: {
                this.beginSelectionTransformation(DrawingAreaPlaceMentOption.DoNothing);
                break;
            }
            case BeginSelectionTransformation: {
                DrawingAreaPlaceMentOption option = DrawingAreaPlaceMentOption.SnapToVerticalOrHorizontalPlane;
                this.beginSelectionTransformation(option);
                break;
            }
            case EndSelectionTransformation: 
            case EndSelectionScale: {
                this.endSelectionTransformation();
            }
        }
    }

    private void releaseSelection() {
        ReleaseSelectionCommand releaseSelectionCommand = new ReleaseSelectionCommand("Release Selection");
        for (Selectable x : this.selector.getSelected()) {
            releaseSelectionCommand.add(x.getId());
        }
        CommandExecutor ex = CommandExecutorHelper.createReleaseAllExecutor(this.selector, this.satellite, releaseSelectionCommand);
        releaseSelectionCommand.setExecutor(ex);
        if (releaseSelectionCommand != null) {
            this.getHistory().add_AndExecuteIfNotYetExecuted(releaseSelectionCommand);
        }
    }

    private void deleteSelection() {
        Set<Selectable> selected = this.selector.getSelected();
        EraseCommand cmd = this.hyve.onDeleteRequest(this.drawingArea.getId(), selected, this.selector, this.satellite);
        if (cmd != null) {
            this.getHistory().add_AndExecuteIfNotYetExecuted(cmd);
        }
    }

    private CommandHistory getHistory() {
        if (this.history != null) {
            return this.history;
        }
        throw new IllegalStateException("no history available in " + this.toString());
    }

    private void copyAndPasteSelection() {
        this.endSelectionTransformation();
        Set<Selectable> selected = this.selector.getSelected();
        CopyCommand cmd = this.hyve.onCopyRequest(this.drawingArea.getId(), selected);
        cmd.execute();
        if (cmd != null) {
            this.getHistory().add_AndExecuteIfNotYetExecuted(cmd);
        }
        this.beginSelectionTransformation(DrawingAreaPlaceMentOption.DoNothing);
    }

    @Override
    public void onDrawingModeRequest(Satellite sat) {
        if (this.selector.hasSomethingSelected()) {
            this.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Editing);
        } else {
            this.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Drawing);
        }
    }

    private TransformerState getTransformerState() {
        DrawingAreaTransformerState state = new DrawingAreaTransformerState(this.drawingArea.getId(), this.drawingArea.getTransformation().copy(), this.drawingArea.getFrame().getCopy());
        return state;
    }

    @Override
    public void onSatelliteActionNotification(SatelliteObserver.Action a) {
        switch (a) {
            case ZoomBegin: {
                if (this.satellite.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.DrawingAreaTransformation)) {
                    this.beginSelectionTransformation(DrawingAreaPlaceMentOption.DoNothing);
                }
                if (!this.ZoomCmdToHistory) break;
                this.daTrfcmd = new DrawingAreaTransformationCommand("Zoom Drawingarea");
                this.daTrfcmd.setTransformerStateBefore(this.getTransformerState());
                break;
            }
            case ZoomEnd: {
                if (this.satellite.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.DrawingAreaTransformation)) {
                    this.endSelectionTransformation();
                }
                if (this.satellite.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Drawing) || this.satellite.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Editing)) {
                    this.orthoShootUpdate();
                }
                if (this.daTrfcmd == null || !this.ZoomCmdToHistory) break;
                this.daTrfcmd.setTransformerStateAfter(this.getTransformerState());
                this.daTrfcmd.setExecutor(CommandExecutorHelper.createDrawingAreaTransformationCommandExecutor(this.drawingArea, this.daTrfcmd));
                this.daTrfcmd.setIsExecuted(true);
                this.getHistory().add_AndExecuteIfNotYetExecuted(this.daTrfcmd);
                this.daTrfcmd = null;
                break;
            }
            case DrawingAreaTransformationBegin: {
                if (!this.TrfCmdToHistory) break;
                this.daTrfcmd = new DrawingAreaTransformationCommand("Transform Drawingarea");
                this.daTrfcmd.setTransformerStateBefore(this.getTransformerState());
                break;
            }
            case DrawingAreaTransformationEnd: {
                if (this.daTrfcmd == null || !this.TrfCmdToHistory) break;
                this.daTrfcmd.setTransformerStateAfter(this.getTransformerState());
                this.daTrfcmd.setExecutor(CommandExecutorHelper.createDrawingAreaTransformationCommandExecutor(this.drawingArea, this.daTrfcmd));
                this.daTrfcmd.setIsExecuted(true);
                this.getHistory().add_AndExecuteIfNotYetExecuted(this.daTrfcmd);
                this.daTrfcmd = null;
                break;
            }
            case Undo: 
            case Redo: {
                if (a.equals((Object)SatelliteObserver.Action.Undo)) {
                    this.performUndo();
                    break;
                }
                if (!a.equals((Object)SatelliteObserver.Action.Redo)) break;
                this.performRedo();
                break;
            }
            case TiltBegin: 
            case TiltEnd: {
                if (a.equals((Object)SatelliteObserver.Action.TiltBegin)) {
                    this.navProxy.startTiltWithReferenceOrientation(this.satellite.getTransformation().getRotation().clone());
                    break;
                }
                if (!a.equals((Object)SatelliteObserver.Action.TiltEnd)) break;
                this.navProxy.stopTilt();
            }
        }
    }

    private void performRedo() {
        if (this.history == null) {
            this.logger.info("No history to perform a redo with!");
            return;
        }
        if (this.history.redo()) {
            this.updateUndoRedoSteps();
            if (this.history.lastUndoOrRedoWasAStrokeCommand()) {
                UUID undoStrokeInfo = this.history.getLastUnDoneOrRedoneStrokeCommandInfos();
                this.sendShowHiddenStrokeBecauseOfRedo(undoStrokeInfo);
                this.delayedUpdate();
            } else {
                this.delayedUpdate();
            }
        }
    }

    private void sendShowHiddenStrokeBecauseOfRedo(UUID strokeID) {
        if (strokeID == null) {
            System.out.println("cannot perform sendShowHiddenStrokeBecauseOfRedo because strokeID was null");
            return;
        }
        StrokeModificationCommand cmd = new StrokeModificationCommand(new StrokeId(strokeID));
        cmd.setModification(StrokeModificationCommand.Modification.VISIBILITY, "true");
        try {
            System.out.println("sendShowHiddenStrokeBecauseOfRedo: " + cmd.toJSON().toString());
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        this.satellite.sendMessage(new CommandMessage(cmd));
    }

    private void sendHideShownStrokeBecauseOfUndo(UUID strokeID) {
        if (strokeID == null) {
            System.out.println("cannot perform sendHideShownStrokeBecauseOfUndo because strokeID was null");
            return;
        }
        StrokeModificationCommand cmd = new StrokeModificationCommand(new StrokeId(strokeID));
        cmd.setModification(StrokeModificationCommand.Modification.VISIBILITY, "false");
        try {
            System.out.println("sendShowHiddenStrokeBecauseOfRedo: " + cmd.toJSON().toString());
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        this.satellite.sendMessage(new CommandMessage(cmd));
    }

    private void performUndo() {
        if (this.history == null) {
            this.logger.info("No history to perform an undo with!");
            return;
        }
        if (this.history.undo()) {
            this.updateUndoRedoSteps();
            if (this.history.lastUndoOrRedoWasAStrokeCommand()) {
                UUID undoStrokeInfo = this.history.getLastUnDoneOrRedoneStrokeCommandInfos();
                this.sendHideShownStrokeBecauseOfUndo(undoStrokeInfo);
                this.delayedUpdate();
            } else {
                this.delayedUpdate();
            }
        }
    }

    private void updateUndoRedoSteps() {
        if (this.history != null) {
            int r = this.history.getNumberOfPossibleRedos();
            int u = this.history.getNumberOfPossibleUndos();
            this.satellite.sendUndoRedoStepsCommand(u, r);
        }
    }

    private void delayedUpdate() {
        if (this.delayedUpdateTimer != null) {
            this.delayedUpdateTimer.cancel();
        }
        this.delayedUpdateTimer = new Timer();
        long delay = 20L;
        this.delayedUpdateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SatelliteDrawingAreaAdapter.this.projectAndSendStrokes();
            }
        }, delay);
    }

    public void setOrthogonalRenderingEnabled(boolean b) {
        this.orthoShootEnabled = b;
        if (!this.orthoShootEnabled) {
            this.orthoShootClear();
        } else if (this.satellite.getCurrentMode().equals((Object)CommandChangeMode.SatelliteMode.Drawing)) {
            this.orthoShootUpdate();
        }
    }

    public void useHistory(CommandHistory cmdHistory) {
        this.history = cmdHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDrawingAreaMoveRequest(Satellite sat, Vector2f moveVectorInFrameRectCoordinates) {
        ThreePerpendicularAxes axes = MathUtils.getQuaternionAxes(this.drawingArea.getTransformation().getRotation());
        switch (this.currentTransformationOptions.transformFilter) {
            default: {
                break;
            }
            case RXYZ_TGXYZ: 
            case TXY: {
                Vector3f vector3f = this.positionChange;
                synchronized (vector3f) {
                    this.positionChange.add(axes.Y.mult(moveVectorInFrameRectCoordinates.y)).add(axes.X.mult(moveVectorInFrameRectCoordinates.x));
                    break;
                }
            }
            case TZ: {
                Vector3f vector3f = this.positionChange;
                synchronized (vector3f) {
                    this.positionChange.add(axes.Z.mult(moveVectorInFrameRectCoordinates.y));
                    break;
                }
            }
        }
        this.updateDrawingAreaTransformationByRecalculation();
    }

    @Override
    public void connectNewIpadCalibrator(IpadSatellite.IpadCalibrator ipadCalibrator) {
        ipadCalibrator.connect(this.myHeading.getAngle());
    }

    public class InertiaNavigationProxy {
        private long expectedNextAddTimeDifference_MS = 50L;
        private long timeInThePast_MS = 500L;
        private List<NavigationEvent> events = new ArrayList<NavigationEvent>();
        private Timer inertiaStartTimer;
        private Timer inertiaMovementTimer;
        private boolean inertia = false;
        private Tilter tilter;

        public void onNavigationRequest(Vector3f direction) {
            if (!GlobalSettings.panoramaMode.booleanValue()) {
                if (this.inertia) {
                    this.add(direction);
                } else {
                    SatelliteDrawingAreaAdapter.this.hyve.onNavigationRequest(this, direction);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Vector3f direction) {
            this.stopInertiaMovement();
            if (!(direction.lengthSquared() > 0.0f)) {
                return;
            }
            NavigationEvent e = new NavigationEvent();
            e.direction = direction;
            e.time = System.currentTimeMillis();
            long oldestNotElapsed = e.time - this.timeInThePast_MS;
            HashSet<NavigationEvent> elapsed = new HashSet<NavigationEvent>();
            List<NavigationEvent> list = this.events;
            synchronized (list) {
                for (NavigationEvent event : this.events) {
                    if (event.time == null) {
                        elapsed.add(event);
                        continue;
                    }
                    if (event.time >= oldestNotElapsed) continue;
                    elapsed.add(event);
                }
                this.events.removeAll(elapsed);
                this.events.add(e);
            }
            this.startInertiaTrigger();
            e.sent = true;
            SatelliteDrawingAreaAdapter.this.hyve.onNavigationRequest(this, e.direction);
        }

        private void startInertiaTrigger() {
            if (this.inertiaStartTimer != null) {
                this.inertiaStartTimer.cancel();
            }
            this.inertiaStartTimer = new Timer();
            long delay = this.expectedNextAddTimeDifference_MS;
            this.inertiaStartTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    InertiaNavigationProxy.this.startInertiaMovement();
                }
            }, delay);
        }

        private void startInertiaMovement() {
            if (this.inertiaMovementTimer != null) {
                this.inertiaMovementTimer.cancel();
            }
            this.printInfos("before createFutureEvents");
            this.createFutureEvents();
            this.printInfos("after createFutureEvents");
            if (this.doNextEvent()) {
                this.scheduleNextEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printInfos(String label) {
            List<NavigationEvent> list = this.events;
            synchronized (list) {
                String s = "------------------------- " + System.currentTimeMillis() + label;
                for (NavigationEvent e : this.events) {
                    s = s + "\n" + e.toString();
                }
                System.out.println(s);
            }
        }

        private void scheduleNextEvent() {
            this.inertiaMovementTimer = new Timer();
            long delay = this.expectedNextAddTimeDifference_MS;
            this.inertiaMovementTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (InertiaNavigationProxy.this.doNextEvent()) {
                        InertiaNavigationProxy.this.scheduleNextEvent();
                    }
                }
            }, delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doNextEvent() {
            List<NavigationEvent> list = this.events;
            synchronized (list) {
                if (this.events.isEmpty()) {
                    return false;
                }
                NavigationEvent next = null;
                for (NavigationEvent e : this.events) {
                    if (e.sent) continue;
                    next = e;
                    break;
                }
                if (next != null) {
                    next.time = System.currentTimeMillis();
                    SatelliteDrawingAreaAdapter.this.hyve.onNavigationRequest(this, next.direction);
                    next.sent = true;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createFutureEvents() {
            List<NavigationEvent> list = this.events;
            synchronized (list) {
                AcceleratedMovement am = new AcceleratedMovement();
                for (int i = 0; i < this.events.size(); ++i) {
                    NavigationEvent current = this.events.get(i);
                    if (i == 0) continue;
                    NavigationEvent previous = this.events.get(i - 1);
                    float deltaTime = current.time - previous.time;
                    am.add(current.direction, deltaTime);
                }
                if (am.hasEnoughData()) {
                    System.out.println(am.toString());
                    float thresholdVelocity = 0.1f;
                    if (am.getHighestVelocity() > thresholdVelocity) {
                        float timeperStep = 20.0f;
                        List<Vector3f> futures = am.createFutureWaysWithTimeSteps(timeperStep);
                        for (Vector3f v : futures) {
                            NavigationEvent e = new NavigationEvent();
                            e.direction = v;
                            this.events.add(e);
                        }
                    }
                }
            }
        }

        private void stopInertiaMovement() {
            if (this.inertiaStartTimer != null) {
                this.inertiaStartTimer.cancel();
                this.inertiaStartTimer = null;
            }
            if (this.inertiaMovementTimer != null) {
                this.inertiaMovementTimer.cancel();
                this.inertiaMovementTimer = null;
            }
        }

        public void startTiltWithReferenceOrientation(Quaternion refSatRotation) {
            if (this.tilter == null) {
                this.tilter = new Tilter();
            }
            this.tilter.start(refSatRotation);
        }

        public void stopTilt() {
            if (this.tilter != null) {
                this.tilter.stop();
            }
        }

        public class Tilter {
            private boolean running = false;
            private Quaternion correctedRefSatRotation;

            public void start(Quaternion refSatRotation) {
                if (this.running) {
                    return;
                }
                this.correctedRefSatRotation = SatelliteDrawingAreaAdapter.this.satelliteRotationCorrection(refSatRotation);
                ThreePerpendicularAxes refAxes = MathUtils.getQuaternionAxes(this.correctedRefSatRotation);
                this.running = true;
                System.out.println("starting tilt with refAxes=" + refAxes.toString());
            }

            public void stop() {
                if (!this.running) {
                    return;
                }
                this.running = false;
                System.out.println("stopp tilt");
            }

            public void reset() {
                SatelliteDrawingAreaAdapter.this.hyve.setTiltAngleAnimated(0.0f, 200);
            }
        }
    }

    private class AnimationPlayer
    implements Animator {
        private AnimationTrigger trigger;

        public AnimationPlayer(AnimationTrigger trigger) {
            this.trigger = trigger;
        }

        @Override
        public void playAnimation(String channel, Animation animation) {
        }
    }

    public static enum PairingDirection {
        DrawingAreaIsLeading,
        SatelliteIsLeading;

    }

    private class DrawingAreaRotator {
        private float angle = 0.0f;
        private float refAngle = 0.0f;

        private DrawingAreaRotator() {
        }

        public void feed(OrbitMessage orbitMsg) {
            switch (orbitMsg.getPhase()) {
                case INTERACTION_BEGIN: 
                case INTERACTION_RESTART: {
                    this.setup();
                    break;
                }
                case INTERACTION_END: {
                    this.cleanup();
                    break;
                }
                case INTERACTION_ONGOING: {
                    System.out.println(String.format("angle = %.2f\u00b0", Float.valueOf(orbitMsg.getAngleRad() * 57.295776f)));
                    this.setAngle(orbitMsg.getAngleRad());
                }
            }
        }

        private void setAngle(float angleRad) {
            this.angle = this.refAngle + angleRad;
        }

        public float getAngleRad() {
            return this.angle;
        }

        public void restart() {
            System.out.println("restart in " + this + " was called !");
            this.refAngle = 0.0f;
            this.angle = 0.0f;
        }

        private void setup() {
            this.refAngle = this.getAngleRad();
        }

        private void cleanup() {
            System.out.println("cleanup in " + this + " was called !");
        }
    }

    private class PullAnimator
    implements Runnable {
        private long starttime;
        private long finishtime;
        private Animation animation;
        private long sleepmillis;
        private boolean canceled = false;

        public String toString() {
            return "Animator [starttime=" + this.starttime + ", finishtime=" + this.finishtime + ", animation=" + this.animation + ", sleepmillis=" + this.sleepmillis + ", canceled=" + this.canceled + "]";
        }

        public PullAnimator(Animation ani) {
            this.animation = ani;
            this.sleepmillis = 40L;
        }

        public void perform() {
            this.starttime = System.currentTimeMillis();
            this.finishtime = this.starttime + this.animation.getDurationInMilliseconds();
            Thread t = new Thread(this);
            t.start();
        }

        @Override
        public void run() {
            this.animation.prepare();
            boolean interrupted = false;
            boolean sent1f = false;
            long current = System.currentTimeMillis();
            float currentF = 0.0f;
            float durationF = this.animation.getDurationInMilliseconds();
            while (current < this.finishtime) {
                if (this.canceled) {
                    return;
                }
                current = System.currentTimeMillis();
                currentF = current - this.starttime;
                float t = Math.min(1.0f, Interpolation.inttrf(currentF, 0.0f, durationF, 0.0f, 1.0f));
                this.animation.step(t);
                if (t == 1.0f) {
                    sent1f = true;
                }
                try {
                    Thread.sleep(this.sleepmillis);
                }
                catch (InterruptedException e) {
                    this.animation.cancel();
                    interrupted = true;
                }
            }
            if (!interrupted) {
                if (!sent1f) {
                    this.animation.step(1.0f);
                }
                this.animation.cleanup();
            }
        }

        public void cancel() {
            this.canceled = true;
            this.animation.cleanup();
        }
    }

    private static class SelectionExecutor
    extends AbstractCommandExecutor {
        private SatelliteDrawingAreaAdapter satDAadapter;
        private SelectionCommand cmd;
        private DrawingArea drawingarea;

        public SelectionExecutor(SatelliteDrawingAreaAdapter satelliteDrawingAreaAdapter, SelectionCommand cmd, DrawingArea drawingArea) {
            this.satDAadapter = satelliteDrawingAreaAdapter;
            this.cmd = cmd;
            this.drawingarea = drawingArea;
        }

        @Override
        public void execute() {
            TransformerState trfState;
            if (this.isExecuted()) {
                return;
            }
            this.setIsExecuted(true);
            switch (this.cmd.getSelectionModificationMode()) {
                case ADDSTROKE: {
                    this.satDAadapter.selector.add(this.cmd.getIds());
                    break;
                }
                default: {
                    this.satDAadapter.selector.remove(this.cmd.getIds());
                }
            }
            if (this.drawingarea != null && (trfState = this.cmd.getTrfStateAfter()) instanceof DrawingAreaTransformerState) {
                DrawingAreaTransformerState dastate = (DrawingAreaTransformerState)trfState;
                this.drawingarea.setTransformation(dastate.getTransformation());
                this.drawingarea.setFrame(dastate.getFrame());
            }
            this.update();
        }

        @Override
        public void undo() {
            TransformerState trfState;
            if (!this.isExecuted()) {
                return;
            }
            this.setIsExecuted(false);
            switch (this.cmd.getSelectionModificationMode()) {
                case ADDSTROKE: {
                    this.satDAadapter.selector.remove(this.cmd.getIds());
                    break;
                }
                default: {
                    this.satDAadapter.selector.add(this.cmd.getIds());
                }
            }
            if (this.drawingarea != null && (trfState = this.cmd.getTrfStateBefore()) instanceof DrawingAreaTransformerState) {
                DrawingAreaTransformerState dastate = (DrawingAreaTransformerState)trfState;
                this.drawingarea.setTransformation(dastate.getTransformation());
                this.drawingarea.setFrame(dastate.getFrame());
            }
            this.update();
        }

        private void update() {
            System.out.println("Selectionsize = " + this.satDAadapter.selector.getSelected().size());
            if (this.satDAadapter.selector.hasSomethingSelected()) {
                this.satDAadapter.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Editing);
                System.out.println("satDAadapter.satellite.setCurrentMode(SatelliteMode.Editing);");
            } else {
                this.satDAadapter.satellite.setCurrentMode(CommandChangeMode.SatelliteMode.Drawing);
                System.out.println("satDAadapter.satellite.setCurrentMode(SatelliteMode.Drawing);");
            }
        }
    }

    public static enum DrawingAreaPlaceMentOption {
        DoNothing,
        SnapToVerticalOrHorizontalPlane;

    }

    public class AcceleratedMovement {
        private boolean calculated = false;
        private Vector3f avgStep = Vector3f.ZERO;
        private Vector3f firstStep = Vector3f.ZERO;
        private Vector3f lastStep = Vector3f.ZERO;
        private float totaldistance = 0.0f;
        private float averageVelocity = 0.0f;
        private float highestVelocity = 0.0f;
        private float highestAcceleration = 0.0f;
        private List<Vector3f> directions = new ArrayList<Vector3f>();
        private List<Float> timeDeltas = new ArrayList<Float>();
        private List<Float> velocities = new ArrayList<Float>();
        private List<Float> accelerations = new ArrayList<Float>();
        private float mindeltaTime = 5.0f;

        public String toString() {
            String s = String.format("AcceleratedMovement: totaldistance=%.4f averageVelocity=%.4f highestVelocity=%.4f highestAcceleration=%.4f averageDirection=%s", Float.valueOf(this.getTotalDistance()), Float.valueOf(this.getAverageVelocity()), Float.valueOf(this.getHighestVelocity()), Float.valueOf(this.getHighestAcceleration()), this.getAverageDirection().toString());
            return s;
        }

        public void add(Vector3f direction, float deltaTime) {
            this.calculated = false;
            if (deltaTime < this.mindeltaTime && !this.directions.isEmpty()) {
                int lastindex = this.directions.size() - 1;
                this.directions.set(lastindex, this.directions.get(lastindex).addLocal(direction));
                this.timeDeltas.set(lastindex, Float.valueOf(this.timeDeltas.get(lastindex).floatValue() + deltaTime));
            } else {
                this.directions.add(direction);
                this.timeDeltas.add(Float.valueOf(deltaTime));
            }
        }

        public float getTotalDistance() {
            if (!this.calculated) {
                this.calculateDynamics();
            }
            return this.totaldistance;
        }

        public Vector3f getAverageDirection() {
            if (!this.calculated) {
                this.calculateDynamics();
            }
            return this.avgStep;
        }

        public Vector3f getLastDirection() {
            if (!this.calculated) {
                this.calculateDynamics();
            }
            return this.lastStep;
        }

        public Vector3f getFirstStep() {
            if (!this.calculated) {
                this.calculateDynamics();
            }
            return this.firstStep;
        }

        public float getAverageVelocity() {
            if (!this.calculated) {
                this.calculateDynamics();
            }
            return this.averageVelocity;
        }

        public float getHighestVelocity() {
            if (!this.calculated) {
                this.calculateDynamics();
            }
            return this.highestVelocity;
        }

        public float getHighestAcceleration() {
            if (!this.calculated) {
                this.calculateDynamics();
            }
            return this.highestAcceleration;
        }

        private void calculateDynamics() {
            this.calculated = true;
            this.avgStep = Vector3f.ZERO;
            this.firstStep = Vector3f.ZERO;
            this.lastStep = Vector3f.ZERO;
            this.totaldistance = 0.0f;
            this.velocities.clear();
            this.accelerations.clear();
            this.averageVelocity = 0.0f;
            this.highestVelocity = 0.0f;
            this.highestAcceleration = 0.0f;
            for (int i = 0; i < this.directions.size(); ++i) {
                Vector3f way = this.directions.get(i);
                float time = this.timeDeltas.get(i).floatValue();
                float length = way.length();
                this.avgStep.addLocal(way);
                if (i == 0) {
                    this.firstStep = way;
                } else if (i == this.directions.size() - 1) {
                    this.lastStep = way;
                }
                this.totaldistance += way.length();
                this.velocities.add(Float.valueOf(length / time));
            }
            if (!this.directions.isEmpty()) {
                this.avgStep.divideLocal((float)this.directions.size());
            }
            float vsum = 0.0f;
            for (int i = 0; i < this.velocities.size(); ++i) {
                if (i == 0) {
                    this.accelerations.add(Float.valueOf(0.0f));
                } else {
                    float deltav = this.velocities.get(i).floatValue() - this.velocities.get(i - 1).floatValue();
                    float acc = deltav / this.timeDeltas.get(i).floatValue();
                    this.accelerations.add(Float.valueOf(acc));
                    if (this.highestAcceleration < acc) {
                        this.highestAcceleration = acc;
                    }
                }
                float v = this.velocities.get(i).floatValue();
                vsum += v;
                if (!(this.highestVelocity < v)) continue;
                this.highestVelocity = v;
            }
            if (!this.velocities.isEmpty()) {
                this.averageVelocity = vsum / (float)this.velocities.size();
            }
        }

        public boolean hasEnoughData() {
            return this.directions.size() > 4;
        }

        public List<Vector3f> createFutureWaysWithTimeSteps(float timeperStep) {
            ArrayList<Vector3f> result = new ArrayList<Vector3f>();
            Vector3f dir = this.getAverageDirection().normalize();
            float initialVelocity = this.getAverageVelocity();
            float acceleration = this.getHighestAcceleration() > 0.0f ? -0.1f * this.getHighestAcceleration() : -0.01f;
            int i = 0;
            for (float v = initialVelocity; v > 0.0f && i < 100; ++i, v += acceleration * timeperStep) {
                float distance = v * timeperStep;
                Vector3f way = dir.mult(distance);
                result.add(way);
            }
            return result;
        }
    }

    private class NavigationEvent {
        public Long time;
        public Vector3f direction;
        public boolean sent = false;

        private NavigationEvent() {
        }

        public String toString() {
            return String.format("t=%s sent=%s dir=%s", this.time == null ? "null" : String.valueOf(this.time), String.valueOf(this.sent), this.direction == null ? "null" : String.valueOf(this.direction));
        }
    }
}

