/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.inputdevice.spacemouse;

import com.hybridlab.hyve3d.inputdevice.InputDevice;
import com.hybridlab.hyve3d.inputdevice.InputListener;
import com.hybridlab.hyve3d.inputdevice.spacemouse.SpaceMouseInputData;
import com.hybridlab.hyve3d.network.messages.SpaceMouseMessage;
import com.hybridlab.hyve3d.network.spacemouse.SpaceMouseTcpSocketConnectionListener;
import com.hybridlab.hyve3d.network.spacemouse.SpaceMouseValueTCPSocketConnection;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class TCPSpaceMouse
extends InputDevice
implements SpaceMouseTcpSocketConnectionListener.SpaceMouseMessageProcessor {
    private SpaceMouseTcpSocketConnectionListener spaceMouseClient;
    private ArrayList<InputListener> listeners = new ArrayList();
    private Thread receiveThread;

    public TCPSpaceMouse(String deviceKey) {
        super(deviceKey);
    }

    @Override
    public void addListener(InputListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(InputListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void removeAll() {
        this.listeners.clear();
    }

    @Override
    public boolean hasListener() {
        return !this.listeners.isEmpty();
    }

    @Override
    public boolean start() {
        boolean printToSystemOut = false;
        SpaceMouseValueTCPSocketConnection smClientConn = new SpaceMouseValueTCPSocketConnection("localhost", 5858, printToSystemOut);
        try {
            smClientConn.connect();
            this.spaceMouseClient = new SpaceMouseTcpSocketConnectionListener(smClientConn);
            this.spaceMouseClient.addProcessor(this);
            this.receiveThread = new Thread(this.spaceMouseClient);
            this.receiveThread.start();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean stop() {
        this.spaceMouseClient.stop();
        if (!this.receiveThread.isInterrupted()) {
            this.receiveThread.interrupt();
        }
        return true;
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public void onMessageReceived(SpaceMouseMessage message) {
        SpaceMouseInputData data = new SpaceMouseInputData(this, message.getTranslation(), message.getRotation(), message.getButtonstate());
        for (InputListener listener : this.listeners) {
            listener.onReceiveInput(data);
        }
    }
}

