/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetUtils {
    public static List<String> scanForLocalInetAdresses() {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        try {
            System.setProperty("java.net.preferIPv4Stack", "true");
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface netInterface = networks.nextElement();
                if (netInterface.isLoopback() || netInterface.isPointToPoint()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    String hostaddress = address.getHostAddress();
                    Logger.getLogger(NetUtils.class.getSimpleName()).log(Level.INFO, "network address: " + hostaddress);
                    ipAddresses.add(hostaddress);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ipAddresses;
    }

    static String getMYIP() {
        String n = null;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            n = ip.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return n;
    }

    public static void searchPeers() {
        String myIPv4 = NetUtils.scanForLocalInetAdresses().get(0);
        String[] parts = myIPv4.split("\\.");
        String subnetIP = parts[0] + "." + parts[1] + "." + parts[2] + ".";
        int myself = Integer.valueOf(parts[3]);
        for (int i = 1; i < 255; ++i) {
            if (i == myself) continue;
            try {
                String n = subnetIP + i;
                Logger.getLogger(NetUtils.class.getSimpleName()).log(Level.INFO, "peers: " + n);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

