/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ResourceProvider {
    private String address;
    private int port;
    private static final String jpeg_type_url_identifier = "jpeg";
    private static final String png_type_url_identifier = "png";
    private Map<String, Resource> resources = new HashMap<String, Resource>();
    private Map<String, String> oldResourceURLS = new HashMap<String, String>();
    private Map<String, String> urlNameMap = new HashMap<String, String>();
    private Server server;
    private Thread serverThread;
    private String serviceName = "ResourceProvider";
    private static ResourceProvider instance;
    private Set<ResourceProviderListener> listener = new HashSet<ResourceProviderListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(String ... resourceids) {
        Map<String, Resource> map = this.resources;
        synchronized (map) {
            for (String id : resourceids) {
                Resource b = this.resources.remove(id);
                System.out.println("ResourceProvider: forgetting " + id + " (" + b.type + ") with " + b.bytes.length + " bytes");
                this.urlNameMap.remove(this.getUrlForResource(id));
            }
            for (ResourceProviderListener l : this.listener) {
                l.onResourcesRemoved(this, resourceids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImagePng(String imageName, byte[] data) {
        Map<String, Resource> map = this.resources;
        synchronized (map) {
            Resource pngimage = new Resource();
            pngimage.type = ResourceType.PNG_IMAGE;
            pngimage.name = imageName;
            pngimage.bytes = data;
            this.resources.put(imageName, pngimage);
            this.oldResourceURLS.put(imageName, this.getUrlForResource(imageName));
            this.urlNameMap.put(this.getUrlForResource(imageName), imageName);
            for (ResourceProviderListener l : this.listener) {
                l.onResourceAdded(this, imageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageJpeg(String imageName, byte[] data) {
        Map<String, Resource> map = this.resources;
        synchronized (map) {
            Resource jpegimage = new Resource();
            jpegimage.type = ResourceType.JPEG_IMAGE;
            jpegimage.name = imageName;
            jpegimage.bytes = data;
            this.resources.put(imageName, jpegimage);
            this.oldResourceURLS.put(imageName, this.getUrlForResource(imageName));
            this.urlNameMap.put(this.getUrlForResource(imageName), imageName);
            for (ResourceProviderListener l : this.listener) {
                l.onResourceAdded(this, imageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResourceForURL(String surl) {
        String name = this.urlNameMap.get(surl);
        Map<String, Resource> map = this.resources;
        synchronized (map) {
            Resource r = this.resources.get(name);
            if (r != null) {
                return r.bytes;
            }
            return new byte[0];
        }
    }

    public String getUrlForResource(String resourceName) {
        Resource r = this.resources.get(resourceName);
        if (r == null) {
            return this.oldResourceURLS.get(resourceName);
        }
        String type = "UndefinedType";
        switch (r.type) {
            case JPEG_IMAGE: {
                type = jpeg_type_url_identifier;
                break;
            }
            case PNG_IMAGE: {
                type = png_type_url_identifier;
            }
        }
        String url = String.format("http://%s:%d/%s/%s", this.address, this.port, type, r.name);
        return url;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() throws UnknownHostException {
        String address = InetAddress.getLocalHost().getHostAddress();
        this.start(address, 8910);
    }

    public void start(String address, int port) {
        this.address = address;
        this.port = port;
        MyCustomHandler handler = new MyCustomHandler();
        this.server = new Server(this.port);
        this.server.setHandler((Handler)handler);
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ResourceProvider.this.server.start();
                    ResourceProvider.this.server.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "ResourceProvider Jetty Server Thread");
        this.serverThread.start();
    }

    public String getServiceIdentifier() {
        return this.serviceName;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public static void setInstance(ResourceProvider resourceProvider) {
        instance = resourceProvider;
    }

    public static ResourceProvider get() {
        if (instance == null) {
            throw new RuntimeException("Access to ResourceProvider before proper creation!");
        }
        return instance;
    }

    public void addListener(ResourceProviderListener l) {
        this.listener.add(l);
    }

    private class Resource {
        public byte[] bytes;
        public ResourceType type;
        public String name;

        private Resource() {
        }

        private Resource getCopy() {
            Resource copy = new Resource();
            copy.bytes = Arrays.copyOf(this.bytes, this.bytes.length);
            copy.name = this.name;
            copy.type = this.type;
            return copy;
        }
    }

    private static enum ResourceType {
        JPEG_IMAGE,
        PNG_IMAGE;

    }

    public static interface ResourceProviderListener {
        public void onResourcesRemoved(ResourceProvider var1, String[] var2);

        public void onResourceAdded(ResourceProvider var1, String var2);
    }

    private class MyCustomHandler
    extends AbstractHandler {
        private MyCustomHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String[] items = StringUtils.split(target, "/");
            if (items.length == 2) {
                String type = items[0];
                String id = items[1];
                if (id != null && id.length() > 0) {
                    Resource copiedResource = null;
                    Map<String, Resource> map = ResourceProvider.this.resources;
                    synchronized (map) {
                        Resource resource = ResourceProvider.this.resources.get(id);
                        if (resource != null) {
                            copiedResource = resource.getCopy();
                        }
                    }
                    if (copiedResource == null) {
                        response.setStatus(404);
                    } else {
                        switch (copiedResource.type) {
                            case JPEG_IMAGE: {
                                byte[] data;
                                if (ResourceProvider.jpeg_type_url_identifier.equals(type)) {
                                    response.setContentType("image/jpeg;");
                                    data = copiedResource.bytes;
                                    response.setStatus(200);
                                    response.setContentLength(data.length);
                                    response.getOutputStream().write(data);
                                    break;
                                }
                                response.setStatus(415);
                                break;
                            }
                            case PNG_IMAGE: {
                                byte[] data;
                                if (ResourceProvider.png_type_url_identifier.equals(type)) {
                                    response.setContentType("image/png;");
                                    data = copiedResource.bytes;
                                    response.setStatus(200);
                                    response.setContentLength(data.length);
                                    response.getOutputStream().write(data);
                                    break;
                                }
                                response.setStatus(415);
                            }
                        }
                    }
                    baseRequest.setHandled(true);
                    response.flushBuffer();
                }
            }
        }
    }
}

