/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.discovery;

import com.hybridlab.hyve3d.network.discovery.DiscoveryClientThread;
import com.hybridlab.hyve3d.network.messages.ServiceRequestAnswerMessage;
import flexjson.JSONDeserializer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Logger;

class DiscoveryClientHandleIncomingMessagesThread
extends Thread {
    private DatagramSocket receiveSocket = null;
    private int timeout = 4000;
    private byte[] inBuf = new byte[1024];
    private static final Logger logger = Logger.getLogger(DiscoveryClientHandleIncomingMessagesThread.class.getName());
    private DiscoveryClientThread discoveryThread = null;

    DiscoveryClientHandleIncomingMessagesThread(DiscoveryClientThread discoveryThread, DatagramSocket receiveSocket) {
        this.receiveSocket = receiveSocket;
        this.discoveryThread = discoveryThread;
    }

    @Override
    public void run() {
        try {
            this.receiveSocket.setSoTimeout(this.timeout);
            boolean loop = true;
            while (loop) {
                DatagramPacket inPacket = new DatagramPacket(this.inBuf, this.inBuf.length);
                try {
                    this.receiveSocket.receive(inPacket);
                    String msg = new String(this.inBuf, 0, inPacket.getLength());
                    logger.info(msg);
                    ServiceRequestAnswerMessage answer = (ServiceRequestAnswerMessage)new JSONDeserializer().deserialize(msg, ServiceRequestAnswerMessage.class);
                    this.discoveryThread.addServices(answer.getServices());
                }
                catch (SocketTimeoutException e) {
                    loop = false;
                }
                catch (IOException e) {
                    loop = false;
                }
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
    }
}

