/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.hydratest;

import com.jme3.math.Vector3f;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class HydraUDPClient
implements Runnable {
    List<HydraValueReceiver> receivers = new ArrayList<HydraValueReceiver>();
    DatagramSocket clientSocket;
    byte[] receiveData = new byte[2400];
    boolean running = false;
    int listenPort = 7777;
    DatagramPacket receivePacket = new DatagramPacket(this.receiveData, this.receiveData.length);

    public HydraUDPClient(int listenPort) {
        this.listenPort = listenPort;
        try {
            this.clientSocket = new DatagramSocket(this.listenPort);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void addValueReceiver(HydraValueReceiver r) {
        this.receivers.add(r);
    }

    void start() {
        this.running = true;
        while (this.running) {
            try {
                this.clientSocket.receive(this.receivePacket);
                try {
                    ByteBuffer msgBuffer = ByteBuffer.wrap(this.receivePacket.getData());
                    float p1x = msgBuffer.getFloat();
                    float p1y = msgBuffer.getFloat();
                    float p1z = msgBuffer.getFloat();
                    float p2x = msgBuffer.getFloat();
                    float p2y = msgBuffer.getFloat();
                    float p2z = msgBuffer.getFloat();
                    Vector3f p1 = new Vector3f(p1x, p1y, -p1z);
                    Vector3f p2 = new Vector3f(p2x, p2y, -p2z);
                    if (this.receivers.isEmpty()) {
                        System.out.println(String.format("%s %s", p1, p2));
                        continue;
                    }
                    for (HydraValueReceiver r : this.receivers) {
                        HydraValuePackage p = new HydraValuePackage();
                        p.posA = p1;
                        p.posB = p2;
                        r.onHydraValues(p);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        this.running = false;
        this.clientSocket.close();
    }

    @Override
    public void run() {
        this.start();
    }

    public static interface HydraValueReceiver {
        public void onHydraValues(HydraValuePackage var1);
    }

    public class HydraValuePackage {
        public Vector3f posA;
        public Vector3f posB;
    }
}

