/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection;

import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.jme3.Stroke3DSelectionAndTransformationGroup;
import com.hybridlab.hyve3d.network.interconnection.HisSceneMemento;
import com.hybridlab.hyve3d.scenes.StaticSceneElementState;
import com.jme3.math.Vector3f;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;

public interface HisScene {
    public void adaptTo(HisScene var1);

    public void addStroke(Stroke3D var1);

    public Collection<Stroke3D> getAllStrokes();

    public void addStrokePoint(UUID var1, Stroke3DPoint var2, Set<SceneObserver> var3);

    public void eraseStroke(UUID var1, Set<SceneObserver> var2);

    public void setStrokeVisibility(UUID var1, Boolean var2, Set<SceneObserver> var3);

    public void setStrokeStrokeAnchorPoint(UUID var1, Vector3f var2);

    public void addSceneObserver(SceneObserver var1);

    public void removeSceneObserver(SceneObserver var1);

    public HisSceneMemento getMemento();

    public void adaptTo(HisSceneMemento var1);

    public Set<His3DCanvas> getAllCanvases();

    public His3DCanvas createNewEmpty3dCanvas();

    public void setStaticSceneElementState(StaticSceneElementState var1);

    public StaticSceneElementState getStaticSceneElementState(StaticSceneElementState.Element var1);

    public static interface SceneObserver {
        public void onStartedObservation(HisScene var1);

        public void onStoppedObservation(HisScene var1);

        public void onStrokeAdded(HisScene var1, Stroke3D var2);

        public void onStrokeFinished(HisScene var1, UUID var2);

        public void onStrokeErased(HisScene var1, UUID var2);

        public void onStrokeVisibilityChanged(HisScene var1, UUID var2, boolean var3);

        public void onStrokeMoved(HisScene var1, UUID var2, Vector3f var3);

        public void onStrokePointAdded(HisScene var1, UUID var2, Stroke3DPoint var3, Set<SceneObserver> var4);

        public void onStaticSceneElementStateHasChanged(HisScene var1, StaticSceneElementState var2);

        public void onSelectionAndTransformationGroupCreated(HisScene var1, Stroke3DSelectionAndTransformationGroup var2);

        public void onSelectionAndTransformationGroupCleared(HisScene var1, Stroke3DSelectionAndTransformationGroup var2);
    }
}

