/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection;

import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.InternetReachableHubNodeAdress;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.LocalHubNodeAdress;
import java.util.HashSet;
import java.util.Set;

public class HubConnector {
    public static final String HYBRIDLAB_SERVER = "132.207.191.249";
    public static final String SERVER_MICHA = "5.35.247.124";
    public static final String BLUENOSE_INTERN = "bluenose.intern";
    public static final String BLUENOSE = "192.168.66.184";
    public static final String BOOKY = "212.122.58.242";
    public static final String ROCKY = "10.0.1.27";
    public static final String immerwind = "10.0.1.8";
    public Set<HubNodeAddress> nodeAdresses = new HashSet<HubNodeAddress>();

    public void addAdressOfLocalHubNode(HubNode localHubNode) {
        this.nodeAdresses.add(new LocalHubNodeAdress(localHubNode));
    }

    public void addAddress(InternetReachableHubNodeAdress adress) {
        for (HubNodeAddress a : this.nodeAdresses) {
            if (!a.equals(adress)) continue;
            return;
        }
        this.nodeAdresses.add(adress);
    }

    public void removeAdress(HubNodeAddress adressToRemove) {
        this.nodeAdresses.remove(adressToRemove);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HubNodeAddress a : this.nodeAdresses) {
            sb.append(" + " + a.toString() + "\n");
        }
        return String.format("HubConnector %s with the following nodeAdresses:\n %s", this.hashCode(), sb.toString().trim());
    }

    public HubConnector clone() {
        HubConnector c = new HubConnector();
        c.nodeAdresses = new HashSet<HubNodeAddress>();
        c.nodeAdresses.addAll(this.nodeAdresses);
        return c;
    }

    public HubConnector removeLocalAddresses() {
        HashSet<HubNodeAddress> nodeAdressesCopy = new HashSet<HubNodeAddress>();
        for (HubNodeAddress a : this.nodeAdresses) {
            if (a instanceof LocalHubNodeAdress) continue;
            nodeAdressesCopy.add(a);
        }
        this.nodeAdresses = nodeAdressesCopy;
        return this;
    }
}

