/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection;

import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.HubNodeInfo;
import com.hybridlab.hyve3d.data.synch.SessionSynchConnection;
import com.hybridlab.hyve3d.data.synch.SessionSynchConnectionEndPoint;
import com.hybridlab.hyve3d.data.synch.SynchronizationProgressTracer;
import com.hybridlab.hyve3d.data.synch.exceptions.ConcurrentAddException;
import com.hybridlab.hyve3d.data.synch.messages.ChunkedSynchMessage;
import com.hybridlab.hyve3d.data.synch.messages.NewDataModelSessionSynchMessage;
import com.hybridlab.hyve3d.data.synch.messages.RequestSynchCompleteMessage;
import com.hybridlab.hyve3d.data.synch.messages.SynchCompleteMessage;
import com.hybridlab.hyve3d.data.synch.messages.SynchMessage;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubConnector;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.InterconnectivityDataModel;
import com.hybridlab.hyve3d.network.interconnection.implementations.SpiderMonkeyHubConnection;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.InternetReachableHubNodeAdress;
import com.hybridlab.hyve3d.network.interconnection.messages.SessionSynchMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class HubNode
implements SessionSynchConnectionEndPoint {
    private Logger logger = Logger.getLogger("de.codemacher.his.jolly.network.interconnection");
    private HubConnector myConnector;
    private UUID id;
    private String descriptiveName = "unnamed HubNode";
    private Map<UUID, Set<HubConnection>> sessionHostingHubConnections = new HashMap<UUID, Set<HubConnection>>();
    private Map<UUID, SessionSynchConnection> sessionSynchConnections = new HashMap<UUID, SessionSynchConnection>();
    private Set<UUID> sessionIds = new HashSet<UUID>();
    private Map<UUID, SessionInfo> sessionInfos = new HashMap<UUID, SessionInfo>();
    private Set<HubConnection> hubconnections = new HashSet<HubConnection>();
    private Map<UUID, UUID> sessionLeadingHubNodes = new HashMap<UUID, UUID>();
    private HubNodeHost host;
    private InterconnectivityDataModel dm = new InterconnectivityDataModel();
    Map<HubConnection, HyveNetworking.ConnectionEstablishListener> connectionEstablishedListener = new HashMap<HubConnection, HyveNetworking.ConnectionEstablishListener>();
    Map<HubNodeAddress, HubConnection> connectedTargets = new HashMap<HubNodeAddress, HubConnection>();
    private Map<UUID, ChunkBuffer> chunkbuffers = new HashMap<UUID, ChunkBuffer>();
    private boolean useUDP = true;

    public HubNode() {
        this(UUID.randomUUID());
    }

    public HubNode(UUID id) {
        this.myConnector = new HubConnector();
        this.myConnector.addAdressOfLocalHubNode(this);
        this.id = id;
        HubNodeInfo info = new HubNodeInfo(id);
        info.setDescriptiveName(this.getDescription());
        if (this.host != null) {
            info.setAddress(this.host.getAddress());
        }
        try {
            this.dm.add(info);
        }
        catch (ConcurrentAddException concurrentAddException) {
            // empty catch block
        }
    }

    public UUID getId() {
        return this.id;
    }

    public InterconnectivityDataModel getInterConnectivityDataModel() {
        return this.dm;
    }

    public String toString() {
        return String.format("HubNode [descriptiveName=%s, id=%s hashCode()=%s]", this.descriptiveName, this.id.toString(), this.hashCode());
    }

    public void setDescription(String descriptiveName) {
        this.descriptiveName = descriptiveName;
    }

    public String getDescription() {
        return this.descriptiveName;
    }

    public void disConnect(HyveNetworking.ConnectionEstablishListener l) {
        HubConnection conn = null;
        if (this.connectionEstablishedListener.values().contains(l)) {
            for (Map.Entry<HubConnection, HyveNetworking.ConnectionEstablishListener> es : this.connectionEstablishedListener.entrySet()) {
                if (!l.equals(es.getValue())) continue;
                conn = es.getKey();
                break;
            }
        }
        if (conn != null) {
            conn.disConnect();
        }
    }

    public HubConnection connectTo(HubNodeAddress targetHubNodeAdress, SynchronizationProgressTracer tracer, HyveNetworking.ConnectionEstablishListener establishListener) throws Exception {
        if (this.hasConnectionTo(targetHubNodeAdress)) {
            throw new Exception("Hubnode " + this + " is already connected to " + targetHubNodeAdress);
        }
        HubConnection c = null;
        if (targetHubNodeAdress instanceof InternetReachableHubNodeAdress) {
            InternetReachableHubNodeAdress address = (InternetReachableHubNodeAdress)targetHubNodeAdress;
            c = new SpiderMonkeyHubConnection(address, this, tracer);
        }
        try {
            c.establish();
            this.addConnectedAddress(targetHubNodeAdress, c);
            this.connectionEstablishedListener.put(c, establishListener);
            establishListener.onConnectionEstablished(targetHubNodeAdress);
            return c;
        }
        catch (ConnectException e) {
            establishListener.onConnectionFailed(e.getMessage(), targetHubNodeAdress.describe());
            throw e;
        }
        catch (IOException e) {
            establishListener.onConnectionFailed(e.getMessage(), targetHubNodeAdress.describe());
            throw e;
        }
        catch (Exception e) {
            establishListener.onConnectionFailed(e.getMessage(), targetHubNodeAdress.describe());
            throw e;
        }
    }

    private void addConnectedAddress(HubNodeAddress targetHubNodeAdress, HubConnection c) {
        this.connectedTargets.put(targetHubNodeAdress, c);
    }

    private boolean hasConnectionTo(HubNodeAddress targetHubNodeAdress) {
        return this.connectedTargets.containsKey(targetHubNodeAdress);
    }

    public HubConnector getConnector() {
        return this.myConnector;
    }

    public void setHost(HubNodeHost host) {
        this.host = host;
    }

    public boolean isHostingNode() {
        return this.host != null && this.host.isAccepting();
    }

    public void onConnectionRemoved(HubConnection removed) {
        boolean wasInList = this.hubconnections.remove(removed);
        this.logger.info("HubConnection was removed from HubNode.\n    (" + (wasInList ? "was" : "was NOT") + " in connection list before)\n  HubNode:" + this.toString() + "\n  HubConnection: " + removed.toString());
        this.connectedTargets.values().remove(removed);
        for (Set<HubConnection> ccc : this.sessionHostingHubConnections.values()) {
            ccc.remove(removed);
        }
        UUID remoteNodeId = removed.getRemoteHubNodeId();
        Set<HubNodeInfo> allInfos = this.dm.getAllHubNodeInfos();
        HashSet<HubNodeInfo> toBeRemoved = new HashSet<HubNodeInfo>();
        for (HubNodeInfo i : allInfos) {
            if (!i.getId().equals(remoteNodeId)) continue;
            toBeRemoved.add(i);
        }
        for (HubNodeInfo d : toBeRemoved) {
            this.dm.remove(d);
        }
        HyveNetworking.ConnectionEstablishListener listener = this.connectionEstablishedListener.remove(removed);
        if (listener != null) {
            listener.onConnectionLost(removed);
        }
    }

    public void onNewConnection(HubConnection c) {
        this.hubconnections.add(c);
        this.logger.info("HubNode accepted HubConnection.\n  HubNode:" + this.toString() + "\n  HubConnection: " + c.toString());
        this.broadCastNewNodeInHubEvent();
    }

    public boolean isConnectedToHub() {
        for (HubConnection c : this.hubconnections) {
            if (!c.isConnected()) continue;
            this.logger.info("isConnectedToHub() == true (" + c.toString() + ")");
            return true;
        }
        this.logger.info("isConnectedToHub() == false (hubconnections " + String.valueOf(this.hubconnections.size()) + ")");
        return false;
    }

    public Set<SessionInfo> getSessionInfos() {
        HashSet<SessionInfo> i = new HashSet<SessionInfo>(this.sessionInfos.values());
        return i;
    }

    public Set<UUID> getSessionIds() {
        return new HashSet<UUID>(this.sessionIds);
    }

    public Set<UUID> getSessionIdsOfLeadedSession() {
        HashSet<UUID> leaded = new HashSet<UUID>();
        return leaded;
    }

    public void addToRemoteSessionHostingInformation(HubConnection hubConnection, UUID hubNodeId, SessionInfo newsession) {
        Set<HubConnection> hoster = this.sessionHostingHubConnections.get(newsession.id);
        if (null == hoster) {
            hoster = new HashSet<HubConnection>();
            this.sessionHostingHubConnections.put(newsession.id, hoster);
        }
        hoster.add(hubConnection);
        HubNodeInfo info = this.dm.getWithID(hubNodeId.toString(), HubNodeInfo.class);
        if (info != null) {
            info.addSession(newsession);
        }
    }

    public void storeRemoteSessionHostingInformation(HubConnection hubConnection, Set<SessionInfo> sessionsOfRemoteHubNode, Set<UUID> sessionIdsOfRemoteLeadedSessions, UUID hubNodeId) {
        for (SessionInfo sessionInfo : sessionsOfRemoteHubNode) {
            UUID remoteSessionId = sessionInfo.id;
            Set<HubConnection> hoster = this.sessionHostingHubConnections.get(remoteSessionId);
            if (null == hoster) {
                hoster = new HashSet<HubConnection>();
                this.sessionHostingHubConnections.put(remoteSessionId, hoster);
            }
            HashSet<HubConnection> oldConnections = new HashSet<HubConnection>();
            for (HubConnection c : hoster) {
                if (c.getRemoteHubNodeId() == null || !c.getRemoteHubNodeId().equals(hubConnection.getRemoteHubNodeId())) continue;
                oldConnections.add(c);
                this.logger.info("dismissing old HubConnection: " + c.toString() + " which was connected to HubNode with id=" + c.getRemoteHubNodeId().toString());
            }
            hoster.removeAll(oldConnections);
            hoster.add(hubConnection);
        }
        for (UUID uUID : sessionIdsOfRemoteLeadedSessions) {
            this.sessionLeadingHubNodes.put(uUID, hubConnection.getRemoteHubNodeId());
        }
        if (hubNodeId != null) {
            HubNodeInfo info = new HubNodeInfo(hubNodeId);
            try {
                this.dm.add(info);
                for (SessionInfo remotesid : sessionsOfRemoteHubNode) {
                    info.addSession(remotesid);
                }
            }
            catch (ConcurrentAddException concurrentAddException) {
                concurrentAddException.printStackTrace();
            }
        }
    }

    private void broadCastNewNodeInHubEvent() {
        for (HubConnection c : this.hubconnections) {
            c.sendNewNodeInHubMessage();
        }
    }

    private void broadCastNewSessionInNodeEvent(SessionInfo sessioninfo) {
        for (HubConnection c : this.hubconnections) {
            c.sendNewSessionInNodeEvent(sessioninfo);
        }
    }

    public void sendSynchMessage(Session session, SessionSynchMessage m) {
        Set<HubConnection> l = this.sessionHostingHubConnections.get(session.getId());
        if (l != null) {
            if (l.isEmpty()) {
                this.logger.severe("sessionHostingHubConnections is empty ! - message will not be sent! \n  Session: " + session + "\n  Message: " + m);
            }
            for (HubConnection conn : l) {
                conn.sendSynchMessage(m);
            }
        }
    }

    public void setUseUDP(boolean useUDP) {
        this.useUDP = useUDP;
        this.logger.info("useUDP = " + useUDP + " in " + this);
    }

    private synchronized ChunkBuffer getChunkBuffer(UUID messageid) {
        ChunkBuffer b = this.chunkbuffers.get(messageid);
        if (b == null) {
            b = new ChunkBuffer(messageid);
            this.chunkbuffers.put(messageid, b);
        }
        return b;
    }

    public void onSessionSynchMessageReceived(HubConnection connection, SessionSynchMessage message) {
        SessionSynchConnection conn = this.sessionSynchConnections.get(message.getSessionId());
        if (message instanceof NewDataModelSessionSynchMessage) {
            NewDataModelSessionSynchMessage ndmsm = (NewDataModelSessionSynchMessage)message;
            SynchMessage sm = ndmsm.getInnerMessage();
            this.logger.finest("SessionSynchMessage was reliable: " + message.isReliable() + "\n" + sm.getClass().toString() + "\n" + sm.toString() + "\n\n");
            conn.receive(sm);
        } else if (message instanceof ChunkedSynchMessage) {
            ChunkedSynchMessage cm = (ChunkedSynchMessage)message;
            ChunkBuffer b = this.getChunkBuffer(cm.messageid);
            if (b.isCompleteWithNewChunk(cm)) {
                try {
                    SynchMessage sm = b.getInnerMessage();
                    conn.receive(sm);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Set<HubConnection> l = this.sessionHostingHubConnections.get(message.getSessionId());
        if (l != null) {
            for (HubConnection c : l) {
                if (c.equals(connection)) continue;
                c.sendSynchMessage(message);
            }
        }
    }

    public boolean knowsSession(UUID sessionId) {
        return this.sessionIds.contains(sessionId);
    }

    @Override
    public void relayMessageFromConnection(SynchMessage m, SessionSynchConnection sourceConnection) {
        block10: {
            UUID sid = sourceConnection.getSessionId();
            Set<HubConnection> receivers = this.sessionHostingHubConnections.get(sid);
            if (receivers == null) break block10;
            if (m instanceof SynchCompleteMessage) {
                this.logger.info("relaying SynchCompleteMessage: " + m);
            }
            if (m.getSize() > ChunkedSynchMessage.splitThreshold) {
                ChunkedSynchMessage[] chunkMessages = ChunkedSynchMessage.split(m, sid);
                for (HubConnection r : receivers) {
                    if (!m.getTargetNodes().isEmpty() && !m.getTargetNodes().contains(r.getRemoteHubNodeId().toString())) {
                        this.logger.info("skipped sending of message {" + m + "} to node (" + r.getRemoteHubNodeId() + ") because not in receiver list: " + m.getTargetNodes());
                        continue;
                    }
                    for (ChunkedSynchMessage c : chunkMessages) {
                        r.sendSynchMessage(c);
                    }
                }
            } else {
                NewDataModelSessionSynchMessage ssm = new NewDataModelSessionSynchMessage(sid, m);
                if (this.useUDP) {
                    ssm.setReliable(m.isReliable());
                }
                for (HubConnection r : receivers) {
                    if (!m.getTargetNodes().isEmpty()) {
                        UUID rhnid = r.getRemoteHubNodeId();
                        if (!m.getTargetNodes().contains(rhnid.toString())) {
                            this.logger.info("skipped sending of message {" + m + "} to node (" + r.getRemoteHubNodeId() + ") because not in receiver list: " + m.getTargetNodes());
                            continue;
                        }
                    }
                    r.sendSynchMessage(ssm);
                }
            }
        }
    }

    @Override
    public void addConnection(SessionSynchConnection c) {
        Set<HubConnection> otherHosters;
        SessionInfo si = c.getSessionInfo();
        this.sessionSynchConnections.put(si.id, c);
        this.sessionIds.add(si.id);
        this.sessionInfos.put(si.id, si);
        HubNodeInfo infoAboutMe = this.dm.getWithID(this.id.toString(), HubNodeInfo.class);
        infoAboutMe.addSession(si);
        this.broadCastNewSessionInNodeEvent(si);
        if (c.isModelFollowing() && !(otherHosters = this.sessionHostingHubConnections.get(si.id)).isEmpty()) {
            HubConnection connectionToLeader = otherHosters.iterator().next();
            RequestSynchCompleteMessage r = new RequestSynchCompleteMessage(this.getId().toString());
            connectionToLeader.sendSynchMessage(new NewDataModelSessionSynchMessage(si.id, r));
        }
    }

    public HubNodeHost getHost() {
        return this.host;
    }

    public void sendHostWillRestartOnOtherPortMessage(int port) {
        for (HubConnection c : this.hubconnections) {
            c.sendHostWillRestartOnOtherPortMessage(port);
        }
    }

    private class ChunkBuffer {
        private UUID messageId;
        private ChunkedSynchMessage[] chunks;

        public ChunkBuffer(UUID messageid) {
            this.messageId = messageid;
        }

        private void add(ChunkedSynchMessage cm) {
            if (this.chunks == null) {
                this.chunks = new ChunkedSynchMessage[cm.numchunks];
            }
            this.chunks[cm.chunkid] = cm;
        }

        public boolean isCompleteWithNewChunk(ChunkedSynchMessage cm) {
            if (!cm.messageid.equals(this.messageId)) {
                throw new IllegalArgumentException("ChunkedSynchMessage with wrong MessageUUID found ");
            }
            this.add(cm);
            return this.isComplete();
        }

        private boolean isComplete() {
            for (int i = 0; i < this.chunks.length; ++i) {
                ChunkedSynchMessage c = this.chunks[i];
                if (c != null) continue;
                return false;
            }
            return true;
        }

        public SynchMessage getInnerMessage() throws IllegalArgumentException, Exception {
            if (this.isComplete()) {
                return ChunkedSynchMessage.join(this.chunks);
            }
            return null;
        }
    }
}

