/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection;

import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;

public abstract class HubNodeHost {
    protected HubNodeAddress address;
    protected HubNode ownerHubNode;

    public HubNodeHost(HubNode owner) {
        this.ownerHubNode = owner;
    }

    public abstract void start();

    public abstract void stop();

    protected void onNewHubConnectionEstablished(final HubConnection c) {
        try {
            c.sendHandshakeRequestAndCallAfterAnswer(new Runnable(){

                @Override
                public void run() {
                    HubNodeHost.this.ownerHubNode.onNewConnection(c);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onHubConnectionRemoved(HubConnection removed) {
        this.ownerHubNode.onConnectionRemoved(removed);
    }

    public HubNodeAddress getAddress() {
        return this.address;
    }

    public abstract boolean isAccepting();

    public abstract int getPort();
}

