/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection;

import com.hybridlab.hyve3d.core.AbstractBaseScene;
import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DObserver;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.files.His3dSceneXMLDocument;
import com.hybridlab.hyve3d.network.interconnection.HisScene;
import com.hybridlab.hyve3d.network.interconnection.HisSceneMemento;
import com.hybridlab.hyve3d.network.interconnection.HisStroke;
import com.hybridlab.hyve3d.scenes.StaticSceneElementState;
import com.hybridlab.utils.CompressionUtils;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.xml.sax.SAXException;

public class SessionScene
extends AbstractBaseScene
implements HisScene {
    private Set<HisScene.SceneObserver> sceneObservers = new HashSet<HisScene.SceneObserver>();
    private LinkedHashMap<UUID, Stroke3D> strokes = new LinkedHashMap();
    private Set<His3DCanvas> canvases = new HashSet<His3DCanvas>();
    private His3DCanvas myCanvas = new SessionScene3DCanvas();
    private Map<StaticSceneElementState.Element, StaticSceneElementState> staticSceneElementStates;

    public SessionScene() {
        this.canvases.add(this.myCanvas);
        this.staticSceneElementStates = AbstractBaseScene.getDefaultStaticElementStateMap();
    }

    @Override
    public void addStroke(Stroke3D stroke) {
        this.strokes.put(stroke.getId(), stroke);
        this.myCanvas.addStroke(stroke);
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeAdded(this, stroke);
        }
    }

    @Override
    public void adaptTo(HisScene leadingScene) {
        throw new RuntimeException("this should not happen at the moment because it is not implemented yet");
    }

    @Override
    public void addSceneObserver(HisScene.SceneObserver l) {
        this.sceneObservers.add(l);
        l.onStartedObservation(this);
    }

    @Override
    public void removeSceneObserver(HisScene.SceneObserver l) {
        this.sceneObservers.remove(l);
        l.onStoppedObservation(this);
    }

    @Override
    public Collection<Stroke3D> getAllStrokes() {
        return this.strokes.values();
    }

    @Override
    public void addStrokePoint(UUID id, Stroke3DPoint point, Set<HisScene.SceneObserver> informedSceneObserver) {
        HisStroke s = this.strokes.get(id);
        if (s != null) {
            s.addPoint(point);
        }
        HashSet<HisScene.SceneObserver> newinformedSceneObserver = new HashSet<HisScene.SceneObserver>(informedSceneObserver);
        newinformedSceneObserver.addAll(this.sceneObservers);
        for (HisScene.SceneObserver o : this.sceneObservers) {
            if (informedSceneObserver.contains(o)) continue;
            o.onStrokePointAdded(this, id, point, newinformedSceneObserver);
        }
    }

    @Override
    public void eraseStroke(UUID strokeId, Set<HisScene.SceneObserver> informed) {
    }

    @Override
    public void setStrokeVisibility(UUID strokeId, Boolean visibility, Set<HisScene.SceneObserver> informed) {
        HisStroke s = this.strokes.get(strokeId);
        if (s != null) {
            s.setVisibility(visibility);
        }
        HashSet<HisScene.SceneObserver> newinformedSceneObserver = new HashSet<HisScene.SceneObserver>(informed);
        newinformedSceneObserver.addAll(this.sceneObservers);
        for (HisScene.SceneObserver o : this.sceneObservers) {
            if (informed.contains(o)) continue;
            o.onStrokeVisibilityChanged(this, strokeId, visibility);
        }
    }

    @Override
    public void setStrokeStrokeAnchorPoint(UUID strokeId, Vector3f vector) {
        HisStroke s = this.strokes.get(strokeId);
        if (s != null) {
            s.setPosition(vector);
        }
        for (HisScene.SceneObserver o : this.sceneObservers) {
            o.onStrokeMoved(this, strokeId, vector);
        }
    }

    @Override
    public HisSceneMemento getMemento() {
        HisSceneMemento m = new HisSceneMemento();
        try {
            His3dSceneXMLDocument doc = new His3dSceneXMLDocument();
            doc.saveSceneIntoDocument(this);
            ByteArrayOutputStream bos = doc.getAsStream();
            byte[] compressedXml = CompressionUtils.compress(bos.toByteArray());
            m.compressedBytesOfHis3dSceneXMLDocument = compressedXml;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return m;
    }

    @Override
    public void adaptTo(HisSceneMemento sceneMemento) {
        System.out.println("WARNING SessionScene::public void adaptTo(HisSceneMemento sceneMemento) was called but nothing is implemented !");
    }

    @Override
    public Set<His3DCanvas> getAllCanvases() {
        return this.canvases;
    }

    @Override
    public His3DCanvas createNewEmpty3dCanvas() {
        SessionScene3DCanvas c = new SessionScene3DCanvas();
        this.canvases.add(c);
        return null;
    }

    @Override
    public void setStaticSceneElementState(StaticSceneElementState state) {
        StaticSceneElementState currentstate = this.staticSceneElementStates.get((Object)state.element).clone();
        if (!state.equals(currentstate)) {
            this.staticSceneElementStates.put(state.element, state);
            for (HisScene.SceneObserver o : this.sceneObservers) {
                o.onStaticSceneElementStateHasChanged(this, state);
            }
        }
    }

    @Override
    public StaticSceneElementState getStaticSceneElementState(StaticSceneElementState.Element e) {
        return this.staticSceneElementStates.get((Object)e);
    }

    public class SessionScene3DCanvas
    implements His3DCanvas {
        private Map<UUID, Stroke3D> strokes = new HashMap<UUID, Stroke3D>();
        private long creationTimeMilliseconds = 0L;

        @Override
        public void addStroke(Stroke3D s3d) {
            this.strokes.put(s3d.getId(), s3d);
        }

        @Override
        public Set<Stroke3D> getAllVisibleStrokes() {
            return new HashSet<Stroke3D>(this.strokes.values());
        }

        @Override
        public Set<Stroke3D> getAllSaveableStrokes() {
            return new HashSet<Stroke3D>(this.strokes.values());
        }

        @Override
        public void clear() {
            this.strokes.clear();
        }

        @Override
        public Stroke3D getStroke(UUID id) {
            return this.strokes.get(id);
        }

        @Override
        public boolean undo() {
            return false;
        }

        @Override
        public boolean redo() {
            return false;
        }

        @Override
        public long getCreationTimeMilliseconds() {
            return this.creationTimeMilliseconds;
        }

        @Override
        public void setCreationTimeMilliseconds(long creationTimeMillis) {
            this.creationTimeMilliseconds = creationTimeMillis;
        }

        @Override
        public void setStyleOfAllStrokes(StrokeInk.StrokeStyle style) {
            for (Stroke3D s : this.strokes.values()) {
                s.getInk().setStyle(style);
            }
        }

        @Override
        public void addStrokeObserver(Stroke3DObserver observer) {
        }

        @Override
        public void removeStrokeObserver(Stroke3DObserver observer) {
        }

        @Override
        public void setVisibilityForStrokeWithoutNotifying(Stroke3D s3d, boolean isVisible) {
        }

        @Override
        public void addStrokeAndPaintCompletely(Stroke3D stroke) {
        }

        @Override
        public void eraseStroke(Stroke3D s) {
            this.strokes.remove(s);
        }
    }
}

