/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection.implementations;

import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.synch.CleverSessionSynchConnection;
import com.hybridlab.hyve3d.network.interconnection.HubConnector;
import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.SessionDescriptor;
import com.hybridlab.hyve3d.network.interconnection.SessionRepository;
import com.hybridlab.hyve3d.network.interconnection.implementations.SessionSynchronizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SimpleSessionController
implements SessionRepository {
    private HubConnector connector = null;
    private Set<SessionRepository.SessionRepositoryObserver> observer = new HashSet<SessionRepository.SessionRepositoryObserver>();
    protected List<SessionDescriptor> knownAvailableSessions = new ArrayList<SessionDescriptor>();
    protected Map<UUID, Session> sessions = new HashMap<UUID, Session>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SessionDescriptor> getKnownAvailableSessions() {
        List<SessionDescriptor> list = this.knownAvailableSessions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<SessionDescriptor>(this.knownAvailableSessions));
        }
    }

    @Override
    public Session createNewSession(UUID sid) throws SessionRepository.SessionAlreadyInRepositoryException {
        return this.createNewSession(sid, "unnamed Session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session createNewSession(UUID sid, String sessionname) throws SessionRepository.SessionAlreadyInRepositoryException {
        if (this.sessions.get(sid) != null) {
            throw new SessionRepository.SessionAlreadyInRepositoryException("Session already created! " + sid.toString());
        }
        Session s = new Session(sid);
        this.sessions.put(s.getId(), s);
        s.setName(sessionname);
        List<SessionDescriptor> list = this.knownAvailableSessions;
        synchronized (list) {
            this.knownAvailableSessions.add(new SessionDescriptor(sid, this.connector, s.getName()));
            for (SessionRepository.SessionRepositoryObserver o : this.observer) {
                o.onAvailableSessionsChanged(this);
            }
        }
        return s;
    }

    @Override
    public Session createNewSession(String sessionname) throws SessionRepository.SessionAlreadyInRepositoryException {
        return this.createNewSession(UUID.randomUUID(), sessionname);
    }

    @Override
    public Session getSession(UUID sid) {
        return this.sessions.get(sid);
    }

    @Override
    public void addObserver(SessionRepository.SessionRepositoryObserver observer) {
        this.observer.add(observer);
    }

    public void createNewSessionInHubNodeBecauseOfRemoteRequest(String sessionName, HubNode node) throws Exception {
        Session s = this.createNewSession(sessionName);
        s.addDefaultLights();
        CleverSessionSynchConnection synchConn = new CleverSessionSynchConnection(s.getInfo());
        SessionSynchronizer synch = new SessionSynchronizer(s, synchConn);
        synchConn.connectToEndPoint(node);
    }
}

