/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection.implementations;

import com.hybridlab.hyve3d.data.synch.SynchronizationProgressTracer;
import com.hybridlab.hyve3d.data.synch.messages.ChunkedSynchMessage;
import com.hybridlab.hyve3d.data.synch.messages.NewDataModelSessionSynchMessage;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.InternetReachableHubNodeAdress;
import com.hybridlab.hyve3d.network.interconnection.messages.DrawingAreaMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.HostWillRestartOnOtherPortMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.HubNodeHandshakeMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.IdeationSpaceMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.KeepAliveMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.NewNodeInHubMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.NewSessionInNodeMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.SessionStateSynchRequestMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.SessionSynchMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.StrokeMessage;
import com.hybridlab.hyve3d.network.messages.TextMessage;
import com.jme3.network.Client;
import com.jme3.network.ClientStateListener;
import com.jme3.network.ErrorListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public class SpiderMonkeyHubConnection
implements HubConnection,
ClientStateListener,
MessageListener<Client>,
ErrorListener<Client> {
    private static List<Class> SupportedMessageClasses = new ArrayList<Class>();
    private Logger logger = Logger.getLogger("de.codemacher.his.jolly.network.interconnection");
    private Direction direction;
    private HubNode localHubNode;
    private UUID remoteHubNodeId = null;
    private InternetReachableHubNodeAdress hostaddress;
    private Client connectionClient;
    private HostedConnection incomingHostedConnection;
    private Map<UUID, HandshakeStatus> handshakeProtocol = new HashMap<UUID, HandshakeStatus>();
    SynchronizationProgressTracer progressTracer = null;
    private Thread keepAlive;
    private boolean verboseKeepAlive = false;

    public SpiderMonkeyHubConnection(HostedConnection conn, HubNode localHubNode) {
        this.direction = Direction.REMOTE_IS_CLIENT;
        this.localHubNode = localHubNode;
        this.incomingHostedConnection = conn;
        this.startKeepAliveMessages();
    }

    public SpiderMonkeyHubConnection(HostedConnection conn, HubNode localHubNode, SynchronizationProgressTracer tracer) {
        this(conn, localHubNode);
        this.progressTracer = tracer;
    }

    @Override
    public UUID getRemoteHubNodeId() {
        return this.remoteHubNodeId;
    }

    public String toString() {
        return String.format("SpiderMonkeyHubConnection -%s- [direction: %s, localHubNode: '%s' -%s-]", new Object[]{this.hashCode(), this.direction, this.localHubNode.getDescription(), this.localHubNode.hashCode()});
    }

    public SpiderMonkeyHubConnection(InternetReachableHubNodeAdress address, HubNode localHubNode, SynchronizationProgressTracer tracer) {
        this(address, localHubNode);
        this.progressTracer = tracer;
    }

    public SpiderMonkeyHubConnection(InternetReachableHubNodeAdress address, HubNode localHubNode) {
        this.direction = Direction.REMOTE_IS_SERVER;
        this.localHubNode = localHubNode;
        this.hostaddress = address;
    }

    @Override
    public boolean isConnected() {
        switch (this.direction) {
            case REMOTE_IS_CLIENT: {
                return this.incomingHostedConnection != null;
            }
            case REMOTE_IS_SERVER: {
                if (this.connectionClient == null) {
                    return false;
                }
                return this.connectionClient.isConnected();
            }
        }
        return false;
    }

    @Override
    public void establish() throws Exception {
        int version = 2;
        String gameName = "Hyve";
        this.connectionClient = Network.connectToServer((String)gameName, (int)version, (String)this.hostaddress.adress.getHostAddress(), (int)this.hostaddress.port, (int)this.hostaddress.port);
        this.connectionClient.addErrorListener((ErrorListener)this);
        this.connectionClient.addClientStateListener((ClientStateListener)this);
        for (Class c : SupportedMessageClasses) {
            this.connectionClient.addMessageListener((MessageListener)this, new Class[]{c});
        }
        this.logger.info("in establish(): " + Thread.currentThread().getName() + " " + Thread.currentThread().getId());
        this.connectionClient.start();
    }

    public void send(Message message) {
        if (this.isConnected()) {
            switch (this.direction) {
                case REMOTE_IS_CLIENT: {
                    this.incomingHostedConnection.send(message);
                    break;
                }
                case REMOTE_IS_SERVER: {
                    this.connectionClient.send(message);
                }
            }
            if (message instanceof KeepAliveMessage) {
                if (this.verboseKeepAlive) {
                    this.logger.finest("sending message (" + this.toString() + "):\n" + message.toString());
                }
            } else {
                this.logger.finest("sending message (" + this.toString() + "):\n" + message.toString());
            }
        } else {
            this.logger.severe("Not able to send message due to isConnected() == false! \n Message: " + message.toString());
        }
    }

    public void messageReceived(Client source, Message message) {
        if (source.equals(this.connectionClient)) {
            this.messageReceived(message);
        } else {
            this.logger.severe(String.format("received message %s but connectionClient != source", message.toString()));
        }
    }

    public void messageReceived(Message message) {
        this.logger.finest("message received by " + this.toString() + "\n" + message.toString());
        if (message instanceof HubNodeHandshakeMessage) {
            HubNodeHandshakeMessage handshakeMessage = (HubNodeHandshakeMessage)message;
            switch (handshakeMessage.type) {
                case HANDSHAKE_REQUEST: {
                    this.handleHandshakeRequest(handshakeMessage);
                    break;
                }
                case HANDSHAKE_ANSWER: {
                    this.handleHandshakeAnswer(handshakeMessage);
                }
            }
        } else if (message instanceof NewNodeInHubMessage) {
            this.handleMessage((NewNodeInHubMessage)message);
        } else if (message instanceof NewSessionInNodeMessage) {
            this.handleMessage((NewSessionInNodeMessage)message);
        } else if (message instanceof SessionSynchMessage) {
            this.handleMessage((SessionSynchMessage)message);
        } else if (message instanceof HostWillRestartOnOtherPortMessage) {
            this.handleMessage((HostWillRestartOnOtherPortMessage)message);
        }
    }

    private void handleMessage(HostWillRestartOnOtherPortMessage message) {
        this.logger.info(this + " received " + message.toString());
    }

    @Override
    public UUID sendSessionStateSynchRequest(UUID sessionId) {
        this.logger.info("sending sessionStateSynchRequest ...");
        SessionStateSynchRequestMessage m = new SessionStateSynchRequestMessage(this.localHubNode.getId(), sessionId);
        this.send(m);
        return m.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID sendHandshakeRequest() {
        this.logger.info("sending HandshakeRequest ...");
        HubNodeHandshakeMessage m = new HubNodeHandshakeMessage(this.localHubNode.getId());
        Map<UUID, HandshakeStatus> map = this.handshakeProtocol;
        synchronized (map) {
            this.handshakeProtocol.put(m.handshakeId, HandshakeStatus.REQUESTED);
        }
        this.send(m);
        return m.handshakeId;
    }

    @Override
    public void sendHandshakeRequestAndCallAfterAnswer(Runnable callback) throws Exception {
        UUID handshakeid = this.sendHandshakeRequest();
        WaitForAnswerCheckThread t = new WaitForAnswerCheckThread(handshakeid, callback);
        Thread waitThread = new Thread((Runnable)t, "Waitforanswer handshake " + handshakeid.toString());
        waitThread.start();
    }

    private void sendHandshakeAnswer(HubNodeHandshakeMessage handshakeRequestTurningIntoAnswerMessage) {
        handshakeRequestTurningIntoAnswerMessage.sessionInfos = this.localHubNode.getSessionInfos();
        handshakeRequestTurningIntoAnswerMessage.sessionIdsOfLeadedSessions = this.localHubNode.getSessionIdsOfLeadedSession();
        handshakeRequestTurningIntoAnswerMessage.type = HubNodeHandshakeMessage.Type.HANDSHAKE_ANSWER;
        handshakeRequestTurningIntoAnswerMessage.hubNodeId = this.localHubNode.getId();
        this.logger.info("sending HandshakeAnswer: " + handshakeRequestTurningIntoAnswerMessage.toString() + " ...");
        this.send(handshakeRequestTurningIntoAnswerMessage);
        this.localHubNode.onNewConnection(this);
    }

    private void handleMessage(SessionSynchMessage message) {
        this.localHubNode.onSessionSynchMessageReceived(this, message);
        this.progressInspection(SynchronizationProgressTracer.MessageDirection.RECEIVE, message);
    }

    private void progressInspection(SynchronizationProgressTracer.MessageDirection direction, SessionSynchMessage message) {
        if (this.progressTracer == null) {
            return;
        }
        if (message instanceof ChunkedSynchMessage) {
            this.progressTracer.trace((ChunkedSynchMessage)message, direction, this.localHubNode.getId().toString() + "--" + this.remoteHubNodeId.toString());
        }
    }

    private void handleMessage(NewNodeInHubMessage message) {
        this.logger.info("handling NewNodeInHubMessage: " + message);
        this.localHubNode.storeRemoteSessionHostingInformation(this, message.sessionInfos, message.sessionIdsOfLeadedSessions, message.hubNodeId);
    }

    private void handleMessage(NewSessionInNodeMessage message) {
        this.logger.info("handling NewSessionInNodeMessage: " + message);
        this.localHubNode.addToRemoteSessionHostingInformation(this, message.hubNodeId, message.newsession);
    }

    private void handleHandshakeRequest(HubNodeHandshakeMessage handshakeMessage) {
        UUID hubnodeId;
        this.remoteHubNodeId = hubnodeId = handshakeMessage.hubNodeId;
        this.logger.info("handling HandshakeRequest from HubNode with id=" + hubnodeId.toString() + " ... (sending HandshakeAnswer now)");
        this.sendHandshakeAnswer(handshakeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHandshakeAnswer(HubNodeHandshakeMessage handshakeMessage) {
        UUID hubnodeId;
        this.logger.info("handling HandshakeAnswer ...");
        this.remoteHubNodeId = hubnodeId = handshakeMessage.hubNodeId;
        Map<UUID, HandshakeStatus> map = this.handshakeProtocol;
        synchronized (map) {
            this.handshakeProtocol.put(handshakeMessage.handshakeId, HandshakeStatus.ANSWERED);
        }
        this.localHubNode.storeRemoteSessionHostingInformation(this, handshakeMessage.sessionInfos, handshakeMessage.sessionIdsOfLeadedSessions, hubnodeId);
    }

    public void clientConnected(Client client) {
        this.logger.info("in clientConnected(Client client): " + Thread.currentThread().getName() + " " + Thread.currentThread().getId());
        if (client == this.connectionClient) {
            this.logger.info("client connected\n" + client.toString());
        }
    }

    private void startKeepAliveMessages() {
        if (this.keepAlive != null) {
            this.keepAlive.interrupt();
        }
        this.keepAlive = new Thread(new Runnable(){

            @Override
            public void run() {
                KeepAliveMessage m = new KeepAliveMessage();
                boolean run = true;
                while (run) {
                    if (!SpiderMonkeyHubConnection.this.isConnected()) {
                        run = false;
                        SpiderMonkeyHubConnection.this.keepAlive = null;
                        continue;
                    }
                    try {
                        if (SpiderMonkeyHubConnection.this.verboseKeepAlive) {
                            SpiderMonkeyHubConnection.this.logger.info("sending keepAlive @ " + System.currentTimeMillis());
                        }
                        SpiderMonkeyHubConnection.this.send((Message)m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SpiderMonkeyHubConnection.this.logger.info("not continuing keepAlive due to exception @ " + System.currentTimeMillis());
                        run = false;
                    }
                    try {
                        Thread.sleep(1800L);
                    }
                    catch (InterruptedException e) {
                        run = false;
                    }
                }
            }
        }, "keepalive");
        this.keepAlive.start();
    }

    public void clientDisconnected(Client client, ClientStateListener.DisconnectInfo info) {
        if (client == this.connectionClient) {
            if (this.keepAlive != null) {
                this.keepAlive.interrupt();
            }
            this.logger.info("client was disconnected\n" + client != null ? client.toString() : (" " + info != null ? info.reason : ""));
            this.localHubNode.onConnectionRemoved(this);
        }
    }

    @Override
    public HubNode getLocalNode() {
        return this.localHubNode;
    }

    @Override
    public void sendSynchMessage(SessionSynchMessage m) {
        this.send(m);
        this.progressInspection(SynchronizationProgressTracer.MessageDirection.SEND, m);
    }

    @Override
    public void disConnect() {
        switch (this.direction) {
            case REMOTE_IS_CLIENT: {
                this.incomingHostedConnection.close("disconnect");
                break;
            }
            case REMOTE_IS_SERVER: {
                this.connectionClient.close();
                break;
            }
        }
    }

    public void handleError(Client client, Throwable t) {
        this.logger.info("client was disconnected\n" + client.toString() + " " + t.getMessage());
        if (this.keepAlive != null) {
            this.keepAlive.interrupt();
        }
        if (t.getMessage().equals("Connector closed.")) {
            this.localHubNode.onConnectionRemoved(this);
        }
    }

    @Override
    public void sendNewNodeInHubMessage() {
        NewNodeInHubMessage m = new NewNodeInHubMessage(this.localHubNode.getId(), this.localHubNode.getSessionInfos(), this.localHubNode.getSessionIdsOfLeadedSession());
        this.send(m);
    }

    @Override
    public void sendNewSessionInNodeEvent(SessionInfo sessionid) {
        NewSessionInNodeMessage m = new NewSessionInNodeMessage(this.localHubNode.getId(), sessionid);
        this.send(m);
    }

    @Override
    public void sendHostWillRestartOnOtherPortMessage(int port) {
        HostWillRestartOnOtherPortMessage m = new HostWillRestartOnOtherPortMessage(port);
        this.send((Message)m);
    }

    @Override
    public String describe() {
        Object d = "";
        if (this.hostaddress != null) {
            d = (String)d + this.hostaddress.describe() + " ";
        }
        return ((String)d).trim();
    }

    static {
        SupportedMessageClasses.add(TextMessage.class);
        SupportedMessageClasses.add(HubNodeHandshakeMessage.class);
        SupportedMessageClasses.add(SessionStateSynchRequestMessage.class);
        SupportedMessageClasses.add(NewNodeInHubMessage.class);
        SupportedMessageClasses.add(NewSessionInNodeMessage.class);
        SupportedMessageClasses.add(SessionSynchMessage.class);
        SupportedMessageClasses.add(IdeationSpaceMessage.class);
        SupportedMessageClasses.add(DrawingAreaMessage.class);
        SupportedMessageClasses.add(StrokeMessage.class);
        SupportedMessageClasses.add(KeepAliveMessage.class);
        SupportedMessageClasses.add(HostWillRestartOnOtherPortMessage.class);
        SupportedMessageClasses.add(NewDataModelSessionSynchMessage.class);
        SupportedMessageClasses.add(ChunkedSynchMessage.class);
    }

    private static enum Direction {
        REMOTE_IS_CLIENT,
        REMOTE_IS_SERVER;

    }

    private static enum HandshakeStatus {
        REQUESTED,
        ANSWERED;

    }

    private class WaitForAnswerCheckThread
    implements Runnable {
        private int sleepingsince = 0;
        private int sleepduration = 50;
        private int maxsleep = 50000;
        private boolean answered = false;
        private UUID handshakeid;
        private Runnable callBack;

        public WaitForAnswerCheckThread(UUID handshakeid, Runnable callback) {
            this.handshakeid = handshakeid;
            this.callBack = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.answered && this.sleepingsince < this.maxsleep) {
                Map<UUID, HandshakeStatus> map = SpiderMonkeyHubConnection.this.handshakeProtocol;
                synchronized (map) {
                    if (SpiderMonkeyHubConnection.this.handshakeProtocol.get(this.handshakeid).equals((Object)HandshakeStatus.ANSWERED)) {
                        this.answered = true;
                    }
                }
                if (this.answered) continue;
                try {
                    Thread.sleep(this.sleepduration);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.sleepingsince += this.sleepduration;
            }
            if (this.answered) {
                this.callBack.run();
            }
        }
    }
}

