/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.interconnection.messages;

import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.network.interconnection.StrokeMemento;
import com.hybridlab.hyve3d.network.interconnection.messages.SessionSynchMessage;
import com.hybridlab.utils.network.NetworkUtil;
import com.jme3.math.Vector3f;
import com.jme3.network.serializing.Serializable;
import java.util.UUID;

@Serializable
public class StrokeMessage
extends SessionSynchMessage {
    private Action action;
    private StrokeMemento strokememento;
    public Stroke3DPoint point = Stroke3DPoint.ZERO;
    public UUID strokeId = NetworkUtil.NULL_UUID;
    public boolean visibility;
    public Vector3f vector = new Vector3f();

    public StrokeMessage() {
    }

    public StrokeMessage(UUID sessionId, Action action) {
        super(sessionId);
        this.action = action;
    }

    public String toString() {
        return switch (this.action) {
            case Action.CREATION -> "StrokeMessage [action=" + this.action + ", strokememento=" + this.strokememento + "]";
            case Action.POINTADDING -> "StrokeMessage [action=" + this.action + ", point=" + this.point + ", strokeId=" + this.strokeId + "]";
            default -> "StrokeMessage [action=" + this.action + ", strokememento=" + this.strokememento + ", point=" + this.point + ", v=" + this.vector + ", strokeId=" + this.strokeId + "]";
        };
    }

    public void setStrokeMemento(StrokeMemento m) {
        this.strokememento = m;
    }

    public Action getAction() {
        return this.action;
    }

    public StrokeMemento getStrokeMemento() {
        return this.strokememento;
    }

    public static enum Action {
        CREATION,
        POINTADDING,
        VISIBILITYCHANGE,
        ERASE,
        STROKE_ANCHOR_MOVED;

    }
}

