/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.jme3.math.Vector2f;
import com.jme3.network.serializing.Serializable;

@Serializable
public class Move2DMessage
extends AbstractHisMessage {
    private Type type = Type.ONE_FINGER;
    private Vector2f vector;
    private State state = State.BEGIN;

    public String toString() {
        String s = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        s = s + String.format(" %s %s", this.type.toString(), this.vector.toString());
        return s;
    }

    public Move2DMessage() {
    }

    public Move2DMessage(Type subType, Vector2f v, State state) {
        this.state = state;
        this.setType(subType);
        this.setVector(v);
    }

    public State getState() {
        return this.state;
    }

    public Vector2f getVector() {
        return this.vector;
    }

    public void setVector(Vector2f vector) {
        this.vector = vector;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        ABSOLUTE(0),
        RELATIVE(-1),
        ONE_FINGER(1),
        TWO_FINGER(2),
        THREE_FINGER(3),
        FOUR_FINGER(4),
        FIVE_FINGER(5);

        private final short code;

        private Type(short c) {
            this.code = c;
        }

        public short getCode() {
            return this.code;
        }

        public static Type getFromShort(short s) {
            if (Type.ABSOLUTE.code == s) {
                return ABSOLUTE;
            }
            if (Type.RELATIVE.code == s) {
                return RELATIVE;
            }
            if (Type.ONE_FINGER.code == s) {
                return ONE_FINGER;
            }
            if (Type.TWO_FINGER.code == s) {
                return TWO_FINGER;
            }
            if (Type.THREE_FINGER.code == s) {
                return THREE_FINGER;
            }
            if (Type.FOUR_FINGER.code == s) {
                return FOUR_FINGER;
            }
            if (Type.FIVE_FINGER.code == s) {
                return FIVE_FINGER;
            }
            return ONE_FINGER;
        }
    }

    public static enum State {
        BEGIN(0),
        MOVE(1),
        END(2);

        private final byte code;

        private State(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        public static State getFromByte(byte s) {
            if (State.BEGIN.code == s) {
                return BEGIN;
            }
            if (State.MOVE.code == s) {
                return MOVE;
            }
            if (State.END.code == s) {
                return END;
            }
            return BEGIN;
        }
    }
}

