/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.jme3.math.Vector3f;
import com.jme3.network.serializing.Serializable;

@Serializable
public class Move3DMessage
extends AbstractHisMessage {
    private Type type = Type.TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER;
    private Vector3f vector;

    public String toString() {
        String s = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        s = s + String.format(" %s %s", this.type.toString(), this.vector.toString());
        return s;
    }

    public Move3DMessage() {
    }

    public Move3DMessage(Type subType, Vector3f v) {
        this.setType(subType);
        this.setVector(v);
    }

    public Vector3f getVector() {
        return this.vector;
    }

    public void setVector(Vector3f vector) {
        this.vector = vector;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER(1),
        TYPE_RELATIVE_HYDRA_BASED(2),
        TYPE_RELATIVE_LEAPMOTION_BASED(3);

        private final short code;

        private Type(short c) {
            this.code = c;
        }

        public short getCode() {
            return this.code;
        }

        public static Type getFromShort(short s) {
            if (Type.TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER.code == s) {
                return TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER;
            }
            if (Type.TYPE_RELATIVE_HYDRA_BASED.code == s) {
                return TYPE_RELATIVE_HYDRA_BASED;
            }
            if (Type.TYPE_RELATIVE_LEAPMOTION_BASED.code == s) {
                return TYPE_RELATIVE_LEAPMOTION_BASED;
            }
            return TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER;
        }
    }
}

