/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.PinchPointsMessage;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Vector2f;
import com.jme3.network.serializing.Serializable;
import java.util.Locale;

@Serializable
public class OrbitMessage
extends AbstractHisMessage {
    private float angleRad;
    private Phase phase;
    private float initialDistance;
    private float currentDistance;

    public OrbitMessage() {
    }

    public OrbitMessage(PinchPointsMessage message) {
        Vector2f init = message.initiatingTouch2Position.subtract(message.initiatingTouch1Position);
        Vector2f current = message.currentTouch2Position.subtract(message.currentTouch1Position);
        float angleRad = MathUtils.signedAngleBetween2Vectors(init, current);
        this.setAngleRad(angleRad);
        this.setDistances(init.length(), current.length());
        this.setPhase(Phase.getFromByte(message.getPhase().getCode()));
    }

    public String toString() {
        return OrbitMessage.class.toString() + " " + String.format(Locale.ENGLISH, "angle: %.2f, initialdistance: %.3f, currentdistance: %.3f, %s", Float.valueOf(this.angleRad * 57.295776f), Float.valueOf(this.initialDistance), Float.valueOf(this.currentDistance), this.phase.toString());
    }

    public Phase getPhase() {
        return this.phase;
    }

    private void setPhase(Phase phase) {
        this.phase = phase;
    }

    public float getAngleRad() {
        return this.angleRad;
    }

    private void setAngleRad(float angleRad) {
        this.angleRad = angleRad;
    }

    private void setDistances(float initial, float current) {
        this.initialDistance = initial;
        this.currentDistance = current;
    }

    public boolean hasDifferentValuesComparedTo(OrbitMessage latestMessage) {
        if (null == latestMessage) {
            return true;
        }
        if (this.angleRad != latestMessage.angleRad) {
            return true;
        }
        if (this.currentDistance != latestMessage.currentDistance) {
            return true;
        }
        return this.initialDistance != latestMessage.initialDistance;
    }

    public static enum Phase {
        INTERACTION_BEGIN(0),
        INTERACTION_ONGOING(1),
        INTERACTION_END(2),
        INTERACTION_RESTART(3);

        private final byte code;

        private Phase(byte c) {
            this.code = c;
        }

        public short getCode() {
            return this.code;
        }

        public static Phase getFromByte(byte s) {
            if (Phase.INTERACTION_ONGOING.code == s) {
                return INTERACTION_ONGOING;
            }
            if (Phase.INTERACTION_BEGIN.code == s) {
                return INTERACTION_BEGIN;
            }
            if (Phase.INTERACTION_END.code == s) {
                return INTERACTION_END;
            }
            if (Phase.INTERACTION_RESTART.code == s) {
                return INTERACTION_RESTART;
            }
            return INTERACTION_ONGOING;
        }
    }
}

