/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.jme3.math.Vector2f;
import com.jme3.network.serializing.Serializable;
import java.util.Locale;

@Serializable
public class Pointing2DTransmissionPartMessage
extends AbstractHisMessage {
    private Vector2f[] points;
    private float pressure = 10.0f;
    private SubType type;

    public Pointing2DTransmissionPartMessage() {
    }

    public Vector2f[] getPoints() {
        return this.points;
    }

    public Vector2f getFirstPoint() {
        return this.points[0];
    }

    public SubType getType() {
        return this.type;
    }

    public Pointing2DTransmissionPartMessage(Vector2f point, SubType type) {
        this(new Vector2f[]{point}, type);
    }

    public Pointing2DTransmissionPartMessage(Vector2f[] points, SubType type) {
        this.points = points;
        this.type = type;
    }

    public String toString() {
        Object sss = "";
        for (Vector2f p : this.points) {
            sss = (String)sss + String.format(Locale.ENGLISH, " (%.4f, %.4f)", Float.valueOf(p.x), Float.valueOf(p.y)) + " ";
        }
        String s = Pointing2DTransmissionPartMessage.class.getSimpleName() + " " + this.type.toString() + " " + String.format(Locale.ENGLISH, " pressure %.6f ", Float.valueOf(this.pressure)) + (String)sss;
        return s;
    }

    public static enum SubType {
        BEGIN(1),
        ADD(17),
        END(16);

        private short code;

        private SubType(short c) {
            this.code = c;
        }

        public short getCode() {
            return this.code;
        }

        public static SubType getFromShort(short s) {
            if (s == SubType.BEGIN.code) {
                return BEGIN;
            }
            if (s == SubType.ADD.code) {
                return ADD;
            }
            if (s == SubType.END.code) {
                return END;
            }
            return BEGIN;
        }
    }
}

